/************************************************************************

    JOYCE v1.90 - Amstrad PCW emulator

    Copyright (C) 1996, 2001  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

/*
 * Note: JOYCE may well contain assumptions that an int is 32 bits or more.
 * I wouldn't recommend porting it to a 16-bit system - the ability
 * to do a malloc(2megs) is quite important :-)
 *
 */
#define MAIN
#include "Joyce.hxx"
#include "Joycefid.hxx"
#include "Joycedos.hxx"
#include "Joycedsk.hxx"
#include "inline.hxx"

void deinitJoyce(void);

/* Argument processing */






/******************* main() *******************/

void initJoyce(void)
{
	fplog = NULL;

        fplog = openJoyceFile(FT_NORMAL, LOGFILE, "w");
	if (!fplog) fplog = fopen(LOGFILE, "w");
	if (!fplog) fplog = stderr;
}





int
main(int argc,char *argv[])
{
	JoyceSystem *sys;
	JoyceArgs args(argc, argv);

        printf("JOYCE PCW Emulator v%x.%x.%x\n", BCDVERS >> 8, 
				(BCDVERS & 0xF0) >> 4, BCDVERS & 0x0F);
	fflush(stdout);
	
	if (!args.parse()) return false;

	// Trap signal to exit gracefully
	signal(SIGINT, goodbye);
	initJoyce();		
	atexit(deinitJoyce);

	/* kick off CP/M */
	sys = gl_sys = new JoyceSystem(&args);

	if (sys->sysInit())
	{
		// Set the Z80 going
		sys->m_cpu.mainloop();
	}

	/* we should exit through the goodbye() function
	 * to restore terminal modes and close disk drives
	 */
	goodbye(99);

	/* The logic will never get here */
	return 0;
}




/* signal trap - reset tty modes and leave program
 * 99 is used if the program wants to exit gracefully,
 */
void goodbye(int sig)
{
	if (fplog)
	{
		if (sig != 99) fprintf(fplog, "Stopped by signal: %d\n", sig);
		if (fplog != stderr) fclose(fplog);
		fplog = NULL;
	}
	exit(sig);
}


/* As goodbye(), but prints a farewell message */

void diewith(char *s, int sig)
{
	alert(s);
	if (fplog)
	{
		fprintf(fplog, "Fatal error %d: %s", sig, s);
		if (fplog != stderr) fclose(fplog);
		fplog = NULL;
	}
	exit(sig);
}



void deinitJoyce(void)	/* v1.21 The very last things done */
{
        if (gl_sys) 
        {
                gl_sys->deinitVideo();
                delete gl_sys;
        }
}





