/*************************************************************************

    JOYCE v2.0.2 - Amstrad PCW emulator

    Copyright (C) 1996, 2001, 2002  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

#ifndef JOYCE_H		    /* Protect against multiple inclusion */

/* Standard libraries */

#include "config.h"	/* Autoconf header */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <ctype.h>
#include <time.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <fcntl.h>
#include <signal.h>
#include <sys/types.h>

/* STL includes */

#include <vector>
#include <string>

// The XLOG macro allows me to do printf()-style debugging of the 
// JoyceSystem::JoyceSystem construct phase.
#define XLOG(s)
//#define XLOG(s) do { FILE *fp = fopen("xlog", "a"); fprintf(fp, "%s\n", s); fclose(fp); } while(0)

#ifdef HAVE_WINDOWS_H
#include "JoyceW32.hxx"
#else
#include "JoycePosix.hxx"
#endif

// XML parser for config files
#include <libxml/parser.h>

// LibPng for graphical output
#include <png.h>

// Code to launch processes asynchronously in Win32 and Unix
#include "Executor.hxx"

#include "UiTypes.hxx"		/* Enums for user interface events */
#include "JoyceArgs.hxx"	/* Argument parser */

//
// PCW model types. There were in fact 6 PCWs, but JOYCE treats the 
// (8256,8512) and (9256,10) pairings as identical; the differences
// between them are configured manually.
//
enum JoyceModel
{
	PCW8000,	// PCW8256. PCW8512
	PCW9000,	// PCW9512
	PCW9000P,	// PCW9512+
	PCW10		// PCW9256, PCW10
};

#include "JoyceZ80.hxx"         /* Z80 emulation declarations    */
#include "765.h"	        /* FDC emulation declarations    */
#include "JoyceComms.hxx"	/* Wrapper for comms code        */
// New device model
#include "JoyceDevice.hxx"      /* Generic device class          */

#include "JoyceMemory.hxx"	/* The memory sybsystem 	 */
#include "JoyceAsic.hxx"	/* Ports 0xF4 and 0xF8           */
#include "JoyceFdc.hxx"		/* The PCW's disc subsystem      */
#include "JoyceHdc.hxx"		/* Emulated hard drives          */

// Input
#include "JoyceInput.hxx"	/* Generic input interface       */
#include "JoycePcwKeyboard.hxx" /* Generic PCW keyboard          */
#include "JoycePcwMouse.hxx"	/* PCW mice                      */

// Screen stuff
#include "JoyceSdlContext.hxx"	/* Our output window             */
#include "JoyceTerminal.hxx"    /* Generic terminal              */
#include "JoyceSdlTerm.hxx"	/* Generic SDL text terminal     */
#include "JoycePcwTerm.hxx"     /* PCW screen drawing            */
#include "JoyceVgaTerm.hxx"	/* VGA: SDL-based console        */
#include "JoyceLogoTerm.hxx"	/* Logo: DR Logo driver          */
#include "JoyceDebugTerm.hxx"	/* Debugger console              */
#include "JoyceMenuTerm.hxx"	/* Menu system                   */
#include "JoyceMenuTermPcw.hxx" /* ditto                         */


// Printers
#include "JoycePrinter.hxx"     /* Basic printer emulation       */
#include "JoyceMatrix.hxx"	/* 8256 matrix printer           */
#include "JoyceDaisy.hxx"	/* 9512 daisywheel printer       */
#include "JoyceCenPrinters.hxx" /* CEN: Centronics printer       */
#include "JoyceCPS.hxx"		/* CPS8256: Centronics + serial  */
#include "JoyceSystem.hxx"	/* The PCW itself                */

#define BCDVERS 0x0202	/* v2.0.2 */

/* file names */
#define BOOT_SYS	"bootfile.emj"	/* boot image of CP/M system	*/
#define LOGFILE		"joyce.log"	/* Log file */

//
// Enum describing the different directories JOYCE uses:
//
enum JoyceFileType
{
	FT_NORMAL,	// JOYCE root
	FT_BOOT,	// boot discs
	FT_DISC,	// non-boot discs
	FT_PNGS,	// PNG output files
	FT_OLDBOOT,	// JOYCE 1.3x boot discs
	FT_OLDDISC,	// JOYCE 1.3x other discs
	FT_PS,		// Postscript output files
};

/////////////////////////////////////////////////////////////////////////////
//
// JOYCE routines: 
//

//
// Locate a file. Mode is an fopen() mode. 
//
string findJoyceFile(JoyceFileType ft, const string name, const string mode);
FILE  *openJoyceFile(JoyceFileType ft, const string name, const string mode);
string findJoyceDir (JoyceFileType ft, bool global);

//
// Shorten a filename for display
//
string displayName (string filename, int len);
//
// Open a temporary file
//
FILE *openTemp(char *name, const string type, const string mode);
//
// Check a directory exists
//
void checkExistsDir(const string path);

// Get user's home directory ($HOME in Unix, "My Documents" in Windows)
string getHomeDir(void);
// Set user's home directory (Windows only)
void setHomeDir(string s);

void joyce_dprintf(char *, ...); /* Printf() to debugger output */
void joyce_vdprintf(char *, va_list);	/* vprintf() to debugger output */
void dgets(char *S, int maxc);	/* Get string for debugger */
char dgetch(void);		/* Get character */
void dcls(void);		/* Clear debug console screen */

void goodbye(int);		/* Exit tidily */
void diewith(char *, int);	/* Exit tidily with an alert */
void alert(const string s);	/* On UNIX, warn to stderr. Under Windows,
				 * do a MessageBox */

UiEvent discManager(JoyceSystem *s, UiDrawer *d);	/* Manage DSK files */
int autoSetup(JoyceSystem *s);	/* Add one or more boot discs */

void fid_com(Z80 *R);		/* (v1.21) COM port handler */
void set_com(void);		/* (v1.22) COM port reinitialise */
void com_init(void);		/* (v1.31) COM port startup */
void com_deinit(void);		/* (v1.31) COM port shutdown */

void boot_id(Z80 *R);		/* (v1.22) parse BOOT.CFG */

char *name_from_path(char *s);

void UpdateArea(int x, int y, int w, int h);

/* Interface to CPMREDIR library */
void cpmredir_intercept(Z80 *R);

#ifdef MAIN	/* Data storage classes - extern unless in main program */
#define EXTERN
#else
#define EXTERN extern
#endif

EXTERN JoyceSystem *gl_sys;		// The OO representation of the computer
EXTERN FILE *fplog;		/* Log file */
/* (v1.31) Requested by external agency to stop */
EXTERN int extern_stop;

#include "colours.hxx"

#define JOYCE_H 1



#endif /* ndef JOYCE_H */
