/************************************************************************

    JOYCE v1.90 - Amstrad PCW emulator

    Copyright (C) 1996, 2001  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

#include "UiControl.hxx"

class UiMenu3;
class UiMenuBar;

class JoyceMenuTerm : public JoyceSdlTerm, public UiDrawer
{
public:
	JoyceMenuTerm(JoyceSystem *s);
	virtual ~JoyceMenuTerm();

protected:
	virtual void menuDraw(void) = 0;
        virtual void drawKeyboard(void) = 0;
	virtual UiEvent aboutBox(void) = 0;
	virtual void onGainFocus();

	UiEvent cpuState(Z80 *R);
	UiEvent debugMenu(Z80 *R, int x, int y);
	UiEvent menuF1(int x, int y);
	UiEvent confirm(int x, int y, const string prompt);
	UiMenuBar *m_menuF9;

public:
	UiEvent yesno(const string prompt);
	void mainMenu(Z80 *R);
	void exitMenu(void);

	UiEvent report(const string s, const string prompt);
// Overrides
        void setSysVideo(JoyceSdlContext *s);
// Callbacks
        virtual SDL_Surface *getSurface();
        virtual SDL_Surface *saveSurface(SDL_Surface *s, SDL_Rect &rc);
        virtual SDL_Surface *saveSurface(SDL_Rect &rc);
        virtual void restoreSurface(SDL_Surface *s, SDL_Rect &rc);

        virtual void onTimer50(void);
        virtual UiEvent menuEvent(SDL_Event &e);
        virtual char getKey(void);

	virtual void centreContainer(UiContainer &c);

        virtual void setManualUpdate(bool b = true);
        virtual bool getManualUpdate(void);
	virtual void updateRect(SDL_Rect &rc);

        void popup(const string message, int time, int centred);
        void popupRedraw(const string message, int centred);
        void popupOff(void);
	virtual SDL_Surface *createPopup(void) = 0;
        virtual void setPopupText(SDL_Surface *s) = 0;

	// Draw a popup message. Returns 0: No popup. 1: Drawn. 2: Removed,
	// update screen behind it.
	int drawPopup(void);

// Popup support
protected:
        char   m_popup[80];
        time_t m_popupTimeout;
        SDL_Surface *m_popupBacking;
	SDL_Surface *m_popupContext;
        SDL_Rect m_popupRect;

private:
	bool	m_menuMutex;
};

