/************************************************************************

    JOYCE v1.90 - Amstrad PCW emulator

    Copyright (C) 1996, 2001  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

class JoycePrinter : public JoyceDevice
{
public:
	JoycePrinter(char *portname);
	virtual ~JoycePrinter();

	virtual void writeChar(char c);
	virtual bool isBusy(void);

	// Call this every 30 secs or so
	virtual void printerTick(void);
	virtual void reset(void);

	virtual UiEvent settings(UiDrawer *d);

protected:
	UiEvent getPipe(UiDrawer *d);

        virtual bool parseNode(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur);
	virtual bool storeNode(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur);

	virtual string getTitle(void);

	bool open(void);
	void close(void);

	FILE *m_fp;	// File for output
	string m_filename; // Output filename or pipename
	time_t m_tick;	// Time of last output 
	int m_timeout;	// Timeout before closing output file
	bool m_pclose;	// Close with pclose() or fclose()?
};




