/************************************************************************

    JOYCE v1.90 - Amstrad PCW emulator

    Copyright (C) 1996, 2001  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

#include "Joyce.hxx"
#include "Joycevga.hxx"
#include "keyboard.hxx"
#include "inline.hxx"

#if 0
int ui_disc_settings(void);
void notify_failed(char *s);
int ui_disc_menu(int x, int y);






/* Set reverse video */

void vid_rv(char r) 
{
	//jstate.m_sys->m_termVga.getMenuTerm().setReverse(r);
}


/* Move cursor */

void vid_at(char y,char x)
{
        //jstate.m_sys->m_termVga.getMenuTerm().moveCursor(x,y);
}

/* Put string */

void vid_puts(char *s)
{
	//jstate.m_sys->m_termVga.getMenuTerm() << s;
}

/* Put string at y,x */

void vid_putsxy(char y, char x, char *s)
{
	vid_at(y,x);
	vid_puts(s);
}




void vid_packsxy(char y, char x, char *s)	/* Print text, clear the */
{						/* rest of the line */
	vid_putsxy(y,x,s);
	//jstate.m_sys->m_termVga.getMenuTerm().clearEOL();	
}



int dgetstr(int y, int x, char *S, int maxc)	/* Input string */
{						
	char c[2];
	int L = 0;

	c[1] = 0;
	while(1)
	{
		c[0] = dgetch();
		if (c[0] == '\n' || c[0] == '\r')
		{
			S[L++] = 0;
			return 1;
		}
		if (c[0] == 0x1B)
		{
			S[L++] = 0;
			return 0;
		}
		if (c[0] == 8 || c[0] == 127)
		{
			if (L > 0)
			{
				--L;
				--x;
				vid_putsxy(y,x," ");
			}
		}
		else
		{
			if (L < maxc - 1)
			{
				S[L++] = c[0];
				vid_putsxy(y,x,c);
				++x;
			}
		}
	}
}		
	












#endif

void joyce_dprintf(char *s, ...)	/* printf() for the debugger console */
{
	va_list arg;

	va_start(arg, s);
	joyce_vdprintf(s, arg);
	va_end(arg);
}

void fdc_dprintf(int debuglevel, char *s, ...)
{
        va_list arg;

	if (debuglevel > 0) return;

        va_start(arg, s);
        joyce_vdprintf(s, arg);
        va_end(arg);
}


void joyce_vdprintf(char *s, va_list arg)
{
	if (!gl_sys || !gl_sys->getDebug() || !gl_sys->m_video)
					/* If debugger not active, or screen
					  not set up, write to log file */
	{
		if (fplog) 
		{
			vfprintf(fplog, s, arg);
			fflush(fplog);
		}
	}
	else
	{
		gl_sys->m_termDebug.vprintf(s, arg);
	}
}

#if 0

void dgets(char *S, int maxc)	/* Gets() for the debugger console */
{
	int L = 0;

	char c[2];

	c[1] = 0;
	while(1)
	{
		c[0] = dgetch();
		if (c[0] == '\n' || c[0] == '\r')
		{
			S[L++] = 0;
			joyce_dprintf("\n");
			return;
		}
		if (c[0] == 8 || c[0] == 127)
		{
			if (L > 0)
			{
				--L;
				joyce_dprintf("\010 \010");
			}
		}
		else
		{
			joyce_dprintf(c);
			if (L < maxc - 1) S[L++] = c[0];
		}
	}
}		


char dgetch(void)
{
	int c;
	static int shifted;

	do
	{
		c = get_keytoken();

		if (c == SDLK_LSHIFT  || c == SDLK_RSHIFT)  { shifted = 1;c=0;}
		if (c == -SDLK_LSHIFT || c == -SDLK_RSHIFT) { shifted = 0;c=0;}

	} while (c <= 0);

	switch(c)	/* (v1.20) Map some keys to WordStar control codes */
	{
		case SDLK_F10:		/* f10   */ c = 10; break;
		case SDLK_UP:		/* up    */ c =  5; break; 
		case SDLK_DOWN:		/* down  */ c = 24; break;
		case SDLK_LEFT:		/* left  */ c = 19; break;
		case SDLK_RIGHT:	/* right */ c =  4; break;
		case SDLK_DELETE:	/* del   */ c =  7; break;
		case SDLK_INSERT:	/* ins   */ c = 22; break;
		case SDLK_PAGEUP:	/* pgup  */ c = 18; break;
		case SDLK_PAGEDOWN:	/* pgdn  */ c =  3; break;
	}
	if (c == '/' && shifted) c = '?';

//	memset((byte *)keyboard_map, 0, sizeof(keyboard_map));
	return c;
}


void dcls(void)
{
	if (!//jstate.m_sys->getDebug()) return;
	//jstate.m_sys->m_termDebug.getTerminal()->clearWindow();
}
#endif

