/************************************************************************

    JOYCE v1.90 - Amstrad PCW emulator

    Copyright (C) 1996, 2001  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

#include "Joyce.hxx"
#include "Joycevga.hxx"
#include "inline.hxx"

JoyceSdlTerm::JoyceSdlTerm(const char *id, JoyceSystem *s) : JoyceTerminal(id)
{
	m_sys = s;
	m_term = NULL;
	m_oldTerm = NULL;
	m_tick = 0;
        m_clrFG.r = m_clrFG.g = m_clrFG.b = 0xFF;
	m_clrBG.r = m_clrBG.g = m_clrBG.b = 0x00;
}


JoyceSdlTerm::~JoyceSdlTerm()
{
	if (m_term) delete m_term;
}


void JoyceSdlTerm::reset(void)
{
	if (m_term) m_term->reset();
}

bool JoyceSdlTerm::storeNode(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur)
{
	return storeColour(doc, ns, cur, "colour", m_clrFG, m_clrBG);
}

bool JoyceSdlTerm::parseNode(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur)
{
	return parseColour(doc, ns, cur, "colour", m_clrFG, m_clrBG);
}


void JoyceSdlTerm::setForeground(byte r, byte g, byte b)
{
	m_clrFG.r = r;
	m_clrFG.g = g;
	m_clrFG.b = b;

	if (m_term) m_term->setForeground(r,g,b);
}


void JoyceSdlTerm::setBackground(byte r, byte g, byte b)
{
	m_clrBG.r = r;
	m_clrBG.g = g;
	m_clrBG.b = b;
	if (m_term) m_term->setBackground(r,g,b);
}


void JoyceSdlTerm::onScreenTimer(void)
{
	++m_tick;
	if (m_tick == 18) 
	{
		if (m_term) m_term->onTimer50();
		m_tick = 0;
	}
}

void JoyceSdlTerm::onDebugSwitch(bool b)
{
	if (m_oldTerm) m_oldTerm->onDebugSwitch(b);
	JoyceTerminal::onDebugSwitch(b);
}


JoyceTerminal& JoyceSdlTerm::operator <<(unsigned char c)
{
	if (m_term)  (*m_term) << c; 
	return (*this);
}


void JoyceSdlTerm::beepOn(void)
{
	if (m_term && !m_beepStat) (*m_term) << '\7';
	JoyceTerminal::beepOn();
}


int ui_char_w() { return 8; }
int ui_char_h() { return 16; }
int ui_screen_w() { return 800; }
int ui_screen_h() { return 600; }
