/************************************************************************

    JOYCE v1.90 - Amstrad PCW emulator

    Copyright (C) 1996, 2001  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

class BootListEntry
{
public:
	string m_title;
	int m_id;
};


//
// This class is supposed to encapsulate the entire PCW system. 
//

class JoyceSystem
{
public:
//
// The actual hardware "modules"
//
	Z80		m_cpu;		// CPU
	JoyceMemory	m_mem;		// Memory controls
	JoyceAsic	m_asic;		// ASIC 
	JoyceFDC	m_fdc;		// Disc subsystem
	JoyceHDC	m_hdc;		// Hard drive controller
// Printers and similar peripherals
	JoyceMatrix     m_matrix;	// Matrix printer
	JoyceDaisy	m_daisy;	// Daisywheel printer
	JoyceCenPrinter	m_cen;		// Centronics printer
	JoyceCPS	m_cps;		// CPS8256
// Keyboard & mouse
	JoycePcwKeyboard m_keyb;	// The keyboard
	JoycePcwMouse    m_mouse;	// The mouse
// Terminals
	JoyceVgaTerm    m_termVga;	// 800x600 text screen
	JoycePcwTerm    m_termPcw;	// PCW screen
	JoyceLogoTerm	m_termLogo;	// Support for DR Logo
	JoyceMenuTermPcw  m_termMenu;	// Menu terminal
	JoyceDebugTerm  m_termDebug;	// Debugger terminal
//
// Resources that belong to the emulator, not the emulated machine
//
	JoyceSdlContext *m_video;	// Things like palettes and 
					// the SDL icon
//
// Internal state variables
//
	JoycePrinter  *m_activePrinter;	 // Current printer for LST intercept
	JoyceTerminal *m_activeTerminal; // Current screen
	JoyceInput    *m_activeKeyboard; // Current keyboard
	JoyceInput    *m_activeMouse;	 // Current mouse
        xmlDocPtr     m_settings;        // The XML DOM containing the settings 
	xmlDocPtr     m_bootcfg;	 // The XML DOM containing BOOT.CFG

	string        m_bootfile;
	vector<BootListEntry> m_bootList;
	byte	     *m_bootRom;
	int	      m_bootRomLen;
//
// Functions
//
public:
	JoyceSystem(JoyceArgs *a);
	~JoyceSystem();

	bool sysInit();		// Initialise the system

	bool loadHardware();	// Load the hardware description XML file.
	bool parseHardware();	// Allow the modules to parse the XML DOM.
	bool storeHardware();	// Ask the modules to save their state to the DOM
	bool saveHardware();	// Save the hardware XML file.

	// Handling booting. This combines several subsystems, so it goes in
	// JoyceSystem itself.
	bool loadBootList();
	bool parseBootList();
	bool storeBootList();
	bool storeBootEntry(int n);
	bool deleteBootEntry(int id);
	bool saveBootList();
	void getBootID(Z80 *R);
	UiEvent chooseBootDisc(UiDrawer *d, string &bootfile, char **type);
	UiEvent chooseBootID(UiDrawer *d, const string prompt, int *bootid);
	int fdcBoot(const string filename, char *type = NULL);
	int fdcBoot(int bootid);
	string idToFilename(int bootid);
	int lookupId(int bootid);
	bool loadBoot(string bootFile);
				// Switch video over to a different terminal.
	void selectTerminal(JoyceTerminal *t);
	bool initVideo(void);	// Start up video
	bool deinitVideo(void);	// Shut down video

	UiEvent settings(UiDrawer *d, int x, int y);
	void setDebug(bool debugMode = true);
	inline bool getDebug(void) { return m_debugMode; }

	// Handle SDL events
	int eventLoop(void);
	// System reset handling
	void reset(void);
	void setResetFlag(bool b = true);
	inline bool getResetFlag() { return m_resetPending; }

	// PCW type handling
	inline JoyceModel getModel() { return m_model; }
	void setModel(JoyceModel j);
protected:
	void addDevice(JoyceDevice *dev);
	UiEvent bootHelp(void);
	JoyceDevice **m_devices;
	int m_devCount, m_devMax;
	bool m_debugMode;
	bool m_resetPending;
	JoyceModel m_model;
	JoyceArgs *m_args;
};


