/************************************************************************

    JOYCE v1.90 - Amstrad PCW emulator

    Copyright (C) 1996, 2001  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

/* JOYCE video model:
 * 
 *    One JoyceSdlContext, which holds the following:
 *       * The master SdlSurface. 
 *       * The 256-colour palette, and functions to manage it.
 *       * The application icon.
 *
 *    A number of JoyceTerminals; at any time, one of them is switched in
 *    and the others aren't, cf CardLayout in the Java AWT. 
 *    JoyceSystem::m_activeTerminal holds the current terminal; it should
 *    be set with JoyceSystem::setActiveTerminal().
 */	

#include "SdlTerm.hxx"
#include "SdlVt52.hxx"

class JoyceTerminal : public JoyceDevice
{
	friend class JoyceSystem;
	friend class JoyceSdlTerm;

public:
	JoyceTerminal(const char *devname);
	virtual ~JoyceTerminal();

// State
protected:
	SdlContext *m_framebuf;
	JoyceSdlContext *m_sysVideo;
	bool	m_debugMode;
	bool	m_beepStat;
// Interface

protected:				// JoyceSystem is a friend and can
					// access these functions.
	virtual void onGainFocus();	// Terminal is gaining focus
	virtual void onLoseFocus();	// Terminal is about to lose focus
	virtual void onDebugSwitch(bool debugMode);
					// System is entering/leaving debug
					// mode.

public:
	virtual void onScreenTimer();	// Called at ~900Hz.

	void setSysVideo(JoyceSdlContext *s);
	inline JoyceSdlContext *getSysVideo(void) { return m_sysVideo; }

	virtual void out(word port, byte value);
	virtual byte in (word port);

	virtual void reset(void);

	inline  JoyceTerminal &operator << (signed char c) 
				{ return operator << ((unsigned char)c); }
	virtual JoyceTerminal &operator << (unsigned char c) = 0;
	JoyceTerminal & operator << (const char *s);
	JoyceTerminal & operator << (int i);
	JoyceTerminal & vprintf(char *s, va_list args);
	JoyceTerminal & printf(char *s, ...);

	virtual void beepOn(void);
	virtual void beepOff(void);

	virtual void setForeground(byte r, byte g, byte b) = 0;
	virtual void setBackground(byte r, byte g, byte b) = 0;

	virtual void tick(void);
};


void flipXbm(int w, int h, Uint8* bits);




