/************************************************************************

    JOYCE v1.90 - Amstrad PCW emulator

    Copyright (C) 1996, 2001  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/

#include "Joyce.hxx"

JoyceVgaTerm::JoyceVgaTerm(JoyceSystem *s) : JoyceSdlTerm("vga", s)
{
	XLOG("JoyceVgaTerm::JoyceVgaTerm()");
	m_menuTerm = NULL;
	m_framebuf = NULL;
	
	m_clrBG.r = 0x00; m_clrBG.g = 0x00; m_clrBG.b = 0xAA;
	m_clrFG.r = 0xFF; m_clrFG.g = 0xFF; m_clrFG.b = 0xFF;
        m_menuBg.r   = 0x00; m_menuBg.g   = 0x00; m_menuBg.b   = 0xAA;
        m_menuFg.r   = 0x55; m_menuFg.g   = 0xFF; m_menuBg.b   = 0xFF;
        m_shadowBg.r = 0x00; m_shadowBg.g = 0x00; m_shadowBg.b = 0x55;
        m_shadowFg.r = 0x55; m_shadowFg.g = 0x55; m_shadowBg.b = 0xAA;
}


JoyceVgaTerm::~JoyceVgaTerm()
{	
	if (m_term)	 delete m_term;
	if (m_menuTerm)  delete m_menuTerm;
}


void JoyceVgaTerm::onGainFocus()     // Terminal is gaining focus
{
	if (!m_term) m_term = new SdlVt52(m_sysVideo->getSurface()); 
	JoyceTerminal::onGainFocus();
}


////////////////////////////////////////////////////////////////////////////
//
// Code to load/store device settings from XML file
//

bool JoyceVgaTerm::parseNode(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur)
{
	parseColour(doc, ns, cur, "menu",   m_menuFg,   m_menuBg);
	parseColour(doc, ns, cur, "shadow", m_shadowFg, m_shadowBg);
	return true;
}


bool JoyceVgaTerm::storeNode(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur)
{
	storeColour(doc, ns, cur, "menu",   m_menuFg,   m_menuBg);
	storeColour(doc, ns, cur, "shadow", m_shadowFg, m_shadowBg);
	return true;
}







