
#include "Joyce.hxx"

#ifdef HAVE_WINDOWS_H

#include "Joycedos.hxx"
#include <direct.h>
#include <io.h>


void alert(const string s)
{
	::MessageBox(NULL, s.c_str(), "JOYCE fatal error", MB_OK | MB_ICONSTOP);
}

void txt2fcb(word addr, char *s);	/* Parse ASCII filename to FCB */

#define FIND_ATTR _A_RDONLY | _A_HIDDEN | _A_ARCH

static char pathname[162];	/* DOS pathname passed by Z80 program */


word jdos_wildex(Z80 *R)	/* Expand DOS wildcard */
{
	struct _finddata_t fblk;
	int m = 0;
	char c;
	long hfind;

	do {
		c = fetch((word)(R->getDE() + m));	/* Extract pathname */
		pathname[m] = c;
		++m;
	} while (c);

	fblk.attrib = FIND_ATTR;
	hfind = _findfirst(pathname, &fblk);
	
	if (!hfind) return 0;

	m = R->b;
	while (m > 0)
	{
		if (_findnext(hfind, &fblk)) return 0;
		--m;
	}
	
	/* Substitute filename into pathname */

	m = strlen(pathname) - 1;
	if (m < 0) return 0;

	while (pathname[m] != '\\' && 
	       pathname[m] != '/'  && 
               pathname[m] != ':'  && m >= 0) --m;	
	
	++m;
	strcpy(pathname + m, fblk.name);	/* Generated pathname */

	txt2fcb(R->getHL(), fblk.name);
	m = (-1);
	do {
		++m;
		store((word)(R->getHL() + m + 11), pathname[m]);
	} while (pathname[m]);
	return 1;
}
#undef FIND_ATTR

#endif	// def HAVE_WINDOWS_H
