/* 
 * SDLUI: emulator UI, built on SDL
 *
 * To customise the UI to a particular emulator's look and feel, the 
 * emulator should provide the following routines:
 *
 */

/* This UI library works in pixels. It uses ui_char_w() and ui_char_h() to 
 * convert to fixed-pitch character cells. */
void ui_menu_border(SDL_Surface *s, SDL_Rect *rect);
/* Draw a menu bar. For a Mac-like UI, ignore the last parameter; for a 
 * PCW-like UI, invert the bar when item_chosen is 1 */
void ui_menu_bar_bg(SDL_Surface *s, SDL_Rect *rect, int item_chosen);
int ui_screen_w(void);
int ui_screen_h(void);
int ui_char_w(void);
int ui_char_h(void);
SDL_Surface *ui_save_surface(SDL_Surface *s, SDL_Rect *rc);
void ui_draw_string(SDL_Surface *surface, int x, int y, unsigned char *s, 
			int inverse);
void ui_draw_mitem (SDL_Surface *surface, SDL_Rect *rect, char *s, int options,
			int selected);
/* SDLUI itself contains the following calls: */

typedef struct
{
        SDLKey uim_key;
        char *uim_caption;
        SDL_Rect uim_rect;  /* Calculated */
        int uim_options;    
} UI_MENUENTRY;

#define UIM_TITLE   1
#define UIM_BAR     2
#define UIM_NOCHECK 3
#define UIM_CHECKED 4

/* Returns -1 for cancelled, or index into "entries" */
int ui_menu_bar(SDL_Surface *surface, int y, int count, UI_MENUENTRY *entries);
int ui_menu    (SDL_Surface *surface, int x, int y, int count, 
		UI_MENUENTRY *entries, int selected);
/* These return:

  * Index of selected option, OR
  * -1  if cancelled out of menu, OR
  * -99 if received the dreaded SDL_QUIT notification */

/* Lock/unlock surface */
int ui_lock(SDL_Surface *s);
void ui_unlock(SDL_Surface *s);

/* Plot a pixel */
void ui_plot(SDL_Surface *surface, int x, int y, Uint32 pixel);

