	;	Disassembled by:
	;	DASMx object code disassembler
	;	(c) Copyright 1996-2003   Conquest Consultants
	;	Version 1.40 (Oct 18 2003)
	;	File:		IC26E.bin
	;	Size:		8192 bytes
	;	Checksum:	2602
	;	Date:		Tue May 31 12:15:30 2016
	;
	;	CPU:		Intel 8051 (MCS-51 family)
				
	; 5/31/2016 Ran code through DASMX

; To do:
;

; tasm -51 -g3 bit99IC26.asm bit99IC26.bin
; g0 is Intel Hex
; g3 selects binary

	#DEFINE BUGFIX

;constants:

p0		.equ	080h

sp		.equ	081h
dpl		.equ	082h
dph		.equ	083h

tcon		.equ	088h
it0		.equ	088h
ie0		.equ	089h
it1		.equ	08Ah
ie1		.equ	08Bh
tr0		.equ	08Ch
tf0		.equ	08Dh
tr1		.equ	08Eh
tf1		.equ	08Fh

tmod		.equ	089h
tl0		.equ	08Ah
tl1		.equ	08Bh
th0		.equ	08Ch
th1		.equ	08Dh

p1		.equ	090h
p1bit0		.equ	090h
p1bit1		.equ	091h
p1bit2		.equ	092h
p1bit3		.equ	093h
p1bit4		.equ	094h
p1bit5		.equ	095h
p1bit6		.equ	096h
p1bit7		.equ	097h

scon		.equ	098h
ri		.equ	098h
ti		.equ	099h
rb8		.equ	09Ah
tb8		.equ	09Bh
ren		.equ	09Ch
sm2		.equ	09Dh
sm1		.equ	09Eh
sm0		.equ	09Fh

sbuf		.equ	099h

p2		.equ	0A0h
p2bit0		.equ	0A0h
p2bit1		.equ	0A1h
p2bit2		.equ	0A2h
p2bit3		.equ	0A3h
p2bit4		.equ	0A4h
p2bit5		.equ	0A5h
p2bit6		.equ	0A6h
p2bit7		.equ	0A7h

p3		.equ	0B0h
p3bit0		.equ	0B0h
p3bit1		.equ	0B1h
p3bit2		.equ	0B2h
p3bit3		.equ	0B3h
p3bit4		.equ	0B4h
p3bit5		.equ	0B5h
p3bit6		.equ	0B6h
p3bit7		.equ	0B7h

ip		.equ	0B8h

ie		.equ	0A8h
ex0		.equ	0A8h
et0		.equ	0A9h
ex1		.equ	0AAh
et1		.equ	0ABh
es		.equ	0ACh
et2		.equ	0ADh
iebit6		.equ	0AEh
ea		.equ	0AFh

psw		.equ	0D0h
par		.equ	0D0h
pswbit1		.equ	0D1h
ov		.equ	0D2h
rs0		.equ	0D3h
rs1		.equ	0D4h
f0		.equ	0D5h
ac		.equ	0D6h
cy		.equ	0D7h

acc		.equ	0E0h
accbit0		.equ	0E0h
accbit1		.equ	0E1h
accbit2		.equ	0E2h
accbit3		.equ	0E3h
accbit4		.equ	0E4h
accbit5		.equ	0E5h
accbit6		.equ	0E6h
accbit7		.equ	0E7h

breg		.equ	0F0h
bregbit0	.equ	0F0h
bregbit1	.equ	0F1h
bregbit2	.equ	0F2h
bregbit3	.equ	0F3h
bregbit4	.equ	0F4h
bregbit5	.equ	0F5h
bregbit6	.equ	0F6h
bregbit7	.equ	0F7h


;I/O addresses:

MIDIUART	.equ	01000h
WVESEL13	.equ	01001h
WVESEL24	.equ	01002h
SANDHSEL	.equ	01003h
MDELEDS		.equ	01004h
DAC		.equ	01005h
DISPLAY		.equ	01006h
RDADC		.equ	01007h		;we read wheel values here

TIMER1		.equ	01010h		;8253 chip IC35
TIMER2		.equ	01014h		;8253 chip IC36
TIMER3		.equ	01018h		;8253 chip IC37
TIMER4		.equ	0101Ch		;8253 chip IC38

					;S&H channel select codes:
VC1SEL		.equ	030h		;CH6-1 code to select VC1
VC2SEL		.equ	031h
VC3SEL		.equ	032h		;these are all in IC21
VC4SEL		.equ	033h
VC5SEL		.equ	034h
VC6SEL		.equ	035h
VEN1SEL		.equ	036h
VEN2SEL		.equ	037h

VEN3SEL		.equ	028h		;CH6-1 code to select VEN3
VEN4SEL		.equ	029h
VEN5SEL		.equ	02Ah		;these are all in IC22
VEN6SEL		.equ	02Bh
VPU1SEL		.equ	02Ch
VPU2SEL		.equ	02Dh
VPU3SEL		.equ	02Eh
VPU4SEL		.equ	02Fh

VLFO1SEL	.equ	018h		;CH6-1 code to select VLFO1
VLFO2SEL	.equ	019h
VRE1SEL		.equ	01Ah		;these are all in IC22
VRE2SEL		.equ	01Bh
VDETUNSEL	.equ	01Ch
VBENDSEL	.equ	01Dh
VNOIS1SEL	.equ	01Eh
VNOIS2SEL	.equ	01Fh

;SRAM:	0-FFFh	(4K bytes)


;Memory addresses:

;Internal RAM:

;Bit-addressable RAM:
;		;byte 	20	bit address 	0-7
		;	21			8-F
		;	22			10-17
		;	23			18-1F
		;	24			20-27
		;	25			28-2F
		;	26			30-37
		;	27			38-3F
		;	28			40-47
		;	29			48-4F
		;	2A			50-57
		;	2B			58-5F
		;	2C			60-67
		;	2D			68-6F
		;	2E			70-77
		;	2F			78-7F

;Bit addresses:
LFO1TODCO1	.equ	030h
LFO1TODCO2	.equ	031h
LFO2TODCO1	.equ	034h
LFO2TODCO2	.equ	035h
SPLTMODE	.equ	040h		;set for split mode
DBLMODE		.equ	041h		;set for double mode
MIDIPRGCHG	.equ	044h		;set to enable MIDI program changes?  (parm 71)
MIDIPEDAL	.equ	045h		;set to enable MIDI release pedal ctl (parm 70)
MIDIBEND	.equ	046h		;set to enable MIDI pitch bend ctl (parm 68)
MIDIMOD		.equ	047h		;set to enable MIDI mod wheel ctl (parm 69)
OMNIMODE	.equ	048h		;set for OMNI mode (parm 72)

;Internal RAM Byte addresses

;Addresses 0-7 are used for r0-r7

VCE1NOTE	.equ	008h		;MIDI note number assigned to voice
VCE1VAR		.equ	009h		;possibly related to order of assignment?
VCE2NOTE	.equ	00Ah
VCE2VAR		.equ	00Bh
VCE3NOTE	.equ	00Ch
VCE3VAR		.equ	00Dh
VCE4NOTE	.equ	00Eh
VCE4VAR		.equ	00Fh
VCE5NOTE	.equ	010h
VCE5VAR		.equ	011h
VCE6NOTE	.equ	012h
VCE6VAR		.equ	013h

VCE1VAR2	.equ	020h		;some value for all six voices stored here
VCE2VAR2	.equ	021h		;in sim, they all had 0x11
VCE3VAR2	.equ	022h
VCE4VAR2	.equ	023h
VCE5VAR2	.equ	024h
VCE6VAR2	.equ	025h

LFOflgs1	.equ	026h		;LFO Flags byte 1
					;D0: LFO1->DCO1 (bit addr 30)
					;D1: LFO1->DCO2 (bit addr 31)
					;D2: LFO1->VCF  (bit addr 32)
					;D3: LFO1->VCA  (bit addr 33)
					;D4: LFO2->DCO1 (bit addr 34)
					;D5: LFO2->DCO2 (bit addr 35)
					;D6: LFO2->VCF  (bit addr 36)
					;D7: LFO2->VCA  (bit addr 37)

LFOflgs2	.equ	027h		;LFO Flags byte 2
					;D1-0: 00 No LFO1	(bit addr 39,38)
					;      01 Triangle LFO1
					;      10 Saw LFO1
					;      11 Pulse LFO1
					;D3-2: 00 No LFO2	(bit addr 3B,3A)
					;      01 Triangle LFO2
					;      10 Saw LFO2
					;      11 Pulse LFO2
					;D6-4: notused
					;D7 : Invert		 (bit addr 3F)
flags3		.equ	028h		;another flag byte

wvesel13	.equ	02Ah		;shadow for IC23, wvesels 1,3, but low 6 bits get inverted first
wvesel24	.equ	02Bh		;shadow for IC22, wvesels 2,4, but low 6 bits get inverted first
LFO1val		.equ	030h		;current value for LFO1
LFO2val		.equ	031h		;current value for LFO2

;External RAM

vce1var0	.equ	000h		;8 values for each voice in this array
vce1var1	.equ	001h
vce1var2	.equ	002h
vce1var3	.equ	003h		;related to note, held 0F for MIDI note 30h, 10 for 32h
vce1var4	.equ	004h		;related to note, held 3E for MIDI note 30h, 3F for 32h
vce1var5	.equ	005h
vce1var6	.equ	006h
vce1var7	.equ	007h

vce2var0	.equ	008h
vce2var1	.equ	009h
vce2var2	.equ	00Ah
;etc
vce6var7	.equ	02Fh		;end of voice variables array

DACvalVC1	.equ	030h		;VC1 CV is updated using this value
DACvalVC2	.equ	031h
DACvalVC3	.equ	032h
DACvalVC4	.equ	033h
DACvalVC5	.equ	034h
DACvalVC6	.equ	035h

DACvalVEN1	.equ	036h		;VEN1 CV updated with this value
DACvalVEN2	.equ	037h
DACvalVEN3	.equ	038h
DACvalVEN4	.equ	039h
DACvalVEN5	.equ	03Ah
DACvalVEN6	.equ	03Bh

LEDshad		.equ	03Eh		;shadow for LED register IC3 (1 turns on LED)

dispval1	.equ	067h		;current value for digit 1 (left?), top nib should be 1
dispval2	.equ	068h		;current value for digit 2, top nib should be 2

dispval3	.equ	069h		;current value for digit 3, top nib should be 3
dispval4	.equ	06Ah		;current value for digit 4, top nib should be 4

dispval5	.equ	06Bh		;current value for digit 5, top nib should be 5
dispval6	.equ	06Ch		;current value for digit 6, top nib should be 6

dispval7	.equ	06Dh		;current value for digit 7, top nib should be 7
dispval8	.equ	06Eh		;current value for digit 8 (right?), top nib should be 8

					;these prog values seem to be also stored here, possibly for lower prog:
					;values are left-justified in their byte
lwheelamt	.equ	06Fh		;parm #12, 6 bits, Wheel Amount
lLFO1dpth	.equ	070h		;parm #11, 6 bits, LFO1 Depth
lLFO1rate	.equ	071h		;parm #10, 6 bits, LFO1 Dynamic Rate
lLFO2dpth	.equ	072h		;parm #63, 6 bits, LFO2 Depth
lLFO2rate	.equ	073h		;parm #62, 6 bits, LFO2 Dynamic Rate
lDetune		.equ	074h		;parm #45, 6 bits, Detune (0-128 no detune), (value-128)/2 is used
lVolume		.equ	075h		;parm #48, 6 bits, Volume
lNoise		.equ	076h		;parm #34, 6 bits, Noise (used as Noise1 cv value)
lDCO1PWM	.equ	077h		;parm #33, 6 bits, DCO1 Dynamic Pulse Width
lDCO2PWM	.equ	078h		;parm #44, 6 bits, DCO2 Dynamic Pulse WIdth
lDCO1Freq	.equ	079h		;		   DCO1 Octave/Freq
lDCO2Freq	.equ	07Ah		;		   DCO2 Octave/Freq	
lDCO1PW		.equ	07Bh		;parm #32, 5 bits, DCO1 Pulse Width
lDCO2PW		.equ	07Ch		;parm #43, 5 bits, DCO2 Pulse Width
lVCFCut		.equ	07Dh		;parm #19, 6 bits, VCF Cutoff Freq
lVCFRes		.equ	07Eh		;parm #20, 6 bits, VCF Resonance (used as VRE1 cv value)
lVCFSust	.equ	07Fh		;parm #15, 6 bits, VCF Sustain
lVCFEnv		.equ	080h		;parm #21, 6 bits, VCF Envelope
lVCFTrk		.equ	081h		;parm #18, 6 bits, VCF Tracking
lVCFDAtt	.equ	082h		;parm #17, 6 bits, VCF Dynamic Attack
lVCFDEnv	.equ	083h		;parm #22, 6 bits, VCF Dynamic Envelope
lVCASust	.equ	084h		;parm #51, 6 bits, VCA Sustain
lVCADAtt	.equ	085h		;parm #46, 6 bits, VCA Dynamic Attack
lVCADVol	.equ	086h		;parm #47, 6 bits, VCA Dynamic Volume


DACvalVPU1	.equ	093h		;VPU1 CV updated with this value
DACvalVPU2	.equ	094h		;VPU2 CV updated with this value

					;these prog values seem to also be stored here, possibly always used for top three voices:
uwheelamt	.equ	097h		;parm #12, 6 bits, Wheel Amount
uLFO1dpth	.equ	098h		;parm #11, 6 bits, LFO1 Depth
uLFO1rate	.equ	099h		;parm #10, 6 bits, LFO1 Dynamic Rate
uLFO2dpth	.equ	09Ah		;parm #63, 6 bits, LFO2 Depth
uLFO2rate	.equ	09Bh		;parm #62, 6 bits, LFO2 Dynamic Rate
uDetune		.equ	09Ch		;parm #45, 6 bits, Detune (0-128 no detune), (value-128)/2 is used
uVolume		.equ	09Dh		;parm #48, 6 bits, Volume
uNoise		.equ	09Eh		;parm #34, 6 bits, Noise (used as Noise2 cv value)
uDCO1PWM	.equ	09Fh		;parm #33, 6 bits, DCO1 Dynamic Pulse Width
uDCO2PWM	.equ	0A0h		;parm #44, 6 bits, DCO2 Dynamic Pulse WIdth
uDCO1Freq	.equ	0A1h		;		   DCO1 Octave/Freq
uDCO2Freq	.equ	0A2h		;		   DCO2 Octave/Freq	
uDCO1PW		.equ	0A3h		;parm #32, 5 bits, DCO1 Pulse Width
uDCO2PW		.equ	0A4h		;parm #43, 5 bits, DCO2 Pulse Width
uVCFCut		.equ	0A5h		;parm #19, 6 bits, VCF Cutoff Freq
uVCFRes		.equ	0A6h		;parm #20, 6 bits, VCF Resonance (used as VRE2 cv value)
uVCFSust	.equ	0A7h		;parm #15, 6 bits, VCF Sustain
uVCFEnv		.equ	0A8h		;parm #21, 6 bits, VCF Envelope
uVCFTrk		.equ	0A9h		;parm #18, 6 bits, VCF Tracking
uVCFDAtt	.equ	0AAh		;parm #17, 6 bits, VCF Dynamic Attack
uVCFDEnv	.equ	0ABh		;parm #22, 6 bits, VCF Dynamic Envelope
uVCASust	.equ	0ACh		;parm #51, 6 bits, VCA Sustain
uVCADAtt	.equ	0ADh		;parm #46, 6 bits, VCA Dynamic Attack
uVCADVol	.equ	0AEh		;parm #47, 6 bits, VCA Dynamic Volume


DACvalVPU3	.equ	0BBh		;VPU1 CV updated with this value
DACvalVPU4	.equ	0BCh		;VPU2 CV updated with this value

					;these prog values seem to be also stored here:
VCFAtt		.equ	0BDh		;parm #13, 8 bits, VCF Attack (0-3F only)
VCFDel		.equ	0BEh		;parm #14, 8 bits, VCF Delay (0-3F only)
VCFRel		.equ	0BFh		;parm #16, 8 bits, VCF Release (0-3F only)
VCAAtt		.equ	0C0h		;parm #49, 8 bits, VCA Attack (0-3F only)	
VCADel		.equ	0C1h		;parm #50, 8 bits, VCA Delay (0-3F only)
VCARel		.equ	0C2h		;parm #52, 8 bits, VCA Release (0-3F only)
LFO1Del		.equ	0C3h		;parm #08, 8 bits, LFO1 Delay (0-3F only)
LFO2Del		.equ	0C4h		;parm #60, 8 bits, LFO2 Delay (0-3F only)
LFO1Rate	.equ	0C5h		;parm #09, 8 bits, LFO1 Rate (0-3F only)
LFO2Rate	.equ	0C6h		;parm #61, 8 bits, LFO2 Rate (0-3F only)

MIDImodval	.equ	0CDh
MIDIchan	.equ	0CEh		;seems to hold MIDI rx channel in low 4 bits
splitpt		.equ	0CFh		;split point 

col3prev	.equ	0D0h		;guessing this holds prev value sw col 3
col2prev	.equ	0D1h		;guessing this holds prev value sw col 2
col1prev	.equ	0D2h		;guessing this holds prev value sw col 1

bendval		.equ	0D5h		;current bend wheel ADC value
modval		.equ	0D6h		;current mod wheel ADC value
spltmintr	.equ	0D7h		;split pt minus transpose value
uprtrans	.equ	0D8h		;upper transpose byte

curkeynote	.equ	0D9h		;MIDI note number of most recent key
curkeyvel	.equ	0DAh		;velocity value rec'd from key MCU for most recent key

swbufctr	.equ	0DDh		;number of events in switch event buffer
swbufrdptr	.equ	0DEh		;next buffer location to be read from buffer
swbufwrptr	.equ	0DFh		;next buffer location to be written to 
swbufbeg	.equ	0E0h		;start of circular switch events buffer
swbufend	.equ	0EFh		;end of buffer

ttxcnt		.equ	0F7h		;counts bytes in tape tx buffer
ttxbufwrptr	.equ	0F9h
krxcnt		.equ	0FAh		;counts bytes in keybed rx buffer
krxbufrdptr	.equ	0FBh
krxbufwrptr	.equ	0FCh		;for internal UART
Mrxcnt		.equ	0FDh		;MIDI rx buffer byte count
Mrxbufwrptr	.equ	0FFh		;MIDI rx buffer write ptr

Mrxbufbeg	.equ	0100h		;MIDI rx buffer
Mrxbufend	.equ	01FFh
krxbufbeg	.equ	0200h		;keybed rx buffer
krxbufend	.equ	02FFh
ttxbufbeg	.equ	0300h		;tape tx buffer 
ttxbufend	.equ	037Fh

progstore	.equ	0380h		;start of program storage, each is 37 bytes
prgend		.equ	0E56h		;there are 75 of them, so 2775 bytes

spdbprgbeg	.equ	0E57h		;start of split/double program storage, each is 7 bytes
spdbprgend	.equ	0EFEh		;there are 24 of them, so 168 bytes

lowprgbeg	.equ	0EFFh		;guessing this is the start of the lower program buffer (37 bytes)
lowprgend	.equ	0F23h

uprprgbeg	.equ	0F24h		;guessing this is the start of the lower program buffer (37 bytes)
uprprgend	.equ	0F48h

flags23		.equ	0FF0h		;some sort of flags byte

lowerprg	.equ	0FF4h		;current lower program
upperprg	.equ	0FF5h		;current upper program
flags		.equ	0FF9h
bendcv		.equ	0FFFh		;bend CV DAC value

;Program format:
;offset	low addr	parm #		bits	descr
;0	0EFFh		12		6	Wheel Amount
;1	0F00h		11		6	LFO1 Depth
;2	0F001		10		6	LFO1 Dynamic Rate
;3	0F002		63		6	LFO2 Depth
;4	0F003		62		6	LFO2 Dynamic Rate
;5	0F004		45		6	Detune (0-128 no detune), (value-128)/2 is used
;6	0F005		48		6	Volume
;7	0F006		34		6	Noise
;8	0F007		33		6	DCO1 Dynamic Pulse Width
;9	0F008		44		6	DCO2 Dynamic Pulse WIdth
;A	0F009					DCO1 Octave/Freq
;B	0F00A					DCO2 Octave/Freq	
;C	0F00B		32		5	DCO1 Pulse Width
;D	0F00C		43		5	DCO2 Pulse Width
;E	0F00D		19		6	VCF Cutoff Freq
;F	0F00E		20		6	VCF Resonance
;10	0F00F		15		6	VCF Sustain
;11	0F010		21		6	VCF Envelope
;12	0F011		18		6	VCF Tracking
;13	0F012		17		6	VCF Dynamic Attack
;14	0F013		22		6	VCF Dynamic Envelope
;15	0F014		51		6	VCA Sustain
;16	0F015		46		6	VCA Dynamic Attack
;17	0F016		47		6	VCA Dynamic Volume
;18	0F017		13		8	VCF Attack (0-3F only)
;19	0F018		14		8	VCF Delay (0-3F only)
;1A	0F019		16		8	VCF Release (0-3F only)
;1B	0F01A		49		8	VCA Attack (0-3F only)	
;1C	0F01B		50		8	VCA Delay (0-3F only)
;1D	0F01C		52		8	VCA Release (0-3F only)
;1E	0F01D		08		8	LFO1 Delay (0-3F only)
;1F	0F01E		60		8	LFO2 Delay (0-3F only)
;20	0F01F		09		8	LFO1 Rate (0-3F only)
;21	0F020		61		8	LFO2 Rate (0-3F only)
;22	0F021					LFO Flags byte 1
;23	0F022					LFO Flags byte 2
;24	0F023					DCO Flags
	

					;addresses in IC27 that we reference:
L2400		.equ	2400h		;timer divider values 16-bit table
L2500		.equ	2500h		;256-byte table, DCO PW CV values
L2600		.equ	2600h					
L3000		.equ	3000h		;timer 0 vector, code to update the CV's
L3500		.equ	3500h		;looks like the tape code

					;we have 4K of RAM total, or addresses 0-FFFh		
	
	.org	00000H
L0000:
	ljmp	L17A8		;jump to init code

L003:				;IE0 vector (INT0, TXRDY)
	clr	ea		;disable all interrupts
	ljmp	L1A55

	.db	$0FF
	.db	$0FF
	.db	$0FF

L000B:				;TF0 vector (timer 0 overflow)
	mov	th0,#0A0H	;seems to update display, and maybe some S&H voltages
	ljmp	L3000

	.db	$0FF
	.db	$0FF

L0013:				;IE1 vector (INT1, RXRDY)
	clr	ea		;disable all interrupts
	ljmp	L1A88

	.FILL	($0023-$),$0FF
 
L0023:				;RI + TI vector (Rx and Tx)
	clr	ea		;disable all interrupts
	ljmp	L1AB9



L0028:				;L1801 jumps here
	mov	r0,#0DDH	;check sw events count
	movx	a,@r0
	jnz	L0038		;jump if there are events to be processed

	jb	04EH,L0033
	ljmp	L1804

L0033:
	mov	r3,#000H
	ljmp	L007A

L0038:
	dec	a
	movx	@r0,a		;decrement the event ctr

	mov	r0,#0DEH	;point to sw events buf read ptr
	movx	a,@r0		;get ptr
	mov	r1,a		;into r1
	inc	a		;inc it
	clr	accbit4		;wrap it at 16
	movx	@r0,a		;and update it

	movx	a,@r1		;read next event byte
	mov	r3,a		;save it in r3

	cjne	r3,#00AH,L004A

	ljmp	L007A

L004A:
	jc	L007A		;sw code is 1-9, for numbers
	cjne	r3,#014H,L0052

	ljmp	L007A

L0052:
	jnc	L007A

	clr	c
	subb	a,#00BH		;subtract 11 from switch code
	mov	breg,#003H
	mul	ab
	mov	dptr,#L005F
	jmp	@a+dptr	
L005F:				;jump table
	ljmp	L1000		;sw 11 Address? 
	ljmp	L0416		;sw 12 Compare?
	ljmp	L008B		;sw 13 Lower?
	ljmp	L0331		;sw 14 Park?
	ljmp	L020E		;sw 15 Upper?
	ljmp	L045D		;sw 16 Split?
	ljmp	L04E5		;sw 17 Double?
	ljmp	L3500		;sw 18 Looks like Tape code
	ljmp	L0CF6		;sw 19 Prg Chain?

L007A:
	jb	04DH,L0080
	ljmp	L1804

L0080:
	mov	r0,#0C8H
	movx	a,@r0
	mov	dph,a
	inc	r0
	movx	a,@r0
	mov	dpl,a
	clr	a
	jmp	@a+dptr		;jump to address in C8:C9


L008B:				;lower switch press jumps here
	mov	r0,#03DH
	movx	a,@r0
	jbc	accbit6,L0093	;if lower was on, turn it off
	sjmp	L00CF		;otherwise, turn it on

L0093:
	movx	@r0,a		;update flag

	mov	r0,#06BH	;lower program left digit
	lcall	L06E6		;converts 2-digit bcd display value at r0 back to binary (in acc)

	mov	r2,a
	mov	r0,#0DFH
	movx	a,@r0
	mov	r1,a
	mov	a,r2
	mov	breg,#00AH
	div	ab
	jnz	L00A7
	mov	a,#00AH
L00A7:
	movx	@r1,a
	inc	r1
	xch	a,r1
	clr	accbit4
	xch	a,r1
	mov	a,breg
	jnz	L00B3
	mov	a,#00AH
L00B3:
	movx	@r1,a
	inc	r1
	mov	a,r1
	clr	accbit4
	movx	@r0,a
	mov	r0,#0DDH
	movx	a,@r0
	add	a,#002H
	movx	@r0,a
	lcall	L14CF
	mov	r0,#06DH	;upper program left digit

	mov	a,#06EH
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	mov	dptr,#00FF8H
	mov	a,#000H
	movx	@dptr,a

L00CF:
	setb	04DH		;turn on Lower flag?

	mov	r0,#03EH	;point to LED shadow
	movx	a,@r0		;read it
	setb	accbit2		;turn on LOWER
	clr	f0
	jnb	accbit0,L00DF	;set f0 based on ADDRESS LED state
	setb	f0
	clr	accbit0		;turn off ADDRESS
L00DF:
	clr	accbit1		;turn off COMPARE
	clr	accbit4		;turn off UPPER
	movx	@r0,a		;update shadow
	lcall	L0861		;update mode LEDs from shadow at 0x3E
	jnb	f0,L010D

	lcall	L14CF
	mov	a,$0028
	anl	a,#003H
	jz	L010D
	mov	r0,#0C7H
	movx	a,@r0
	cjne	a,#000H,L00FC
	ljmp	L010D

L00FC:
	mov	r0,#069H	;parm address left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs
	jnb	040H,L010D	;skip down if not in split mode

	mov	r0,#0CFH
	movx	a,@r0
	inc	a
	mov	r0,#067H	;value left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

L010D:
	clr	04EH
	clr	04CH
	mov	r0,#0C8H
	mov	a,#001H
	movx	@r0,a
	inc	r0
	mov	a,#02EH
	movx	@r0,a

	mov	r0,#03EH
	movx	a,@r0
	mov	c,accbit3
	orl	c,040H		;OR in split mode enable
	orl	c,041H		;and double mode enable
	jc	L012B

	mov	dptr,#00EFFH
	lcall	L083B		;build 37-byte program image at [dptr]
L012B:
	ljmp	L1804
;
	cjne	r3,#00AH,L0136
	mov	r3,#000H
	ljmp	L015E
;
L0136:
	jc	L015E
	jb	04CH,L015B

	mov	r0,#06BH	;lower program left digit
	lcall	L06E6		;converts 2-digit bcd display value at r0 back to binary (in acc)

	cjne	r3,#014H,L014D
	clr	c
	subb	a,#001H
	jnc	L014A
	mov	a,#000H
L014A:
	ljmp	L0180
;
L014D:
	inc	a
	cjne	a,#063H,L0154
	ljmp	L0158
;
L0154:
	jc	L0158
	mov	a,#063H
L0158:
	ljmp	L0180
L015B:
	ljmp	L1804
;
L015E:
	jbc	04CH,L017A

	mov	a,#00AH
	mov	r0,#06CH
	lcall	L06FE
	mov	a,r3
	mov	r0,#06BH	;lower program left digit
	lcall	L06FE

	setb	04CH

	mov	dptr,#00FF0H
	movx	a,@dptr
	clr	accbit0
	movx	@dptr,a

	ljmp	L1804

L017A:
	mov	r0,#06BH	;lower program left digit
	lcall	L06E6		;converts 2-digit bcd display value at r0 back to binary (in acc)

	add	a,r3
L0180:
	jnz	L0183
	inc	a
L0183:
	mov	r0,#06BH	;lower program left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs
	mov	r3,a
	dec	r3
	mov	dptr,#00FFAH
	movx	a,@dptr
	cjne	a,#001H,L0194
	ljmp	L01BD

L0194:
	mov	r0,#0CEH	;seems to hold MIDI channels
	movx	a,@r0
	swap	a		;probably tx one in the upper 4 bits
	anl	a,#00FH
	orl	a,#0C0H		;Cn would be a program change
	mov	r2,a

	clr	f0
	lcall	L0F9D		;writes r2,r3 to tx buffer, and if f0 set, r4 as well

	mov	dptr,#00FFAH
	movx	a,@dptr
	cjne	a,#002H,L01BD

	mov	dptr,#00FF0H
	movx	a,@dptr
	setb	accbit0
	movx	@dptr,a

	mov	dptr,#00FECH
	mov	a,#0FFH
	movx	@dptr,a
	inc	dptr
	mov	a,#003H
	movx	@dptr,a
	ljmp	L1804
;
L01BD:
	lcall	L0FDC		;clear a bunch of internal RAM and first 12 CV's

	mov	a,r3
	inc	a
	cjne	a,#04CH,L01C8
	ljmp	L01F9

L01C8:
	jnc	L01F9
	mov	r0,#06BH	;lower program left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	lcall	L0709		;loads dptr with RAM starting address for program # in acc (1-99)

	lcall	L0827
	jb	041H,L01DE	;skip if double mode enabled
	jb	040H,L01DE	;or if split mode enabled

	lcall	L07DA

L01DE:
	lcall	L07F8		;update waveform select hw from 2A,2B shadows
	mov	r0,#03EH
	movx	a,@r0
	jb	accbit3,L01ED
	mov	dptr,#00EFFH
	lcall	L083B		;build 37-byte program image at [dptr]

L01ED:
	mov	r0,#06BH	;lower program left digit
	lcall	L06E6		;converts 2-digit bcd display value at r0 back to binary (in acc)

	mov	dptr,#00FF4H	;lower program number?
	movx	@dptr,a
	ljmp	L1804


L01F9:
	mov	r0,#0C7H
	movx	@r0,a
	mov	r5,a
	lcall	L0719		;get address of split/dbl prog # in acc into dptr

	lcall	L086A

	mov	r0,#06DH	;upper program left digit
	lcall	L06E6		;converts 2-digit bcd display value at r0 back to binary (in acc)

	mov	dptr,#00FF5H	;upper program number?
	movx	@dptr,a
	sjmp	L01ED

L020E:
	mov	r0,#03DH
	movx	a,@r0
	jnb	accbit6,L0217
	ljmp	L1804
;
L0217:
	mov	a,$0028
	anl	a,#003H
	jnz	L0220
	ljmp	L1804

L0220:
	setb	04DH

	mov	r0,#03EH	;point to LED shadow
	movx	a,@r0		;read it
	setb	accbit4		;turn on UPPER
	clr	f0
	jnb	accbit0,L0230	;set f0 based on ADDRESS LED prev state
	setb	f0
	clr	accbit0		;turn off ADDRESS
L0230:
	clr	accbit1		;turn off COMPARE
	clr	accbit2		;turn off LOWER
	movx	@r0,a		;update shadow

	lcall	L0861		;update mode LEDs from shadow at 0x3E
	jnb	f0,L0258

	lcall	L14CF
	mov	r0,#0C7H
	movx	a,@r0
	cjne	a,#000H,L0247
	ljmp	L0258

L0247:
	mov	r0,#069H	;parm address left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	jnb	040H,L0258	;skip if split not enabled

	mov	r0,#0CFH
	movx	a,@r0
	inc	a
	mov	r0,#067H	;value left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

L0258:
	clr	04EH
	clr	04CH
	mov	r0,#0C8H
	mov	a,#002H
	movx	@r0,a
	inc	r0
	mov	a,#068H
	movx	@r0,a
	ljmp	L1804
;
	cjne	r3,#00AH,L0270
	mov	r3,#000H
	ljmp	L028E
;
L0270:
	jc	L028E
	jb	04CH,L028B

	mov	r0,#06DH	;upper program left digit
	lcall	L06E6		;converts 2-digit bcd display value at r0 back to binary (in acc)

	cjne	r3,#014H,L0287
	clr	c
	subb	a,#001H
	jnc	L0284
	mov	a,#000H
L0284:
	ljmp	L02B0
;
L0287:
	inc	a
	ljmp	L02B0
L028B:
	ljmp	L1804
;
L028E:
	jbc	04CH,L02AA
	mov	a,#00AH
	mov	r0,#06EH
	lcall	L06FE
	mov	a,r3
	mov	r0,#06DH	;upper program left digit
	lcall	L06FE
	setb	04CH
	mov	dptr,#00FF0H
	movx	a,@dptr
	clr	accbit1
	movx	@dptr,a
	ljmp	L1804
;
L02AA:
	mov	r0,#06DH	;upper program left digit
	lcall	L06E6		;converts 2-digit bcd display value at r0 back to binary (in acc)

	add	a,r3
L02B0:
	cjne	a,#04BH,L02B6
	ljmp	L02BA
;
L02B6:
	jc	L02BA
	mov	a,#04BH
L02BA:
	jnz	L02BD
	inc	a
L02BD:
	mov	r0,#06DH	;upper program left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	mov	r3,a
	dec	r3
	mov	dptr,#00FF9H	;flag byte?
	movx	a,@dptr
	jz	L02E3

	mov	dptr,#00FFAH
	movx	a,@dptr
	cjne	a,#001H,L02D4
	ljmp	L02FE

L02D4:
	mov	r0,#0CEH	;seems to hold MIDI channels
	movx	a,@r0
	swap	a		;tx is in upper 4 bits
	inc	a		;adjust MIDI channel for split?
	anl	a,#00FH
	orl	a,#0C0H		;Cn would be a program change
	mov	r2,a

	clr	f0
	lcall	L0F9D		;writes r2,r3 to tx buffer, and if f0 set, r4 as well

L02E3:
	mov	dptr,#00FFAH
	movx	a,@dptr
	cjne	a,#002H,L02FE
	mov	dptr,#00FF0H
	movx	a,@dptr
	setb	accbit1
	movx	@dptr,a
	mov	dptr,#00FEEH
	mov	a,#0FFH
	movx	@dptr,a
	inc	dptr
	mov	a,#003H
	movx	@dptr,a
	ljmp	L1804
;
L02FE:
	lcall	L0FDC		;clear a bunch of internal RAM and first 12 CV's

	mov	a,r3
	inc	a
	mov	r0,#06DH	;upper program left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	mov	dptr,#00FF5H	;upper program number
	movx	@dptr,a

	lcall	L0709	;loads dptr with RAM starting address for program # in acc (1-99)

	inc	dptr
	inc	dptr
	inc	dptr
	inc	dptr
	inc	dptr
	inc	dptr
	mov	r0,#09DH
	lcall	L0736
	lcall	L073F
	inc	dptr
	inc	dptr
	inc	dptr
	inc	dptr
	inc	dptr
	movx	a,@dptr
	mov	c,accbit7
	mov	043H,c
	inc	dptr
	movx	a,@dptr
	mov	$002B,a		;2B is shadow for wavesels 2,4
	lcall	L07F8		;update waveform select hw from 2A,2B shadows
	ljmp	L1804

L0331:
	mov	r0,#03DH
	movx	a,@r0
	jnb	accbit6,L033A
	ljmp	L1804

L033A:
	mov	r0,#03CH
	movx	a,@r0
	setb	accbit7
	movx	@r0,a
	lcall	L1A45
	mov	c,p1bit6
	jc	L034A
	ljmp	L1804

L034A:
	mov	r0,#03EH	;point to LED shadow
	movx	a,@r0		;read it
	jb	accbit3,L03A6	;jump if PARK LED is on

	clr	accbit0		;turn off ADDRESS
	clr	accbit1		;turn off COMPARE
	setb	accbit3		;turn on PARK
	clr	accbit2		;turn off LOWER
	clr	accbit4		;turn off UPPER
	movx	@r0,a		;update shadow

	lcall	L0861		;update mode LEDs from shadow at 0x3E

	clr	04DH
	mov	a,$0028
	anl	a,#003H
	jnz	L0378
	lcall	L14CF
	mov	dptr,#00EFFH
	lcall	L083B		;build 37-byte program image at [dptr]

	mov	r0,#03DH
	movx	a,@r0
	clr	accbit7
	movx	@r0,a
	ljmp	L1804
;
L0378:
	mov	dptr,#00EFFH
	lcall	L092F
	mov	r0,#03DH
	movx	a,@r0
	setb	accbit7
	movx	@r0,a
	mov	r0,#0C7H
	movx	a,@r0
	cjne	a,#000H,L0390
	lcall	L14CF
	ljmp	L1804
;
L0390:
	mov	r0,#069H	;parm address left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	mov	a,#06EH
	jnb	040H,L039E	;skip if split not enabled

	mov	r0,#0CFH
	movx	a,@r0
	inc	a
L039E:
	mov	r0,#067H	;value left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	ljmp	L1804
;
L03A6:
	mov	a,$0028
	anl	a,#003H
	jnz	L03E5
	mov	r0,#03DH
	movx	a,@r0
	jb	accbit7,L03E2

	mov	r0,#06BH	;lower program left digit
	lcall	L06E6		;converts 2-digit bcd display value at r0 back to binary (in acc)

	lcall	L0709		;loads dptr with RAM starting address for program # in acc (1-99)

	mov	r3,dpl
	mov	r4,dph
	mov	r5,dpl
	mov	breg,dph

	mov	dptr,#00EFFH
	mov	r2,#025H	;37 bytes
	lcall	L0810		;copy r2 count bytes from dptr to r4:r3

	mov	dpl,r5
	mov	dph,breg
	lcall	L0827
	lcall	L07DA
	lcall	L07F8		;update waveform select hw from 2A,2B shadows
L03D9:
	mov	r0,#03EH	;point to LED shadow
	movx	a,@r0		;read it
	clr	accbit3		;turn off PARK
	movx	@r0,a		;update shadow

	lcall	L0861		;update mode LEDs from shadow at 0x3E
L03E2:
	ljmp	L1804

L03E5:
	mov	r0,#03DH
	movx	a,@r0
	jnb	accbit7,L03E2
	mov	r0,#0C7H
	movx	a,@r0
	cjne	a,#000H,L03F4
	ljmp	L1804
;
L03F4:
	lcall	L0719		;get address of split/dbl prog # in acc into dptr

	mov	r3,dpl
	mov	r4,dph
	mov	r5,dpl
	mov	breg,dph
	mov	dptr,#00EFFH	;possible start of lower prog buffer
	mov	r2,#007H
	lcall	L0810		;copy r2 count bytes from dptr to r4:r3
	mov	dpl,r5
	mov	dph,breg
	mov	r0,#0C7H
	movx	a,@r0
	mov	r5,a
	lcall	L086A
	sjmp	L03D9
;
L0416:
	mov	r0,#03DH
	movx	a,@r0
	jnb	accbit6,L041F
	ljmp	L1804
;
L041F:
	mov	r0,#03EH	;point to LED shadow
	movx	a,@r0		;read it
	jbc	accbit3,L0452	;jump if PARK and clear bit

	mov	c,040H		;get split mode enable in cy
	orl	c,041H		;OR in double mode enable
	jc	L0452		;skip down if either is enabled

	cpl	accbit1
	movx	@r0,a
	lcall	L0861		;update mode LEDs from shadow at 0x3E

	mov	dptr,#00F24H	;possible start of upper prog buffer
	lcall	L083B		;build 37-byte program image at [dptr]

	mov	dptr,#00EFFH	;possible start of lower prog buffer
	lcall	L0827
	lcall	L07DA
	lcall	L07F8		;update waveform select hw from 2A,2B shadows

	mov	dptr,#00F24H	;possible start of upper prog buffer
	mov	r3,#0FFH
	mov	r4,#00EH
	mov	r2,#025H	;37 bytes
	lcall	L0810		;copy r2 count bytes from dptr to r4:r3
	ljmp	L1804


L0452:
	clr	accbit3		;turn off PARK
	clr	accbit1		;turn off COMPARE
	movx	@r0,a		;update LED shadow

	lcall	L0861		;update mode LEDs from shadow at 0x3E
	ljmp	L1804

L045D:
	mov	r0,#03DH
	movx	a,@r0
	jnb	accbit6,L0466
	ljmp	L1804
;
L0466:
	mov	r0,#03EH	;point to LED shadow
	movx	a,@r0		;read it
	jnb	accbit3,L046F	;jump if not PARK mode

	ljmp	L1804

L046F:
	jbc	040H,L04AF	;jump down if split enabled and disable it

	setb	accbit5		;turn on SPLIT 
	clr	accbit6		;turn off DOUBLE
	movx	@r0,a		;update shadow

	lcall	L0861		;update mode LEDs from shadow at 0x3E
	jb	041H,L048B

	mov	r0,#06BH	;lower program left digit
	lcall	L06E6		;converts 2-digit bcd display value at r0 back to binary (in acc)

	mov	r0,#06DH	;upper program left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	mov	dptr,#00FF5H	;upper program number?
	movx	@dptr,a
L048B:
	lcall	L0FDC		;clear a bunch of internal RAM and first 12 CV's

	setb	040H		;enable split mode
	clr	041H		;disable double mode

	mov	r0,#0C7H
	movx	a,@r0
	cjne	a,#000H,L049E
	lcall	L14CF
	ljmp	L1804

L049E:
	mov	r0,#069H	;parm address left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	mov	r0,#0CFH
	movx	a,@r0
	inc	a
	mov	r0,#067H	;value left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	ljmp	L1804

L04AF:				;we jumped here if we were in split mode
	clr	accbit5		;turn off SPLIT
	clr	accbit4		;turn off UPPER 
	setb	accbit2		;turn on LOWER
	clr	accbit0		;turn off ADDRESS
	movx	@r0,a		;update shadow

	lcall	L0861		;update mode LEDs from shadow at 0x3E

	lcall	L0FDC		;clear a bunch of internal RAM and first 12 CV's

	lcall	L14CF
	mov	a,#06EH
	mov	r0,#06DH	;upper program left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	setb	04DH
	clr	04EH
	clr	04CH
	mov	r0,#0C8H
	mov	a,#001H
	movx	@r0,a
	inc	r0
	mov	a,#02EH
	movx	@r0,a
	lcall	L07DA
	lcall	L07F8		;update waveform select hw from 2A,2B shadows

	mov	r0,#0C7H
	mov	a,#000H
	movx	@r0,a
	ljmp	L1804
;
L04E5:
	mov	r0,#03DH
	movx	a,@r0
	jnb	accbit6,L04EE
	ljmp	L1804
;
L04EE:
	mov	r0,#03EH	;point to LED shadow
	movx	a,@r0		;read it
	jnb	accbit3,L04F7	;jump if not in park mode

	ljmp	L1804

L04F7:
	jbc	041H,L0535
	setb	accbit6		;turn on DOUBLE
	clr	accbit5		;turn off SPLIT
	movx	@r0,a		;update shadow

	lcall	L0861		;update mode LEDs from shadow at 0x3E
	jb	040H,L0513	;skip if split mode enabled

	mov	r0,#06BH	;lower program left digit
	lcall	L06E6		;converts 2-digit bcd display value at r0 back to binary (in acc)

	mov	r0,#06DH	;upper program left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	mov	dptr,#00FF5H	;upper program number?
	movx	@dptr,a
L0513:
	lcall	L0FDC		;clear a bunch of internal RAM and first 12 CV's

	setb	041H		;enable double mode
	clr	040H		;disable split mode

	mov	r0,#0C7H
	movx	a,@r0
	cjne	a,#000H,L0526
	lcall	L14CF
	ljmp	L1804

L0526:
	mov	r0,#069H	;parm address left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	mov	r0,#067H	;value left digit
	mov	a,#06EH
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	ljmp	L1804

L0535:				;we jumped here if not in double mode
	clr	accbit6		;turn off DOUBLE
	clr	accbit4		;turn off UPPER
	setb	accbit2		;turn on LOWER
	clr	accbit0		;turn off ADDRESS
	movx	@r0,a		;update shadow

	lcall	L0861		;update mode LEDs from shadow at 0x3E

	lcall	L0FDC		;clear a bunch of internal RAM and first 12 CV's

	lcall	L14CF
	mov	a,#06EH

	mov	r0,#06DH	;upper program left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	setb	04DH
	clr	04EH
	clr	04CH
	mov	r0,#0C8H
	mov	a,#001H
	movx	@r0,a
	inc	r0
	mov	a,#02EH
	movx	@r0,a
	lcall	L07DA
	lcall	L07F8		;update waveform select hw from 2A,2B shadows

	mov	r0,#0C7H
	mov	a,#000H
	movx	@r0,a
	ljmp	L1804


L056B:				;seems to handle flag bit display and update
	clr	04EH
	mov	breg,r5
	mov	a,@r1
	ljmp	L0574
;
L0573:
	rr	a
L0574:
	djnz	r5,L0573

	mov	r5,breg
	cjne	r3,#000H,L057E
	ljmp	L0588
;
L057E:
	cjne	r3,#015H,L0586
	setb	accbit0
	ljmp	L0588
;
L0586:
	clr	accbit0
L0588:
	mov	r3,a
	anl	a,#001H
	mov	r0,#067H	;value left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs
	mov	a,r3
	ljmp	L0595
L0594:
	rl	a
L0595:
	djnz	r5,L0594

	mov	@r1,a
	cjne	r1,#02AH,L05A1
	mov	r1,#02BH
	mov	@r1,a
	lcall	L07F8		;update waveform select hw from 2A,2B shadows
L05A1:
	mov	c,042H
	mov	043H,c
	ljmp	L1804


L05A8:				;we jump here when we change parm 75, kbd mode
	clr	04EH	
	mov	dptr,#00FF9H	;flag byte?
	movx	a,@dptr
	cjne	r3,#000H,L05B4

	ljmp	L0602

L05B4:
	cjne	r3,#015H,L05DE
	mov	r0,#0CEH	;seems to hold MIDI channels
	movx	a,@r0
	swap	a		;tx one in upper 4 bits
	anl	a,#00FH
	orl	a,#0B0H		;Bn would be control change
	mov	r2,a
	mov	r3,#07CH	;7C means OMNI mode off
	mov	r4,#000H

	setb	f0
	lcall	L0F9D		;writes r2,r3 to tx buffer, and if f0 set, r4 as well

	inc	r2
	anl	$0002,#00FH
	orl	$0002,#0B0H

	setb	f0
	lcall	L0F9D		;writes r2,r3 to tx buffer, and if f0 set, r4 as well

	mov	dptr,#00FF9H
	movx	a,@dptr
	setb	accbit0	
	ljmp	L0602


L05DE:
	mov	r0,#0CEH	;seems to hold MIDI channels
	movx	a,@r0
	swap	a		;tx one in upper 4 bits
	anl	a,#00FH
	orl	a,#0B0H		;Bn would be control change
	mov	r2,a
	mov	r3,#07DH	;7D would be OMNI mode on
	mov	r4,#000H

	setb	f0
	lcall	L0F9D		;writes r2,r3 to tx buffer, and if f0 set, r4 as well

	inc	r2
	anl	$0002,#00FH
	orl	$0002,#0B0H

	setb	f0
	lcall	L0F9D		;writes r2,r3 to tx buffer, and if f0 set, r4 as well

	mov	dptr,#00FF9H
	movx	a,@dptr
	clr	accbit0	
L0602:
	anl	a,#001H
	movx	@dptr,a

	mov	r0,#067H	;value left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs
	ljmp	L1804
;
L060D:
	clr	04EH
	mov	a,$0027
	mov	breg,a
	jnb	f0,L061E
	rr	a
	rr	a
	anl	breg,#0F3H
	ljmp	L0621
;
L061E:
	anl	breg,#0FCH
L0621:
	anl	a,#003H
	cjne	r3,#000H,L0629
	ljmp	L0632
;
L0629:
	cjne	r3,#015H,L0630
	mov	a,r5
	ljmp	L0632
;
L0630:
	mov	a,#000H
L0632:
	cjne	a,$0005,L063A
	mov	r5,#001H
	ljmp	L063C
;
L063A:
	mov	r5,#000H
L063C:
	jnb	f0,L0641
	rl	a
	rl	a
L0641:
	orl	a,breg
	mov	$0027,a
	mov	a,r5
	mov	r0,#067H	;value left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs
	ljmp	L1804
;
L064E:
	clr	04EH
	movx	a,@r1
	mov	breg,#00CH
	div	ab
	mov	r0,breg
	cjne	r3,#000H,L0667
	cjne	a,$0005,L0662
	mov	a,#001H
	ljmp	L067F
;
L0662:
	mov	a,#000H
	ljmp	L067F
;
L0667:
	cjne	r3,#015H,L0675
	mov	a,r5
	mov	breg,#00CH
	mul	ab
	add	a,r0
	mov	r5,#001H
	ljmp	L0678
;
L0675:
	mov	a,r0
	mov	r5,#000H
L0678:
	movx	@r1,a
	xch	a,r1
	add	a,#028H
	xch	a,r1
	movx	@r1,a
	mov	a,r5
L067F:
	mov	r0,#067H	;value left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs
	ljmp	L1804
;
L0687:
	movx	a,@r1
	mov	breg,#00CH
	div	ab
	xch	a,breg
	cjne	r3,#000H,L0694
	ljmp	L06B8


L0694:
	cjne	r3,#015H,L06A5
	inc	a
	cjne	a,#00BH,L069E
	ljmp	L06AC
;
L069E:
	jc	L06AC
	mov	a,#00BH
	ljmp	L06AC
;
L06A5:
	clr	c
	subb	a,#001H
	jnc	L06AC
	mov	a,#000H
L06AC:
	mov	r0,a
	mov	a,#00CH
	mul	ab
	add	a,r0
	movx	@r1,a
	xch	a,r1
	add	a,#028H
	xch	a,r1
	movx	@r1,a
	mov	a,r0
L06B8:
	mov	r0,#067H	;value left digit
	lcall	L06C0
	ljmp	L1804



L06C0:				;converts acc to bcd, adds dig indexes, writes to 2 dsp buf locs at r0
	mov	r4,a		;save acc in r4
	cjne	a,#06EH,L06CC	;if acc=6E, skip

	mov	a,#00AH
	mov	breg,#00AH
	ljmp	L06D4

L06CC:
	mov	breg,#00AH	
	div	ab		;divide a by 10, a=rslt, b=rem
	jnz	L06D4
	mov	a,#00AH
L06D4:
	mov	r2,a		;tens part in r2
	mov	a,r0		;r0 pts to dest addr
	clr	c
	subb	a,#066H		;get digit number (1-8)
	swap	a
	orl	a,r2		;and put it in upper nibble
	movx	@r0,a		;write that to first location
	inc	r0		;pt to units digit
	anl	a,#0F0H		;get digit index
	add	a,#010H		;bump it
	orl	a,breg		;add in units result from div
	movx	@r0,a		;write to second location
	mov	a,r4		;restore orig acc value
	ret


				;converts 2-digit bcd display value at r0 back to binary (in acc)
L06E6:				;called with r0 pointing at a program dsp left digit
	movx	a,@r0
	anl	a,#00FH		;look at tens digit first, remove index
	cjne	a,#00AH,L06ED	;if it's blanked, zero acc
	clr	a
L06ED:
	mov	breg,#00AH	
	mul	ab		;multiply tens digit calue times ten
	mov	breg,a
	inc	r0		;point to ones digit
	movx	a,@r0
	anl	a,#00FH		;remove index
	cjne	a,#00AH,L06FB
	clr	a
L06FB:
	add	a,breg		;add ones digit to tens value
	ret



L06FE:
	mov	breg,a
	mov	a,r0
	clr	c
	subb	a,#066H
	swap	a
	orl	a,breg
	movx	@r0,a
	ret



L0709:				;loads dptr with RAM starting address for program # in acc (1-75)
	dec	a
	mov	breg,#025H	;each program is 37 bytes
	mul	ab		;multiply result left in b:a
	add	a,#080H
	mov	dpl,a		;add 80 to address low byte
	mov	a,breg
	addc	a,#003H		;and 3 to address high byte
	mov	dph,a		;so programs start at address 0380h, maybe?
	ret



L0719:				;get address of split/dbl prog # in acc into dptr (76-99)
	clr	c
	subb	a,#04CH
	mov	breg,#007H
	mul	ab
	add	a,#057H
	mov	dpl,a
	mov	a,breg
	addc	a,#00EH
	mov	dph,a
	ret



L072B:
	mov	r0,#06FH
	mov	r2,#006H
L072F:
	movx	a,@dptr
	movx	@r0,a
	inc	dptr
	inc	r0
	djnz	r2,L072F

	ret


;
L0736:
	mov	r2,#012H
L0738:
	movx	a,@dptr
	movx	@r0,a
	inc	dptr
	inc	r0
	djnz	r2,L0738

	ret
;
L073F:
	mov	r3,dpl
	mov	r4,dph
	cjne	r0,#087H,L0750
	mov	r1,#0BDH
	mov	r2,#006H
L074A:
	movx	a,@dptr
	movx	@r1,a
	inc	dptr
	inc	r1
	djnz	r2,L074A

L0750:
	mov	dptr,#02300H	;point to EPROM table
	mov	r2,#006H

L0755:
	xch	a,r3	;swap r3 and dpl, acc unchanged
	xch	a,dpl
	xch	a,r3

	xch	a,r4	;swap r4 and dph, acc unchanged
	xch	a,dph
	xch	a,r4

	movx	a,@dptr	;read a byte from dptr table
	inc	dptr

	xch	a,r3	;swap r3 and dpl, acc unchanged
	xch	a,dpl
	xch	a,r3

	xch	a,r4	;swap r4 and dph, acc unchanged
	xch	a,dph
	xch	a,r4

	rl	a
	mov	r5,a	;store first byte times 2 in r5

	movc	a,@a+dptr	;read a byte from r4:r3 table
				;using first table byte as index
	movx	@r0,a	;save it
	inc	r0

	mov	a,r5
	inc	a

	movc	a,@a+dptr	;second byte from r4:r3 table
	movx	@r0,a		;save it
	inc	r0

	djnz	r2,L0755	;execute loop 6 times

	xch	a,r3
	xch	a,dpl
	xch	a,r3
	xch	a,r4
	xch	a,dph
	xch	a,r4
	ret




L077C:
	mov	r1,#0C3H
	mov	r2,#004H
L0780:
	movx	a,@dptr
	movx	@r1,a
	inc	dptr
	inc	r1
	djnz	r2,L0780

	mov	r3,dpl
	mov	r4,dph
	mov	r0,#097H
	mov	r1,#0C3H
	mov	dptr,#02300H
	mov	r2,#002H


L0793:
	movx	a,@r1
	inc	r1
	rl	a
	mov	r5,a
	movc	a,@a+dptr
	movx	@r0,a
	inc	r0
	mov	a,r5
	inc	a
	movc	a,@a+dptr
	movx	@r0,a
	mov	r0,#09BH
	djnz	r2,L0793

	mov	r0,#095H
	mov	r1,#0C5H
	mov	dptr,#02380H
	mov	r2,#002H

L07AB:
	movx	a,@r1
	inc	r1
	rl	a
	mov	r5,a
	movc	a,@a+dptr
	movx	@r0,a
	inc	r0
	mov	a,r5
	inc	a
	movc	a,@a+dptr
	movx	@r0,a
	mov	r0,#099H
	djnz	r2,L07AB	;do this twice

	mov	dpl,r3
	mov	dph,r4
	movx	a,@dptr
	inc	dptr
	mov	$0026,a		;addr 26 should be LFO Flags 1 byte

	movx	a,@dptr
	inc	dptr
	mov	c,accbit7
	mov	042H,c
	anl	$0027,#0F0H
	anl	a,#00FH
	orl	$0027,a		;addr 27 should be LFO Flags 2 byte
	movx	a,@dptr
	mov	$002A,a		;2A is shadow for wavesels 1,3
	mov	r0,#0CCH
	movx	a,@r0
	mov	c,accbit7
	mov	$056,c
	ret



L07DA:
	mov	r0,#075H
	mov	r1,#09DH
	mov	r2,#01EH
L07E0:
	movx	a,@r0
	movx	@r1,a
	inc	r0
	inc	r1
	djnz	r2,L07E0

	mov	$002B,$002A	;2B is shadow for wavesels 2,4, 2A is shadow for wavesels 1,3
	mov	c,042H
	mov	043H,c
	mov	dptr,#00FFBH
	movx	a,@dptr
	mov	r0,#075H
	movx	@r0,a
	mov	r0,#09DH
	movx	@r0,a
	ret



L07F8:				;update waveform select hw from 2A,2B shadows
	mov	dptr,#01001H	;point to waveform 1 and 3 register
	mov	a,$002A		;2A is shadow for wavesels 1,3
	mov	breg,a
	cpl	a		;invert low 6 bits
	anl	a,#03FH
	anl	breg,#0C0H	;but not the top two
	orl	a,breg
	movx	@dptr,a

	mov	dptr,#01002H	;point to waveform 2 and 4 register
	mov	a,$002B		;2B is shadow for wavesels 2,4
	cpl	a		;invert all 8 bits
	movx	@dptr,a
	ret



L0810:				;copy r2 count bytes from dptr to r4:r3
	movx	a,@dptr
	inc	dptr
				;swap r3,dpl, acc unchanged
	xch	a,r3		;r3=data read, a=r3 value
	xch	a,dpl		;dpl=r3 value, a=dpl
	xch	a,r3		;r3=dpl, a=data read

	xch	a,r4		;swap r4,dph, acc unchanged
	xch	a,dph
	xch	a,r4

	movx	@dptr,a		;write out value read to r4:r3
	inc	dptr

	xch	a,r3		;swap r3,dpl, acc unchanged
	xch	a,dpl
	xch	a,r3

	xch	a,r4		;swap r4,dph, acc unchanged
	xch	a,dph
	xch	a,r4

	djnz	r2,L0810

	ret



L0827:
	lcall	L072B
	lcall	L0736
	lcall	L073F
	lcall	L077C
	mov	r0,#075H
	movx	a,@r0
	mov	dptr,#00FFBH
	movx	@dptr,a
	ret



L083B:				;build 37-byte program image at [dptr]
	mov	r0,#06FH	;copy 24 bytes from 6F to [dptr]
	mov	r2,#018H
L083F:
	movx	a,@r0
	movx	@dptr,a
	inc	r0
	inc	dptr
	djnz	r2,L083F

	mov	r2,#00AH
	mov	r0,#0BDH	;copy 10 bytes from BDh to [dptr]
L0849:
	movx	a,@r0
	movx	@dptr,a
	inc	r0
	inc	dptr
	djnz	r2,L0849

	mov	a,$0026		;must be LFO1 flags byte
	movx	@dptr,a

	inc	dptr

	mov	a,$0027		;LFO2 flags byte?
	anl	a,#00FH
	mov	c,042H		;should be LFO invert
	mov	accbit7,c
	movx	@dptr,a

	inc	dptr

	mov	a,$002A		;2A is shadow for wavesels 1,3
	movx	@dptr,a
	ret



L0861:				;update mode LEDs from shadow at 0x3E
	mov	r0,#03EH	;shadow for mode LEDs (1 = on)
	mov	dptr,#01004H	;point to Mode LEDs
	movx	a,@r0
	cpl	a
	movx	@dptr,a
	ret


L086A:
	movx	a,@dptr
	inc	dptr
	cjne	a,#04BH,L0872
	ljmp	L0876

L0872:
	jc	L0876
	mov	a,#04BH
L0876:
	jnz	L087A
	mov	a,#001H
L087A:
	mov	r0,#06BH	;lower program left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	movx	a,@dptr
	inc	dptr
	cjne	a,#04BH,L0887
	ljmp	L088B
;
L0887:
	jc	L088B
	mov	a,#04BH
L088B:
	jnz	L088F
	mov	a,#001H
L088F:
	mov	r0,#06DH	;upper program left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	mov	a,r5
	mov	r0,#069H	;parm address left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	movx	a,@dptr
	inc	dptr
	anl	$0028,#0FCH
	anl	a,#003H
	jnz	L08A5
	mov	a,#001H
L08A5:
	cjne	a,#003H,L08AA
	mov	a,#001H
L08AA:
	orl	$0028,a
	movx	a,@dptr
	inc	dptr
	jb	040H,L08BB	;skip if split mode enabled

	mov	a,#06EH
	mov	r0,#067H	;value left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	ljmp	L08C5
;

L08BB:
	mov	r5,a
	mov	r0,#0CFH
	movx	@r0,a
	inc	a
	mov	r0,#067H	;value left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs
L08C5:
	movx	a,@dptr
	inc	dptr
	jnb	040H,L08D2	;skip if not in split mode

	mov	r0,#0D8H
	movx	@r0,a
	clr	c
	subb	a,r5
	mov	r0,#0D7H
	movx	@r0,a
L08D2:
	movx	a,@dptr
	inc	dptr
	mov	r0,#0D3H
	movx	@r0,a
	inc	r0
	movx	a,@dptr
	movx	@r0,a
	mov	r0,#06BH	;lower program left digit
	lcall	L06E6		;converts 2-digit bcd display value at r0 back to binary (in acc)

	lcall	L0709		;loads dptr with RAM starting address for program # in acc (1-99)
	lcall	L0827

	mov	r0,#06DH	;upper program left digit
	lcall	L06E6		;converts 2-digit bcd display value at r0 back to binary (in acc)

	lcall	L0709		;loads dptr with RAM starting address for program # in acc (1-99)

	mov	a,dpl
	add	a,#006H
	mov	dpl,a
	mov	a,dph
	addc	a,#000H
	mov	dph,a
	mov	r0,#09DH
	lcall	L0736
	lcall	L073F
	inc	dptr
	inc	dptr
	inc	dptr
	inc	dptr
	inc	dptr
	movx	a,@dptr
	mov	c,accbit7
	mov	043H,c
	inc	dptr
	movx	a,@dptr
	mov	$002B,a		;2B is shadow for wavesels 2,4
	lcall	L07F8		;update waveform select hw from 2A,2B shadows

	mov	r0,#0D3H
	mov	dptr,#00075H
	movx	a,@r0
	movx	@dptr,a
	inc	r0
	mov	dptr,#0009DH
	movx	a,@r0
	movx	@dptr,a

	mov	r0,#03EH	;point to LED shadow
	movx	a,@r0		;read it
	mov	c,040H		;move SPLIT enable into 
	mov	accbit5,c	;acc bit 5
	mov	c,041H		;move DOUBLE enable into 
	mov	accbit6,c	;acc bit 6
	movx	@r0,a		;update shadow

	lcall	L0861		;update mode LEDs from shadow at 0x3E
	ret


L092F:
	mov	r0,#06BH	;lower program left digit
	lcall	L06E6		;converts 2-digit bcd display value at r0 back to binary (in acc)

	movx	@dptr,a
	inc	dptr

	mov	r0,#06DH	;upper program left digit
	lcall	L06E6		;converts 2-digit bcd display value at r0 back to binary (in acc)

	movx	@dptr,a
	inc	dptr
	mov	a,$0028
	anl	a,#003H
	movx	@dptr,a
	inc	dptr
	mov	r0,#0CFH
	movx	a,@r0
	movx	@dptr,a
	inc	dptr
	mov	r0,#0D8H
	movx	a,@r0
	movx	@dptr,a
	inc	dptr
	mov	r0,#075H
	movx	a,@r0
	movx	@dptr,a
	inc	dptr
	mov	r0,#09DH
	movx	a,@r0
	movx	@dptr,a
	ret


L0957:
	mov	r1,#0CEH
	movx	a,@r1
	jnb	f0,L095E
	swap	a
L095E:
	mov	r5,a
	anl	$0005,#0F0H
	anl	a,#00FH
	cjne	r3,#000H,L096A
	ljmp	L0982
;
L096A:
	cjne	r3,#015H,L097B
	inc	a
	cjne	a,#00FH,L0974
	ljmp	L0982
;
L0974:
	jc	L0982
	mov	a,#00FH
	ljmp	L0982
;
L097B:
	clr	c
	subb	a,#001H
	jnc	L0982
	mov	a,#000H
L0982:
	inc	a
	mov	r0,#067H	;display digit 1 value
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	dec	a
	orl	a,r5
	jnb	f0,L098E
	swap	a
L098E:
	movx	@r1,a
	ljmp	L1804
;
L0992:
	mov	dptr,#00FFAH
	movx	a,@dptr
	cjne	r3,#000H,L099C
	ljmp	L09B4
;
L099C:
	cjne	r3,#015H,L09AD
	inc	a
	cjne	a,#002H,L09A6
	ljmp	L09B4
;
L09A6:
	jc	L09B4
	mov	a,#002H
	ljmp	L09B4
;
L09AD:
	clr	c
	subb	a,#001H
	jnc	L09B4
	mov	a,#000H
L09B4:
	anl	a,#003H
	movx	@dptr,a
	mov	r0,#067H	;display digit 1 value
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	ljmp	L1804
;
L09BF:
	movx	a,@r1
	cjne	r3,#000H,L09D0
	cjne	a,#03CH,L09C9
	ljmp	L09E8
;
L09C9:
	jc	L09E8
	mov	a,#03CH
	ljmp	L09E8
;
L09D0:
	cjne	r3,#015H,L09E1
	inc	a
	cjne	a,#03CH,L09DA
	ljmp	L09E8
;
L09DA:
	jc	L09E8
	mov	a,#03CH
	ljmp	L09E8
;
L09E1:
	clr	c
	subb	a,#001H
	jnc	L09E8
	mov	a,#000H
L09E8:
	movx	@r1,a
	inc	a
	mov	r0,#067H	;display digit 1 value
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	jb	f0,L0A03
	mov	r1,#0D8H
	mov	r0,#0CFH
	movx	a,@r0
	mov	breg,a
	movx	a,@r1
	clr	c
	subb	a,breg
	mov	r0,#0D7H
	movx	@r0,a
	ljmp	L1804
;
L0A03:
	mov	r1,#0F1H
	mov	r0,#0F0H
	movx	a,@r0
	mov	breg,a
	movx	a,@r1
	clr	c
	subb	a,breg
	mov	r0,#03FH
	movx	@r0,a
	ljmp	L1804
;
L0A14:
	mov	r1,#074H
	movx	a,@r1
	cjne	r3,#000H,L0A27
	cjne	a,#080H,L0A20
	ljmp	L0A40
;
L0A20:
	jnc	L0A40
	mov	a,#080H
	ljmp	L0A40
;
L0A27:
	cjne	r3,#015H,L0A33
	add	a,#002H
	jnc	L0A30
	mov	a,#0FFH
L0A30:
	ljmp	L0A40
;
L0A33:
	clr	c
	subb	a,#002H
	cjne	a,#080H,L0A3C
	ljmp	L0A40
;
L0A3C:
	jnc	L0A40
	mov	a,#080H
L0A40:
	movx	@r1,a
	clr	c
	subb	a,#080H
	rrc	a
	mov	r0,#067H	;display digit 1 value
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	jnz	L0A51
	setb	057H
	ljmp	L0A53
;
L0A51:
	clr	057H
L0A53:
	lcall	L07F8		;update waveform select hw from 2A,2B shadows
	ljmp	L1804
;
L0A59:
	mov	a,r3
	jnz	L0A5F
	ljmp	L0BA4
;
L0A5F:
	mov	a,$0028
	anl	a,#003H
	rl	a
	mov	dptr,#L0A68
	jmp	@a+dptr		;jump table
L0A68:
	ajmp	L0A6E
	ajmp	L0AC3
	ajmp	L0B41

L0A6E:
	mov	r4,$0006
	cjne	r4,#006H,L0A76
	ljmp	L0BE4


L0A76:
	mov	a,r4
	rl	a
	add	a,#008H
	mov	r1,a
	mov	@r1,$0002	;this was writing MIDI note number into array at addr 8
	mov	a,#001H
	jnb	003H,L0A85
	jnb	007H,L0AA2
L0A85:
	inc	a
	jnb	00BH,L0A8C
	jnb	00FH,L0AA2
L0A8C:
	inc	a
	jnb	013H,L0A93
	jnb	017H,L0AA2
L0A93:
	inc	a
	jnb	01BH,L0A9A
	jnb	01FH,L0AA2
L0A9A:
	inc	a
	jnb	023H,L0AA1
	jnb	027H,L0AA2
L0AA1:
	inc	a
L0AA2:
	inc	r1
	mov	@r1,a		;and this writes a value to the next byte
	inc	$0006
L0AA6:
	mov	r4,#000H
	cjne	@r1,#003H,L0AAD
	sjmp	L0AB1

L0AAD:
	jc	L0AB1
	mov	r4,#028H
L0AB1:
	lcall	L150C

	mov	a,#01FH
	add	a,@r1
	mov	r0,a
	mov	c,pswbit1
	mov	a,@r1
	mov	accbit7,c
	mov	@r1,a
	mov	@r0,#000H
	ljmp	L17DB
;
L0AC3:
	mov	r0,#0CFH
	movx	a,@r0
	add	a,#024H
	cjne	a,$0002,L0ACD
	sjmp	L0ACF
;
L0ACD:
	jnc	L0B08
L0ACF:
	mov	r4,$0007
	cjne	r4,#003H,L0AD7
	ljmp	L0C5C
;
L0AD7:
	mov	a,r4
	rl	a
	add	a,#00EH
	mov	r1,a
	mov	@r1,$0002
	mov	a,#004H
	jnb	01BH,L0AE6
	jnb	01FH,L0AEE
L0AE6:
	inc	a
	jnb	023H,L0AED
	jnb	027H,L0AEE
L0AED:
	inc	a
L0AEE:
	inc	r1
	mov	@r1,a
	inc	$0007
L0AF2:
	mov	r4,#028H
	setb	f0
	lcall	L150C

	mov	a,#01FH
	add	a,@r1
	mov	r0,a
	mov	c,pswbit1
	mov	a,@r1
	mov	accbit7,c
	mov	@r1,a
	mov	@r0,#000H
	ljmp	L17DB
;
L0B08:
	mov	r4,$0006
	cjne	r4,#003H,L0B10
	ljmp	L0C20
;
L0B10:
	mov	a,r4
	rl	a
	add	a,#008H
	mov	r1,a
	mov	@r1,$0002
	mov	a,#001H
	jnb	003H,L0B1F
	jnb	007H,L0B27
L0B1F:
	inc	a
	jnb	00BH,L0B26
	jnb	00FH,L0B27
L0B26:
	inc	a
L0B27:
	inc	r1
	mov	@r1,a
	inc	$0006
L0B2B:
	mov	r4,#000H
	clr	f0
	lcall	L150C

	mov	a,#01FH
	add	a,@r1
	mov	r0,a
	mov	c,pswbit1
	mov	a,@r1
	mov	accbit7,c
	mov	@r1,a
	mov	@r0,#000H
	ljmp	L17DB
;
L0B41:
	mov	r4,$0006
	cjne	r4,#003H,L0B49
	ljmp	L0C98
;
L0B49:
	mov	a,r4
	rl	a
	add	a,#008H
	mov	r1,a
	mov	@r1,$0002
	mov	r0,#020H
	cjne	@r0,#048H,L0B5A
	mov	a,#001H
	ljmp	L0B65
;
L0B5A:
	inc	r0
	cjne	@r0,#048H,L0B63
	mov	a,#002H
	ljmp	L0B65
;
L0B63:
	mov	a,#003H
L0B65:
	inc	r1
	mov	@r1,a
	xch	a,r1
	add	a,#006H
	xch	a,r1
	add	a,#003H
	mov	@r1,a
	dec	r1
	mov	@r1,$0002
	inc	r1
	inc	$0007
	inc	$0006
L0B76:
	mov	r4,#028H
	lcall	L150C

	mov	a,r1
	clr	c
	subb	a,#006H
	mov	r1,a
	mov	r4,#000H
	lcall	L150C

	mov	a,#01FH
	add	a,@r1
	mov	r0,a
	mov	c,pswbit1
	mov	a,@r1
	mov	accbit7,c
	mov	@r1,a
	mov	@r0,#000H
	mov	a,r1
	add	a,#006H
	mov	r1,a
	mov	c,pswbit1
	mov	a,@r1
	mov	accbit7,c
	mov	@r1,a
	mov	a,r0
	add	a,#003H
	mov	r0,a
	mov	@r0,#000H
	ljmp	L17DB
;
L0BA4:
	mov	r1,#006H
L0BA6:
	inc	r1
	inc	r1
	cjne	r1,#014H,L0BAE
	ljmp	L17DB
;
L0BAE:
	mov	$0004,@r1
	mov	a,r2
	cjne	a,$0004,L0BA6
	inc	r1
	mov	a,@r1
	dec	r1
	jb	pswbit1,L0BC0
	jb	accbit7,L0BA6
	ljmp	L0BC3
;
L0BC0:
	jnb	accbit7,L0BA6
L0BC3:
	clr	accbit7
	add	a,#01FH
	mov	r0,a
	mov	a,@r0
	mov	breg,a
	jnb	accbit3,L0BD3
	mov	a,#0C8H
	mov	@r0,a
	sjmp	L0BA6
;
L0BD3:
	jb	accbit2,L0BA6
	anl	a,#003H
	cjne	a,#003H,L0BDD
	sjmp	L0BA6
;
L0BDD:
	mov	a,breg
	setb	accbit2
	mov	@r0,a
	sjmp	L0BA6
;
L0BE4:
	mov	r0,#007H
L0BE6:
	inc	r0
	inc	r0
	cjne	r0,#015H,L0BF0
	mov	r0,#00FH
	ljmp	L0BFF
;
L0BF0:
	mov	a,@r0
	clr	accbit7
	add	a,#01FH
	mov	r1,a
	mov	a,@r1
	jb	accbit2,L0BFF
	anl	a,#003H
	cjne	a,#003H,L0BE6
L0BFF:
	mov	breg,@r0
	clr	bregbit7
	mov	$0001,r0
	dec	r0
	inc	r1
	mov	a,#014H
	clr	c
	subb	a,r1
	inc	a
	mov	r4,a
	ljmp	L0C14
;
L0C10:
	mov	a,@r1
	mov	@r0,a
	inc	r0
	inc	r1
L0C14:
	djnz	r4,L0C10
	mov	@r0,$0002
	inc	r0
	mov	@r0,breg
	mov	r1,$0000
	ljmp	L0AA6
;
L0C20:
	mov	r0,#007H
L0C22:
	inc	r0
	inc	r0
	cjne	r0,#00FH,L0C2C
	mov	r0,#00DH
	ljmp	L0C3B
;
L0C2C:
	mov	a,@r0
	clr	accbit7
	add	a,#01FH
	mov	r1,a
	mov	a,@r1
	jb	accbit2,L0C3B
	anl	a,#003H
	cjne	a,#003H,L0C22
L0C3B:
	mov	breg,@r0
	clr	bregbit7
	mov	$0001,r0
	dec	r0
	inc	r1
	mov	a,#00EH
	clr	c
	subb	a,r1
	inc	a
	mov	r4,a
	ljmp	L0C50
;
L0C4C:
	mov	a,@r1
	mov	@r0,a
	inc	r0
	inc	r1
L0C50:
	djnz	r4,L0C4C
	mov	@r0,$0002
	inc	r0
	mov	@r0,breg
	mov	r1,$0000
	ljmp	L0B2B
;
L0C5C:
	mov	r0,#00DH
L0C5E:
	inc	r0
	inc	r0
	cjne	r0,#015H,L0C68
	mov	r0,#013H
	ljmp	L0C77
;
L0C68:
	mov	a,@r0
	clr	accbit7
	add	a,#01FH
	mov	r1,a
	mov	a,@r1
	jb	accbit2,L0C77
	anl	a,#003H
	cjne	a,#003H,L0C5E
L0C77:
	mov	breg,@r0
	clr	bregbit7
	mov	$0001,r0
	dec	r0
	inc	r1
	mov	a,#014H
	clr	c
	subb	a,r1
	inc	a
	mov	r4,a
	ljmp	L0C8C
;
L0C88:
	mov	a,@r1
	mov	@r0,a
	inc	r0
	inc	r1
L0C8C:
	djnz	r4,L0C88
	mov	@r0,$0002
	inc	r0
	mov	@r0,breg
	mov	r1,$0000
	ljmp	L0AF2
;
L0C98:
	mov	r0,#007H
L0C9A:
	inc	r0
	inc	r0
	cjne	r0,#00FH,L0CA4
	mov	r0,#00DH
	ljmp	L0CB6
;
L0CA4:
	mov	a,@r0
	clr	accbit7
	add	a,#01FH
	mov	r1,a
	mov	a,@r1
	jb	accbit2,L0CB6
	jb	accbit7,L0CB6
	anl	a,#003H
	cjne	a,#003H,L0C9A
L0CB6:
	mov	$0005,r0
	mov	breg,@r0
	clr	bregbit7
	mov	$0001,r0
	dec	r0
	inc	r1
	mov	a,#00FH
	clr	c
	subb	a,r1
	mov	r4,a
	ljmp	L0CCC
;
L0CC8:
	mov	a,@r1
	mov	@r0,a
	inc	r0
	inc	r1
L0CCC:
	djnz	r4,L0CC8
	mov	@r0,$0002
	inc	r0
	mov	@r0,breg
	mov	a,r5
	add	a,#006H
	mov	r0,a
	mov	$0001,r0
	dec	r0
	inc	r1
	mov	a,#015H
	clr	c
	subb	a,r1
	mov	r4,a
	ljmp	L0CE7
;
L0CE3:
	mov	a,@r1
	mov	@r0,a
	inc	r0
	inc	r1
L0CE7:
	djnz	r4,L0CE3
	mov	@r0,$0002
	inc	r0
	mov	a,breg
	add	a,#003H
	mov	@r0,a
	mov	r1,$0000
	ljmp	L0B76
;
L0CF6:
	mov	r0,#03DH
	movx	a,@r0
	jb	accbit6,L0D52
	setb	accbit6
	movx	@r0,a
	setb	04DH
	mov	dptr,#00FF0H
	clr	a
	movx	@dptr,a
	mov	r0,#0C8H
	mov	a,#00DH
	movx	@r0,a
	inc	r0
	mov	a,#06AH
	movx	@r0,a
	clr	04EH
	clr	04CH

	mov	r0,#03EH	;point to LED shadow
	clr	a		;turn off all LEDs
	movx	@r0,a		;update shadow

	lcall	L0861		;update mode LEDs from shadow at 0x3E

	mov	r0,#06DH	;upper program left digit
	mov	a,#06EH
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	mov	dptr,#00FF8H
	movx	a,@dptr
	cjne	a,#062H,L0D2A
	sjmp	L0D2F
;
L0D2A:
	jc	L0D2F
	mov	a,#062H
	movx	@dptr,a
L0D2F:
	mov	r5,a
	mov	breg,#021H
	div	ab
	mov	r3,breg
	inc	a
	mov	r0,#067H	;display digit 1 value
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	mov	a,r3
	inc	a
	mov	r0,#069H	;parm address left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	mov	a,#04AH
	add	a,r5
	mov	dpl,a
	mov	a,#00FH
	addc	a,#000H
	mov	dph,a
	movx	a,@dptr
	ljmp	L0DAE
;
L0D52:
	mov	r0,#067H	;value left digit
	lcall	L06E6		;converts 2-digit bcd display value at r0 back to binary (in acc)

	cjne	a,#003H,L0D5D
	ljmp	L0D67
;
L0D5D:
	mov	dptr,#00FF8H
	mov	breg,#021H
	mul	ab
	movx	@dptr,a
	sjmp	L0D2F
L0D67:
	ljmp	L008B
;
	cjne	r3,#00AH,L0D72
	mov	r3,#000H
	ljmp	L0D8E
;
L0D72:
	jc	L0D8E
	mov	dptr,#00FF8H
	movx	a,@dptr
	cjne	r3,#014H,L0D84
	jnz	L0D80
	ljmp	L1804
;
L0D80:
	dec	a
	movx	@dptr,a
	sjmp	L0D2F
;
L0D84:
	cjne	a,#062H,L0D8A
	ljmp	L1804
;
L0D8A:
	inc	a
	movx	@dptr,a
	sjmp	L0D2F
;
L0D8E:
	jbc	04CH,L0DA8
	mov	a,#00AH
	mov	r0,#06CH
	lcall	L06FE
	mov	a,r3
	mov	r0,#06BH	;lower program left digit
	lcall	L06FE
	setb	04CH
	mov	dptr,#00FF0H
	clr	a
	movx	@dptr,a
	ljmp	L1804
;
L0DA8:
	mov	r0,#06BH	;lower program left digit
	lcall	L06E6		;converts 2-digit bcd display value at r0 back to binary (in acc)

	add	a,r3
L0DAE:
	jnz	L0DB1
	inc	a
L0DB1:
	cjne	a,#063H,L0DB7
	ljmp	L0DBB
;
L0DB7:
	jc	L0DBB
	mov	a,#063H
L0DBB:
	mov	r0,#06BH	;lower program left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	mov	r3,a
	mov	dptr,#00FF8H
	movx	a,@dptr
	add	a,#04AH
	mov	dpl,a
	mov	a,#00FH
	addc	a,#000H
	mov	dph,a
	mov	a,r3
	movx	@dptr,a
	dec	r3
	mov	dptr,#00FFAH
	movx	a,@dptr
	cjne	a,#001H,L0DDC
	ljmp	L0E05
;
L0DDC:
	mov	r0,#0CEH
	movx	a,@r0
	swap	a
	anl	a,#00FH
	orl	a,#0C0H
	mov	r2,a

	clr	f0
	lcall	L0F9D		;writes r2,r3 to tx buffer, and if f0 set, r4 as well

	mov	dptr,#00FFAH
	movx	a,@dptr
	cjne	a,#002H,L0E05
	mov	dptr,#00FF0H
	clr	a
	setb	accbit0
	movx	@dptr,a
	mov	dptr,#00FECH
	mov	a,#0FFH
	movx	@dptr,a
	inc	dptr
	mov	a,#003H
	movx	@dptr,a
	ljmp	L1804
;
L0E05:
	lcall	L0FDC		;clear a bunch of internal RAM and first 12 CV's

	mov	a,r3
	inc	a
	cjne	a,#04CH,L0E10
	ljmp	L0E35

L0E10:
	jnc	L0E35
	mov	r0,#06BH	;lower program left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	lcall	L0709		;loads dptr with RAM starting address for program # in acc (1-99)
	lcall	L0827
	lcall	L07DA
	lcall	L07F8		;update waveform select hw from 2A,2B shadows

	clr	041H		;disable double mode
	clr	040H		;disable split mode

	mov	r0,#03EH	;point to LED shadow
	movx	a,@r0		;read it
	clr	accbit6		;turn off DOUBLE
	clr	accbit5		;turn off SPLIT
	movx	@r0,a		;update shadow

	lcall	L0861		;update mode LEDs from shadow at 0x3E

	ljmp	L1804

L0E35:
	mov	r0,#0C7H
	movx	@r0,a
	mov	r5,a
	lcall	L0719		;get address of split/dbl prog # in acc into dptr
	lcall	L0E42
	ljmp	L1804
;
L0E42:
	movx	a,@dptr
	inc	dptr
	cjne	a,#04BH,L0E4A
	ljmp	L0E4E
;
L0E4A:
	jc	L0E4E
	mov	a,#04BH
L0E4E:
	jnz	L0E52
	mov	a,#001H
L0E52:
	mov	r0,dpl
	mov	r1,dph
	mov	dptr,#00FF7H
	movx	@dptr,a
	mov	dpl,r0
	mov	dph,r1
	movx	a,@dptr
	inc	dptr
	cjne	a,#04BH,L0E66
	ljmp	L0E6A
;
L0E66:
	jc	L0E6A
	mov	a,#04BH
L0E6A:
	jnz	L0E6E
	mov	a,#001H
L0E6E:
	mov	r0,dpl
	mov	r1,dph
	mov	dptr,#00FF6H
	movx	@dptr,a
	mov	dpl,r0
	mov	dph,r1
	mov	a,r5
	mov	r0,#06BH	;lower program left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs
	movx	a,@dptr
	inc	dptr
	anl	$0028,#0FCH
	anl	a,#003H
	jnz	L0E8B
	mov	a,#001H
L0E8B:
	cjne	a,#003H,L0E90
	mov	a,#001H
L0E90:
	orl	$0028,a
	movx	a,@dptr
	inc	dptr
	mov	r5,a
	mov	r0,#0CFH
	movx	@r0,a
	movx	a,@dptr
	inc	dptr
	jnb	040H,L0EA5	;skip if not in split mode

	mov	r0,#0D8H
	movx	@r0,a
	clr	c
	subb	a,r5
	mov	r0,#0D7H
	movx	@r0,a
L0EA5:
	movx	a,@dptr
	inc	dptr
	mov	r0,#0D3H
	movx	@r0,a
	inc	r0
	movx	a,@dptr
	movx	@r0,a
	mov	dptr,#00FF7H
	movx	a,@dptr
	lcall	L0709		;loads dptr with RAM starting address for program # in acc (1-99)

	lcall	L0827
	mov	dptr,#00FF6H
	movx	a,@dptr
	lcall	L0709		;loads dptr with RAM starting address for program # in acc (1-99)
	mov	a,dpl
	add	a,#006H
	mov	dpl,a
	mov	a,dph
	addc	a,#000H
	mov	dph,a
	mov	r0,#09DH
	lcall	L0736
	lcall	L073F
	inc	dptr
	inc	dptr
	inc	dptr
	inc	dptr
	inc	dptr
	movx	a,@dptr
	mov	c,accbit7
	mov	043H,c
	inc	dptr
	movx	a,@dptr
	mov	$002B,a		;2B is shadow for wavesels 2,4
	lcall	L07F8		;update waveform select hw from 2A,2B shadows

	mov	r0,#0D3H
	mov	dptr,#00075H
	movx	a,@r0
	movx	@dptr,a
	inc	r0
	mov	dptr,#0009DH
	movx	a,@r0
	movx	@dptr,a

	mov	r0,#03EH	;point to LED shadow
	movx	a,@r0		;read it
	mov	c,040H		;move split enable into
	mov	accbit5,c	;acc bit 5
	mov	c,041H		;move double enable into
	mov	accbit6,c	;acc bit 6
	movx	@r0,a		;update shadow

	lcall	L0861		;update mode LEDs from shadow at 0x3E

	ret



L0F00:
	mov	r0,#0FAH	;possibly byte cnt for key RX buffer
	movx	a,@r0
	jnz	L0F08
	ljmp	L17BB		;jump if key buffer is empty

L0F08:
	mov	r1,#0FBH	;point to key rxbuf rd ptr
	mov	dph,#002H
	movx	a,@r1		;read ptr
	mov	dpl,a		;load dptr with rx buf rd ptr
	clr	ea		;disable all interrupts
	inc	a
	movx	@r1,a		;update read ptr

	movx	a,@r0		;decr key RX buffer byte count?
	dec	a
	movx	@r0,a

	setb	ea		;enable interrupts
	movx	a,@dptr		;read rx byte from buffer
	mov	r2,a		;and save in r2

	mov	r0,#03DH
	movx	a,@r0
	jbc	accbit5,L0F2D	;jump if bit is set and clear bit
	setb	accbit5
	movx	@r0,a
				;3D bit 5 was not set, so this is a note number
	mov	r0,#0D9H	
	mov	a,r2
	add	a,#00CH		;add 0x0C to rec'd byte (to form MIDI note #)
	movx	@r0,a		;and save it at 0xD9
				;D9 holds MIDI note # for most recent key
	ljmp	L17BB

L0F2D:				;if 3D bit 5 was set, this is velocity byte (0-1F?)
	setb	accbit4
	movx	@r0,a		;set bit 4 at 0x3D and write it out
				;probably this indicates a key was received
	mov	a,r2
	mov	r0,#0DAH	;DA holds vel value rec'd from key MCU for most recent key
	movx	@r0,a		;save rx data at 0xDA

	mov	dptr,#00FF9H	;flag byte?
	movx	a,@dptr
	anl	a,#001H
	rl	a
	mov	dptr,#L0F3F
	jmp	@a+dptr		;INFO: indirect jump
L0F3F:				;a little jump table
	ajmp	L0F43		;flag = 0		
	ajmp	L0F5C		;flag = 1

L0F43:
	mov	r0,#0CEH	;seems to hold MIDI channels
	movx	a,@r0		;tx in upper 4 bits
	swap	a
	anl	a,#00FH
	orl	a,#090H		;form note on status byte
	mov	r2,a

	mov	r0,#0D9H	;ptr to note number we wrote above?
	movx	a,@r0
	mov	r3,a

	mov	r0,#0DAH	;ptr to velocity byte we wrote above?
	movx	a,@r0
	mov	r4,a

	setb	f0
	lcall	L0F9D		;writes r2,r3 to tx buffer, and if f0 set, r4 as well

	ljmp	L17BB


L0F5C:
	mov	r0,#0D9H
	movx	a,@r0
	mov	r3,a
	mov	r0,#0F0H
	movx	a,@r0
	add	a,#024H
	cjne	a,$0003,L0F6B
	ljmp	L0F82


L0F6B:
	jc	L0F82
	mov	r0,#0CEH
	movx	a,@r0
	swap	a
	anl	a,#00FH
	orl	a,#090H
	mov	r2,a
	mov	r0,#0DAH
	movx	a,@r0
	mov	r4,a

	setb	f0
	lcall	L0F9D		;writes r2,r3 to tx buffer, and if f0 set, r4 as well

	ljmp	L17BB

L0F82:
	mov	r0,#03FH
	movx	a,@r0
	add	a,r3
	mov	r3,a
	mov	r0,#0CEH
	movx	a,@r0
	swap	a
	inc	a
	anl	a,#00FH
	orl	a,#090H
	mov	r2,a
	mov	r0,#0DAH
	movx	a,@r0
	mov	r4,a

	setb	f0
	lcall	L0F9D		;writes r2,r3 to tx buffer, and if f0 set, r4 as well

	ljmp	L17BB



L0F9D:				;writes r2,r3 to tx buffer, and if f0 set, r4 as well
	mov	r0,#0F9H	;point to tx buffer write ptr
	movx	a,@r0
	mov	dpl,a
	mov	dph,#003H	;set up dptr to pt into tx buffer

	mov	r1,#0F7H	;point to tx buffer byte count?

	mov	a,r2
	clr	ea		;disable all interrupts
	movx	@dptr,a		;write r2 byte into buffer

	movx	a,@r1
	inc	a		;inc buffer byte count
	movx	@r1,a

	setb	ea		;enable interrupts

	mov	a,dpl
	inc	a
	clr	accbit7		;tx buffer is only 300-37Fh
	mov	dpl,a

	mov	a,r3
	clr	ea		;disable all interrupts
	movx	@dptr,a		;write r3 byte into buffer

	movx	a,@r1
	inc	a		;inc buffer byte count
	movx	@r1,a

	setb	ea		;enable interrupts

	jnb	f0,L0FD3	;skip down if bit not set

	mov	a,dpl
	inc	a		;bump dptr
	clr	accbit7
	mov	dpl,a

	mov	a,r4
	clr	ea		;disable all interrupts
	movx	@dptr,a		;write r4 byte into buffer

	movx	a,@r1
	inc	a		;inc buffer byte count
	movx	@r1,a

	setb	ea		;enable interrupts
L0FD3:
	mov	a,dpl
	inc	a		;bump dptr
	clr	accbit7
	movx	@r0,a		;and update write ptr
	setb	ex0
	ret



L0FDC:				;clear a bunch of internal RAM and first 12 CV's
	mov	$0006,#000H
	mov	$0007,#000H

	mov	r0,#008H
	mov	r2,#00CH
L0FE6:				;clear 8031 ram from 8 to 19
	mov	@r0,#000H
	inc	r0
	djnz	r2,L0FE6

	mov	r0,#020H
L0FED:
	mov	@r0,#048H
	inc	r0
	cjne	r0,#026H,L0FED	;26 should be LFO flags 1 byte

	mov	r2,#00CH
	mov	r0,#030H	;zero 12 control voltage values
	mov	a,#000H		;6 cutoffs and 2 VEN (VCA) ones
L0FF9:
	movx	@r0,a
	inc	r0
	djnz	r2,L0FF9
	ret


	.db	0FFh
	.db	0FFh

L1000:
	mov	r0,#03DH
	movx	a,@r0
	jnb	accbit6,L1009
	ljmp	L1804

L1009:
	mov	r0,#03EH	;point to LED shadow
	movx	a,@r0		;read it
	jnb	accbit3,L1012	;jump if not in park mode

	ljmp	L1804

L1012:
	jbc	accbit0,L1038	;jump if ADDRESS LED is on and clear bit

	setb	accbit0		;turn on ADDRESS
	clr	accbit1		;turn off COMPARE
	clr	accbit2		;turn off LOWER
	clr	accbit4		;turn off UPPER
	movx	@r0,a		;update shadow

	lcall	L0861		;update mode LEDs from shadow at 0x3E

	lcall	L14CF
	mov	r0,#0C8H
	mov	a,#010H
	movx	@r0,a
	inc	r0
	mov	a,#068H
	movx	@r0,a
	clr	04EH
	setb	04DH
	clr	04BH
	clr	04CH
	ljmp	L1804
;
L1038:
	movx	@r0,a
	lcall	L0861		;update mode LEDs from shadow at 0x3E

	lcall	L14CF
	mov	a,#028H
	anl	a,#003H
	jz	L105F
	mov	r0,#0C7H
	movx	a,@r0
	cjne	a,#000H,L104E
	ljmp	L105F
;
L104E:
	mov	r0,#069H	;parm address left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	jnb	040H,L105F	;skip if not in split mode

	mov	r0,#0CFH
	movx	a,@r0
	inc	a
	mov	r0,#067H	;value left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

L105F:
	clr	04EH
	clr	04DH
	clr	04BH
	ljmp	L1804
;
	cjne	r3,#000H,L106E
	ljmp	L1078
;
L106E:
	cjne	r3,#00AH,L1076
	mov	r3,#000H
	ljmp	L10F2
;
L1076:
	jc	L10F2
L1078:
	jb	04BH,L107E
	ljmp	L1804
;
L107E:
	jnb	04CH,L1084
	ljmp	L1804
;
L1084:
	cjne	r3,#000H,L10E0
	mov	r0,#041H
	movx	a,@r0
	jz	L108F
	ljmp	L1804
;
L108F:
	mov	r0,#03CH
	movx	a,@r0
	setb	accbit7
	clr	05EH
	movx	@r0,a
	lcall	L1A45
	jnb	p1bit3,L10A2
	mov	r3,#014H
	ljmp	L10BA
;
L10A2:
	jnb	p1bit4,L10AA
	mov	r3,#015H
	ljmp	L10BA
;
L10AA:
	mov	r0,#03CH
	movx	a,@r0
	clr	accbit7
	setb	05EH
	movx	@r0,a
	lcall	L1A45
	clr	04EH
	ljmp	L1804
;
L10BA:
	mov	r0,#03CH
	movx	a,@r0
	clr	accbit7
	setb	05EH
	movx	@r0,a
	lcall	L1A45
	mov	r0,#041H
	mov	r1,#040H
	movx	a,@r1
	clr	c
	subb	a,#090H
	jnc	L10D1
	mov	a,#020H
L10D1:
	cjne	a,#020H,L10D7
	ljmp	L10DB
;
L10D7:
	jnc	L10DB
	mov	a,#020H
L10DB:
	movx	@r0,a
	movx	@r1,a
	ljmp	L10EA
;
L10E0:
	mov	r0,#041H
	mov	r1,#040H
	mov	a,#0A0H
	movx	@r0,a
	movx	@r1,a
	setb	04EH
L10EA:
	mov	r0,#069H	;parm address left digit
	lcall	L06E6		;converts 2-digit bcd display value at r0 back to binary (in acc)

	ljmp	L111A
;
L10F2:
	jbc	04CH,L1112
	mov	a,#00AH
	mov	r0,#06AH
	lcall	L06FE
	mov	a,r3
	mov	r0,#069H	;parm address left digit
	lcall	L06FE
	mov	a,#06EH
	mov	r0,#067H	;value left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	clr	04BH
	setb	04CH
	clr	04EH
	ljmp	L1804
;
L1112:
	mov	r0,#069H	;parm address left digit
	lcall	L06E6		;converts 2-digit bcd display value at r0 back to binary (in acc)

	add	a,r3
	mov	r3,#000H
L111A:
	jnz	L1120
	inc	a
	ljmp	L112A
;
L1120:
	cjne	a,#04CH,L1126
	ljmp	L112A
;
L1126:
	jc	L112A
	mov	a,#04CH
L112A:
	mov	r1,a
	mov	a,$0028
	anl	a,#003H
	jz	L1179
	mov	a,r1

	cjne	a,#042H,L1137		;~~~here we check for each value between
	ajmp	L1188			;040h and 04Ch individually, and if a match
					;we jump to L1188.   This is silly code!
L1137:	
	cjne	a,#043H,L113C
	ajmp	L1188

L113C:
	cjne	a,#040H,L1141
	ajmp	L1188

L1141:
	cjne	a,#041H,L1146
	ajmp	L1188

L1146:
	cjne	a,#049H,L114B
	ajmp	L1188

L114B:
	cjne	a,#04AH,L1150
	ajmp	L1188

L1150:
	cjne	a,#046H,L1155
	ajmp	L1188

L1155:
	cjne	a,#047H,L115A
	ajmp	L1188

L115A:
	cjne	a,#04CH,L115F
	ajmp	L1188

L115F:
	cjne	a,#044H,L1164
	ajmp	L1188

L1164:
	cjne	a,#045H,L1169
	ajmp	L1188

L1169:
	cjne	a,#048H,L116E
	ajmp	L1188

L116E:
	cjne	a,#04BH,L1173
	ajmp	L1188

L1173:
	lcall	L14CF
	ljmp	L1804

L1179:
	mov	a,r1
	cjne	a,#042H,L117F
	sjmp	L1182

L117F:
	cjne	a,#043H,L1188
L1182:
	lcall	L14CF
	ljmp	L1804


L1188:					;update display with new parm value, then jump to code to update that parm
	mov	r0,#069H		;parm address left digit
	lcall	L06C0			;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	setb	04DH
	setb	04BH

	mov	dptr,#L1197
	dec	a
	rl	a
	jmp	@a+dptr			;INFO: indirect jump
L1197:
	ajmp	L12BF		;1 LFO1 Tri 	
	ajmp	L12C6		;2 LFO1 Saw
	ajmp	L12CD		;3 LFO1 Squ
	ajmp	L12E9		;4 LFO1->DCO1, Flag byte 1 bit 0	
	ajmp	L12F0		;5 LFO1->DCO2, Flag byte 1 bit 1	
	ajmp	L12F7		;6 LFO1->VCF,  Flag byte 1 bit 2			
	ajmp	L12FE		;7 LFO1->VCA,  Flag byte 1 bit 3	
	ajmp	L1321		;8 LFO1->Delay	
	ajmp	L1328		;9 LFO1 rate
	ajmp	L132F		;10 LFO1 dyn rate	
	ajmp	L12B2		;11 LFO1 depth		
	ajmp	L12AD		;12 wheel amt
	ajmp	L1353	
	ajmp	L135A	
	ajmp	L1361		;15	
	ajmp	L1366		;		
	ajmp	L1372		;17 VCF Attack	
	ajmp	L136D		;18 VCF key tracking	
	ajmp	L1377		;19 VCF Cut
	ajmp	L137C		;20 VCF Res	
	ajmp	L1381		;21 VCF Env	
	ajmp	L1386		;22 VCF Dyn Env	
	ajmp	L138B	
	ajmp	L1392	
	ajmp	L1399		;25	
	ajmp	L13A0		
	ajmp	L13A7	
	ajmp	L13CA	
	ajmp	L13D1	
	ajmp	L13D8		;30	
	ajmp	L13EE			
	ajmp	L13DF		;32 DCO1 Pulse width	
	ajmp	L13E4	
	ajmp	L134E	
	ajmp	L13AE		;35	
	ajmp	L13B5		;36		
	ajmp	L13BC	
	ajmp	L13C3			
	ajmp	L13F3	
	ajmp	L13FA		;40	
	ajmp	L1401		
	ajmp	L13E9	
	ajmp	L1408		;43 DCO2 Pulse width	
	ajmp	L140D	
	ajmp	L12BC		;45	
	ajmp	L1412			
	ajmp	L1417	
	ajmp	L1347	
	ajmp	L1421	
	ajmp	L1428		;50	
	ajmp	L141C		
	ajmp	L142F	
	ajmp	L12D4	
	ajmp	L12DB	
	ajmp	L12E2		;55	
	ajmp	L1305		
	ajmp	L130C	
	ajmp	L1313	
	ajmp	L131A	
	ajmp	L1334		;60	
	ajmp	L133B		
	ajmp	L1342	
	ajmp	L12B7	
	ajmp	L128B	
	ajmp	L129C		;65	
	ajmp	L127D		
	ajmp	L1284	
	ajmp	L1247	
	ajmp	L124E	
	ajmp	L1239		;70 	
	ajmp	L1240		
	ajmp	L1255		;72 OMNI mode 	
	ajmp	L122F	
	ajmp	L1234	
	ajmp	L1439		;75	
	ajmp	L1436		;76	

L122F:
	clr	f0
	ljmp	L0957

L1234:
	setb	f0
	ljmp	L0957

L1239:					;parm 70, Release Pedal
	mov	r1,#028H		;addr 28	
	mov	r5,#006H		;bit 5	
	ljmp	L056B			;seems to handle flag bit display and update

L1240:					;parm 71, MIDI prog chg enable				
	mov	r1,#028H		;addr 28		
	mov	r5,#005H		;bit 4
	ljmp	L056B

L1247:					;parm 68, Pitch bend MIDI ctl enab
	mov	r1,#028H		;addr 28
	mov	r5,#007H		;bit 6
	ljmp	L056B

L124E:					;parm 69, Mod wheel MIDI ctl enab
	mov	r1,#028H		;addr 28
	mov	r5,#008H		;bit 7
	ljmp	L056B

L1255:
	mov	r0,#01FH
L1257:
	inc	r0
	cjne	r0,#026H,L125E		;26 should be LFO flags 1 byte
	ljmp	L1276

L125E:
	mov	a,@r0
	anl	a,#00FH
	cjne	a,#008H,L1266
	sjmp	L1257

L1266:
	jb	accbit2,L1257
	anl	a,#003H
	cjne	a,#003H,L1270
	sjmp	L1257

L1270:
	mov	a,@r0
	setb	accbit2
	mov	@r0,a
	sjmp	L1257

L1276:
	mov	r1,#029H
	mov	r5,#001H
	ljmp	L056B

L127D:
	clr	f0
	mov	r1,#075H
	ljmp	L143C

L1284:
	clr	f0
	mov	r1,#09DH
	ljmp	L143C

L128B:				;parm 64, split point
	mov	r1,#0CFH
	clr	f0

	mov	dptr,#00FF9H	;flag byte?
	movx	a,@dptr	
	jz	L1299

	mov	r1,#0F0H
	setb	f0
L1299:
	ljmp	L09BF

L129C:				;parm 65, upper transpose
	mov	r1,#0D8H
	clr	f0

	mov	dptr,#00FF9H	;flag byte?
	movx	a,@dptr	
	jz	L12AA

	mov	r1,#0F1H
	setb	f0
L12AA:
	ljmp	L09BF
;
L12AD:
	mov	r1,#06FH
	ljmp	L143C
;
L12B2:
	mov	r1,#070H
	ljmp	L143C
;
L12B7:
	mov	r1,#072H
	ljmp	L143C
L12BC:
	ljmp	L0A14
;
L12BF:
	clr	f0
	mov	r5,#001H
	ljmp	L060D
;
L12C6:
	clr	f0
	mov	r5,#002H
	ljmp	L060D
;
L12CD:
	clr	f0
	mov	r5,#003H
	ljmp	L060D
;
L12D4:
	setb	f0
	mov	r5,#001H
	ljmp	L060D
;
L12DB:
	setb	f0
	mov	r5,#002H
	ljmp	L060D
;
L12E2:
	setb	f0
	mov	r5,#003H
	ljmp	L060D
;
L12E9:				;LFO Flag byte 1, bit 0
	mov	r5,#001H
	mov	r1,#026H
	ljmp	L056B
;
L12F0:				;LFO Flag byte 1, bit 1
	mov	r5,#002H
	mov	r1,#026H
	ljmp	L056B
;
L12F7:				;LFO Flag byte 1, bit 2
	mov	r5,#003H
	mov	r1,#026H
	ljmp	L056B
;
L12FE:				;LFO Flag byte 1, bit 3
	mov	r5,#004H
	mov	r1,#026H
	ljmp	L056B
;
L1305:
	mov	r5,#005H
	mov	r1,#026H
	ljmp	L056B
;
L130C:
	mov	r5,#006H
	mov	r1,#026H
	ljmp	L056B
;
L1313:
	mov	r5,#007H
	mov	r1,#026H
	ljmp	L056B
;
L131A:
	mov	r5,#008H
	mov	r1,#026H
	ljmp	L056B
;
L1321:
	mov	r5,#097H
	mov	r1,#0C3H
	ljmp	L146C
;
L1328:
	mov	r5,#095H
	mov	r1,#0C5H
	ljmp	L146C
;
L132F:
	mov	r1,#071H
	ljmp	L143C
;
L1334:
	mov	r5,#09BH
	mov	r1,#0C4H
	ljmp	L146C
;
L133B:
	mov	r5,#099H
	mov	r1,#0C6H
	ljmp	L146C
;
L1342:
	mov	r1,#073H
	ljmp	L143C
;
L1347:
	setb	f0
	mov	r1,#075H
	ljmp	L143C
;
L134E:
	mov	r1,#076H
	ljmp	L143C
;
L1353:
	mov	r5,#087H
	mov	r1,#0BDH
	ljmp	L146C
;
L135A:
	mov	r5,#089H
	mov	r1,#0BEH
	ljmp	L146C
;
L1361:
	mov	r1,#07FH
	ljmp	L143C

L1366:				
	mov	r5,#08BH
	mov	r1,#0BFH
	ljmp	L146C

L136D:				;parm 18, VCF key tracking
	mov	r1,#081H	;address of this parm
	ljmp	L143C

L1372:
	mov	r1,#082H
	ljmp	L143C

L1377:
	mov	r1,#07DH
	ljmp	L143C

L137C:
	mov	r1,#07EH
	ljmp	L143C

L1381:
	mov	r1,#080H
	ljmp	L143C

L1386:
	mov	r1,#083H
	ljmp	L143C

L138B:
	mov	r5,#003H
	mov	r1,#028H
	ljmp	L056B

L1392:
	mov	r1,#079H
	mov	r5,#000H
	ljmp	L064E

L1399:
	mov	r5,#001H
	mov	r1,#079H
	ljmp	L064E

L13A0:
	mov	r5,#002H
	mov	r1,#079H
	ljmp	L064E

L13A7:
	mov	r5,#003H
	mov	r1,#079H
	ljmp	L064E

L13AE:
	mov	r5,#000H
	mov	r1,#07AH
	ljmp	L064E

L13B5:
	mov	r5,#001H
	mov	r1,#07AH
	ljmp	L064E

L13BC:
	mov	r5,#002H
	mov	r1,#07AH
	ljmp	L064E

L13C3:
	mov	r5,#003H
	mov	r1,#07AH
	ljmp	L064E

L13CA:
	mov	r5,#005H
	mov	r1,#02AH
	ljmp	L056B

L13D1:
	mov	r5,#003H
	mov	r1,#02AH
	ljmp	L056B

L13D8:
	mov	r5,#001H
	mov	r1,#02AH
	ljmp	L056B

L13DF:
	mov	r1,#07BH	;DCO1 pulse width parm address
	ljmp	L14DC

L13E4:
	mov	r1,#077H
	ljmp	L143C

L13E9:
	mov	r1,#07AH
	ljmp	L0687

L13EE:
	mov	r1,#079H
	ljmp	L0687

L13F3:
	mov	r5,#006H
	mov	r1,#02AH
	ljmp	L056B

L13FA:
	mov	r5,#004H
	mov	r1,#02AH
	ljmp	L056B

L1401:
	mov	r5,#002H
	mov	r1,#02AH
	ljmp	L056B

L1408:
	mov	r1,#07CH	;DCO2 pulse width parm address
	ljmp	L14DC

L140D:
	mov	r1,#078H
	ljmp	L143C

L1412:
	mov	r1,#085H
	ljmp	L143C

L1417:
	mov	r1,#086H
	ljmp	L143C

L141C:
	mov	r1,#084H
	ljmp	L143C

L1421:
	mov	r5,#08DH
	mov	r1,#0C0H
	ljmp	L146C

L1428:
	mov	r5,#08FH
	mov	r1,#0C1H
	ljmp	L146C

L142F:
	mov	r5,#091H
	mov	r1,#0C2H
	ljmp	L146C

L1436:
	ljmp	L0992

L1439:					;parm 75, kbd mode
	ljmp	L05A8


L143C:					;many of the parms jump here after pointing r1 at value byte			
	movx	a,@r1
	cjne	r3,#000H,L1442
	sjmp	L1466
;
L1442:
	cjne	r3,#015H,L144E
	add	a,#004H
	jnc	L144B
	mov	a,#0FFH
L144B:
	ljmp	L1455
;
L144E:
	clr	c
	subb	a,#004H
	jnc	L1455
	mov	a,#000H
L1455:
	movx	@r1,a			;maybe this is where the parm value gets updated?
	cjne	r1,#075H,L145F
	jnb	f0,L1466
	ljmp	L1461
;
L145F:
	jc	L1466
L1461:
	xch	a,r1
	add	a,#028H
	xch	a,r1
	movx	@r1,a
L1466:
	lcall	L14C5
	ljmp	L1804
;
L146C:
	movx	a,@r1
	cjne	r3,#000H,L1475
	anl	a,#03FH
	ljmp	L148D
;
L1475:
	cjne	r3,#015H,L1486
	inc	a
	cjne	a,#03FH,L147F
	ljmp	L1483
;
L147F:
	jc	L1483
	mov	a,#03FH
L1483:
	ljmp	L148D
;
L1486:
	clr	c
	subb	a,#001H
	jnc	L148D
	mov	a,#000H
L148D:
	movx	@r1,a
	mov	dptr,#02300H
	cjne	r1,#0C5H,L149A
L1494:
	mov	dptr,#02380H
	ljmp	L149C
;
L149A:
	jnc	L1494
L149C:
	mov	r0,#067H	;value left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	rl	a
	mov	breg,a
	mov	r0,$0005
	movc	a,@a+dptr
	movx	@r0,a
	inc	r0
	mov	a,breg
	inc	a
	movc	a,@a+dptr
	movx	@r0,a
	cjne	r5,#095H,L14B4
	ljmp	L14C2

;
L14B4:
	jnc	L14C2
	mov	r0,$0005
	mov	a,r0
	add	a,#028H
	mov	r1,a
	movx	a,@r0
	movx	@r1,a
	inc	r0
	inc	r1
	movx	a,@r0
	movx	@r1,a
L14C2:
	ljmp	L1804



L14C5:
	mov	breg,#004H
	div	ab
	mov	r0,#067H	;value left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	ret



L14CF:
	mov	a,#06EH
	mov	r0,#067H	;value left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	mov	r0,#069H	;parm address left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs
	ret



L14DC:
	movx	a,@r1
	cjne	r3,#000H,L14E2
	sjmp	L14FB

L14E2:
	cjne	r3,#015H,L14EE
	add	a,#008H
	jnc	L14EB
	mov	a,#0F8H
L14EB:
	ljmp	L14F5

L14EE:
	clr	c
	subb	a,#008H
	jnc	L14F5
	mov	a,#001H
L14F5:
	movx	@r1,a
	xch	a,r1
	add	a,#028H
	xch	a,r1
	movx	@r1,a
L14FB:
	mov	dptr,#L2500	;256-byte table, 32 values, 8 copies of each
	movc	a,@a+dptr

	mov	breg,#008H
	div	ab
	dec	a
	mov	r0,#067H	;value left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	ljmp	L1804



L150C:				;seems like when this is called, r4 is either 0 or 28h
	mov	r2,$0001	;possibly selecting either lower or upper prog values
	mov	a,@r1
	dec	a
	rl	a
	rl	a
	rl	a
	mov	r1,a

	mov	a,#083H		;83 would be VCF dynamic env parm
	lcall	L1AE9

	mov	a,#080H		;80 would be VCF Env parm
	add	a,r4		;select lower or upper prog value
	mov	r0,a
	movx	a,@r0
	mul	ab
	mov	a,breg
	movx	@r1,a

	inc	r1

	mov	a,#07FH		;7F would be VCF Sust parm
	add	a,r4		;select lower or upper prog value
	mov	r0,a
	movx	a,@r0
	cpl	a
	mov	r0,breg
	mul	ab
	mov	a,breg
	mov	breg,r0
	movx	@r1,a

	inc	r1

	mov	a,#07FH
	add	a,r4		;select lower or upper prog value
	mov	r0,a
	movx	a,@r0
	mul	ab
	mov	a,breg
	movx	@r1,a

	mov	a,#081H		;81 would be VCF Track parm
	add	a,r4		;select lower or upper prog value
	mov	r0,a
	movx	a,@r0
	mov	breg,a		;get parm into breg

	mov	r0,$0002	;r2 was 9 here for voice 1
	dec	r0		;now it's 8
	mov	a,@r0		;so get note value for this voice
	cjne	a,#018H,L154C

	ljmp	L1550
L154C:
	jnc	L1550		;cy is 0 if acc >= 24
	add	a,#00CH		;add 12 if it's less than 24
L1550:		
	clr	c
	subb	a,#023H		;then subtract 35 from it?
	jnc	L1557

	mov	a,#000H		;clip it to 0 if underflow from subtract
L1557:
	jnb	040H,L1562	;skip if not in split mode

	jnb	f0,L1562	;set if this is an upper note?

	mov	r5,a
	mov	r0,#0D7H	;this is split pt-transpose value
	movx	a,@r0
	add	a,r5

L1562:
	mov	r0,a
	add	a,r0		;double value derived from note number
	jnc	L1568

	mov	a,#0FFH		;clip it
L1568:
	mov	r0,a		;double it again
	add	a,r0

	jnc	L156E

	mov	a,#0FFH		;clip it again
L156E:
	mul	ab		;multiply tracking parm times value based on keycode

	mov	a,#07DH		;7D would be VCF cut parm
	add	a,r4		;select lower or upper value
	mov	r0,a
	movx	a,@r0		;read parm

	add	a,breg		;add in multiplication result (tracking contribution)

	jnc	L157A		;clip result if overflow

	mov	a,#0FFH
L157A:
	mov	breg,a		

	movx	a,@r1
	xch	a,breg
	inc	r1
	movx	@r1,a
	inc	r1
	add	a,breg
	jnc	L1588

	mov	a,#0FFH
L1588:
	movx	@r1,a

	inc	r1

	mov	a,#086H
	lcall	L1AE9
	mov	a,#075H
	add	a,r4
	mov	r0,a
	movx	a,@r0
	mul	ab
	mov	a,breg
	movx	@r1,a

	mov	a,#084H
	add	a,r4
	mov	r0,a
	movx	a,@r0
	mov	r0,a
	cpl	a
	mul	ab
	movx	a,@r1
	inc	r1
	xch	a,breg
	movx	@r1,a
	inc	r1
	mov	a,r0
	mul	ab
	mov	a,breg
	movx	@r1,a

	mov	r0,$0002
	mov	a,@r0
	mov	r0,a
	add	a,r0
	add	a,r0
	add	a,#055H
	mov	r0,a
	dec	r1
	dec	r1
	movx	a,@r1
	mov	@r0,a
	dec	r1
	dec	r1
	dec	r0
	movx	a,@r1
	mov	@r0,a
	dec	r1
	dec	r1
	dec	r1
	dec	r0
	movx	a,@r1
	mov	@r0,a

	mov	r1,#000H
	mov	r5,#079H
	lcall	L1974		;loads timer based on note number at [r2-1]

	mov	r1,#008H
	mov	r5,#07AH
	lcall	L1974		;loads timer based on note number at [r2-1]

	mov	r0,#085H
	mov	r1,#08EH

	lcall	L1F81		;three multiplies, r4 is index, r0,r1 are base addr,r3 with results in r1,r4,r5

	mov	r0,$0002
	mov	a,@r0
	rl	a
	add	a,#030H
	mov	r0,a

	mov	a,r5
	mov	@r0,a

	mov	a,r1
	inc	r0
	mov	@r0,a

	mov	r0,#082H
	mov	r1,#088H
	lcall	L1F81		;three multiplies, r4 is index, r0,r1 are base addr,r3 with results in r1,r4,r5

	mov	r0,$0002
	mov	a,@r0
	rl	a
	add	a,#048H
	mov	r0,a
	mov	a,r5
	mov	@r0,a
	mov	a,r1
	inc	r0
	mov	@r0,a

	mov	r0,#085H
	mov	r1,#090H
	lcall	L1F81		;three multiplies, r4 is index, r0,r1 are base addr,r3 with results in r1,r4,r5

	mov	r0,$0002
	mov	a,@r0
	rl	a
	mov	dptr,#0004DH
	add	a,dpl
	mov	dpl,a
	clr	a
	addc	a,dph
	mov	dph,a
	mov	a,r5
	movx	@dptr,a
	mov	a,r1
	inc	dptr
	movx	@dptr,a

	mov	r0,#082H
	mov	r1,#08AH
	lcall	L1F81		;three multiplies, r4 is index, r0,r1 are base addr,r3 with results in r1,r4,r5

	mov	r0,$0002
	mov	a,@r0
	rl	a
	mov	dptr,#00059H
	add	a,dpl
	mov	dpl,a
	clr	a
	addc	a,dph
	mov	dph,a
	mov	a,r5
	movx	@dptr,a
	mov	a,r1
	inc	dptr
	movx	@dptr,a

	mov	a,#077H		;DCO1 dynamic pw parm (0-63)
	lcall	L1AE9		;apply selected selected dyn parm value to velocity value (in r3), rslt in breg

	mov	a,#07BH		;addr of DCO1 pw parm
	add	a,r4		;select lower or upper voice
	mov	r0,a
	movx	a,@r0		;get PW setting (in top 5 bits)
	mul	ab		;multiply it by dynamic factor
	mov	a,breg

	mov	dptr,#L2500	;PW cv values lookup table addr
	movc	a,@a+dptr	;use top byte of mult rslt as index into array
	mov	breg,a

	mov	a,#093H		;DCO1 PW CV value is stored at 93 and BB
	add	a,r4		;select lower or upper voice
	mov	r0,a
	mov	a,breg		;value read from table
	movx	@r0,a		;update PW 1 CV

	mov	a,#078H		;DCO1 dynamic pw parm (0-63)
	lcall	L1AE9		;apply selected selected dyn parm value to velocity value (in r3), rslt in breg

	mov	a,#07CH		;DCO1 pw parm
	add	a,r4		;select lower or upper voice
	mov	r0,a
	movx	a,@r0		;get PW setting (in top 5 bits)
	mul	ab		;multiply it by dynamic factor
	mov	a,breg

	mov	dptr,#L2500	;PW cv values lookup table addr
	movc	a,@a+dptr	;use top byte of mult rslt as index into array
	mov	breg,a

	mov	a,#094H		;DCO1 PW CV value is stored at 94 and BC
	add	a,r4		;select lower or upper voice
	mov	r0,a
	mov	a,breg		;value read from table
	movx	@r0,a		;update PW 2 CV

	mov	a,$0027
	anl	a,#003H
	cjne	a,#000H,L1672
	clr	03CH
	anl	$0026,#0F0H
	ljmp	L169C
;
L1672:
	mov	r0,#071H
	mov	r4,#000H
	mov	r1,#096H
	lcall	L1F81		;three multiplies, r4 is index, r0,r1 are base addr,r3 with results in r1,r4,r5

	mov	r0,#04BH
	mov	a,r5
	movx	@r0,a
	inc	r0
	mov	a,r1
	movx	@r0,a

	mov	r0,#071H
	mov	r4,#000H
	mov	r1,#098H
	lcall	L1F81		;three multiplies, r4 is index, r0,r1 are base addr,r3 with results in r1,r4,r5

	mov	r0,#047H
	mov	a,r5
	movx	@r0,a
	mov	r0,#048H
	mov	a,r1
	movx	@r0,a
	mov	a,#000H
	mov	r0,#043H
	movx	@r0,a
	inc	r0
	movx	@r0,a
	setb	03CH
L169C:
	mov	a,$0027
	rr	a
	rr	a
	anl	a,#003H
	cjne	a,#000H,L16AD
	anl	$0026,#00FH
	clr	03DH
	ljmp	L16D7

L16AD:
	mov	r0,#073H
	mov	r4,#000H
	mov	r1,#09AH
	lcall	L1F81		;three multiplies, r4 is index, r0,r1 are base addr,r3 with results in r1,r4,r5

	mov	r0,#04DH
	mov	a,r5
	movx	@r0,a
	inc	r0
	mov	a,r1
	movx	@r0,a

	mov	r0,#073H
	mov	r4,#000H
	mov	r1,#09CH
	lcall	L1F81		;three multiplies, r4 is index, r0,r1 are base addr,r3 with results in r1,r4,r5

	mov	r0,#049H
	mov	a,r5
	movx	@r0,a
	mov	r0,#04AH
	mov	a,r1
	movx	@r0,a
	mov	a,#000H
	mov	r0,#045H
	movx	@r0,a
	inc	r0
	movx	@r0,a
	setb	03DH
L16D7:
	mov	r1,$0002
	mov	a,@r1
	rl	a
	add	a,#012H
	mov	r0,a
	mov	@r0,#000H
	inc	r0
	mov	@r0,#000H
	mov	a,@r1
	rl	a
	add	a,#03CH
	mov	r0,a
	mov	@r0,#000H
	inc	r0
	mov	@r0,#000H
	ret



L16EE:				;called by init code
	lcall	L0FDC		;clear a bunch of internal RAM and first 12 CV's

	mov	dptr,#01004H	;select IC14, S&H select signal
	mov	a,#0FFH
	movx	@dptr,a		;inhibit all three chips

	mov	dptr,#00FF1H
	mov	a,#000H
	movx	@dptr,a

	mov	r0,#067H	;start of LED display buffer
	mov	a,#01AH		;A will blank digit
	mov	r3,#008H	;loop ctr
L1703:
	movx	@r0,a
	inc	r0
	add	a,#010H		;increment digit index part
	djnz	r3,L1703	;blank all 8 LED's

	mov	r0,#0F7H
	mov	r1,#009H
	mov	a,#000H
L170F:
	movx	@r0,a		;write 0 to 0F7-FFh
	inc	r0
	djnz	r1,L170F
				;now we init switch press event buffer/queue
	mov	a,#003H		;we insert three bytes in the buffer and set the ptrs
	mov	r0,#0DDH	;to match
	movx	@r0,a		;write 03 to addr DDh (sw event buffer byte count)

	mov	r0,#0DEH
	mov	a,#0E0H
	movx	@r0,a		;write 0E0h to addr DEh (rd ptr)

	mov	r0,#0DFH
	add	a,#003H
	movx	@r0,a		;write E3 to addr DFh (wr ptr to switch event buffer)

	mov	r0,a
	dec	r0
	mov	a,#001H
	movx	@r0,a		;write 01 to addr E2, "1" switch press, I think

	dec	r0
	mov	a,#000H
	movx	@r0,a		;write 00 to addr E1 (maybe this counts as the first digit entered?)

	dec	r0
	mov	a,#00DH
	movx	@r0,a		;write 0D to addr E0, place a "lower" switch press  in the buffer

	mov	a,#000H
	mov	r0,#0D0H
	mov	r1,#003H
L1735:
	movx	@r0,a		;write 00 to addr D0,D1,D2
	inc	r0
	djnz	r1,L1735

	mov	r0,#0CCH
	mov	a,#080H
	movx	@r0,a		;write 80h to CCh

	mov	r0,#0D5H
	movx	@r0,a		;write 80h to D5h

	mov	dptr,#00FFFH
	movx	@r0,a

	setb	056H

	mov	r0,#0CDH
	mov	a,#000H
	movx	@r0,a
	mov	r0,#0D6H
	movx	@r0,a
	mov	dptr,#00FFEH
	movx	@r0,a
	mov	$0026,#000H
	mov	$0027,#000H
	mov	$0028,#000H
	mov	$0029,#001H	;D0 set for OMNI mode

	mov	r0,#03DH
	mov	a,#000H
	movx	@r0,a

	mov	r0,#0CEH
	mov	a,#000H		;write 0 to addr CEh (init MIDI channels)
	movx	@r0,a

	mov	dptr,#00FFAH	;write 0 to addr FFAh
	movx	@dptr,a

	mov	dptr,#00FF9H	;write 0 to addr FF9h
	movx	@dptr,a

	mov	r0,#0CAH
	mov	a,#01BH		;write address 1B89 to CA:CB
	movx	@r0,a
	inc	r0
	mov	a,#089H
	movx	@r0,a

	mov	dptr,#01013H	;init all 4 timers in a loop
	mov	r1,#004H
L177F:
	mov	a,#036H

	mov	r0,#003H
L1783:				;write 36 to addr 3
				;then 76 then B6
	movx	@dptr,a		;select mode 3, low byte then high byte access
	add	a,#040H		;for all three timers
	djnz	r0,L1783

	mov	a,dpl
	add	a,#004H		;select the next timer
	mov	dpl,a
	djnz	r1,L177F	;rinse and repeat

	mov	r0,#03EH	;point to LED shadow
	mov	a,#000H	
	movx	@r0,a		;turn off all LEDs

	mov	r0,#0C7H
	movx	@r0,a		;write 0 to addr C7

	mov	dptr,#00FF8H
	movx	@dptr,a		;write 0 to addr 0FF8

	mov	r0,#0D7H
	movx	@r0,a		;write 0 to addr D7 (split minus transpose value)

	mov	a,#018H
	mov	r0,#0CFH
	movx	@r0,a		;write 24d to 0CF (split point)

	mov	r0,#0D8H
	movx	@r0,a		;and 0D8 (upper transpose value)

	ret



L17A8:				;we jump here at reset
	mov	sp,#067H
	lcall	L19CE		;init a bunch of registers in the 8031 and the MIDI UART
	lcall	L16EE
	mov	ie,#097H	;set EA, ES (ser), EX1 (ext1) , ET0 (timer0) , EX0 (ext0) bits
	setb	tr0
	setb	tr1
L17B8:
	ljmp	L0F00		;check rx buffer

L17BB:
	ljmp	L1B00		;check for MIDI rx chars


L17BE:				;MIDI code jumps here if RX buf is empty
	lcall	L2600

	mov	r0,#03DH
	movx	a,@r0
	jnb	accbit4,L17DB
	clr	accbit4
	movx	@r0,a

	mov	r0,#0D9H	;get MIDI note number for new key into r2
	movx	a,@r0
	mov	r2,a

	mov	r0,#0DAH	;get vel value for new key
	movx	a,@r0
	jz	L17D5
	rl	a		;times 2
	inc	a		;and add 1 to it
L17D5:
	mov	r3,a		;save that value in r3
	clr	pswbit1
	ljmp	L0A59

L17DB:
	jnb	04AH,L17F8
	clr	04AH
	mov	r0,#0DBH
	movx	a,@r0
	mov	r2,a
	cjne	r2,#00CH,L17EA
	ljmp	L17EF
;
L17EA:
	jnc	L17EF
	ljmp	L17F8
;
L17EF:
	mov	r0,#0DCH
	movx	a,@r0
	mov	r3,a
	setb	pswbit1
	ljmp	L0A59

L17F8:
	jbc	04FH,L17FE	;every 8th display refresh, this bit will be set
				;and we will check the switches
	ljmp	L1801		

L17FE:
	lcall	L18ED		;check switches
L1801:
	ljmp	L0028

L1804:
	lcall	L184F
	lcall	L180C
	sjmp	L17B8


L180C:
	mov	dptr,#00FF0H
	movx	a,@dptr
	jnb	accbit0,L1829
	mov	dptr,#00FEDH
	movx	a,@dptr
	jnz	L1829

	mov	dptr,#00FF4H	;lower program number?
	movx	a,@dptr
	mov	r0,#06BH	;lower program left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	mov	dptr,#00FF0H
	movx	a,@dptr
	clr	accbit0
	movx	@dptr,a
L1829:
	jnb	accbit1,L184E

	mov	c,040H		;get split mode enable into c
	orl	c,041H		;OR in double mode
	jc	L1838		;skip if either is enabled

	clr	accbit1
	movx	@dptr,a
	ljmp	L184E
;
L1838:
	mov	dptr,#00FEFH
	movx	a,@dptr
	jnz	L184E

	mov	dptr,#00FF5H	;upper program number?
	movx	a,@dptr
	mov	r0,#06DH	;upper program left digit
	lcall	L06C0		;converts acc to decimal, adds dig indexes, writes to 2 dsp buf locs

	mov	dptr,#00FF0H
	movx	a,@dptr
	clr	accbit1
	movx	@dptr,a
L184E:
	ret



L184F:
	mov	r0,#0F6H
	mov	r1,#0D6H
	movx	a,@r0
	mov	r2,a
	movx	a,@r1
	cjne	a,$0002,L185C
	ljmp	L1882

L185C:
	movx	@r0,a
	clr	c
	rrc	a
	mov	r4,a
	mov	r3,#001H
	mov	r0,#0CEH
	movx	a,@r0
	swap	a
	anl	a,#00FH
	orl	a,#0B0H
	mov	r2,a

	setb	f0
	lcall	L0F9D			;writes r2,r3 to tx buffer, and if f0 set, r4 as well

	mov	dptr,#00FF9H		;flag byte?
	movx	a,@dptr			
	jz	L1882

	inc	r2
	anl	$0002,#00FH
	orl	$0002,#0B0H

	setb	f0
	lcall	L0F9D			;writes r2,r3 to tx buffer, and if f0 set, r4 as well

L1882:
	mov	r0,#0CDH
	mov	r1,#0D6H
	movx	a,@r0
	mov	breg,a
	movx	a,@r1
	add	a,breg
	jnc	L1890
	mov	a,#0FFH
L1890:
	mov	dptr,#00FFEH
	movx	@dptr,a
	mov	r0,#042H
	mov	r1,#0D5H
	movx	a,@r0
	mov	r2,a
	movx	a,@r1
	cjne	a,$0002,L18A1
	ljmp	L18C7

L18A1:
	movx	@r0,a
	clr	c
	rrc	a
	mov	r4,a
	mov	r3,#000H
	mov	r0,#0CEH
	movx	a,@r0
	swap	a
	anl	a,#00FH
	orl	a,#0E0H
	mov	r2,a

	setb	f0
	lcall	L0F9D			;writes r2,r3 to tx buffer, and if f0 set, r4 as well

	mov	dptr,#00FF9H		;flag byte?
	movx	a,@dptr		
	jz	L18C7

	inc	r2
	anl	$0002,#00FH
	orl	$0002,#0E0H

	setb	f0
	lcall	L0F9D			;writes r2,r3 to tx buffer, and if f0 set, r4 as well

L18C7:
	mov	r0,#0CCH
	mov	r1,#0D5H
	movx	a,@r0
	mov	breg,a
	movx	a,@r1
	cpl	accbit7
	cpl	bregbit7
	add	a,breg
	jnb	ov,L18E2
	jb	accbit7,L18E0
	mov	a,#080H
	ljmp	L18E2

L18E0:
	mov	a,#07FH
L18E2:
	cpl	accbit7
	mov	c,accbit7
	mov	056H,c
	mov	dptr,#00FFFH
	movx	@dptr,a
	ret



L18ED:				;read switches
	setb	05EH		;this maps to 2B bit 6, which L1A45 uses to drive sw col 3
	mov	r0,#03CH
	movx	a,@r0
	clr	accbit6		;don't drive cols 1 and 2
	clr	accbit7
	movx	@r0,a

	lcall	L1A45		;write data to IC22 and 17 to drive select a switch column
	nop			;drive col 3
	nop
	mov	r4,p1

	clr	05EH
	mov	r0,#03CH
	movx	a,@r0
	setb	accbit6
	clr	accbit7
	movx	@r0,a

	lcall	L1A45		;write data to IC22 and 17 to drive select a switch column
				;drive col 2
	mov	r0,#0D0H
	movx	a,@r0
	mov	breg,#000H
	lcall	L1A18		;process col3 result

	mov	r4,p1

	clr	05EH
	mov	r0,#03CH
	movx	a,@r0
	clr	accbit6
	setb	accbit7		;now drive col 1
	movx	@r0,a

	lcall	L1A45		;write data to IC22 and 17 to select a switch column
	mov	r0,#0D1H
	movx	a,@r0
	mov	breg,#008H
	lcall	L1A18		;process col2 result

	jb	045H,L1966
	mov	c,p1bit5	;check for release pedal?
	jc	L193B

	jnb	03EH,L1962
	mov	r4,#000H
	ljmp	L1940

L193B:
	jb	03EH,L1962
	mov	r4,#07FH
L1940:
	mov	r0,#0CEH
	movx	a,@r0
	swap	a
	anl	a,#00FH
	orl	a,#0B0H		;Bn 040 07Fh, release pedal value is 07Fh
	mov	r2,a
	mov	r3,#040H

	setb	f0
	lcall	L0F9D		;writes r2,r3 to tx buffer, and if f0 set, r4 as well

	mov	dptr,#00FF9H	;flag byte?
	movx	a,@dptr		

	jz	L1962
	inc	r2
	anl	$0002,#00FH
	orl	$0002,#0B0H

	setb	f0
	lcall	L0F9D		;writes r2,r3 to tx buffer, and if f0 set, r4 as well
L1962:
	mov	c,p1bit5
	mov	03EH,c
L1966:
	mov	r4,p1		;read switches
	mov	r0,#0D2H
	movx	a,@r0
	mov	breg,#010H
	lcall	L1A18		;process col 1 result

	clr	04FH		;clear the flag that tells us to read the switches

	ret


				;loads timer based on note number at [r2-1]
				;called with r5=79,7A, these seem to hold offsets which are added to note #
L1974:				
	mov	dptr,#L2400	;start of the timer divider value array for our notes
	mov	r0,$0002
	dec	r0
	mov	a,@r0		;get note number
L197B:
	cjne	a,#018H,L1981	;is it >= 24?
	ljmp	L1987

L1981:
	jnc	L1987
	add	a,#00CH		;if not, add 12 to it until it is
	sjmp	L197B

L1987:
	clr	c
	subb	a,#018H		;subtract 24 from it
	mov	breg,a		;save result in b reg

	mov	a,r5
	add	a,r4
	mov	r0,a		
	movx	a,@r0		;read RAM value
	add	a,breg		;add it to note number

	jnb	040H,L199F	;skip if not in split mode

	jnb	f0,L199F
				;if f0 set, maybe note is in upper part of keybd
	mov	breg,a		;save note # in breg
	mov	r0,#0D7H
	movx	a,@r0
	add	a,breg		;add in split pt minus transpose value

L199F:
	cjne	a,#06CH,L19A4	;if note number is > 108, 
	sjmp	L19AB

L19A4:
	jc	L19AB
	clr	c
	subb	a,#00CH		;subtract 12 from it until it's not
	sjmp	L199F

L19AB:
	rl	a		;table values are words
	mov	r0,a
	movc	a,@a+dptr
	mov	breg,a		;upper timer byte is in lower address
	mov	a,r0
	inc	a
	movc	a,@a+dptr
	mov	r5,a		;then lower timer byte

	mov	dptr,#0100FH	;address just below the timers
	mov	r0,$0002	;guessing this selects a timer and writes to it
	mov	a,@r0
	cjne	a,#003H,L19C0
	ljmp	L19C3

L19C0:
	jc	L19C3
	inc	a
L19C3:
	add	a,r1		
	add	a,dpl
	mov	dpl,a
	mov	a,r5		;write low timer byte
	movx	@dptr,a
	mov	a,breg		;write upper timer byte
	movx	@dptr,a
	ret



L19CE:				;init a bunch of registers in the 8031 and the MIDI UART
	mov	tcon,#000H
	mov	tmod,#020H
	mov	scon,#050H
	mov	ie,#080H
	mov	ip,#014H
	mov	th0,#0A0H
	mov	th1,#0FFH
	mov	tl1,#0FFH
	mov	p3,#0FFH
	mov	p2,#000H
	mov	p1,#0FFH
	mov	p0,#000H

	setb	p3bit5		;set UART C/Db high
	nop
	nop
	mov	dptr,#01000H	;select MIDI UART
	mov	a,#000H		;write six bytes to it
	movx	@dptr,a
	nop
	nop
	movx	@dptr,a
	nop
	nop
	movx	@dptr,a
	nop
	nop
	mov	a,#040H
	movx	@dptr,a
	nop
	nop
	mov	a,#0CEH
	movx	@dptr,a
	nop
	nop
	mov	a,#005H
	movx	@dptr,a
	nop
	nop
	clr	p3bit5		;set UART C/Db low
	nop
	nop
	ret



L1A18:
	xch	a,r4
	movx	@r0,a
	xch	a,r4
	cpl	a
	anl	a,r4		;we are looking for a change here
	jz	L1A44

	mov	r3,#008H
L1A21:
	rlc	a
	jc	L1A27
	djnz	r3,L1A21
	ret

L1A27:
	mov	a,r3
	add	a,breg
	cjne	a,#016H,L1A2E
	ret


L1A2E:
	jnc	L1A44
	mov	r3,a
	mov	r0,#0DDH	;looks like a sw events ctr
	movx	a,@r0
	cjne	a,#010H,L1A38	;which can't exceed 15
	ret


L1A38:
	inc	a		;inc ctr and update it
	movx	@r0,a		

	mov	r0,#0DFH	
	movx	a,@r0		;get wr ptr into buffer
	mov	r1,a		;into r1
	inc	a		;then bump it
	clr	accbit4		;wrap it at 16
	movx	@r0,a		;update it
	mov	a,r3		;put the new event into the buffer
	movx	@r1,a
L1A44:
	ret



L1A45:
	mov	dptr,#01003H	;select reg IC17, S&H select and sw cols 1 and 2
	movx	@dptr,a

	mov	a,$002B
	mov	dptr,#01002H	;select reg IC22, Wavesels 2 and 4, bit 6 is SW col 3
	mov	c,accbit6
	cpl	a
	mov	accbit6,c
	movx	@dptr,a
	ret



L1A55:
	push	acc
	push	$0000
	push	dpl
	push	dph
	push	psw
	mov	r0,#0F7H
	movx	a,@r0
	jnz	L1A68
	clr	ex0
	sjmp	L1A7B
;
L1A68:
	dec	a
	movx	@r0,a
	mov	r0,#0F8H
	movx	a,@r0
	mov	dpl,a
	mov	dph,#003H
	inc	a
	clr	accbit7
	movx	@r0,a
	movx	a,@dptr
	mov	dptr,#01000H
	movx	@dptr,a
L1A7B:
	pop	psw
	pop	dph
	pop	dpl
	pop	$0000
	pop	acc
	setb	ea
	reti



L1A88:				;MIDI UART RX interrupt jumps here
	push	acc
	push	$0000
	push	$0001
	push	dpl
	push	dph
	push	psw

	mov	dptr,#01000H	;point to UART
	movx	a,@dptr
	mov	r1,a		

	mov	r0,#0FFH	;get MIDI rx buffer ptr
	movx	a,@r0
	mov	dpl,a
	mov	dph,#001H
	inc	a
	movx	@r0,a		;update buffer ptr

	mov	a,r1
	movx	@dptr,a		;store MIDI byte in buffer

	mov	r0,#0FDH	;MIDI rx bytes ctr
	movx	a,@r0
	inc	a		;increment it
	movx	@r0,a

	pop	psw
	pop	dph
	pop	dpl
	pop	$0001
	pop	$0000
	pop	acc

	setb	ea		;enable interrupts
	reti



L1AB9:				;internal serial interrupt vector jumps here
	clr	ri		;this is used to get messages from keyboard MCU
	push	acc		;save registers
	push	$0000
	push	$0001
	push	dpl
	push	dph
	push	psw

	mov	r1,sbuf		;read rec'd data

	mov	r0,#0FCH	;point to internal rx buffer ptr
	movx	a,@r0		;read pointer
	mov	dpl,a
	mov	dph,#002H	;load dptr using ptr
	inc	a
	movx	@r0,a		;incr ptr
	mov	a,r1
	movx	@dptr,a		;store rx data in rx buffer

	mov	r0,#0FAH	;keybd rx buffer byte count
	movx	a,@r0
	inc	a		;increment it
	movx	@r0,a		;and write it out

	pop	psw		;restore registers
	pop	dph
	pop	dpl
	pop	$0001
	pop	$0000
	pop	acc
	setb	ea		;re-enable interrupts
	reti



L1AE9:				;called with ptr to dyn amt parm in acc
	add	a,r4		;select lower or upper voice
	mov	r0,a
	movx	a,@r0		;read parm into acc (0-63, in top 6 bits)

	mov	breg,a		;save it in breg

	cpl	a
	mov	r0,a		;save one's complement of parm in r0

	mov	a,r3		;r3 holds velocity value from keybd times 2 plus 1
	mul	ab
	mov	a,breg		;get high byte of product
	add	a,r0		;add complement of parm
				;this is so that max vel value gives close to FF
				;regardless of dyn parm value, so dyn parm determines how
				;much parm setting is reduced based on vel value
	mov	breg,a		;result in b reg
	ret


	.db	$FF
	.db	$FF
	.db	$FF
	.db	$FF
	.db	$FF
	.db	$FF
	.db	$FF
	.db	$FF


L1B00:
	mov	r0,#0FDH	;point to MIDI rx buf byte ctr
	movx	a,@r0
	jnz	L1B08
	ljmp	L17BE		;jump here if it's 0

L1B08:				;MIDI rx buf is not empty:
	mov	r1,#0FEH	;point to rx buf read ptr
	mov	dph,#001H
	movx	a,@r1
	mov	dpl,a		;load dptr with MIDI rx buf rd ptr

	clr	ea		;disable interrupts

	inc	a
	movx	@r1,a		;bump ptr and write it out

	movx	a,@r0
	dec	a		;decrement buffer byte count
	movx	@r0,a

	movx	a,@dptr		;read byte from buffer
	setb	ea		;enable interrupts
	mov	r2,a		;and save it in r2
	jb	accbit7,L1B2F	;jump if status byte

	jb	049H,L1B24
	ljmp	L1EE1

L1B24:
	mov	r0,#0CAH	;jump through CA:CB
	movx	a,@r0
	mov	dph,a
	inc	r0
	movx	a,@r0
	mov	dpl,a
	clr	a
	jmp	@a+dptr		;INFO: indirect jump


L1B2F:				;MIDI rx byte is a status byte
	anl	a,#0F0H
	cjne	a,#0F0H,L1B37	;jump if not sysex status byte?
	ljmp	L1B65

L1B37:				;not sysex status:
	jb	048H,L1B4C	;skip if OMNI mode

	mov	r0,#0CEH	;MIDI channels
	movx	a,@r0
	anl	a,#00FH		;rx channel
	mov	r0,a		;r0 is same as address $0000
	mov	a,r2
	anl	a,#00FH
	cjne	a,$0000,L1B49	;MIDI channel match rx one?
	ljmp	L1B4C
L1B49:
	ljmp	L1C3F


L1B4C:				;rec'd channel matches our rx one
	setb	049H
	mov	a,r2		;get status byte
	swap	a		;upper nibble
	anl	a,#007H		;low 3 bits
	rl	a		;times 2
	mov	dptr,#L1B57
	jmp	@a+dptr		;sysex jump table
L1B57:
	ajmp	L1B8F		;08n
	ajmp	L1B7B		;09n
	ajmp	L1C3F		;0An
	ajmp	L1C44		;0Bn
	ajmp	L1BB8		;0Cn
	ajmp	L1C3F		;0Dn
	ajmp	L1C14		;0En


L1B65:				;status byte is 0Fn (sysex)
	mov	a,r2
	cjne	a,#0F0H,L1B6C
	ljmp	L1CF4		;jump here if 0Fn
;
L1B6C:
	cjne	a,#0F7H,L1B72
	ljmp	L1CEF
;
L1B72:
	cjne	a,#0FFH,L1B78	;MIDI reset is 0xFF
	ljmp	L0000
L1B78:
	ljmp	L1EE1


L1B7B:				;MIDI 09n (note on)
	mov	r0,#0CAH
	mov	a,#01BH
	movx	@r0,a		;write 0x1B89 addr to CA:CB
	inc	r0
	mov	a,#089H
	movx	@r0,a
	clr	03FH
	ljmp	L1EE1

;L1B89:
	jbc	03FH,L1BAB
	ljmp	L1BA0


L1B8F:				;MIDI 08n (note off)
	mov	r0,#0CAH
	mov	a,#01BH
	movx	@r0,a		;write 0x1B9D addr to CA:CB
	inc	r0
	mov	a,#09DH
	movx	@r0,a
	clr	03FH
	ljmp	L1EE1

;L1B9D:
	jbc	03FH,L1BA9
L1BA0:
	mov	r0,#0DBH
	mov	a,r2
	movx	@r0,a
	setb	03FH
	ljmp	L1EE1

L1BA9:
	mov	r2,#000H
L1BAB:
	mov	a,r2
	jz	L1BB0
	rl	a
	inc	a
L1BB0:
	mov	r0,#0DCH
	movx	@r0,a
	setb	04AH
	ljmp	L1EE1


L1BB8:				;MIDI 0Cn (program change)
	jb	044H,L1BBE	;this must be the enable for MIDI program changes (parm 71)
	ljmp	L1C3F
;
L1BBE:
	mov	r0,#0CAH
	mov	a,#01BH		;write addr 0x1BD6 to CA:CB
	movx	@r0,a
	inc	r0
	mov	a,#0D6H
	movx	@r0,a
	jnb	040H,L1BCD	;skip if not in split mode

	ljmp	L1D6D
;
L1BCD:
	jnb	041H,L1BD3
	ljmp	L1D54
L1BD3:
	ljmp	L1EE1

;L1BD6:
	mov	r0,#0DFH
	movx	a,@r0
	mov	r1,a
	mov	a,#00DH
	movx	@r1,a
	inc	r1
	xch	a,r1
	clr	accbit4
	xch	a,r1
	mov	a,r2
L1BE3:
	cjne	a,#062H,L1BE9	;0-62h are programs 1-99
	ljmp	L1BF0		
;
L1BE9:
	jc	L1BF0
	clr	c
	subb	a,#063H		;63-7F are programs 1-29
	sjmp	L1BE3
;
L1BF0:
	inc	a
	mov	breg,#00AH
	div	ab
	jnz	L1BF9
	mov	a,#00AH
L1BF9:
	movx	@r1,a
	inc	r1
	xch	a,r1
	clr	accbit4
	xch	a,r1
	mov	a,breg
	jnz	L1C05
	mov	a,#00AH
L1C05:
	movx	@r1,a
	inc	r1
	mov	a,r1
	clr	accbit4
	movx	@r0,a
	mov	r0,#0DDH
	movx	a,@r0
	add	a,#003H
	movx	@r0,a
	ljmp	L1EE1


L1C14:
	jb	046H,L1C1F
	mov	r0,#0CCH
	mov	a,#080H
	movx	@r0,a
	ljmp	L1C3F
;
L1C1F:
	mov	r0,#0CAH
	mov	a,#01CH
	movx	@r0,a
	inc	r0
	mov	a,#02BH
	movx	@r0,a
	ljmp	L1EE1

	mov	r0,#0CAH
	mov	a,#01CH
	movx	@r0,a
	inc	r0
	mov	a,#037H
	movx	@r0,a
	ljmp	L1EE1

	mov	a,r2
	rl	a
	mov	r0,#0CCH
	movx	@r0,a
	ljmp	L1EE1


L1C3F:					;MIDI 0An ()
	clr	049H
	ljmp	L1EE1



L1C44:					;MIDI 0Bn (cc) code
	mov	a,r2
	anl	a,#00FH
	mov	breg,a			;save MIDI channel part

	mov	r0,#03DH
	movx	a,@r0
	anl	a,#0F0H
	orl	a,breg
	movx	@r0,a

	mov	r0,#0CAH
	mov	a,#01CH			;store 0x1C5D at CA:CB
	movx	@r0,a
	inc	r0
	mov	a,#05DH
	movx	@r0,a
	ljmp	L1EE1


;L1C5D:					;we come here on MIDI controller # byte
	cjne	r2,#001H,L1C63		;Bn 01 is mod wheel change
	ljmp	L1C8C

L1C63:
	cjne	r2,#040H,L1C69		;Bn 40 is release pedal value
	ljmp	L1CA9

L1C69:
	mov	r0,#03DH
	movx	a,@r0
	anl	a,#00FH
	mov	r1,a
	mov	r0,#0CEH		;CE holds MIDI channels
	movx	a,@r0
	anl	a,#00FH			;recve in low nibble
	cjne	a,$0001,L1C3F		;bail if it doesn't match

	cjne	r2,#07BH,L1C7D		
	ljmp	L1CC0			;Bn 7B is all notes off

L1C7D:
	cjne	r2,#07CH,L1C83		
	ljmp	L1CE7			;Bn 7C turns off OMNI mode

L1C83:
	cjne	r2,#07DH,L1C89		
	ljmp	L1CEB			;Bn 7D turns on OMNI mode

L1C89:					;bail if no match by now
	ljmp	L1C3F

L1C8C:					;CC Mod wheel change 
	mov	r0,#0CAH
	mov	a,#01CH
	movx	@r0,a			;store 0x1C98 at CA:CB
	inc	r0
	mov	a,#098H
	movx	@r0,a
	ljmp	L1EE1

;L1C98:
	mov	r0,#0CDH
	jb	047H,L1CA3
	mov	a,#000H
	movx	@r0,a
	ljmp	L1EE1
;
L1CA3:
	mov	a,r2
	rl	a
	movx	@r0,a
	ljmp	L1EE1
;
L1CA9:
	mov	r0,#0CAH
	mov	a,#01CH
	movx	@r0,a
	inc	r0
	mov	a,#0B5H
	movx	@r0,a
	ljmp	L1EE1
;
	jnb	045H,L1CBD
	mov	a,r2
	mov	c,accbit0
	mov	03EH,c
L1CBD:
	ljmp	L1EE1


L1CC0:					;this should be turning all notes off
	mov	r1,#007H
L1CC2:
	inc	r1
	inc	r1
	cjne	r1,#015H,L1CCA
	ljmp	L1C3F
L1CCA:
	mov	a,@r1
	jnb	accbit7,L1CC2
	clr	accbit7
	add	a,#01FH
	mov	r0,a
	mov	a,@r0
	jb	accbit3,L1CC2
	jb	accbit2,L1CC2
	anl	a,#003H
	cjne	a,#003H,L1CE1
	sjmp	L1CC2			;loop



L1CE1:
	mov	a,@r0
	setb	accbit2
	mov	@r0,a
	sjmp	L1CC2

L1CE7:
	clr	048H			;should be disabling OMNI mode
	sjmp	L1CC0

L1CEB:
	setb	048H			;should be enabling OMNI mode
	sjmp	L1CC0

L1CEF:
	setb	049H
	ljmp	L1EE1			;just does ljmp to L17BE

					;sysex first byte jumps here
L1CF4:					;store 1D02 address at CA:CB
	mov	r0,#0CAH
	mov	a,#01DH
	movx	@r0,a
	inc	r0
	mov	a,#002H
	movx	@r0,a
	setb	049H
	ljmp	L1EE1			;just does ljmp to L17BE

					;sysex second byte comes here
;L1D02:					;we get here through above address
	cjne	r2,#025H,L1D11		;check for BIT ID (025h)
	mov	r0,#0CAH
	mov	a,#01DH
	movx	@r0,a
	inc	r0
	mov	a,#014H			;store 1D14 address at CA:CB
	movx	@r0,a
	ljmp	L1EE1			;just does ljmp to L17BE

L1D11:
	ljmp	L1C3F

;L1D14					;sysex third byte comes here (after F0 25)
	mov	r0,#0CEH		;must contain our rx MIDI channel in low 4 bits
	movx	a,@r0
	anl	a,#00FH
	orl	a,#020H			;OR in BIT99 ID?
	cjne	a,$0002,L1D11
		
	mov	r0,#0CAH		;store 1D2A address at CA:CB
	mov	a,#01DH
	movx	@r0,a
	inc	r0
	mov	a,#02AH
	movx	@r0,a
	ljmp	L1EE1			;just does ljmp to L17BE


;L1D2A:					;sysex third byte comes here (after F0 25 2n)
	mov	a,r2
	cjne	a,#00AH,L1D31
L1D2E:
	ljmp	L1C3F

L1D31:
	jnc	L1D2E
	rl	a
	mov	dptr,#L1D38
	jmp	@a+dptr		;jump table
L1D38:				;sysex fcn code
	ajmp	L1D86		;0 activate split mode			
	ajmp	L1D6D		;1 disable split mode
	ajmp	L1D4E		;2 activate double mode
	ajmp	L1D54		;3 disable double mode
	ajmp	L1C3F		;4 just exits
	ajmp	L1DB7		;5 lower program change
	ajmp	L1E07		;6 upper program change
	ajmp	L1E57		;7 single program receive
	ajmp	L1ECB		;8 appears to set up 75-program receive
	ajmp	L1EE4		;9 Request single program send
	ajmp	L1C3F		;A just exits

L1D4E:				;activate double mode
	jnb	041H,L1D5A	;is it already active?
	ljmp	L1C3F

L1D54:				;disable double mode
	jb	041H,L1D5A	;is it active?
	ljmp	L1C3F

L1D5A:
	mov	r0,#0DFH
	movx	a,@r0
	mov	r1,a
	inc	a
	clr	accbit4
	movx	@r0,a
	mov	a,#011H
	movx	@r1,a
	mov	r0,#0DDH
	movx	a,@r0
	inc	a
	movx	@r0,a
	ljmp	L1EE1		;just does ljmp to L17BE

L1D6D:				;disable split mode
	jb	040H,L1D73	;is it active?
	ljmp	L1C3F

L1D73:
	mov	r0,#0DFH
	movx	a,@r0
	mov	r1,a
	inc	a
	clr	accbit4
	movx	@r0,a
	mov	a,#010H
	movx	@r1,a
	mov	r0,#0DDH
	movx	a,@r0
	inc	a
	movx	@r0,a
	ljmp	L1EE1		;just does ljmp to L17BE
	
L1D86:				;activate split mode
	mov	r0,#0CAH
	mov	a,#01DH		;write 1D95 to CA:CB
	movx	@r0,a
	inc	r0
	mov	a,#095H
	movx	@r0,a
	jnb	040H,L1D73	;jump up if not in split mode

	ljmp	L1EE1		;just does ljmp to L17BE

;L1D95:
	mov	a,r2		;Split pt byte comes here
	mov	r0,#0CFH
	movx	@r0,a		;save it

	mov	r0,#0CAH
	mov	a,#01DH		;write 0x1DA5 to CA:CB
	movx	@r0,a
	inc	r0
	mov	a,#0A5H
	movx	@r0,a
	ljmp	L1EE1		;just does ljmp to L17BE

;L1DA5:				;upper transpose byte comes here
	mov	a,r2
	mov	r0,#0D8H
	movx	@r0,a		;save upper transpose byte
	mov	breg,a		;and in breg

	mov	r1,#0CFH
	movx	a,@r1		;get split point
	clr	c
	subb	a,breg		;subtract transpose from split pt
	mov	r0,#0D7H	;and save that here
	movx	@r0,a
	ljmp	L1EE1		;just does ljmp to L17BE


L1DB7:				;lower program change
	jb	044H,L1DBD
	ljmp	L1C3F

L1DBD:
	mov	r0,#0CAH
	mov	a,#01DH		;write 0x1DC9 to CA:CB
	movx	@r0,a
	inc	r0
	mov	a,#0C9H
	movx	@r0,a
	ljmp	L1EE1		;just does ljmp to L17BE

;L1DC9:
	mov	r0,#0DFH	;lower program chg # comes here
	movx	a,@r0
	mov	r1,a
	mov	a,#00DH
	movx	@r1,a
	inc	r1
	mov	a,r1
	clr	accbit4
	mov	r1,a
	mov	a,r2
L1DD6:
	cjne	a,#04AH,L1DDC
	ljmp	L1DE3

L1DDC:
	jc	L1DE3
	clr	c
	subb	a,#04BH
	sjmp	L1DD6

L1DE3:
	inc	a
	mov	breg,#00AH
	div	ab
	jnz	L1DEC
	mov	a,#00AH
L1DEC:
	movx	@r1,a
	inc	r1
	xch	a,r1
	clr	accbit4
	xch	a,r1
	mov	a,breg
	jnz	L1DF8
	mov	a,#00AH
L1DF8:
	movx	@r1,a
	inc	r1
	mov	a,r1
	clr	accbit4
	movx	@r0,a
	mov	r0,#0DDH
	movx	a,@r0
	add	a,#003H
	movx	@r0,a
	ljmp	L1EE1		;just does ljmp to L17BE

L1E07:
	jb	044H,L1E0D
	ljmp	L1C3F

L1E0D:
	mov	r0,#0CAH
	mov	a,#01EH
	movx	@r0,a
	inc	r0
	mov	a,#019H
	movx	@r0,a
	ljmp	L1EE1		;just does ljmp to L17BE

	mov	r0,#0DFH
	movx	a,@r0
	mov	r1,a
	mov	a,#00FH
	movx	@r1,a
	inc	r1
	mov	a,r1
	clr	accbit4
	mov	r1,a
	mov	a,r2
L1E26:
	cjne	a,#04AH,L1E2C
	ljmp	L1E33

L1E2C:
	jc	L1E33
	clr	c
	subb	a,#04BH
	sjmp	L1E26

L1E33:
	inc	a
	mov	breg,#00AH
	div	ab
	jnz	L1E3C
	mov	a,#00AH
L1E3C:
	movx	@r1,a
	inc	r1
	xch	a,r1
	clr	accbit4
	xch	a,r1
	mov	a,breg
	jnz	L1E48
	mov	a,#00AH
L1E48:
	movx	@r1,a
	inc	r1
	mov	a,r1
	clr	accbit4
	movx	@r0,a
	mov	r0,#0DDH
	movx	a,@r0
	add	a,#003H
	movx	@r0,a
	ljmp	L1EE1		;just does ljmp to L17BE



L1E57:				;single program receive
	mov	r0,#0CAH
	mov	a,#01EH		;store 0x1E63 at CA:CB
	movx	@r0,a
	inc	r0
	mov	a,#063H
	movx	@r0,a
	ljmp	L1EE1		;just does ljmp to L17BE


;L1E63:
	mov	a,r2		;grab program number byte
	inc	a		;0 means to program 1
	cjne	a,#04CH,L1E6B	;range check progrm #
				;cy set if a < 4C
	ljmp	L1E73

L1E6B:
	jnc	L1E73		;jump if program # is 76 or greater

	lcall	L0709		;loads dptr with RAM starting address for program # in acc (1-99)
	ljmp	L1E76

L1E73:
	lcall	L0719		;get address of split/dbl prog # in acc into dptr
				
L1E76:
	mov	breg,dpl	;save low addr byte in breg
	mov	a,dph		;and upper byte in acc
	mov	dptr,#00FFCH
	movx	@dptr,a		;write upper byte to 0xFFC
	mov	a,breg
	inc	dptr		;and lower addr byte to 0xFFD
	movx	@dptr,a

	mov	r0,#0CAH
	mov	a,#01EH		;store 0x1E8F at CA:CB
	movx	@r0,a
	inc	r0
	mov	a,#08FH
	movx	@r0,a
	ljmp	L1EE1		;just does ljmp to L17BE

;L1E8F:
	mov	dptr,#00FFCH	;we jump here when prog bytes arrive
	movx	a,@dptr		;grab upper byte of program RAM address
	mov	c,accbit7
	mov	f0,c		;copy address upper bit into f0 flag
	clr	accbit7		;clear address top bit
	mov	breg,a		;save that in breg

	inc	dptr		;point to lower addr byte
	movx	a,@dptr		;read it
	mov	dpl,a		;move into dpl
	mov	dph,breg	;put upper addr with D7=0 in dph
	jb	f0,L1EAA
	mov	a,r2
	movx	@dptr,a		;put MIDI byte into program RAM
	ljmp	L1EB5

L1EAA:				;if second of every pair of MIDI bytes.. 
	mov	a,r2
	swap	a		;swap nibbles
	anl	a,#0F0H		;save upper bits
	mov	r2,a		;in r2
	movx	a,@dptr		;read first byte we wrote to RAM
	anl	a,#00FH		;just save low nibble
	orl	a,r2		;OR in upper nibble from second byte
	movx	@dptr,a		;write back to RAM
	inc	dptr		;and inc ptr
L1EB5:
	mov	a,dph		;save dph in acc
	mov	breg,dpl	;dpl in breg
	mov	dptr,#00FFCH
	cpl	f0		;flip bit 15 of address
	mov	c,f0
	mov	accbit7,c
	movx	@dptr,a		;write upper byte to FFC
	inc	dptr
	mov	a,breg		;and lower byte to FFD
	movx	@dptr,a
	ljmp	L1EE1		;just does ljmp to L17BE



L1ECB:				;looks like code to receive a full set of patches
	mov	a,#003H
	mov	dptr,#00FFCH	;store 0x03 at FFC
	movx	@dptr,a
	inc	dptr
	mov	a,#080H		;and 0x80 at FFD
	movx	@dptr,a		;ready to receive a full set of programs

	mov	r0,#0CAH
	mov	a,#01EH		;store 0x1E8F at CA:CB
	movx	@r0,a
	inc	r0
	mov	a,#08FH
	movx	@r0,a
	ljmp	L1EE1		;just does ljmp to L17BE

L1EE1:
	ljmp	L17BE



L1EE4:				;request for us to send a single patch comes here
	mov	r0,#0CAH
	mov	a,#01EH
	movx	@r0,a		;store 0x1EEF at CA:CB
	inc	r0
	mov	a,#0EFH
	movx	@r0,a
	sjmp	L1EE1

;L1EEF:
	mov	a,r2		;grab first byte, which should be ID of recv dev, plus MIDI chan to use
	mov	dptr,#00FEBH
	anl	a,#0F0H		;check ID first
	jnz	L1EFF

	mov	a,r2		;if top nibble is 0, then send to BIT99
	anl	a,#00FH
	orl	a,#020H		;OR in 2 for BIT99 plus the MIDI channel and save at 0xFEB
	ljmp	L1F00

L1EFF:
	mov	a,r2		;if top nibble is 1, send to BIT01
L1F00:
	movx	@dptr,a		;save ID code and MIDI channel at 0xFEB

	mov	r0,#0CAH
	mov	a,#01FH		;store 0x1F0C at CA:CB
	movx	@r0,a
	inc	r0
	mov	a,#00CH
	movx	@r0,a
	sjmp	L1EE1

;L1F0CL
	mov	a,r2		;get requested program number
	inc	a
	cjne	a,#04CH,L1F14	;see if it's a split/dbl one
	ljmp	L1F1E		;if so, jump here

L1F14:
	jnc	L1F1E
	lcall	L0709		;loads dptr with RAM starting address for program # in acc (1-99)
	mov	r5,#025H	;byte count = 37
	ljmp	L1F23

L1F1E:
	lcall	L0719		;get address of split/dbl prog # in acc into dptr
	mov	r5,#007H	;byte count = 7
L1F23:
	mov	breg,dpl
	mov	a,dph
	mov	dptr,#00FFCH
	movx	@dptr,a		;save high byte of addr at 0xFFC
	mov	a,breg
	inc	dptr
	movx	@dptr,a		;and low byte at 0xFFD

	mov	breg,r2		;save program number in breg
	mov	r2,#0F0H	;send sysex first
	mov	r3,#025H	;then mfr ID for BIT
	mov	dptr,#00FEBH
	movx	a,@dptr
	mov	r4,a		;then ID plus MIDI channel byte

	setb	f0
	lcall	L0F9D		;writes r2,r3 to tx buffer, and if f0 set, r4 as well

	mov	r2,#007H	;then single program dump code
	mov	r3,breg		;then program number

	clr	f0
	lcall	L0F9D		;writes r2,r3 to tx buffer, and if f0 set, r4 as well

L1F49:
	mov	dptr,#00FFCH
	movx	a,@dptr
	mov	breg,a		;load dptr from 0xFFC, 0xFFD
	inc	dptr
	movx	a,@dptr
	mov	dpl,a
	mov	dph,breg

	movx	a,@dptr		;read program byte
	inc	dptr

	mov	r2,#00FH	;put mask in r2
	anl	$0002,a		;and acc with that mask, low nibble of prog byte in r2

	mov	r3,#00FH	;put mask in r3
	swap	a
	anl	$0003,a		;and acc with that mask, high nibble of prog byte in r3

	mov	a,dph
	mov	breg,dpl
	mov	dptr,#00FFCH
	movx	@dptr,a
	mov	a,breg
	inc	dptr
	movx	@dptr,a

	clr	f0
	lcall	L0F9D		;writes r2,r3 to tx buffer, and if f0 set, r4 as well

	djnz	r5,L1F49	;loop until count bytes sent

	mov	r2,#0F7H	;send end of sysex byte twice
	mov	r3,#0F7H

	clr	f0
	lcall	L0F9D		;writes r2,r3 to tx buffer, and if f0 set, r4 as well

	ljmp	L1EE1


L1F81:			;three multiplies, r4 is index, r0,r1 are base addr,r3 with results in r1,r4,r5
	mov	a,r0
	add	a,r4
	mov	r0,a	;r0 = r0 + r4

	movx	a,@r0
	mov	r5,a	;r5 = [r0+r4]

	cpl	a	;acc = ~[r0+r4]
	xch	a,r5	;r5 = ~[r0+r4], acc = [r0+r4]

	mov	breg,r3
	mul	ab	;upper result byte is in b
	mov	a,breg	;acc = upper byte of r3 * breg

	add	a,r5
	mov	r5,a	;r5 = upper byte of r3 * breg + ~[r0+r4]
	mov	breg,a	;breg= upper byte of r3 * breg + ~[r0+r4]

	mov	a,r1
	add	a,r4
	mov	r0,a	;r0 = r1 + r4
	movx	a,@r0	;acc = [r1+r4]

	mul	ab	;upper result byte is in b
	mov	r1,breg	;r1 = upper byte of [r1+r4] * breg

	dec	r0
	movx	a,@r0
	mov	breg,r5
	mul	ab
	add	a,r1
	mov	r1,a
	mov	a,breg
	addc	a,#000H
	mov	r5,a
	cjne	r5,#000H,L1FAC
	cjne	r1,#000H,L1FAC
	mov	r1,#004H
L1FAC:
	ret
	
	.FILL	($2000-$),0FFh
	
	.END

