/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.lib.expect;

import com.cisco.nm.lib.expect.TelnetSocket;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class TelnetProtocol {
    private static final boolean DEBUG = false;
    protected byte[] SEND_OPT;
    protected byte[] SB_NAWS;
    private TelnetSocket _telnetSocket;
    private BufferedWriter _writer;
    private StringBuffer _stringBuffer;
    protected static final int IAC = 255;
    public static final byte DONT = -2;
    public static final byte DO = -3;
    public static final byte WONT = -4;
    public static final byte WILL = -5;
    public static final byte SB = -6;
    public static final byte GA = -7;
    public static final byte EL = -8;
    public static final byte EC = -9;
    public static final byte AYT = -10;
    public static final byte AO = -11;
    public static final byte IP = -12;
    public static final byte BRK = -13;
    public static final byte DM = -14;
    public static final byte NOP = -15;
    public static final byte SE = -16;
    public static final byte EOR = -17;
    public static final byte ECHO = 1;
    public static final byte TELOPT_SGA = 3;
    public static final byte STATUS = 5;
    public static final byte TIMING_MARK = 6;
    public static final byte TERMINAL_TYPE = 24;
    public static final byte NAWS = 31;
    public static final byte TERMINAL_SPEED = 32;
    public static final byte TOGGLE_FLOW_CONTROL = 33;
    public static final byte LINEMODE = 34;
    public static final byte ENVIRON = 36;

    protected TelnetProtocol() {
        byte[] byArray = new byte[3];
        byArray[0] = -1;
        this.SEND_OPT = byArray;
        this.SB_NAWS = new byte[]{-2, -2, -2, -2, -1, -16};
        this._telnetSocket = null;
        this._writer = null;
        this._stringBuffer = new StringBuffer();
    }

    public TelnetProtocol(TelnetSocket ts) {
        byte[] byArray = new byte[3];
        byArray[0] = -1;
        this.SEND_OPT = byArray;
        this.SB_NAWS = new byte[]{-2, -2, -2, -2, -1, -16};
        this._telnetSocket = null;
        this._writer = null;
        this._stringBuffer = new StringBuffer();
        this.setTelnetSocket(ts);
        if (!this.initialize()) {
            ts.notReady();
        }
    }

    private int available() throws IOException {
        return this.telnetSocket().input().available();
    }

    public void close() throws IOException {
        this.telnetSocket().close();
    }

    public String codeStr(int b) {
        int v = b & 0xFF;
        String s = null;
        switch (v) {
            case 1: {
                s = "ECHO";
                break;
            }
            case 3: {
                s = "TELOPT_SGA";
                break;
            }
            case 5: {
                s = "STATUS";
                break;
            }
            case 6: {
                s = "TIMING_MARK";
                break;
            }
            case 24: {
                s = "TERMINAL_TYPE";
                break;
            }
            case 31: {
                s = "NAWS";
                break;
            }
            case 32: {
                s = "TERMINAL_SPEED";
                break;
            }
            case 33: {
                s = "TOGGLE_FLOW_CONTROL";
                break;
            }
            case 34: {
                s = "LINEMODE";
                break;
            }
            case 36: {
                s = "ENVIRON";
                break;
            }
            case 239: {
                s = "EOR";
                break;
            }
            case 240: {
                s = "SE";
                break;
            }
            case 241: {
                s = "NOP";
                break;
            }
            case 242: {
                s = "DM";
                break;
            }
            case 243: {
                s = "BRK";
                break;
            }
            case 244: {
                s = "IP";
                break;
            }
            case 245: {
                s = "AO";
                break;
            }
            case 246: {
                s = "AYT";
                break;
            }
            case 247: {
                s = "EC";
                break;
            }
            case 248: {
                s = "EL";
                break;
            }
            case 249: {
                s = "GA";
                break;
            }
            case 250: {
                s = "SB";
                break;
            }
            case 251: {
                s = "WILL";
                break;
            }
            case 252: {
                s = "WONT";
                break;
            }
            case 253: {
                s = "DO";
                break;
            }
            case 254: {
                s = "DONT";
                break;
            }
            case 255: {
                s = "IAC";
                break;
            }
            default: {
                return Integer.toString(v);
            }
        }
        return String.valueOf(s) + "(" + v + ")";
    }

    protected void doOpt(byte opt) throws IOException {
        this.sendOpt((byte)-3, opt);
    }

    public void dontEcho() throws IOException {
        this.dontOpt((byte)1);
        this.parse();
    }

    protected void dontOpt(byte opt) throws IOException {
        this.sendOpt((byte)-2, opt);
    }

    protected void iacOpt(byte opt) throws IOException {
        byte[] SEND_IAC_OPT = new byte[]{-1, opt};
        this.writeBytes(SEND_IAC_OPT);
    }

    protected void iacSbOpt(byte opt) throws IOException {
        byte[] SEND_IAC_SB_OPT = new byte[]{-1, -6, opt};
        this.writeBytes(SEND_IAC_SB_OPT);
    }

    public synchronized boolean initialize() {
        try {
            this.willOpt((byte)31);
            if (!this.parse()) {
                return false;
            }
            this.doOpt((byte)3);
            if (!this.parse()) {
                return false;
            }
            this.willOpt((byte)3);
            if (!this.parse()) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean parse() throws IOException {
        is = this.telnetSocket().input();
        aByte = 0;
        command = 0;
        option = 0;
        if (this.available() == 0) {
            return true;
        }
        is.mark(1);
        aByte = is.read();
        if (aByte != -1) ** GOTO lbl62
        return false;
lbl-1000:
        // 1 sources

        {
            command = is.read();
            if (command == -1) {
                return false;
            }
            switch ((byte)command) {
                case -3: {
                    option = is.read();
                    if (option == -1) {
                        return false;
                    }
                    if (option == 3) {
                        this.willOpt((byte)option);
                        break;
                    }
                    if (option == 31) {
                        this.iacSbOpt((byte)31);
                        this.writeBytes(this.SB_NAWS);
                        break;
                    }
                    this.wontOpt((byte)option);
                    break;
                }
                case -2: {
                    option = is.read();
                    if (option == -1) {
                        return false;
                    }
                    this.wontOpt((byte)option);
                    break;
                }
                case -5: {
                    option = is.read();
                    if (option == -1) {
                        return false;
                    }
                    if (option == 1) {
                        this.dontOpt((byte)option);
                        break;
                    }
                    this.doOpt((byte)option);
                    break;
                }
                case -4: {
                    option = is.read();
                    if (option == -1) {
                        return false;
                    }
                    this.dontOpt((byte)option);
                    break;
                }
                case -12: {
                    return false;
                }
                case -1: {
                    is.reset();
                    return true;
                }
                default: {
                    return true;
                }
            }
            if (is.available() == 0) {
                return true;
            }
            is.mark(1);
            aByte = is.read();
            if (aByte != -1) continue;
            return false;
lbl62:
            // 2 sources

            ** while (aByte == 255)
        }
lbl63:
        // 1 sources

        is.reset();
        return true;
    }

    public byte readByte() throws IOException {
        this.parse();
        int anInt = this.telnetSocket().input().read();
        if (anInt == -1) {
            throw new IOException();
        }
        return (byte)anInt;
    }

    public synchronized String readText() throws IOException {
        this._stringBuffer.setLength(0);
        byte aByte = this.readByte();
        while (aByte != 10 && aByte != -1) {
            this._stringBuffer.append((char)aByte);
            if (this.available() == 0) {
                return this._stringBuffer.toString();
            }
            aByte = this.readByte();
        }
        if (aByte == -1) {
            return "";
        }
        this._stringBuffer.append("\r\n");
        return this._stringBuffer.toString();
    }

    protected void sendOpt(byte command, byte opt) throws IOException {
        this.SEND_OPT[1] = command;
        this.SEND_OPT[2] = opt;
        this.writeBytes(this.SEND_OPT);
    }

    protected void setTelnetSocket(TelnetSocket ts) {
        this._telnetSocket = ts;
    }

    protected TelnetSocket telnetSocket() {
        return this._telnetSocket;
    }

    protected void willOpt(byte opt) throws IOException {
        this.sendOpt((byte)-5, opt);
    }

    protected void wontOpt(byte opt) throws IOException {
        this.sendOpt((byte)-4, opt);
    }

    public void write(String s) throws IOException {
        this.writer().write(s, 0, s.length());
    }

    public void writeBytes(byte[] toWrite) throws IOException {
        this.telnetSocket().output().write(toWrite, 0, toWrite.length);
        this.telnetSocket().output().flush();
    }

    public void writeString(String s) throws IOException {
        this.writer().write(s, 0, s.length());
        this.writer().flush();
    }

    public BufferedWriter writer() {
        if (this._writer == null) {
            this._writer = new BufferedWriter(new OutputStreamWriter(this.telnetSocket().output()));
        }
        return this._writer;
    }
}

