/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class SortableVector
extends Vector {
    public static Vector getSortedHashtableStringKeys(Hashtable t) {
        SortableVector v = SortableVector.newStringSortableVector();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        v.sort();
        return v;
    }

    protected abstract boolean isLess(Object var1, Object var2);

    public static SortableVector newStringSortableVector() {
        return new SortableVector(){

            protected boolean isLess(Object o1, Object o2) {
                return ((String)o1).compareTo((String)o2) < 0;
            }
        };
    }

    private void quicksort(int left, int right) {
        if (left >= right) {
            return;
        }
        int middle = (left + right) / 2;
        Object tmp = this.elementAt(left);
        this.setElementAt(this.elementAt(middle), left);
        this.setElementAt(tmp, middle);
        int last = left;
        int i = left + 1;
        while (i <= right) {
            if (this.isLess(this.elementAt(i), this.elementAt(left))) {
                tmp = this.elementAt(++last);
                this.setElementAt(this.elementAt(i), last);
                this.setElementAt(tmp, i);
            }
            ++i;
        }
        tmp = this.elementAt(left);
        this.setElementAt(this.elementAt(last), left);
        this.setElementAt(tmp, last);
        this.quicksort(left, last - 1);
        this.quicksort(last + 1, right);
    }

    public void sort() {
        int s = this.size();
        if (s > 1) {
            this.quicksort(0, s - 1);
        }
    }
}

