/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.xms.cliparser;

import com.cisco.nm.xms.cliparser.BaseNode;
import com.cisco.nm.xms.cliparser.ChoiceNode;
import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdSet;
import com.cisco.nm.xms.cliparser.KeywordNode;
import com.cisco.nm.xms.cliparser.KeywordParamNode;
import com.cisco.nm.xms.cliparser.ModeNode;
import java.io.Serializable;
import java.util.Vector;

public class CmdTree
implements Serializable {
    static final long serialVersionUID = 1000L;
    public static final int SINGLE = 1;
    public static final int MULTIPLE = 2;
    public static int NEXTPRIORITY = 1;
    String _cmdName;
    Vector _nodes = new Vector();
    boolean _hasNoCmd = false;
    boolean _bModeCmd = false;
    boolean _removeCmd = false;
    boolean _addCmd = false;
    int _cmdType = 1;
    int _priority = NEXTPRIORITY++;
    boolean _bSeq = false;

    public void CmdTree() {
    }

    public void CmdTree(String cmd, boolean hasNoCmd) {
        this._cmdName = cmd;
        this._hasNoCmd = hasNoCmd;
    }

    public int getPriority() {
        return this._priority;
    }

    public int numNodes() {
        return this._nodes.size();
    }

    public boolean hasNoCmd() {
        return this._hasNoCmd;
    }

    void setRemoveCmd(boolean value) {
        this._removeCmd = value;
    }

    void setAddCmd(boolean value) {
        this._addCmd = value;
    }

    void setModeCmd(boolean value) {
        this._bModeCmd = value;
    }

    public boolean isModeCmd() {
        return this._bModeCmd;
    }

    void setSeq(boolean value) {
        this._bSeq = value;
    }

    public boolean hasSeq() {
        return this._bSeq;
    }

    boolean removeCmd() {
        return this._removeCmd;
    }

    boolean addCmd() {
        return this._addCmd;
    }

    void setCmdType(int type) {
        this._cmdType = type;
    }

    public int getCmdType() {
        return this._cmdType;
    }

    void setHasNoCmd(boolean value) {
        this._hasNoCmd = value;
    }

    public boolean isEmpty() {
        return this._nodes.size() == 0;
    }

    void setCmdName(String cmd) {
        this._cmdName = cmd;
    }

    public String getCmdName() {
        return this._cmdName;
    }

    boolean matchCmd(String cmd) {
        if (this._cmdName != null) {
            return cmd.equals(this._cmdName);
        }
        return false;
    }

    boolean matchCmdTree(CmdTree newCmdTree) {
        if (newCmdTree.numNodes() != this.numNodes()) {
            return false;
        }
        int i = 0;
        while (i < this.numNodes()) {
            if (!this.getNode(i).matchNode(newCmdTree.getNode(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void addNode(BaseNode node) {
        this._nodes.addElement(node);
    }

    public BaseNode getNode(int index) {
        if (index < this._nodes.size()) {
            return (BaseNode)this._nodes.elementAt(index);
        }
        return null;
    }

    void replaceNodes(CmdTree cmdTree) {
        this._nodes = cmdTree._nodes;
        this._hasNoCmd = cmdTree._hasNoCmd;
    }

    void replaceNodesWithModeNode(CmdTree cmdTree) throws CliGPBException {
        ModeNode saveModeNode = this.getModeNode();
        this._nodes = cmdTree._nodes;
        saveModeNode.update(cmdTree.getModeNode());
        int i = 0;
        while (i < this.numNodes()) {
            if (this.getNode(i) instanceof ModeNode) {
                this._nodes.setElementAt(saveModeNode, i);
                break;
            }
            ++i;
        }
        this._hasNoCmd = cmdTree._hasNoCmd;
    }

    public ModeNode getModeNode() {
        int i = 0;
        while (i < this.numNodes()) {
            if (this.getNode(i) instanceof ModeNode) {
                return (ModeNode)this.getNode(i);
            }
            ++i;
        }
        return null;
    }

    boolean isPartOfNoCmd() {
        int i = 0;
        while (i < this.numNodes()) {
            if (this.getNode(i).isPartOfNoCmd()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    KeywordParamNode getKeywordParamNode(String cmd, String key, boolean checkCmdName, boolean isSearchCaseSensitive) {
        if (this.numNodes() == 0) {
            return null;
        }
        if (checkCmdName && (isSearchCaseSensitive ? !cmd.equals(this._cmdName) : !cmd.toUpperCase().equals(this._cmdName.toUpperCase()))) {
            return null;
        }
        int i = 0;
        while (i < this.numNodes()) {
            BaseNode node = this.getNode(i);
            if (node instanceof KeywordNode) {
                boolean bOptional;
                KeywordNode keyNode = (KeywordNode)node;
                if (isSearchCaseSensitive) {
                    if (keyNode.getKey().equals(key)) {
                        bOptional = keyNode.isOptional();
                        KeywordParamNode result = new KeywordParamNode(keyNode.getKey(), -1, bOptional, "", new Vector(), -1, -1);
                        return result;
                    }
                } else if (keyNode.getKey().toUpperCase().equals(key.toUpperCase())) {
                    bOptional = keyNode.isOptional();
                    KeywordParamNode result = new KeywordParamNode(keyNode.getKey(), -1, bOptional, "", new Vector(), -1, -1);
                    return result;
                }
            } else if (node instanceof KeywordParamNode) {
                KeywordParamNode kpNode = (KeywordParamNode)node;
                if (isSearchCaseSensitive) {
                    if (kpNode.getKey().equals(key)) {
                        return kpNode;
                    }
                } else if (kpNode.getKey().toUpperCase().equals(key.toUpperCase())) {
                    return kpNode;
                }
            } else if (node instanceof ChoiceNode) {
                ChoiceNode choiceNode = (ChoiceNode)node;
                boolean opt = choiceNode.isOptional();
                int j = 0;
                while (j < choiceNode.numCmdTrees()) {
                    CmdTree ct = choiceNode.getCmdTree(j);
                    KeywordParamNode result = ct.getKeywordParamNode(ct.getCmdName(), key, false, isSearchCaseSensitive);
                    if (result != null) {
                        return result;
                    }
                    ++j;
                }
            } else if (node instanceof ModeNode) {
                ModeNode mnode = (ModeNode)node;
                int j = 0;
                while (j < mnode.numModes()) {
                    CmdSet cs = mnode.getCmdSet(j);
                    KeywordParamNode result = cs.getParamNode(cmd, key, false, isSearchCaseSensitive);
                    if (result != null) {
                        return result;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        String outStr = "";
        outStr = String.valueOf(outStr) + "(" + this._priority + ")" + String.valueOf(' ');
        if (this.hasNoCmd()) {
            outStr = String.valueOf(outStr) + String.valueOf('@') + "no" + String.valueOf(' ');
        }
        if (this._bSeq) {
            outStr = String.valueOf(outStr) + "SEQ" + String.valueOf(' ');
        }
        if (this._cmdName != null) {
            outStr = String.valueOf(outStr) + this._cmdName + String.valueOf(' ');
        }
        int i = 0;
        while (i < this._nodes.size()) {
            outStr = String.valueOf(outStr) + this._nodes.elementAt(i).toString() + String.valueOf(' ');
            ++i;
        }
        return outStr;
    }
}

