/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.xms.cliparser;

import com.cisco.nm.xms.cliparser.IosVersion;

public class GrammarEntry {
    IosVersion _iosVersion;
    String _deviceType;

    public GrammarEntry(String iosVersionStr, String deviceType) {
        String fixedVersion = iosVersionStr;
        int index = iosVersionStr.indexOf(",");
        if (index != -1) {
            fixedVersion = iosVersionStr.substring(0, index);
        }
        if (deviceType == null) {
            deviceType = "";
        }
        if (deviceType.startsWith("CISCO")) {
            deviceType = deviceType.substring(5);
        }
        if (deviceType.length() > 4) {
            deviceType = deviceType.substring(0, 4);
        }
        this._iosVersion = new IosVersion(fixedVersion);
        this._deviceType = deviceType;
    }

    String getKey() {
        return String.valueOf(this._iosVersion._versionStr) + "-" + this._deviceType;
    }

    String getVersionStr() {
        return this._iosVersion._versionStr;
    }

    String getDeviceType() {
        return this._deviceType;
    }

    int compareIosVersion(IosVersion iosVersion) {
        return this._iosVersion.compareTo(iosVersion);
    }
}

