/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.xms.cliparser;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdSet;
import com.cisco.nm.xms.cliparser.Debug;
import com.cisco.nm.xms.cliparser.GrammarEntry;
import com.cisco.nm.xms.cliparser.IosVersion;
import com.cisco.nm.xms.cliparser.MyProperties;
import com.cisco.nm.xms.cliparser.Util;
import gnu.regexp.RE;
import gnu.regexp.REException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class GrammarLocator {
    static MyProperties _versionMappings = null;

    public static CmdSet getCmdSet(String iosVersion, String deviceType) throws CliGPBException {
        Debug.log("com.cisco.nm.xms.cliparser.GrammarLocator", "Original: version=" + iosVersion + " device =" + deviceType, 4);
        if (_versionMappings == null) {
            try {
                String propFileName = "versionmapping.properties";
                _versionMappings = new MyProperties(propFileName);
            }
            catch (Exception e) {
                Debug.log("com.cisco.nm.xms.cliparser.GrammarLocator", "Cannot load IOS version mapping file.\nOriginal Exception :" + e, 4);
                throw new CliGPBException("Cannot load IOS version mapping file.\nOriginal Exception :" + e, e);
            }
        }
        return GrammarLocator.getCmdSet(iosVersion, deviceType, "", _versionMappings);
    }

    public static CmdSet getCmdSet(String iosVersion, String deviceType, String goPath) throws CliGPBException {
        Debug.log("com.cisco.nm.xms.cliparser.GrammarLocator", "Original: version=" + iosVersion + " device =" + deviceType, 1);
        try {
            String propFileName = String.valueOf(goPath) + "versionmapping.properties";
            Debug.log("com.cisco.nm.xms.cliparser.GrammarLocator", "propFileName:" + propFileName, 1);
            return GrammarLocator.getCmdSet(iosVersion, deviceType, goPath, new MyProperties(propFileName));
        }
        catch (CliGPBException clie) {
            throw clie;
        }
        catch (Exception e) {
            Debug.log("com.cisco.nm.xms.cliparser.GrammarLocator", "Cannot load IOS version mapping file.\nOriginal Exception :" + e, 4);
            throw new CliGPBException("Cannot load IOS version mapping file.\nOriginal Exception :" + e, e);
        }
    }

    public static CmdSet getCmdSet(String iosVersion, String deviceType, String goPath, InputStream propFileStream) throws CliGPBException {
        Debug.log("com.cisco.nm.xms.cliparser.GrammarLocator", "Original: version=" + iosVersion + " device =" + deviceType, 1);
        try {
            return GrammarLocator.getCmdSet(iosVersion, deviceType, goPath, new MyProperties(propFileStream));
        }
        catch (CliGPBException clie) {
            throw clie;
        }
        catch (Exception e) {
            Debug.log("com.cisco.nm.xms.cliparser.GrammarLocator", "Cannot load IOS version mapping file.\nOriginal Exception :" + e, 4);
            throw new CliGPBException("Cannot load IOS version mapping file.\nOriginal Exception :" + e, e);
        }
    }

    static CmdSet getCmdSet(String iosVersion, String deviceType, String goPath, MyProperties versionMappings) throws CliGPBException {
        Debug.log("com.cisco.nm.xms.cliparser.GrammarLocator", "Original: version=" + iosVersion + " device =" + deviceType, 1);
        GrammarEntry grammarEntry = new GrammarEntry(iosVersion, deviceType);
        try {
            String grammarObjectKey = GrammarLocator.findMatchingKey(grammarEntry, versionMappings);
            Debug.log("com.cisco.nm.xms.cliparser.GrammarLocator", "Grammar Object File=" + grammarObjectKey, 1);
            return GrammarLocator.getCmdSet(String.valueOf(goPath) + grammarObjectKey + "." + "ser");
        }
        catch (REException e) {
            throw new CliGPBException("Badly formatted device type in the version mapping file.\nOriginal Exception :" + e, e);
        }
    }

    public static CmdSet getCmdSet(String fileName) throws CliGPBException {
        try {
            return (CmdSet)Util.readStoredObject(fileName);
        }
        catch (Exception e) {
            throw new CliGPBException("Exception in reading grammar file " + fileName + "\nOriginal Exception :" + e, e);
        }
    }

    static String getMappedVersionEntry(GrammarEntry entry, MyProperties versionMappings) {
        Vector keys = versionMappings.keys();
        String minMax = versionMappings.nextElement();
        while (versionMappings.hasMoreElements()) {
            IosVersion iosVersion;
            String key = versionMappings.nextElement();
            if (key.indexOf("-") != -1 || entry.compareIosVersion(iosVersion = new IosVersion(key)) != 0) continue;
            return versionMappings.getProperty(key);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String findMatchingKey(GrammarEntry entry, MyProperties versionMappings) throws REException, CliGPBException {
        String mappedVersion;
        String value;
        block14: {
            String versionStr;
            block15: {
                String grammarObjectKey = entry.getKey();
                versionStr = entry.getVersionStr();
                value = GrammarLocator.matchCompleteEntry(versionStr, entry.getDeviceType(), versionMappings);
                if (value != null) {
                    return value;
                }
                mappedVersion = GrammarLocator.getMappedVersionEntry(entry, versionMappings);
                if (mappedVersion != null) break block15;
                Debug.log("com.cisco.nm.xms.cliparser.GrammarLocator", String.valueOf(versionStr) + " doesn't exist", 2);
                Vector keys = versionMappings.keys();
                String minmax = versionMappings.getProperty(versionMappings.nextElement());
                StringTokenizer st = new StringTokenizer(minmax, ",", true);
                String token = st.hasMoreTokens() ? st.nextToken() : null;
                String minVersionStr = null;
                String maxVersionStr = null;
                if (token != null) {
                    if (!token.equals(",")) {
                        minVersionStr = token.trim();
                        String string = token = st.hasMoreTokens() ? st.nextToken() : null;
                        if (token != null) {
                            token = st.hasMoreTokens() ? st.nextToken() : null;
                        }
                    } else {
                        String string = token = st.hasMoreTokens() ? st.nextToken() : null;
                    }
                    if (token != null) {
                        maxVersionStr = token.trim();
                    }
                }
                Debug.log("com.cisco.nm.xms.cliparser.GrammarLocator", "minVersionStr: " + minVersionStr + " maxVerStr: " + maxVersionStr, 1);
                IosVersion minVersion = null;
                if (minVersionStr != null) {
                    minVersion = new IosVersion(minVersionStr);
                }
                Debug.log("com.cisco.nm.xms.cliparser.GrammarLocator", "minVersion: " + minVersion, 1);
                IosVersion maxVersion = null;
                if (maxVersionStr != null) {
                    maxVersion = new IosVersion(maxVersionStr);
                }
                Debug.log("com.cisco.nm.xms.cliparser.GrammarLocator", "maxVersion: " + maxVersion, 1);
                IosVersion curVersion = new IosVersion(versionStr);
                Debug.log("com.cisco.nm.xms.cliparser.GrammarLocator", "curVersion: " + curVersion, 1);
                if (maxVersion != null && curVersion.compareTo(maxVersion) >= 0) {
                    mappedVersion = maxVersionStr;
                    break block14;
                } else if (minVersion != null && curVersion.compareTo(minVersion) >= 0) {
                    mappedVersion = minVersionStr;
                    break block14;
                } else {
                    Vector<String> v = new Vector<String>();
                    v.addElement(versionStr);
                    throw new CliGPBException(Util.createString("IOS version %s is not supported. Please contact Cisco TAC.", v));
                }
            }
            if (mappedVersion.indexOf(",") != -1) {
                mappedVersion = versionStr;
            }
        }
        Debug.log("com.cisco.nm.xms.cliparser.GrammarLocator", "new mapped version =" + mappedVersion, 1);
        value = GrammarLocator.matchCompleteEntry(mappedVersion, entry.getDeviceType(), versionMappings);
        if (value != null) {
            return value;
        }
        return mappedVersion;
    }

    static String matchCompleteEntry(String mappedVersion, String deviceType, MyProperties versionMappings) throws REException {
        Vector keys = versionMappings.keys();
        String matchedKey = null;
        int numWilds = 4;
        int curWilds = 0;
        while (versionMappings.hasMoreElements()) {
            String version;
            String key = versionMappings.nextElement();
            int index = key.indexOf("-");
            if (index == -1 || !(version = key.substring(0, index)).equals(mappedVersion) || key.charAt(index + 1) != deviceType.charAt(0)) continue;
            String deviceTypeStr = key.substring(index + 1);
            String deviceTypeStrFixed = deviceTypeStr.replace('x', '.');
            index = deviceTypeStr.indexOf(120);
            curWilds = index == -1 ? 0 : 4 - index;
            RE regExp = new RE(deviceTypeStrFixed);
            if (!regExp.isMatch(deviceType) || curWilds >= numWilds) continue;
            matchedKey = key;
            numWilds = curWilds;
        }
        return matchedKey;
    }
}

