/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.xms.cliparser;

import com.cisco.nm.xms.cliparser.BaseNode;
import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdSet;
import com.cisco.nm.xms.cliparser.Debug;
import com.cisco.nm.xms.cliparser.ParamNode;
import java.util.Vector;

public class ModeNode
extends ParamNode {
    static final long serialVersionUID = 1000L;
    Vector _cmdSets = new Vector();
    Vector _modes = new Vector();
    public static final String DUMMY_MODE = "dummy";

    public ModeNode(int type) {
        this(type, null);
    }

    public ModeNode(int type, String key) {
        super(type, key);
    }

    public boolean isDummy() {
        return this._modes.indexOf(DUMMY_MODE) >= 0;
    }

    public boolean hasCommonCommands() {
        return this._modes.indexOf("common") >= 0;
    }

    public int numModes() {
        return this._modes.size();
    }

    public CmdSet getCmdSet(int index) {
        return (CmdSet)this._cmdSets.elementAt(index);
    }

    boolean matchNode(BaseNode node) {
        return node instanceof ModeNode && super.matchNode(node);
    }

    public void addMode(String mode) {
        this._modes.addElement(mode);
        this._cmdSets.addElement("");
    }

    public boolean addCmdSet(String mode, CmdSet cmdSet) {
        int index = this._modes.indexOf(mode);
        if (index >= 0) {
            this._cmdSets.setElementAt(cmdSet, index);
            return true;
        }
        return false;
    }

    public CmdSet getCmdSet(String mode) {
        int numModes = this._modes.size();
        int i = 0;
        while (i < numModes) {
            if (mode.startsWith((String)this._modes.elementAt(i))) {
                CmdSet cset = (CmdSet)this._cmdSets.elementAt(i);
                cset._priority = i;
                return cset;
            }
            ++i;
        }
        return null;
    }

    public CmdSet getFullCmdSet(String mode) {
        CmdSet cmdSet;
        CmdSet modeCmdSet = new CmdSet();
        if (this.hasCommonCommands()) {
            modeCmdSet = this.getCmdSet("common");
        }
        if ((cmdSet = this.getCmdSet(mode)) != null) {
            modeCmdSet._priority = cmdSet._priority;
            return modeCmdSet.append(cmdSet);
        }
        return null;
    }

    public void update(ModeNode node) throws CliGPBException {
        int i = 0;
        while (i < node._modes.size()) {
            String mode = (String)node._modes.elementAt(i);
            CmdSet cmdSet = this.getCmdSet(mode);
            CmdSet newCmdSet = null;
            if (!(node._cmdSets.elementAt(i) instanceof String)) {
                newCmdSet = (CmdSet)node._cmdSets.elementAt(i);
                if (cmdSet == null) {
                    this.addCmdSet(mode, newCmdSet);
                } else {
                    cmdSet.update(newCmdSet);
                }
            }
            ++i;
        }
    }

    public void print(int nestedLevel) {
        int j;
        int i = 0;
        while (i < this._cmdSets.size()) {
            StringBuffer strBuf = new StringBuffer();
            j = 0;
            while (j < nestedLevel) {
                strBuf.append(String.valueOf(' '));
                ++j;
            }
            strBuf.append('#');
            strBuf.append((String)this._modes.elementAt(i));
            Debug.log(this, strBuf.toString(), 2);
            ((CmdSet)this._cmdSets.elementAt(i)).print(nestedLevel);
            ++i;
        }
        StringBuffer strBuf2 = new StringBuffer();
        j = 0;
        while (j < nestedLevel) {
            strBuf2.append(String.valueOf(' '));
            ++j;
        }
        strBuf2.append('%');
        Debug.log(this, strBuf2.toString(), 2);
    }

    public String toString() {
        String retStr = "";
        retStr = String.valueOf(retStr) + String.valueOf('(');
        retStr = String.valueOf(retStr) + super.toString();
        int i = 0;
        while (i < this._modes.size()) {
            if (i > 0) {
                retStr = String.valueOf(retStr) + String.valueOf('|') + String.valueOf(' ');
            }
            retStr = String.valueOf(retStr) + (String)this._modes.elementAt(i);
            ++i;
        }
        retStr = String.valueOf(retStr) + String.valueOf('>');
        retStr = String.valueOf(retStr) + String.valueOf(')');
        return retStr;
    }
}

