/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.xms.cliparser;

import com.cisco.nm.xms.cliparser.Debug;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

class MyProperties {
    String _line;
    int _curIndex = -1;
    BufferedReader _fileReader;
    Vector _keys = new Vector();
    Vector _values = new Vector();

    public MyProperties(String fileName) throws Exception {
        Debug.log(this, "MyProperties - prop file name = " + fileName, 1);
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream(fileName);
            if (is == null) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            is = new FileInputStream(fileName);
            if (is == null) {
                throw new Exception("File Input Stream returned null");
            }
        }
        try {
            this.readPropertiesFile(is);
        }
        catch (Exception e3) {
            is.close();
            throw e3;
        }
        is.close();
    }

    public MyProperties(InputStream is) throws Exception {
        this.readPropertiesFile(is);
    }

    private void readPropertiesFile(InputStream is) throws Exception {
        try {
            this._fileReader = new BufferedReader(new InputStreamReader(is));
            while (this.readNextLine()) {
                int index = this._line.indexOf("=");
                String key = this._line.substring(0, index);
                String value = this._line.substring(index + 1);
                Debug.log(this, "key=" + key + " value=" + value, 1);
                this._keys.addElement(key.trim());
                this._values.addElement(value.trim());
            }
            this._fileReader.close();
        }
        catch (Exception exception) {
            this._fileReader.close();
            throw new Exception("MyProperties couldn't read versionmapping.properties.");
        }
    }

    public boolean hasMoreElements() {
        return this._curIndex < this._keys.size();
    }

    public String getProperty(String key) {
        int index = this._keys.indexOf(key);
        if (index == -1) {
            return null;
        }
        return (String)this._values.elementAt(index);
    }

    public Vector keys() {
        this._curIndex = 0;
        return this._keys;
    }

    public String nextElement() {
        return (String)this._keys.elementAt(this._curIndex++);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean readNextLine() {
        try {
            block2: while (true) {
                this._line = this._fileReader.readLine();
                if (this._line == null) {
                    Debug.log(this, "**** DONE *****", 1);
                    return false;
                }
                int length = this._line.length();
                int i = 0;
                while (true) {
                    if (i >= length || this._line.charAt(i) != ' ') {
                        if (i < length) break;
                        Debug.log(this, "--- blank line.", 1);
                        continue block2;
                    }
                    ++i;
                }
                if (this._line.charAt(i) != ';') break;
            }
            Debug.log(this, this._line, 1);
            return true;
        }
        catch (IOException e) {
            Debug.log(this, "Error in reading file: " + e, 4);
            return false;
        }
    }
}

