/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.updateengine;

import com.cisco.updateengine.ConfigEngine;
import com.cisco.updateengine.JDiscoverUtil;
import com.cisco.updateengine.JLog;
import com.cisco.updateengine.JMiscUtil;
import com.cisco.updateengine.JUpdateCommandBase;
import com.cisco.xdm.io.Base64;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

public class DiscoverHTTPS
extends JUpdateCommandBase {
    public static int _http_status = 0;
    public static int _https_status = 0;
    public static int _http_port = 80;
    public static boolean _https_supported = false;
    int _https_port = 443;
    private static boolean _https_blocked = false;

    public DiscoverHTTPS() {
    }

    public DiscoverHTTPS(IOSCmdService p0) {
        super(p0);
        this._output = new StringBuffer();
    }

    public void checkHTTPSBlocked() {
        boolean bHTTPSEnabled_AdHoc;
        block6: {
            JLog.debug("Inside DiscoverHTTPS::checkHTTPSBlocked");
            bHTTPSEnabled_AdHoc = false;
            if (!DiscoverHTTPS.isHTTPSEnabled()) {
                ConfigEngine.enableHTTPS(true);
                bHTTPSEnabled_AdHoc = true;
            }
            boolean bConnectionRefused = false;
            URL url = null;
            URLConnection urlC = null;
            try {
                String urlString = "https://" + this._cmdSvc.getIPAddress();
                if (this._https_port != 443) {
                    urlString = String.valueOf(urlString) + ":" + Integer.toString(this._https_port);
                }
                url = new URL(urlString);
                urlC = url.openConnection();
                urlC.setDoOutput(true);
                urlC.setDoInput(true);
                urlC.setUseCaches(false);
                urlC.setRequestProperty("Authorization", "Basic " + Base64.encode(String.valueOf(JMiscUtil.getUpdateEngine().get_username()) + ":" + JMiscUtil.getUpdateEngine().get_password()));
                InputStream is = urlC.getInputStream();
                if (is == null) {
                    bConnectionRefused = true;
                }
            }
            catch (Exception e) {
                _https_blocked = true;
                e.printStackTrace();
                String error = e.getMessage();
                JLog.error(error);
                JLog.printStackTrace(e);
                if (e.toString().indexOf("SSLHandshakeException") == -1) break block6;
                _https_blocked = false;
            }
        }
        if (bHTTPSEnabled_AdHoc) {
            ConfigEngine.enableHTTPS(false);
        }
        JLog.debug(_https_blocked ? "HTTPS is BLOCKED" : "HTTPS is not blocked");
    }

    public boolean executeCommand() {
        JLog.debug("Inside DiscoverHTTPS::executeCommand");
        String[] showCLIs = new String[]{"show running-config | include ip http"};
        String[] execCLI = new String[]{"ip http ?"};
        try {
            IOSCmdResponse[] replies = this._cmdSvc.config(execCLI);
            if (JDiscoverUtil.isOKResponse(replies[0]) && JDiscoverUtil.getOptionSupportedOnCmd(replies[0], "secure-server")) {
                _https_supported = true;
                JLog.debug("HTTPS is supported");
            } else {
                JLog.debug("HTTPS is not supported");
            }
            replies = this._cmdSvc.exec(showCLIs);
            if (JDiscoverUtil.isOKResponse(replies[0])) {
                this.parseResponse(replies[0].getOutput());
            }
        }
        catch (Exception e) {
            JLog.error(e);
            JLog.error("Exception");
            JLog.printStackTrace(e);
            e.printStackTrace();
        }
        this.checkHTTPSBlocked();
        this.writeStatus();
        return true;
    }

    public static int getHTTPPort() {
        return _http_port;
    }

    public static boolean isHTTPEnabled() {
        return _http_status == 1;
    }

    public static boolean isHTTPSEnabled() {
        return _https_status == 1;
    }

    public static boolean isHTTPSSupported() {
        return _https_supported;
    }

    public static boolean is_https_blocked() {
        return _https_blocked;
    }

    public void parseResponse(String response) {
        JLog.debug("Inside DiscoverHTTPS::parseResponse");
        JLog.debug("Response is -" + response);
        StringReader strReader = new StringReader(response);
        try {
            LineNumberReader lineReader = new LineNumberReader(strReader);
            String line = lineReader.readLine();
            while (line != null) {
                String port;
                if ((line = line.trim().toLowerCase()).equals("ip http server")) {
                    _http_status = 1;
                } else if (line.equals("ip http secure-server")) {
                    _https_status = 1;
                } else if (line.indexOf("ip http port") != -1) {
                    port = line.substring(line.indexOf("port") + 5);
                    _http_port = Integer.parseInt(port);
                } else if (line.indexOf("ip http secure-port") != -1) {
                    port = line.substring(line.indexOf("port") + 5);
                    this._https_port = Integer.parseInt(port);
                }
                line = lineReader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JLog.printStackTrace(e);
        }
    }

    public void populate(Vector param) {
    }

    public void writeStatus() {
        StringBuffer sb = new StringBuffer();
        if (_https_supported && !_https_blocked) {
            sb.append("https:").append(Integer.toString(this._https_port));
            if (_http_status != 0) {
                sb.append(", http:").append(Integer.toString(_http_port));
            }
        } else {
            sb.append("http:").append(Integer.toString(_http_port));
        }
        this._output.append("[Protocols]\n");
        this._output.append("Protocols=").append(sb.toString());
    }
}

