/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.updateengine;

import com.cisco.updateengine.BackupCmd;
import com.cisco.updateengine.JCmdCopyApplication;
import com.cisco.updateengine.JCmdCopyFile;
import com.cisco.updateengine.JCmdExit;
import com.cisco.updateengine.JLog;
import com.cisco.updateengine.JUpdateCommandBase;
import com.cisco.updateengine.UnInstallCmd;
import java.util.StringTokenizer;
import java.util.Vector;

public class JCommandFactory {
    private JCommandFactory() {
    }

    public static JUpdateCommandBase createCommand(int cmdID, Vector param) {
        JUpdateCommandBase cmd = null;
        switch (cmdID) {
            case 102: {
                cmd = new JCmdCopyFile();
                break;
            }
            case 0: {
                cmd = new JCmdExit();
                break;
            }
            case 103: {
                cmd = new JCmdCopyApplication();
                break;
            }
            case 104: {
                cmd = new UnInstallCmd();
                break;
            }
            case 105: {
                cmd = new BackupCmd();
                break;
            }
        }
        if (cmd != null) {
            cmd.populate(param);
            cmd.setcommandID(cmdID);
        }
        return cmd;
    }

    public static JUpdateCommandBase createCommand(String rawCmd) {
        if ((rawCmd = rawCmd.trim()).length() == 0) {
            return null;
        }
        JLog.debug("Command Received \n" + rawCmd);
        int nCmdID = -1;
        Vector<String> param = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(rawCmd, "\n");
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            if (line == null || line.trim().length() == 0) continue;
            if (line.indexOf("Command") != -1 && line.indexOf("=") != -1) {
                try {
                    String strCmd = line.substring(line.indexOf("=") + 1, line.length());
                    nCmdID = Integer.parseInt(strCmd.trim());
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    JLog.printStackTrace(e);
                }
                continue;
            }
            param.addElement(line);
        }
        return JCommandFactory.createCommand(nCmdID, param);
    }
}

