/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.updateengine;

import com.cisco.updateengine.ConfigEngine;
import com.cisco.updateengine.DiscoverHTTPS;
import com.cisco.updateengine.JFlashInfo;
import com.cisco.updateengine.JLog;
import com.cisco.updateengine.JMiscUtil;
import com.cisco.updateengine.JPackage;
import com.cisco.updateengine.JSDMUpdateAPIWrapper;
import com.cisco.xdm.data.discovery.XDMDiscovery;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class JDiscoverFlash {
    public static final String CSDPackage = "csd";
    public static final String SVCPackage = "svc";

    public static String discover(IOSCmdService cmdsvc) {
        Enumeration enumeration;
        JSDMUpdateAPIWrapper api = JMiscUtil.getUpdateEngine().getAPIWrapper();
        Vector vFlashInfo = api.getFlashInfo();
        boolean bDefaultFS = api.is_defaultFileSystemPresent();
        StringBuffer sbDrives = new StringBuffer();
        StringBuffer sbFlashInfo = new StringBuffer();
        JFlashInfo defFlashInfo = null;
        String defFileSysName = JSDMUpdateAPIWrapper.getSDMLocationOnFlash();
        int i = 0;
        while (i < vFlashInfo.size()) {
            JFlashInfo info = (JFlashInfo)vFlashInfo.elementAt(i);
            if (sbDrives.length() != 0) {
                sbDrives.append(",");
            }
            sbDrives.append(info.get_name());
            if (defFileSysName != null && defFileSysName.equals(info.get_name())) {
                defFlashInfo = info;
            }
            if (!bDefaultFS) {
                sbFlashInfo.append("\n[").append(info.get_name()).append("]\n");
            }
            sbFlashInfo.append("TotalMemory =").append(Long.toString(info.gettotalFlash())).append("\n");
            sbFlashInfo.append("AvailableMemory =").append(Long.toString(info.getavailFlash())).append("\n");
            sbFlashInfo.append("Drive =").append(sbDrives.toString());
            ++i;
        }
        StringBuffer sb = new StringBuffer("[Memory]");
        if (!bDefaultFS || JSDMUpdateAPIWrapper.getRouterModel().indexOf(55) == 0 && defFlashInfo != null && defFlashInfo.getavailFlash() / 1024L / 1024L < 5L) {
            sb.append("\nDefaultFileSys = NO");
            sb.append("\nDrives=").append(sbDrives.toString());
        }
        sb.append("\n");
        sb.append(sbFlashInfo.toString());
        Hashtable apps = JMiscUtil.getUpdateEngine().getAppsOnCD();
        JPackage japp = (JPackage)apps.get("IPS");
        Vector sdffiles = japp.getSDFFiles();
        if (sdffiles != null && sdffiles.size() != 0) {
            sb.append("\nIPSsdfFile = ").append((String)sdffiles.elementAt(0)).append("\n");
        }
        boolean bHTTPEnabled_AdHoc = false;
        if (!DiscoverHTTPS.isHTTPEnabled()) {
            ConfigEngine.enableHTTP(true);
            bHTTPEnabled_AdHoc = true;
        }
        Hashtable installedApps = JMiscUtil.getUpdateEngine().getAPIWrapper().getAppInfo(cmdsvc);
        if (bHTTPEnabled_AdHoc) {
            ConfigEngine.enableHTTP(false);
        }
        if ((enumeration = installedApps.elements()) != null && enumeration.hasMoreElements()) {
            sb.append("\n[Applications]").append("\n");
            while (enumeration.hasMoreElements()) {
                JPackage appinfo = (JPackage)enumeration.nextElement();
                if (appinfo == null) continue;
                sb.append(appinfo.get_name()).append(" = ");
                sb.append(appinfo.get_version());
                sb.append("\n");
            }
            if (JDiscoverFlash.discoverWebVPNImage()) {
                sb.append(JDiscoverFlash.writeWebVPNDetails());
            }
        } else if (JDiscoverFlash.discoverWebVPNImage()) {
            sb.append("\n[Applications]").append("\n");
            sb.append(JDiscoverFlash.writeWebVPNDetails()).append("\n");
        }
        if (installedApps.size() != 0) {
            JPackage app = (JPackage)installedApps.get("SDM");
            if (app == null) {
                app = (JPackage)installedApps.get("ES");
            }
            if (app == null) {
                app = (JPackage)installedApps.get("IPS");
            }
            if (app == null) {
                app = (JPackage)installedApps.get("WLAN");
            }
            if (app != null) {
                sb.append("\nLanguage = ").append(app.get_language()).append("\n");
            }
        }
        if (installedApps.get("IPS") == null && JMiscUtil.getUpdateEngine().getAPIWrapper().isOldIPSInstalled()) {
            sb.append("IPS=OLD \n");
        }
        return sb.toString();
    }

    public static boolean discoverWebVPNImage() {
        IOSCmdService cmdsvc = JMiscUtil.getUpdateEngine().getCmdsvc();
        StringBuffer sb = new StringBuffer();
        String[] cli = new String[]{"show webvpn ?"};
        IOSCmdResponse[] replies = null;
        try {
            replies = cmdsvc.exec(cli);
            if (XDMDiscovery.getOptionSupportedOnCmd(replies[0], "context")) {
                return true;
            }
        }
        catch (Exception ex) {
            JLog.printStackTrace(ex);
            ex.printStackTrace();
        }
        return false;
    }

    public static Hashtable getFileNameSizeFromRouter(String filePattern) {
        IOSCmdService comm = JMiscUtil.getUpdateEngine().getCmdsvc();
        JSDMUpdateAPIWrapper api = JMiscUtil.getUpdateEngine().getAPIWrapper();
        String location = JSDMUpdateAPIWrapper.getAppLocationOnRouter(comm, null);
        Hashtable nameSizeTable = null;
        nameSizeTable = JSDMUpdateAPIWrapper.getFileSizePairFromRouter();
        Hashtable<String, String> CSDSVCTable = new Hashtable<String, String>();
        Enumeration e = nameSizeTable.elements();
        int test = nameSizeTable.size();
        Enumeration keys = nameSizeTable.keys();
        while (keys.hasMoreElements()) {
            String fileName = (String)keys.nextElement();
            String fileSize = (String)nameSizeTable.get(fileName);
            if (!fileName.startsWith(filePattern)) continue;
            CSDSVCTable.put(fileName, fileSize);
        }
        return CSDSVCTable;
    }

    public static String getInstalledVersionFromRouter(String packageName) {
        IOSCmdService comm = JMiscUtil.getUpdateEngine().getCmdsvc();
        String version = null;
        String fileNameonRouter = "";
        String[] whatInstalledCmd = new String[]{"show webvpn install status " + packageName};
        try {
            IOSCmdResponse[] result = comm.exec(whatInstalledCmd);
            if (result == null || result.length < 0) {
                return null;
            }
            StringReader str_reader = new StringReader(result[0].getOutput().trim());
            LineNumberReader line_reader = new LineNumberReader(str_reader);
            String firstLine = line_reader.readLine();
            if (firstLine.startsWith("No")) {
                return null;
            }
            fileNameonRouter = line_reader.readLine();
            version = line_reader.readLine();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JLog.printStackTrace(ex);
        }
        return version;
    }

    public static String getVersionFromFileName(String fileName) {
        String version = null;
        int i = 0;
        StringTokenizer stVersionTokenizer = new StringTokenizer(fileName.substring(0, fileName.indexOf(".pkg")), "-");
        String[] tokenArray = new String[stVersionTokenizer.countTokens()];
        while (stVersionTokenizer.hasMoreTokens()) {
            tokenArray[i++] = stVersionTokenizer.nextToken();
        }
        version = tokenArray[2];
        return version;
    }

    public static StringBuffer writeWebVPNDetails() {
        String fileName;
        StringBuffer sb = new StringBuffer();
        String CSDInstalledVersion = null;
        CSDInstalledVersion = JDiscoverFlash.getInstalledVersionFromRouter(CSDPackage);
        if (CSDInstalledVersion != null) {
            CSDInstalledVersion = CSDInstalledVersion.replaceAll(",", ".");
            sb.append("CSD-Installed = " + CSDInstalledVersion);
            sb.append("\n");
        }
        String SVCInstalledVersion = null;
        SVCInstalledVersion = JDiscoverFlash.getInstalledVersionFromRouter(SVCPackage);
        if (SVCInstalledVersion != null) {
            SVCInstalledVersion = SVCInstalledVersion.replaceAll(",", ".");
            sb.append("SVC-Installed = " + SVCInstalledVersion);
            sb.append("\n");
        }
        if (CSDInstalledVersion == null) {
            Hashtable CSDTable = new Hashtable();
            CSDTable = JDiscoverFlash.getFileNameSizeFromRouter("securedesktop");
            if (CSDTable.size() > 0) {
                Enumeration keys = CSDTable.keys();
                fileName = null;
                String CSDVersion = null;
                String CSDfileSize = null;
                long totalCSD = 0L;
                StringBuffer CSDVersionList = new StringBuffer();
                boolean i = false;
                while (keys.hasMoreElements()) {
                    fileName = (String)keys.nextElement();
                    CSDfileSize = (String)CSDTable.get(fileName);
                    if (CSDfileSize != null) {
                        totalCSD += Long.parseLong(CSDfileSize);
                    }
                    CSDVersion = JDiscoverFlash.getVersionFromFileName(fileName);
                    if (CSDTable.size() > 1) {
                        CSDVersionList.append(CSDVersion).append(",");
                        continue;
                    }
                    CSDVersionList.append(CSDVersion);
                }
                String CSDFinalVersion = CSDVersionList.toString();
                if (CSDFinalVersion.endsWith(",")) {
                    int endComma = CSDFinalVersion.lastIndexOf(",");
                    CSDFinalVersion = CSDFinalVersion.substring(0, endComma);
                }
                sb.append("CSD-Flash = " + CSDFinalVersion);
                sb.append("\n");
                sb.append("CSD-FileSizeonFlash = ").append(totalCSD);
                sb.append("\n");
            }
        }
        if (SVCInstalledVersion == null) {
            Hashtable SVCTable = null;
            SVCTable = JDiscoverFlash.getFileNameSizeFromRouter("sslclient");
            if (SVCTable.size() > 0) {
                Enumeration enumName1 = SVCTable.keys();
                fileName = null;
                String SVCVersion = null;
                String SVCVersionList = null;
                String SVCfileSize = null;
                long totalSVC = 0L;
                while (enumName1.hasMoreElements()) {
                    fileName = (String)enumName1.nextElement();
                    SVCfileSize = (String)SVCTable.get(fileName);
                    if (SVCfileSize != null) {
                        totalSVC += Long.parseLong(SVCfileSize);
                    }
                    SVCVersion = JDiscoverFlash.getVersionFromFileName(fileName);
                    SVCVersionList = SVCTable.size() > 1 ? String.valueOf(SVCVersion) + "," : SVCVersion;
                }
                String SVCFinalVersion = SVCVersionList.toString();
                if (SVCFinalVersion.endsWith(",")) {
                    SVCFinalVersion = SVCFinalVersion.substring(0, SVCFinalVersion.lastIndexOf(","));
                }
                sb.append("SVC-Flash = " + SVCFinalVersion);
                sb.append("\n");
                sb.append("SVC-FileSizeonFlash = ").append(totalSVC);
            }
            sb.append("\n");
        }
        return sb;
    }
}

