/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.updateengine;

import com.cisco.updateengine.JDiscoverUtil;
import com.cisco.updateengine.JLog;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import java.util.StringTokenizer;

public class JDiscoverIDS {
    private static boolean _idsSupported = false;

    public static String discover(IOSCmdService cmdsvc) {
        String[] execCLIs = new String[]{"show subsys name ips", "show ip sdee ?"};
        boolean idsCorrectVer = false;
        boolean bSDee = false;
        try {
            IOSCmdResponse[] execReplies = cmdsvc.exec(execCLIs);
            if (JDiscoverUtil.isOKResponse(execReplies[0])) {
                String idsVersion = "";
                StringTokenizer st = new StringTokenizer(execReplies[0].getOutput(), " ");
                while (st.hasMoreElements()) {
                    String token = st.nextToken();
                    if (!token.equalsIgnoreCase("protocol") || !st.hasMoreElements()) continue;
                    idsVersion = st.nextToken();
                    break;
                }
                if (idsVersion != null && idsVersion.startsWith("2")) {
                    idsCorrectVer = true;
                }
            }
            bSDee = JDiscoverUtil.isOKResponse(execReplies[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
            JLog.printStackTrace(e);
        }
        StringBuffer sb = new StringBuffer("IPS=");
        sb.append(idsCorrectVer && bSDee ? "0" : "1");
        _idsSupported = idsCorrectVer && bSDee;
        return sb.toString();
    }

    public static boolean isIDSSupported() {
        return _idsSupported;
    }
}

