/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.updateengine;

import com.cisco.updateengine.JLog;
import com.cisco.updateengine.JMiscUtil;
import com.cisco.xdm.data.discovery.XDMDiscovery;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import com.cisco.xdm.parser.ShowCmdParser;
import com.cisco.xdm.parser.VersionInfo;
import java.io.IOException;
import java.io.StringBufferInputStream;

public class JDiscoverMisc {
    public static boolean isWebVPNImage = false;

    public static String discover(IOSCmdService cmdsvc) {
        StringBuffer sb = new StringBuffer();
        sb.append(JDiscoverMisc.discoverModel(cmdsvc));
        return sb.toString();
    }

    public static String discoverModel(IOSCmdService cmdsvc) {
        VersionInfo info = null;
        String strVersion = "Unknown";
        try {
            String[] cmd = new String[]{"show version"};
            IOSCmdResponse[] reply = cmdsvc.exec(cmd);
            info = ShowCmdParser.parseShowVersion(new StringBufferInputStream(reply[0].getOutput()));
        }
        catch (Exception e) {
            JLog.printStackTrace(e);
        }
        if (info != null) {
            strVersion = info._hardware;
            JMiscUtil.set_IOSVersion(info._iosVersion);
        }
        JMiscUtil.set_model(strVersion);
        try {
            if (XDMDiscovery.getHWConfig(cmdsvc, strVersion) == null) {
                JMiscUtil.getUpdateEngine().unsupportedRouter();
            }
        }
        catch (IOException e) {
            JLog.printStackTrace(e);
            e.printStackTrace();
        }
        return "Model=" + strVersion;
    }

    public static String discoverWebVPNImage(IOSCmdService cmdsvc) {
        StringBuffer sb = new StringBuffer();
        String[] cli = new String[]{"show webvpn ?"};
        IOSCmdResponse[] replies = null;
        try {
            replies = cmdsvc.exec(cli);
            if (XDMDiscovery.getOptionSupportedOnCmd(replies[0], "context")) {
                sb.append("isWebVPNImage=").append("0");
                isWebVPNImage = true;
                return sb.toString();
            }
        }
        catch (Exception ex) {
            JLog.printStackTrace(ex);
            ex.printStackTrace();
        }
        sb.append("isWebVPNImage=").append("1");
        return sb.toString();
    }
}

