/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.updateengine;

import com.cisco.updateengine.ConfigEngine;
import com.cisco.updateengine.DiscoverHTTPS;
import com.cisco.updateengine.FileCopyListener;
import com.cisco.updateengine.JFlashInfo;
import com.cisco.updateengine.JLog;
import com.cisco.updateengine.JMiscUtil;
import com.cisco.updateengine.JPackage;
import com.cisco.updateengine.LegacyAppCollection;
import com.cisco.updateengine.LegacyApplication;
import com.cisco.updateengine.RcpUtility;
import com.cisco.updateengine.VersionTextParser;
import com.cisco.xdm.io.Base64;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceException;
import com.cisco.xdm.net.cmdsvc.PAIIOSCmdService;
import com.cisco.xdm.net.cmdsvc.PromptHandlerIf;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;

public class JSDMUpdateAPIWrapper {
    private String _backupDir;
    private boolean _nBackup;
    public static int _instanceCounter = 0;
    private static String _localAddr = null;
    private static RcpUtility _rcpUtil;
    private static String _SDMLocation;
    private boolean _squeezeRequired;
    private boolean _filesLimitExceeded;
    private long _totalBytes;
    private boolean _defaultFileSystemPresent = true;
    private long _availableBytes;
    private static String _appLocation;
    public static final String VERSION_FILE = "version.txt";
    public static final int FILES_LIMIT_EXCEEDED = 0;
    public static final int UPDATE_WITHOUT_SQUEEZE = 1;
    public static final int UPDATE_WITH_SQUEEZE = 2;

    private JSDMUpdateAPIWrapper() {
    }

    public static boolean backupSDMFilesFromRouter(IOSCmdService comm, String folder, Vector filesVect, String userName, String passWord) {
        String routerResource = null;
        String routerUrl = null;
        String location = null;
        String filesOnRouter = null;
        String port = "";
        location = JSDMUpdateAPIWrapper.getAppLocationOnRouter(comm, null);
        port = JSDMUpdateAPIWrapper.getHttpPortFromRouter(comm);
        if (port == null) {
            return false;
        }
        if (port.length() > 0) {
            port = ":" + port;
        }
        routerUrl = "http://" + comm.getIPAddress() + port + "/" + location;
        filesOnRouter = JSDMUpdateAPIWrapper.getFilesOnRouter(comm, location);
        int i = 0;
        while (i < filesVect.size()) {
            String strFile = (String)filesVect.elementAt(i);
            if (filesOnRouter.indexOf(strFile) != -1 && !JSDMUpdateAPIWrapper.downloadFileFromHttpServer(routerResource = String.valueOf(routerUrl) + "/" + strFile, folder, null, userName, passWord)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean checkIfFilePresentOnRouter(IOSCmdService comm, String fileName, String fileSize) {
        IOSCmdResponse[] resp = null;
        String location = null;
        String response = null;
        StringTokenizer stz = null;
        StringTokenizer lineSTz = null;
        String lineStr = null;
        Vector<String> vectTokens = new Vector<String>();
        try {
            location = JSDMUpdateAPIWrapper.getAppLocationOnRouter(comm, fileName);
            resp = comm.exec(new String[]{"dir " + location + ":"});
            response = resp[0].getOutput();
            if (response != null && response.trim().length() > 0) {
                stz = new StringTokenizer(response.trim(), "\n");
                while (stz.hasMoreTokens()) {
                    lineStr = stz.nextToken();
                    if (lineStr.indexOf(fileName) == -1) continue;
                    lineSTz = new StringTokenizer(lineStr);
                    while (lineSTz.hasMoreTokens()) {
                        vectTokens.addElement(lineSTz.nextToken());
                    }
                    break block2;
                }
                if (vectTokens.size() >= 3 && ((String)vectTokens.elementAt(2)).equals(fileSize)) {
                    return true;
                }
            }
        }
        catch (IOSCmdServiceException icse) {
            JLog.printStackTrace(icse);
            icse.printStackTrace();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkRCPEnabled(IOSCmdService comm) {
        sock = null;
        try {
            try {
                this.enableRCP(comm);
                sock = RcpUtility.createSocket(comm.getIPAddress(), 514, JSDMUpdateAPIWrapper._localAddr);
                var3_3 = true;
                var5_5 = null;
            }
            catch (Exception e) {
                JLog.printStackTrace(e);
                e.printStackTrace();
                var3_4 = false;
                var5_6 = null;
                try {
                    if (sock != null) {
                        sock.close();
                    }
                    if (JSDMUpdateAPIWrapper._rcpUtil == null) return var3_4;
                    this.disableRCP();
                    return var3_4;
                }
                catch (IOException ioe) {
                    JLog.printStackTrace(ioe);
                    ioe.printStackTrace();
                    return var3_4;
                }
                catch (Exception me) {
                    JLog.printStackTrace(me);
                    me.printStackTrace();
                }
                return var3_4;
            }
        }
        catch (Throwable var4_15) {
            var5_7 = null;
            ** try [egrp 2[TRYBLOCK] [2, 3 : 60->82)] { 
lbl36:
            // 1 sources

            if (sock != null) {
                sock.close();
            }
            if (JSDMUpdateAPIWrapper._rcpUtil == null) throw var4_15;
            this.disableRCP();
            throw var4_15;
lbl42:
            // 1 sources

            catch (IOException ioe) {
                JLog.printStackTrace(ioe);
                ioe.printStackTrace();
                throw var4_15;
            }
lbl46:
            // 1 sources

            catch (Exception me) {
                JLog.printStackTrace(me);
                me.printStackTrace();
                throw var4_15;
            }
        }
        ** try [egrp 2[TRYBLOCK] [2, 3 : 60->82)] { 
lbl52:
        // 1 sources

        if (sock != null) {
            sock.close();
        }
        if (JSDMUpdateAPIWrapper._rcpUtil == null) return var3_3;
        this.disableRCP();
        return var3_3;
lbl58:
        // 1 sources

        catch (IOException ioe) {
            JLog.printStackTrace(ioe);
            ioe.printStackTrace();
            return var3_3;
        }
lbl62:
        // 1 sources

        catch (Exception me) {
            JLog.printStackTrace(me);
            me.printStackTrace();
        }
        return var3_3;
    }

    public static int compareSDMVersion(String runningSDM, String selectedSDM) throws Exception {
        int checkVal = 0;
        int i = 0;
        int shorterLen = 0;
        StringTokenizer stVersionTokenizer = new StringTokenizer(runningSDM, ".");
        String[] strRunnArray = new String[stVersionTokenizer.countTokens()];
        while (stVersionTokenizer.hasMoreTokens()) {
            strRunnArray[i++] = stVersionTokenizer.nextToken();
        }
        i = 0;
        stVersionTokenizer = new StringTokenizer(selectedSDM, ".");
        String[] strSelectedArray = new String[stVersionTokenizer.countTokens()];
        while (stVersionTokenizer.hasMoreTokens()) {
            strSelectedArray[i++] = stVersionTokenizer.nextToken();
        }
        shorterLen = strRunnArray.length < strSelectedArray.length ? strRunnArray.length : strSelectedArray.length;
        i = 0;
        while (i < shorterLen) {
            char[] cSelectedArray;
            char[] cRunnArray = strRunnArray[i].toCharArray();
            int shorterLen2 = cRunnArray.length < (cSelectedArray = strSelectedArray[i].toCharArray()).length ? cRunnArray.length : cSelectedArray.length;
            int j = 0;
            while (j < shorterLen2) {
                if (cRunnArray[j] > cSelectedArray[j]) {
                    checkVal = -1;
                    i = 1000;
                    break;
                }
                if (cRunnArray[j] < cSelectedArray[j]) {
                    checkVal = 1;
                    i = 1000;
                    break;
                }
                ++j;
            }
            if (checkVal == 0) {
                if (cRunnArray.length > cSelectedArray.length) {
                    if (Character.isDigit(cRunnArray[cSelectedArray.length])) {
                        checkVal = -1;
                        break;
                    }
                    if (strRunnArray.length > strSelectedArray.length) {
                        checkVal = 0;
                    }
                } else if (cRunnArray.length < cSelectedArray.length) {
                    if (Character.isDigit(cSelectedArray[cRunnArray.length])) {
                        checkVal = 1;
                        break;
                    }
                    if (strRunnArray.length < strSelectedArray.length) {
                        checkVal = 0;
                    }
                }
            }
            ++i;
        }
        if (checkVal == 0) {
            if (strRunnArray.length > strSelectedArray.length) {
                checkVal = -1;
            } else if (strRunnArray.length < strSelectedArray.length) {
                checkVal = 1;
            } else if (strRunnArray.length == strSelectedArray.length) {
                String strRunnLastToken = strRunnArray[strRunnArray.length - 1];
                String strSelectedLastToken = strSelectedArray[strSelectedArray.length - 1];
                if (strRunnLastToken.length() > strSelectedLastToken.length()) {
                    checkVal = -1;
                } else if (strRunnLastToken.length() < strSelectedLastToken.length()) {
                    checkVal = 1;
                }
            }
        }
        JLog.debug("checkVal = " + checkVal);
        return checkVal;
    }

    public boolean copyFiles(String location, Vector files) {
        IOSCmdService comm = JMiscUtil.getUpdateEngine().getCmdsvc();
        this.enableRCP(comm);
        Object[] obj = new Object[files.size()];
        files.copyInto(obj);
        boolean filesCopied = _rcpUtil.copyFileToRouter(obj, null, location);
        this.disableRCP();
        return filesCopied;
    }

    public static boolean deleteFileFromRouter(IOSCmdService comm, String sdmLocation, String fileName) {
        try {
            if (comm instanceof PAIIOSCmdService) {
                comm.exec(new String[]{"delete /force " + sdmLocation + ":" + fileName});
            } else {
                comm.exec(new String[]{"delete /force " + sdmLocation + ":" + fileName}, new PromptHandlerIf(){

                    public String handle(String[] devOutput) {
                        if (devOutput[devOutput.length - 1].toLowerCase().indexOf("delete filename") > -1) {
                            return "\r\n";
                        }
                        return null;
                    }
                });
            }
        }
        catch (IOSCmdServiceException icse) {
            JLog.printStackTrace(icse);
            return false;
        }
        return true;
    }

    public boolean disableRCP() {
        if (_rcpUtil != null) {
            try {
                try {
                    _rcpUtil.disableRcp();
                }
                catch (Exception e) {
                    JLog.printStackTrace(e);
                    e.printStackTrace();
                    boolean bl = false;
                    Object var3_3 = null;
                    _rcpUtil = null;
                    return bl;
                }
                Object var3_4 = null;
                _rcpUtil = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                _rcpUtil = null;
                throw throwable;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean downloadFileFromHttpServer(String fileURL, String destDir, FileCopyListener fcl, String userName, String passWord) {
        block51: {
            block50: {
                block49: {
                    url = null;
                    urlC = null;
                    iFileTransferType = false;
                    iFileSize = 0;
                    lLastModified = 0L;
                    st = null;
                    mimeType = "";
                    strFileSizeDenom = "";
                    strDestFileName = "";
                    userPassword = "";
                    encoding = "";
                    subDir = null;
                    fileDest = null;
                    is = null;
                    bis = null;
                    fos = null;
                    cis = null;
                    cos = null;
                    inChecksum = new CRC32();
                    outChecksum = new CRC32();
                    strHttpVersionLine = "";
                    try {
                        try {
                            url = new URL(fileURL);
                            urlC = url.openConnection();
                            urlC.setDoOutput(true);
                            urlC.setDoInput(true);
                            urlC.setUseCaches(false);
                            if (userName != null && passWord != null) {
                                userPassword = String.valueOf(userName) + ":" + passWord;
                                encoding = Base64.encode(userPassword);
                            }
                            if (encoding.length() > 0) {
                                urlC.setRequestProperty("Authorization", "Basic " + encoding);
                            }
                            is = urlC.getInputStream();
                            JLog.debug("About to get Header Values from HTTP response");
                            i = 0;
                            while (true) {
                                headerName = urlC.getHeaderFieldKey(i);
                                headerValue = urlC.getHeaderField(i);
                                JLog.debug(String.valueOf(headerName) + " = " + headerValue);
                                if (headerName == null && headerValue == null) break;
                                if (headerValue != null && headerName == null) {
                                    strHttpVersionLine = headerValue;
                                    JLog.debug("strHttpVersionLine = " + strHttpVersionLine);
                                    if (strHttpVersionLine.indexOf("200") == -1) {
                                        var27_36 = false;
                                        var29_40 = null;
                                        break block49;
                                    }
                                }
                                ++i;
                            }
                            iFileSize = urlC.getContentLength();
                            JLog.debug("Content-Length = " + iFileSize);
                            bis = new BufferedInputStream(is);
                            strDestFileName = fileURL.substring(fileURL.lastIndexOf("/") + 1);
                            nf = NumberFormat.getInstance();
                            nf.setMaximumFractionDigits(2);
                            if (iFileSize <= 0) {
                                strFileSizeDenom = "";
                            } else if (iFileSize > 0 && iFileSize < 1024) {
                                strFileSizeDenom = String.valueOf(iFileSize) + " byte(s)";
                            } else if (iFileSize >= 1024 && iFileSize < 0x100000) {
                                strFileSizeDenom = String.valueOf(nf.format((double)iFileSize / 1024.0)) + " KB";
                            } else if (iFileSize >= 0x100000 && iFileSize < 0x40000000) {
                                strFileSizeDenom = String.valueOf(nf.format((double)iFileSize / 1048576.0)) + " MB";
                            }
                            subDir = new File(destDir);
                            JLog.debug("About to create SDM_New subdiretcory");
                            if (!subDir.exists()) {
                                subDir.mkdir();
                            }
                            fileDest = new File(subDir, strDestFileName);
                            JLog.debug("SDM_New subdiretcory created");
                            fos = new FileOutputStream(fileDest);
                            cis = new CheckedInputStream(bis, inChecksum);
                            cos = new CheckedOutputStream(fos, outChecksum);
                            c = 0;
                            count = 0;
                            percent = 0;
                            if (fcl != null) {
                                if (iFileSize < 0) {
                                    fcl.activateProgressBar(20, strDestFileName, "<some message on the amount of file transferred>");
                                } else {
                                    fcl.activateProgressBar(percent, strDestFileName, "<some message on the amount of file transferred>");
                                }
                            }
                            JLog.debug("About to copy bytes from URL resource");
                            byteBuff = new byte[8192];
                            while (true) {
                                if ((c = cis.read(byteBuff, 0, byteBuff.length)) == -1) {
                                    if (iFileSize < 0 && fcl != null) {
                                        fcl.activateProgressBar(100, strDestFileName, "<some message on the amount of file transferred>");
                                    }
                                    JLog.debug("Going to return boolean value from downloadFileFromHttpServer()");
                                    if (inChecksum.getValue() == outChecksum.getValue()) break;
                                    var27_37 = false;
                                    break block50;
                                }
                                cos.write(byteBuff, 0, c);
                                count += c;
                                if (iFileSize <= 0 || fcl == null) continue;
                                percent = 100 * count / iFileSize;
                                if (count % 81920 != 0 && percent != 100) continue;
                                fcl.activateProgressBar(percent, strDestFileName, "<some message on the amount of file transferred>");
                            }
                            var27_38 = true;
                            break block51;
                        }
                        catch (Exception e) {
                            JLog.printStackTrace(e);
                            JLog.error("Error in downloadFileFromHttpServer() : " + e);
                            var27_39 = false;
                            var29_43 = null;
                            try {
                                if (bis != null) {
                                    bis.close();
                                }
                                if (fos != null) {
                                    fos.close();
                                }
                                if (cis != null) {
                                    cis.close();
                                }
                                if (cos != null) {
                                    cos.close();
                                }
                                if (is == null) return var27_39;
                                is.close();
                                return var27_39;
                            }
                            catch (IOException ie) {
                                JLog.printStackTrace(ie);
                                ie.printStackTrace();
                            }
                            return var27_39;
                        }
                    }
                    catch (Throwable var28_48) {
                        var29_44 = null;
                        try {}
                        catch (IOException ie) {
                            JLog.printStackTrace(ie);
                            ie.printStackTrace();
                            throw var28_48;
                        }
                        if (bis != null) {
                            bis.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                        if (cis != null) {
                            cis.close();
                        }
                        if (cos != null) {
                            cos.close();
                        }
                        if (is == null) throw var28_48;
                        is.close();
                        throw var28_48;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [2 : 859->912)] { 
lbl151:
                // 1 sources

                if (bis != null) {
                    bis.close();
                }
                if (fos != null) {
                    fos.close();
                }
                if (cis != null) {
                    cis.close();
                }
                if (cos != null) {
                    cos.close();
                }
                if (is == null) return var27_36;
                is.close();
                return var27_36;
lbl162:
                // 1 sources

                catch (IOException ie) {
                    JLog.printStackTrace(ie);
                    ie.printStackTrace();
                }
                return var27_36;
            }
            var29_41 = null;
            ** try [egrp 2[TRYBLOCK] [2 : 859->912)] { 
lbl169:
            // 1 sources

            if (bis != null) {
                bis.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (cis != null) {
                cis.close();
            }
            if (cos != null) {
                cos.close();
            }
            if (is == null) return var27_37;
            is.close();
            return var27_37;
lbl180:
            // 1 sources

            catch (IOException ie) {
                JLog.printStackTrace(ie);
                ie.printStackTrace();
            }
            return var27_37;
        }
        var29_42 = null;
        ** try [egrp 2[TRYBLOCK] [2 : 859->912)] { 
lbl187:
        // 1 sources

        if (bis != null) {
            bis.close();
        }
        if (fos != null) {
            fos.close();
        }
        if (cis != null) {
            cis.close();
        }
        if (cos != null) {
            cos.close();
        }
        if (is == null) return var27_38;
        is.close();
        return var27_38;
lbl198:
        // 1 sources

        catch (IOException ie) {
            JLog.printStackTrace(ie);
            ie.printStackTrace();
        }
        return var27_38;
    }

    public boolean enableRCP(IOSCmdService comm) {
        if (_rcpUtil == null) {
            try {
                _rcpUtil = new RcpUtility();
                _rcpUtil.enableRcp(comm, JSDMUpdateAPIWrapper.getClientAddrOnRouter(comm));
            }
            catch (Exception e) {
                JLog.printStackTrace(e);
                e.printStackTrace();
                _rcpUtil = null;
                return false;
            }
        }
        return true;
    }

    public Hashtable getAppInfo(IOSCmdService comm) {
        JPackage pkg;
        Enumeration enumeration;
        Hashtable<String, JPackage> installedApps = new Hashtable<String, JPackage>();
        Hashtable packages = JMiscUtil.getUpdateEngine().getAppsOnCD();
        if (packages != null) {
            enumeration = packages.elements();
            while (enumeration.hasMoreElements()) {
                JPackage app;
                pkg = (JPackage)enumeration.nextElement();
                String strVersion = this.getVersionFileFromRouter(comm, pkg.get_masterFile());
                if (strVersion == null || strVersion.trim().length() == 0 || (app = new VersionTextParser(strVersion).get_package()) == null) continue;
                app.set_name(pkg.get_name());
                installedApps.put(pkg.get_name(), app);
            }
        }
        if (packages != null) {
            enumeration = packages.elements();
            while (enumeration.hasMoreElements()) {
                JPackage app;
                pkg = (JPackage)enumeration.nextElement();
                if (installedApps.get(pkg.get_name()) != null || (app = this.getInstalledAppInfo(pkg.get_name(), comm)) == null) continue;
                installedApps.put(pkg.get_name(), app);
            }
        }
        JMiscUtil.getUpdateEngine().set_installedApps(installedApps);
        return installedApps;
    }

    public static String getAppLocationOnRouter(IOSCmdService comm, String appFileName) {
        if (_appLocation != null && _appLocation.length() > 0) {
            return _appLocation;
        }
        String sdmFsName = null;
        String[] cmd = new String[]{"dir all-filesystems"};
        String[] cmd2 = new String[]{"pwd"};
        IOSCmdResponse[] resp = null;
        try {
            if (appFileName == null) {
                resp = comm.exec(cmd2);
                sdmFsName = resp[0].getOutput().trim();
            } else {
                resp = comm.exec(cmd);
                String dirStr = resp[0].getOutput();
                int index = dirStr.indexOf("Directory of");
                String searchStr = dirStr.substring(index);
                String fsName = searchStr.substring(13, searchStr.indexOf(":"));
                int sdmIndex = dirStr.indexOf(appFileName);
                JLog.debug("sdmIndex = " + sdmIndex);
                while (index != -1) {
                    int nextIndex = dirStr.indexOf("Directory of", index + 14);
                    if (sdmIndex > index && (sdmIndex < nextIndex || nextIndex == -1)) {
                        sdmFsName = fsName;
                    }
                    JLog.debug("found sdmFsName = " + sdmFsName);
                    index = nextIndex;
                    if (index < 0) break;
                    searchStr = dirStr.substring(index);
                    fsName = searchStr.substring(13, searchStr.indexOf(":"));
                }
            }
            JLog.debug("sdmFsName before validation = " + sdmFsName);
            if (sdmFsName != null && sdmFsName.indexOf(":") != -1) {
                sdmFsName = sdmFsName.substring(0, sdmFsName.indexOf(":"));
            }
            if (sdmFsName != null && !JSDMUpdateAPIWrapper.getValidFileSystems(comm).contains(sdmFsName) && (sdmFsName = (resp = comm.exec(cmd2))[0].getOutput().trim()) != null && sdmFsName.indexOf(":") != -1) {
                sdmFsName = sdmFsName.substring(0, sdmFsName.indexOf(":"));
            }
            JLog.debug("final sdmFsName = " + sdmFsName);
        }
        catch (IOSCmdServiceException icse) {
            JLog.printStackTrace(icse);
            icse.printStackTrace();
        }
        if (sdmFsName != null && sdmFsName.toUpperCase().indexOf("USBFLASH") != -1) {
            sdmFsName = null;
        }
        _appLocation = sdmFsName;
        return _appLocation;
    }

    public long getAvailableBytes(IOSCmdService comm, String location) throws IOSCmdServiceException {
        this.setAvailableBytes(comm, location);
        return this._availableBytes;
    }

    public String getBackupDir() {
        return this._backupDir;
    }

    /*
     * WARNING - void declaration
     */
    public static String getClientAddrOnRouter(IOSCmdService comm) throws Exception {
        if (_localAddr == null) {
            int curTimeout = comm.getTimeout();
            try {
                int end;
                String key;
                String line = JSDMUpdateAPIWrapper.getCurrentLine(comm);
                JLog.debug("JSDMUpdateAPIWrapper.getClientAddrOnRouter(), returned from getCurrentLine(), line = " + line);
                String host = null;
                if (line == null) {
                    _localAddr = JSDMUpdateAPIWrapper.getClientAddrOnRouterByHTTP(comm);
                    return _localAddr;
                }
                JLog.debug("JSDMUpdateAPIWrapper.getClientAddrOnRouter(), returned from getClientAddrOnRouterByHTTP(), _localAddr = " + _localAddr);
                comm.setTimeout(60000);
                IOSCmdResponse[] shCallerReply = comm.exec(new String[]{"show caller line " + line + " full"});
                if (shCallerReply == null || shCallerReply.length == 0) {
                    throw new Exception("cannot get response from show caller");
                }
                JLog.debug("show caller -- " + shCallerReply[shCallerReply.length - 1].getOutput());
                StringTokenizer st = new StringTokenizer(shCallerReply[shCallerReply.length - 1].getOutput());
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!token.equalsIgnoreCase("remote")) continue;
                    if (!st.hasMoreTokens()) break;
                    host = st.nextToken();
                    break;
                }
                if (host == null) {
                    throw new Exception("cannot get host from show caller");
                }
                IOSCmdResponse[] pingReply = comm.exec(new String[]{"ping " + host});
                if (pingReply == null || pingReply.length == 0) {
                    throw new Exception("cannot get response from ping");
                }
                String output = pingReply[pingReply.length - 1].getOutput();
                int start = output.indexOf(key = "ICMP Echos to ");
                if (start > 0 && (end = output.indexOf(",", start)) > start) {
                    _localAddr = output.substring(start + key.length(), end);
                }
            }
            catch (Exception e) {
                void line;
                JLog.printStackTrace(e);
                comm.setTimeout(curTimeout);
                throw line;
            }
            comm.setTimeout(curTimeout);
        }
        return _localAddr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getClientAddrOnRouterByHTTP(IOSCmdService _comm) throws Exception {
        int i3;
        Object[] cmdRevertBack2;
        Throwable throwable2;
        boolean bHTTPEnabled_AdHoc;
        block32: {
            String m_strLocalAddr = new String();
            Vector<String> vectRevertBack = new Vector<String>(5, 1);
            bHTTPEnabled_AdHoc = false;
            JLog.debug("JSDMUpdateAPIWrapper.getClientAddrOnRouterByHTTP() called");
            try {
                try {
                    IOSCmdResponse[] resp_1;
                    String[] cmdEnableBuffer = new String[]{"logging buffered 52000 debugging"};
                    String[] cmdDebug = new String[]{"debug ip http url"};
                    String[] cmdShowLogg = new String[]{"show logging | include /level/15/exec/-/show/clock"};
                    String[] cmdCheckLogEnabled = new String[]{"show running-config | include logging buffered"};
                    String[] cmdCheckDebugHttp = new String[]{"show debugging | include HTTP Server URL"};
                    String[] cmdCheckNoLogginOn = new String[]{"show running-config | include no logging on"};
                    String[] cmdEnableLogginOn = new String[]{"logging on"};
                    String strLoggingBuffered = "logging buffered";
                    String strDebugging = "debugging";
                    String strHttpUrlDebug = "HTTP Server URL debugging is on";
                    String strPattern = "/level/15/exec/-/show/clock";
                    int iStartIndexOfPattern = 0;
                    int iBackOff_milliSecs = 2000;
                    IOSCmdResponse[] respTemp = null;
                    StringTokenizer sTokenizer = null;
                    String strExistingPatternLine = "";
                    String strNewPatternLine = "";
                    IOSCmdResponse[] resp_logOn = _comm.exec(cmdCheckNoLogginOn);
                    if (resp_logOn[0].getOutput().startsWith("no " + cmdEnableLogginOn[0])) {
                        JLog.debug("CLI starts with no logging on, resp_logOn[0].getOutput() = " + resp_logOn[0].getOutput());
                        _comm.config(cmdEnableLogginOn);
                        vectRevertBack.addElement("no " + cmdEnableLogginOn[0]);
                    }
                    if ((resp_1 = _comm.exec(cmdCheckLogEnabled))[0].getOutput().startsWith(strLoggingBuffered) && !resp_1[0].getOutput().endsWith(strDebugging)) {
                        JLog.debug("line starts with logging buffered and ends with debugging, resp_1[0].getOutput() = " + resp_1[0].getOutput());
                        _comm.config(cmdEnableBuffer);
                        vectRevertBack.addElement(resp_1[0].getOutput());
                    } else if (!resp_1[0].getOutput().startsWith(strLoggingBuffered)) {
                        JLog.debug("line does not start with logging buffered, resp_1[0].getOutput() = " + resp_1[0].getOutput());
                        _comm.config(cmdEnableBuffer);
                        vectRevertBack.addElement("no " + cmdEnableBuffer[0]);
                    }
                    IOSCmdResponse[] resp_2 = _comm.exec(cmdCheckDebugHttp);
                    if (!resp_2[0].getOutput().trim().startsWith(strHttpUrlDebug)) {
                        JLog.debug("HTTP url debugging was not on, resp_2[0].getOutput() = " + resp_2[0].getOutput());
                        _comm.exec(cmdDebug);
                        vectRevertBack.addElement("no " + cmdDebug[0]);
                    }
                    respTemp = _comm.exec(cmdShowLogg);
                    JLog.debug("First show logg output, respTemp[0].getOutput() = " + respTemp[0].getOutput());
                    if (respTemp[0].getOutput().length() > 0) {
                        sTokenizer = new StringTokenizer(respTemp[0].getOutput(), "\n");
                        while (sTokenizer.hasMoreTokens()) {
                            strExistingPatternLine = sTokenizer.nextToken().trim();
                        }
                    }
                    if (!DiscoverHTTPS.isHTTPEnabled()) {
                        ConfigEngine.enableHTTP(true);
                        bHTTPEnabled_AdHoc = true;
                    }
                    block7: while (true) {
                        if (iBackOff_milliSecs >= 10000 || m_strLocalAddr.length() != 0) {
                            if (m_strLocalAddr.length() != 0) break;
                            throw new Exception("Not able to get router's IP address through HTTP");
                        }
                        iStartIndexOfPattern = 0;
                        String urlString = "http://" + _comm.getIPAddress();
                        if (DiscoverHTTPS.getHTTPPort() != 80) {
                            urlString = String.valueOf(urlString) + ":" + Integer.toString(DiscoverHTTPS.getHTTPPort());
                        }
                        URL url = new URL(String.valueOf(urlString) + strPattern);
                        URLConnection urlC = url.openConnection();
                        urlC.setDoOutput(true);
                        urlC.setDoInput(true);
                        urlC.setUseCaches(false);
                        urlC.setRequestProperty("Authorization", "Basic " + Base64.encode(String.valueOf(JMiscUtil.getUpdateEngine().get_username()) + ":" + JMiscUtil.getUpdateEngine().get_password()));
                        InputStream is = urlC.getInputStream();
                        try {
                            Thread.sleep(iBackOff_milliSecs);
                        }
                        catch (InterruptedException ie) {
                            JLog.printStackTrace(ie);
                        }
                        IOSCmdResponse[] resp = null;
                        resp = _comm.exec(cmdShowLogg);
                        resp = _comm.exec(cmdShowLogg);
                        JLog.debug("##############################");
                        JLog.debug("Second show logg output ");
                        JLog.debug(resp[0].getOutput());
                        JLog.debug("##############################");
                        if (resp[0].getOutput().length() > 0) {
                            sTokenizer = new StringTokenizer(resp[0].getOutput(), "\n");
                            while (true) {
                                if (!sTokenizer.hasMoreTokens()) {
                                    JLog.debug("strExistingPatternLine = " + strExistingPatternLine);
                                    JLog.debug("strNewPatternLine = " + strNewPatternLine);
                                    if (!strNewPatternLine.equals(strExistingPatternLine)) break;
                                    m_strLocalAddr = "";
                                    continue block7;
                                }
                                strNewPatternLine = sTokenizer.nextToken().trim();
                            }
                        }
                        JLog.debug("resp[0].getOutput().lastIndexOf(strPattern) = " + resp[0].getOutput().lastIndexOf(strPattern));
                        iStartIndexOfPattern = resp[0].getOutput().lastIndexOf(strPattern);
                        JLog.debug("iStartIndexOfPattern = " + iStartIndexOfPattern);
                        if (iStartIndexOfPattern < 0) {
                            m_strLocalAddr = "";
                        } else {
                            int i2 = iStartIndexOfPattern - 1;
                            String strTemp = "";
                            while (true) {
                                if ((strTemp = resp[0].getOutput().substring(i2 - 1, i2)).equals(" ")) {
                                    JLog.debug("value of index i after traversing back by the IP address = " + i2);
                                    m_strLocalAddr = resp[0].getOutput().substring(i2, iStartIndexOfPattern).trim();
                                    break;
                                }
                                JLog.debug("strTemp = [" + strTemp + "]");
                                --i2;
                            }
                        }
                        JLog.debug("m_strLocalAddr = " + m_strLocalAddr);
                        iBackOff_milliSecs += 2000;
                    }
                }
                catch (Exception e) {
                    JLog.printStackTrace(e);
                    JLog.debug("Exception in JSDMUpdateAPIWrapper.getClientAddrOnRouterByHTTP() " + e);
                    throw e;
                }
                Object var5_37 = null;
            }
            catch (Throwable throwable2) {
                Object var5_38 = null;
                cmdRevertBack2 = new String[vectRevertBack.size()];
                vectRevertBack.copyInto(cmdRevertBack2);
                i3 = 0;
                break block32;
            }
            Object[] cmdRevertBack2 = new String[vectRevertBack.size()];
            vectRevertBack.copyInto(cmdRevertBack2);
            int i3 = 0;
            while (true) {
                if (i3 >= cmdRevertBack2.length) {
                    if (!bHTTPEnabled_AdHoc) return m_strLocalAddr;
                    ConfigEngine.enableHTTP(false);
                    return m_strLocalAddr;
                }
                String[] strCmdArr = new String[]{cmdRevertBack2[i3]};
                if (((String)cmdRevertBack2[i3]).indexOf("debug ") == -1) {
                    _comm.config(strCmdArr);
                } else {
                    _comm.exec(strCmdArr);
                }
                ++i3;
            }
        }
        while (true) {
            if (i3 >= cmdRevertBack2.length) {
                if (!bHTTPEnabled_AdHoc) throw throwable2;
                ConfigEngine.enableHTTP(false);
                throw throwable2;
            }
            String[] strCmdArr = new String[]{cmdRevertBack2[i3]};
            if (((String)cmdRevertBack2[i3]).indexOf("debug ") == -1) {
                _comm.config(strCmdArr);
            } else {
                _comm.exec(strCmdArr);
            }
            ++i3;
        }
    }

    private static String getCurrentLine(IOSCmdService comm) throws Exception {
        String line = null;
        JLog.debug("Retrieve client ip address on the router");
        String whoami = "show whoami\r\n";
        IOSCmdResponse[] reply = comm.exec(new String[]{whoami}, new PromptHandlerIf(){

            public String handle(String[] devOutput) {
                if (devOutput[devOutput.length - 1].trim().toLowerCase().indexOf("more--") > -1) {
                    return "\r\n";
                }
                return null;
            }
        });
        if (reply == null || reply.length == 0) {
            throw new Exception("cannot get response from show whoami");
        }
        JLog.debug("show whoami -- " + reply[reply.length - 1].getOutput());
        StringTokenizer st = new StringTokenizer(reply[reply.length - 1].getOutput());
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.equalsIgnoreCase("Line")) continue;
            if (!st.hasMoreTokens()) break;
            line = st.nextToken();
            break;
        }
        JLog.debug("JSDMUpdateAPIWrapper.getCurrentLine(), line = " + line);
        return line;
    }

    public static Hashtable getFileSizePairFromRouter() {
        String location = JSDMUpdateAPIWrapper.getSDMLocationOnFlash();
        IOSCmdService comm = JMiscUtil.getUpdateEngine().getCmdsvc();
        IOSCmdResponse[] resp = null;
        Hashtable<String, String> hashT = null;
        StringTokenizer st = null;
        long headerSize = 64L;
        try {
            resp = comm.exec(new String[]{"dir " + location + ":"});
        }
        catch (IOSCmdServiceException icse) {
            icse.printStackTrace();
            JLog.printStackTrace(icse);
            return hashT;
        }
        hashT = new Hashtable<String, String>();
        st = new StringTokenizer(resp[0].getOutput(), "\n");
        while (st.hasMoreElements()) {
            Vector<String> vectOuputLine = new Vector<String>();
            String strLine = st.nextToken().trim();
            StringTokenizer stOutputLine = new StringTokenizer(strLine);
            while (stOutputLine.hasMoreTokens()) {
                vectOuputLine.addElement(stOutputLine.nextToken().trim());
            }
            if (vectOuputLine.size() <= 0) continue;
            try {
                Long.parseLong((String)vectOuputLine.elementAt(0));
                Long.parseLong((String)vectOuputLine.elementAt(2));
                String strLineFile = ((String)vectOuputLine.elementAt(vectOuputLine.size() - 1)).trim();
                if (strLineFile.startsWith("[") && strLineFile.endsWith("]")) continue;
                long fsWithHeader = JSDMUpdateAPIWrapper.getFileSpaceOnRouter(Long.parseLong((String)vectOuputLine.elementAt(2)));
                hashT.put(strLineFile, String.valueOf(fsWithHeader));
            }
            catch (Exception e) {
                JLog.printStackTrace(e);
            }
        }
        if (hashT.size() == 0) {
            hashT = null;
        }
        return hashT;
    }

    public static long getFileSpaceOnRouter(long fs) {
        long headerSize = 64L;
        long fsWithHeader = 0L;
        fsWithHeader = fs % 4L != 0L ? fs + headerSize + 4L - fs % 4L : fs + headerSize;
        return fsWithHeader;
    }

    public static String getFileSystemType(IOSCmdService comm, String fileSystem) {
        String fsType = null;
        try {
            String[] cmd = new String[]{"show " + fileSystem + ": all"};
            IOSCmdResponse[] resp = comm.exec(cmd);
            JLog.debug("Output of show " + fileSystem + ": all = " + resp[0].getOutput());
            fsType = resp[0].getOutput().toLowerCase().indexOf("geometry") != -1 && resp[0].getOutput().toLowerCase().indexOf("format") != -1 ? "DOS" : "LEFS";
        }
        catch (Exception icse) {
            JLog.printStackTrace(icse);
            JLog.debug("Exception occcured while determining type of file system" + icse);
            return null;
        }
        return fsType;
    }

    public static String getFilesOnRouter(IOSCmdService comm, String location) {
        IOSCmdResponse[] resp = null;
        try {
            resp = comm.exec(new String[]{"dir " + location + ":"});
        }
        catch (IOSCmdServiceException icse) {
            JLog.printStackTrace(icse);
            icse.printStackTrace();
        }
        return resp[0].getOutput();
    }

    public Vector getFlashInfo() {
        Vector vDisks;
        Vector<JFlashInfo> vDiskInfo = new Vector<JFlashInfo>();
        IOSCmdService comm = JMiscUtil.getUpdateEngine().getCmdsvc();
        String appLocation = JSDMUpdateAPIWrapper.getSDMLocationOnFlash();
        if (appLocation == null || appLocation.length() == 0) {
            appLocation = JSDMUpdateAPIWrapper.getAppLocationOnRouter(comm, null);
        }
        JLog.debug("JSDMUpdateAPIWrapper.getFlashInfo: appLocation = " + appLocation);
        String defFileSysName = JSDMUpdateAPIWrapper.getSDMLocationOnFlash();
        boolean isDefFileSysFull = false;
        try {
            isDefFileSysFull = JSDMUpdateAPIWrapper.getRouterModel().indexOf(55) == 0 && this.getAvailableBytes(comm, defFileSysName) / 1024L / 1024L < 5L;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!JSDMUpdateAPIWrapper.isFileSysPresent(comm, appLocation) || isDefFileSysFull) {
            JLog.debug("File system " + appLocation + " is absent");
            this._defaultFileSystemPresent = false;
            vDisks = JSDMUpdateAPIWrapper.getValidFileSystems(comm);
        } else {
            JLog.debug("File system " + appLocation + " is present");
            vDisks = new Vector();
            vDisks.addElement(appLocation);
        }
        if (vDisks == null) {
            JLog.error("Disks is NULL !!! EXCEPTION");
        }
        int i = 0;
        while (i < vDisks.size()) {
            JFlashInfo info = new JFlashInfo();
            try {
                String drive = (String)vDisks.elementAt(i);
                info.setavailFlash(this.getAvailableBytes(comm, drive));
                info.settotalFlash(this.getTotalBytes(comm, drive));
                info.set_name(drive);
                vDiskInfo.addElement(info);
            }
            catch (IOSCmdServiceException icse) {
                JLog.printStackTrace(icse);
                icse.printStackTrace();
            }
            ++i;
        }
        return vDiskInfo;
    }

    public URLConnection getHttpConnection(String urlStr, String userName, String passWord) throws IOException {
        String userPassword = "";
        String encoding = "";
        URL urlObj = new URL(urlStr);
        URLConnection urlC = urlObj.openConnection();
        urlC.setDoOutput(true);
        urlC.setDoInput(true);
        urlC.setUseCaches(false);
        if (userName != null && passWord != null) {
            userPassword = String.valueOf(userName) + ":" + passWord;
            encoding = Base64.encode(userPassword);
        }
        if (encoding.length() > 0) {
            urlC.setRequestProperty("Authorization", "Basic " + encoding);
        }
        return urlC;
    }

    public static String getHttpPortFromRouter(IOSCmdService comm) {
        String httpPort = "";
        String standardPort = "80";
        String[] cmd = new String[]{"show ip http server status"};
        IOSCmdResponse[] resp = null;
        StringTokenizer sTZ = null;
        try {
            resp = comm.exec(cmd);
            if (resp[0].getOutput().trim().length() == 0) {
                return null;
            }
            sTZ = new StringTokenizer(resp[0].getOutput().trim(), "\n");
            while (sTZ.hasMoreTokens()) {
                String lineStr = sTZ.nextToken();
                if (lineStr.indexOf("HTTP server port:") == -1) continue;
                httpPort = lineStr.substring(lineStr.indexOf(":") + 1).trim();
                if (httpPort.equals(standardPort)) {
                    httpPort = "";
                }
                break;
            }
        }
        catch (IOSCmdServiceException icse) {
            JLog.printStackTrace(icse);
            icse.printStackTrace();
            return null;
        }
        return httpPort.trim();
    }

    public String getIOSVersion() {
        return JMiscUtil.get_IOSVersion();
    }

    public JPackage getInstalledAppInfo(String app, IOSCmdService comm) {
        LegacyAppCollection appColl = JMiscUtil.getUpdateEngine().getLegacyAppCollection();
        LegacyApplication legApp = appColl.getLegacyApp(app);
        if (legApp != null) {
            Hashtable versions = legApp.get_versions();
            Enumeration enumeration = versions.elements();
            while (enumeration.hasMoreElements()) {
                int size;
                String tar_file;
                boolean bFound;
                JPackage appVersionInfo = (JPackage)enumeration.nextElement();
                if (appVersionInfo == null || !(bFound = JSDMUpdateAPIWrapper.checkIfFilePresentOnRouter(comm, tar_file = appVersionInfo.get_masterFile(), String.valueOf(size = appVersionInfo.get_masterFileSize())))) continue;
                JPackage info = new JPackage(appVersionInfo);
                return info;
            }
        }
        return null;
    }

    public static JSDMUpdateAPIWrapper getInstance() {
        if (_instanceCounter == 0) {
            ++_instanceCounter;
            return new JSDMUpdateAPIWrapper();
        }
        return null;
    }

    public Vector getNewHomeFiles() {
        return new Vector();
    }

    public static String getRouterModel() {
        return JMiscUtil.get_model();
    }

    public static String getSDMLocationOnFlash() {
        if (_SDMLocation != null) {
            return _SDMLocation;
        }
        String sdmLocation = null;
        IOSCmdService comm = JMiscUtil.getUpdateEngine().getCmdsvc();
        Hashtable appsOnCD = JMiscUtil.getUpdateEngine().getAppsOnCD();
        Enumeration e = appsOnCD.elements();
        while (e.hasMoreElements()) {
            JPackage jPack = (JPackage)e.nextElement();
            String masterFile = jPack.get_masterFile();
            sdmLocation = JSDMUpdateAPIWrapper.getAppLocationOnRouter(comm, masterFile);
            if (sdmLocation != null && sdmLocation.length() > 0) break;
        }
        if (sdmLocation == null) {
            sdmLocation = JSDMUpdateAPIWrapper.getAppLocationOnRouter(comm, null);
        }
        JSDMUpdateAPIWrapper.setSDMLocation(sdmLocation);
        return sdmLocation;
    }

    public long getTotalBytes(IOSCmdService comm, String location) throws IOSCmdServiceException {
        this.setTotalBytes(comm, location);
        return this._totalBytes;
    }

    public static long getTotalSizeOfDeletedFiles() {
        String location = JSDMUpdateAPIWrapper.getSDMLocationOnFlash();
        IOSCmdService comm = JMiscUtil.getUpdateEngine().getCmdsvc();
        long sizeOfDeletedFiles = 0L;
        IOSCmdResponse[] resp = null;
        StringTokenizer st = null;
        long headerSize = 64L;
        try {
            resp = comm.exec(new String[]{"dir /all " + location + ":"});
        }
        catch (IOSCmdServiceException icse) {
            JLog.printStackTrace(icse);
            icse.printStackTrace();
            return sizeOfDeletedFiles;
        }
        st = new StringTokenizer(resp[0].getOutput(), "\n");
        while (st.hasMoreElements()) {
            Vector<String> vectOuputLine = new Vector<String>();
            String strLine = st.nextToken().trim();
            StringTokenizer stOutputLine = new StringTokenizer(strLine);
            while (stOutputLine.hasMoreTokens()) {
                vectOuputLine.addElement(stOutputLine.nextToken().trim());
            }
            if (vectOuputLine.size() <= 0) continue;
            try {
                Long.parseLong((String)vectOuputLine.elementAt(0));
                Long.parseLong((String)vectOuputLine.elementAt(2));
                String strLineFile = ((String)vectOuputLine.elementAt(vectOuputLine.size() - 1)).trim();
                if (!strLineFile.startsWith("[") || !strLineFile.endsWith("]")) continue;
                long fsWithHeader = JSDMUpdateAPIWrapper.getFileSpaceOnRouter(Long.parseLong((String)vectOuputLine.elementAt(2)));
                sizeOfDeletedFiles += fsWithHeader;
            }
            catch (Exception e) {
                JLog.printStackTrace(e);
            }
        }
        return sizeOfDeletedFiles;
    }

    public static Vector getValidFileSystems(IOSCmdService comm) {
        IOSCmdResponse[] resp = null;
        Vector<String> fileSystems = new Vector<String>(5, 5);
        String[] cmd = new String[]{"show file systems"};
        String cmdOutput = null;
        StringTokenizer sTZ_1 = null;
        StringTokenizer sTZ_2 = null;
        try {
            resp = comm.exec(cmd);
            cmdOutput = resp[0].getOutput().trim();
            sTZ_1 = new StringTokenizer(cmdOutput, "\n");
            while (sTZ_1.hasMoreTokens()) {
                String strLine = sTZ_1.nextToken();
                sTZ_2 = new StringTokenizer(strLine);
                String[] strTokens = new String[sTZ_2.countTokens()];
                int i = 0;
                while (sTZ_2.hasMoreTokens()) {
                    strTokens[i++] = sTZ_2.nextToken();
                }
                String fileSize = "";
                String fileSysType = "";
                String fileSysName = "";
                if (strTokens.length < 5) continue;
                if (strTokens[0].equals("*")) {
                    fileSize = strTokens[1];
                    fileSysType = strTokens[3];
                    fileSysName = strTokens[5];
                } else {
                    fileSize = strTokens[0];
                    fileSysType = strTokens[2];
                    fileSysName = strTokens[4];
                }
                try {
                    Long.parseLong(fileSize);
                    if (fileSysName.indexOf(":") != -1) {
                        fileSysName = fileSysName.substring(0, fileSysName.indexOf(":"));
                    }
                    String cfileSysName = fileSysName.toUpperCase();
                    String cfileSysType = fileSysType.toUpperCase();
                    if (cfileSysType.indexOf("DISK") != -1) {
                        fileSystems.addElement(fileSysName);
                        continue;
                    }
                    if (cfileSysType.indexOf("FLASH") == -1 || cfileSysName.indexOf("BOOTFLASH") != -1 || cfileSysName.indexOf("WEBFLASH") != -1 || cfileSysName.indexOf("SLOT") != -1 && JSDMUpdateAPIWrapper.getRouterModel().startsWith("36")) continue;
                    fileSystems.addElement(fileSysName);
                }
                catch (NumberFormatException nfe) {
                    JLog.printStackTrace(nfe);
                }
            }
        }
        catch (Exception e) {
            JLog.printStackTrace(e);
            JLog.debug("JSDMUpdateAPIWrapper.getValidFileSystems(), exception = " + e);
            return null;
        }
        return fileSystems;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getVersionFileFromRouter(IOSCmdService comm, String tar_file) {
        block19: {
            block18: {
                block17: {
                    sb = new StringBuffer();
                    baseUrl = null;
                    location = null;
                    port = "";
                    tarName = "";
                    strRouterBaseUrl = "";
                    strResourceUrl = "";
                    user = JMiscUtil.getUpdateEngine().get_username();
                    pass = JMiscUtil.getUpdateEngine().get_password();
                    urlC = null;
                    is = null;
                    buffReader = null;
                    strLine = null;
                    byteBuff = null;
                    c = false;
                    tarExt = ".tar";
                    try {
                        try {
                            location = JSDMUpdateAPIWrapper.getAppLocationOnRouter(comm, null);
                            if (JSDMUpdateAPIWrapper.getFilesOnRouter(comm, location).indexOf(tar_file) == -1) {
                                var19_19 = null;
                                var21_22 = null;
                                break block17;
                            }
                            port = JSDMUpdateAPIWrapper.getHttpPortFromRouter(comm);
                            if (port == null) {
                                var19_20 = null;
                                break block18;
                            }
                            if (port.length() > 0) {
                                port = ":" + port;
                            }
                            strRouterBaseUrl = "http://" + comm.getIPAddress() + port;
                            if (tar_file.indexOf(tarExt) != -1) {
                                tarName = tar_file.substring(0, tar_file.indexOf(tarExt));
                            }
                            try {
                                strResourceUrl = String.valueOf(strRouterBaseUrl) + "/archive/" + location + ":" + tarName + "/" + tarName + "/" + "version.txt";
                                urlC = this.getHttpConnection(strResourceUrl, user, pass);
                                is = urlC.getInputStream();
                            }
                            catch (IOException temExcep) {
                                JLog.printStackTrace(temExcep);
                                strResourceUrl = String.valueOf(strRouterBaseUrl) + "/archive/" + location + ":" + tarName + "/" + "version.txt";
                                urlC = this.getHttpConnection(strResourceUrl, user, pass);
                                is = urlC.getInputStream();
                            }
                            buffReader = new BufferedReader(new InputStreamReader(is));
                            byteBuff = new byte[8192];
                            while ((strLine = buffReader.readLine()) != null) {
                                sb.append(String.valueOf(strLine) + "\n");
                            }
                            break block19;
                        }
                        catch (IOException ie) {
                            JLog.printStackTrace(ie);
                            var19_21 = null;
                            var21_24 = null;
                            try {
                                if (is == null) return var19_21;
                                is.close();
                                return var19_21;
                            }
                            catch (IOException ioe) {
                                JLog.printStackTrace(ioe);
                                ioe.printStackTrace();
                            }
                            return var19_21;
                        }
                    }
                    catch (Throwable var20_34) {
                        var21_26 = null;
                        ** try [egrp 3[TRYBLOCK] [3 : 447->460)] { 
lbl69:
                        // 1 sources

                        if (is == null) throw var20_34;
                        is.close();
                        throw var20_34;
lbl72:
                        // 1 sources

                        catch (IOException ioe) {
                            JLog.printStackTrace(ioe);
                            ioe.printStackTrace();
                        }
                        throw var20_34;
                    }
                }
                ** try [egrp 3[TRYBLOCK] [3 : 447->460)] { 
lbl78:
                // 1 sources

                if (is == null) return var19_19;
                is.close();
                return var19_19;
lbl81:
                // 1 sources

                catch (IOException ioe) {
                    JLog.printStackTrace(ioe);
                    ioe.printStackTrace();
                }
                return var19_19;
            }
            var21_23 = null;
            ** try [egrp 3[TRYBLOCK] [3 : 447->460)] { 
lbl88:
            // 1 sources

            if (is == null) return var19_20;
            is.close();
            return var19_20;
lbl91:
            // 1 sources

            catch (IOException ioe) {
                JLog.printStackTrace(ioe);
                ioe.printStackTrace();
            }
            return var19_20;
        }
        var21_25 = null;
        try {}
        catch (IOException ioe) {
            JLog.printStackTrace(ioe);
            ioe.printStackTrace();
            return sb.toString();
        }
        if (is == null) return sb.toString();
        is.close();
        return sb.toString();
    }

    public boolean isBackup() {
        return this._nBackup;
    }

    public static boolean isFileSysPresent(IOSCmdService comm, String fileSysName) {
        try {
            IOSCmdResponse[] resp = comm.exec(new String[]{"show " + fileSysName + ":"});
            if (resp[0].getOutput().trim().toLowerCase().indexOf("%") != -1 || resp[0].getOutput().trim().toLowerCase().indexOf("error") != -1) {
                return false;
            }
        }
        catch (Exception e) {
            JLog.printStackTrace(e);
            JLog.debug("JSDMUpdateAPIWrapper.isFileSysPresent(), exception = " + e);
            return false;
        }
        return true;
    }

    public boolean isFilesLimitExceeded() {
        return this._filesLimitExceeded;
    }

    public boolean isMemorySufficientForUpdates(Vector currentFiles, Vector newFiles, long newSize, IOSCmdService comm) throws Exception {
        JLog.debug("JSDMUpdateAPIWrapper.isMemorySufficientForUpdates, Current files = " + currentFiles);
        JLog.debug("JSDMUpdateAPIWrapper.isMemorySufficientForUpdates, New files = " + newFiles);
        JLog.debug("JSDMUpdateAPIWrapper.isMemorySufficientForUpdates, Size of new files = " + newSize);
        long lTotalSpace = 0L;
        long lFreeSpace = 0L;
        IOSCmdResponse[] rsps = null;
        int iSqueezeCheck = 0;
        String appLocation = null;
        if (currentFiles.size() == 0) {
            appLocation = JSDMUpdateAPIWrapper.getAppLocationOnRouter(comm, null);
        } else {
            int i = 0;
            while (i < currentFiles.size()) {
                if (appLocation != null) break;
                appLocation = JSDMUpdateAPIWrapper.getAppLocationOnRouter(comm, (String)currentFiles.elementAt(i));
                ++i;
            }
        }
        if (appLocation == null) {
            throw new Exception("Memory check could not be done as location of application on router could not be determined.");
        }
        JLog.debug("isMemorySufficientForUpdates(), location of <app>.tar = " + appLocation);
        rsps = comm.exec(new String[]{"dir " + appLocation + ":"});
        iSqueezeCheck = this.performSqueezeLogic(currentFiles, newFiles, comm, appLocation);
        JLog.debug("returned from performSqueezeLogic() = " + iSqueezeCheck);
        StringTokenizer st = new StringTokenizer(rsps[0].getOutput(), "\n");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            int end = s.toLowerCase().indexOf("bytes free");
            if (end <= 0) continue;
            while (end > 0 && !Character.isDigit(s.charAt(end - 1))) {
                --end;
            }
            int beg = end - 1;
            while (beg > 0 && Character.isDigit(s.charAt(beg - 1))) {
                --beg;
            }
            if (beg <= 0) continue;
            lFreeSpace = Long.parseLong(s.substring(beg, end));
            JLog.debug("Actual free space = " + lFreeSpace);
            if (lFreeSpace < newSize) continue;
            if (iSqueezeCheck == 0) {
                return false;
            }
            if (iSqueezeCheck == 2) {
                this.setSqueezeNeeded(true);
            }
            return true;
        }
        StringTokenizer st2 = new StringTokenizer(rsps[0].getOutput(), "\n");
        while (st2.hasMoreTokens()) {
            String s = st2.nextToken();
            int end = s.toLowerCase().indexOf("bytes total");
            if (end <= 0) continue;
            while (end > 0 && !Character.isDigit(s.charAt(end - 1))) {
                --end;
            }
            int beg = end - 1;
            while (beg > 0 && Character.isDigit(s.charAt(beg - 1))) {
                --beg;
            }
            if (beg <= 0) continue;
            lTotalSpace = Long.parseLong(s.substring(beg, end));
        }
        this._totalBytes = lTotalSpace;
        rsps = comm.exec(new String[]{"dir /all " + appLocation + ":"});
        StringTokenizer st3 = new StringTokenizer(rsps[0].getOutput(), "\n");
        while (st3.hasMoreElements()) {
            Vector<String> vectOuputLine = new Vector<String>(1, 1);
            String strLine = st3.nextToken().trim();
            StringTokenizer stOutputLine = new StringTokenizer(strLine);
            while (stOutputLine.hasMoreTokens()) {
                vectOuputLine.addElement(stOutputLine.nextToken().trim());
            }
            if (vectOuputLine.size() <= 0) continue;
            try {
                Long.parseLong((String)vectOuputLine.elementAt(0));
                Long.parseLong((String)vectOuputLine.elementAt(2));
                String strLineFile = ((String)vectOuputLine.elementAt(vectOuputLine.size() - 1)).trim();
                if (strLineFile.startsWith("[") && strLineFile.endsWith("]")) {
                    lFreeSpace += JSDMUpdateAPIWrapper.getFileSpaceOnRouter(Long.parseLong((String)vectOuputLine.elementAt(2)));
                    continue;
                }
                int i = 0;
                while (i < currentFiles.size()) {
                    String strCurrentFile = (String)currentFiles.elementAt(i);
                    if (strCurrentFile.equalsIgnoreCase(strLineFile)) {
                        lFreeSpace += JSDMUpdateAPIWrapper.getFileSpaceOnRouter(Long.parseLong((String)vectOuputLine.elementAt(2)));
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                JLog.printStackTrace(e);
            }
        }
        JLog.debug("Yet to be freed space = " + lFreeSpace);
        if (lFreeSpace >= newSize) {
            if (iSqueezeCheck == 0) {
                return false;
            }
            this.setSqueezeNeeded(true);
            return true;
        }
        return false;
    }

    public boolean isOldIPSInstalled() {
        IOSCmdService comm = JMiscUtil.getUpdateEngine().getCmdsvc();
        String IPS_FILE = "ips.tar";
        try {
            String location = JSDMUpdateAPIWrapper.getAppLocationOnRouter(comm, IPS_FILE);
            IOSCmdResponse[] resp = comm.exec(new String[]{"dir " + location + ":"});
            String response = resp[0].getOutput();
            if (response != null && response.trim().length() > 0) {
                StringTokenizer stz = new StringTokenizer(response.trim(), "\n");
                while (stz.hasMoreTokens()) {
                    String lineStr = stz.nextToken();
                    if (lineStr.indexOf(IPS_FILE) == -1) continue;
                    return true;
                }
            }
        }
        catch (IOSCmdServiceException icse) {
            JLog.printStackTrace(icse);
            icse.printStackTrace();
        }
        return false;
    }

    public boolean isSqueezeNeeded() {
        return this._squeezeRequired;
    }

    public boolean is_defaultFileSystemPresent() {
        return this._defaultFileSystemPresent;
    }

    public int performSqueezeLogic(Vector currentFiles, Vector newFiles, IOSCmdService comm, String sdmLocation) throws Exception {
        IOSCmdResponse[] resp = null;
        int iTotalFlashFiles = 0;
        int iNewFiles = 0;
        int iOldFiles = 0;
        int iDeletedFiles = 0;
        StringTokenizer sTz = null;
        Object newVersion = null;
        boolean bDowngrade = false;
        Object newHomeFiles = null;
        resp = comm.exec(new String[]{"dir /all " + sdmLocation + ":"});
        sTz = new StringTokenizer(resp[0].getOutput(), "\n");
        while (sTz.hasMoreTokens()) {
            Vector<String> vectOuputLine = new Vector<String>(1, 1);
            String strLine = sTz.nextToken().trim();
            StringTokenizer stOutputLine = new StringTokenizer(strLine);
            while (stOutputLine.hasMoreTokens()) {
                vectOuputLine.addElement(stOutputLine.nextToken().trim());
            }
            if (vectOuputLine.size() <= 0) continue;
            try {
                Long.parseLong((String)vectOuputLine.elementAt(0));
                Long.parseLong((String)vectOuputLine.elementAt(2));
                ++iTotalFlashFiles;
            }
            catch (Exception e) {
                JLog.printStackTrace(e);
                continue;
            }
            String strFileName = ((String)vectOuputLine.elementAt(vectOuputLine.size() - 1)).trim();
            if (strFileName.startsWith("[") && strFileName.endsWith("]")) {
                ++iDeletedFiles;
                continue;
            }
            int i = 0;
            while (i < currentFiles.size()) {
                String strTempFileName = (String)currentFiles.elementAt(i);
                if (strFileName.equals(strTempFileName)) {
                    ++iOldFiles;
                }
                ++i;
            }
        }
        int i = 0;
        while (i < newFiles.size()) {
            String newFile = ((String)newFiles.elementAt(i)).trim();
            ++iNewFiles;
            ++i;
        }
        JLog.debug("Total Files on Flash = " + iTotalFlashFiles);
        JLog.debug("No of new SDM Files = " + iNewFiles);
        JLog.debug("No of SDM Files on Flash = " + iOldFiles);
        JLog.debug("No of deleted Files on Flash = " + iDeletedFiles);
        int iMaxFileNum = 256;
        int iSum1 = iTotalFlashFiles + iNewFiles;
        int iSum2 = iSum1 - (iOldFiles + iDeletedFiles);
        String strRouterModel = JSDMUpdateAPIWrapper.getRouterModel();
        if (strRouterModel == null) {
            throw new Exception("performSqueezeLogic(), router model returned as null");
        }
        if (strRouterModel.trim().startsWith("C8") || strRouterModel.trim().startsWith("SB10") || strRouterModel.trim().startsWith("17") && this.getIOSVersion().indexOf("12.2(13)T") != -1) {
            iMaxFileNum = 32;
        } else if (this.getIOSVersion().indexOf("12.2") != -1) {
            iMaxFileNum = 64;
        }
        if (iSum1 <= iMaxFileNum) {
            return 1;
        }
        if (iSum2 <= iMaxFileNum) {
            return 2;
        }
        this.setFilesLimitExceeded(true);
        return 0;
    }

    public static void setAppLocationOnRouter(String loc) {
        _appLocation = loc;
    }

    public void setAvailableBytes(IOSCmdService comm, String location) throws IOSCmdServiceException {
        long lAvailSpace = 0L;
        IOSCmdResponse[] rsps = null;
        rsps = comm.exec(new String[]{"dir " + location + ":"});
        StringTokenizer st = new StringTokenizer(rsps[0].getOutput(), "\n");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            int end = s.toLowerCase().indexOf("bytes free");
            if (end <= 0) continue;
            while (end > 0 && !Character.isDigit(s.charAt(end - 1))) {
                --end;
            }
            int beg = end - 1;
            while (beg > 0 && Character.isDigit(s.charAt(beg - 1))) {
                --beg;
            }
            if (beg <= 0) continue;
            lAvailSpace = Long.parseLong(s.substring(beg, end));
        }
        this._availableBytes = lAvailSpace;
    }

    public void setBackup(boolean _nBackup) {
        this._nBackup = _nBackup;
    }

    public void setBackupDir(String _backupDir) {
        this._backupDir = _backupDir;
    }

    public void setFilesLimitExceeded(boolean flag) {
        this._filesLimitExceeded = flag;
    }

    public static void setSDMLocation(String SDMLocation) {
        _SDMLocation = SDMLocation;
    }

    public void setSqueezeNeeded(boolean flag) {
        this._squeezeRequired = flag;
    }

    public void setTotalBytes(IOSCmdService comm, String location) throws IOSCmdServiceException {
        long lTotalSpace = 0L;
        IOSCmdResponse[] rsps = null;
        rsps = comm.exec(new String[]{"dir " + location + ":"});
        StringTokenizer st = new StringTokenizer(rsps[0].getOutput(), "\n");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            int end = s.toLowerCase().indexOf("bytes total");
            if (end <= 0) continue;
            while (end > 0 && !Character.isDigit(s.charAt(end - 1))) {
                --end;
            }
            int beg = end - 1;
            while (beg > 0 && Character.isDigit(s.charAt(beg - 1))) {
                --beg;
            }
            if (beg < 0) continue;
            lTotalSpace = Long.parseLong(s.substring(beg, end));
        }
        this._totalBytes = lTotalSpace;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean squeezeRouter(IOSCmdService comm, String sdmLocation) {
        block9: {
            currTimeOut = 0;
            resp = null;
            cmdOutput = null;
            try {
                try {
                    currTimeOut = comm.getTimeout();
                    comm.setTimeout(1800000);
                    resp = comm instanceof PAIIOSCmdService != false ? comm.exec(new String[]{"squeeze " + sdmLocation + ":"}) : comm.exec(new String[]{"squeeze " + sdmLocation + ":"}, new PromptHandlerIf(){

                        public String handle(String[] devOutput) {
                            if (devOutput[devOutput.length - 1].toLowerCase().indexOf("[confirm]") > -1) {
                                return "\r\n";
                            }
                            return null;
                        }
                    });
                    cmdOutput = resp[0].getOutput().trim().toLowerCase();
                    JLog.debug("JSDMUpdateAPIWrapper.squeezeRouter(), cmdOutput = " + cmdOutput);
                    if (cmdOutput.indexOf("%") == -1 && cmdOutput.indexOf("error") == -1) break block9;
                    var5_5 = false;
                    var7_7 = null;
                }
                catch (IOSCmdServiceException icse) {
                    JLog.printStackTrace(icse);
                    JLog.printStackTrace(icse);
                    var5_6 = false;
                    var7_8 = null;
                    try {
                        comm.setTimeout(currTimeOut);
                        return var5_6;
                    }
                    catch (IOSCmdServiceException icse) {
                        icse.printStackTrace();
                    }
                    return var5_6;
                }
            }
            catch (Throwable var6_16) {
                var7_10 = null;
                ** try [egrp 2[TRYBLOCK] [2 : 211->221)] { 
lbl32:
                // 1 sources

                comm.setTimeout(currTimeOut);
                throw var6_16;
lbl34:
                // 1 sources

                catch (IOSCmdServiceException icse) {
                    icse.printStackTrace();
                }
                throw var6_16;
            }
            ** try [egrp 2[TRYBLOCK] [2 : 211->221)] { 
lbl39:
            // 1 sources

            comm.setTimeout(currTimeOut);
            return var5_5;
lbl41:
            // 1 sources

            catch (IOSCmdServiceException icse) {
                icse.printStackTrace();
            }
            return var5_5;
        }
        var7_9 = null;
        try {}
        catch (IOSCmdServiceException icse) {
            icse.printStackTrace();
            return true;
        }
        comm.setTimeout(currTimeOut);
        return true;
    }
}

