/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.updateengine;

import com.cisco.updateengine.JDiscoverUtil;
import com.cisco.updateengine.JLog;
import com.cisco.updateengine.JMiscUtil;
import com.cisco.updateengine.LineConfig;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class LineAdjustor {
    private static Vector _CLI;

    public static String[] VectortoArray(Vector vect) {
        String[] arr = new String[vect.size()];
        int i = 0;
        while (i < vect.size()) {
            arr[i] = (String)vect.elementAt(i);
            ++i;
        }
        return arr;
    }

    public static void getTimeoutsFromRouter() {
        _CLI = new Vector();
        IOSCmdService cmdsvc = JMiscUtil.getUpdateEngine().getCmdsvc();
        String[] showCLIs = new String[]{"show running-config | begin line vty"};
        try {
            IOSCmdResponse[] replies = cmdsvc.exec(showCLIs);
            if (JDiscoverUtil.isOKResponse(replies[0])) {
                LineAdjustor.parseResponse(replies[0].getOutput());
            }
        }
        catch (Exception e) {
            JLog.printStackTrace(e);
            JLog.error(e);
            e.printStackTrace();
        }
    }

    public static void parseResponse(String response) {
        Vector configs = LineAdjustor.seperateConfigsForIndividualLines(response);
        int i = 0;
        while (i < configs.size()) {
            String strTimeOut = "exec-timeout 10 0";
            String strRange = "";
            StringBuffer sb = (StringBuffer)configs.elementAt(i);
            StringTokenizer tk = new StringTokenizer(sb.toString(), "\n");
            while (tk.hasMoreElements()) {
                String line = tk.nextToken().trim();
                if (line.startsWith("line")) {
                    strRange = line;
                    continue;
                }
                if (!line.startsWith("exec")) continue;
                strTimeOut = line;
            }
            LineConfig cli = new LineConfig();
            cli._rangeCLI = strRange;
            cli._timeoutCLI = strTimeOut;
            _CLI.addElement(cli);
            ++i;
        }
    }

    public static void restoreTimeouts() {
        Vector<String> vCLIs = new Vector<String>();
        int i = 0;
        while (i < _CLI.size()) {
            LineConfig cfg = (LineConfig)_CLI.elementAt(i);
            vCLIs.addElement(cfg._rangeCLI);
            vCLIs.addElement(cfg._timeoutCLI);
            ++i;
        }
        String[] execCLI = LineAdjustor.VectortoArray(vCLIs);
        try {
            IOSCmdResponse[] replies = JMiscUtil.getUpdateEngine().getCmdsvc().config(execCLI);
        }
        catch (Exception e) {
            e.printStackTrace();
            JLog.printStackTrace(e);
        }
    }

    public static Vector seperateConfigsForIndividualLines(String response) {
        Vector<StringBuffer> vlines = new Vector<StringBuffer>();
        StringReader strReader = new StringReader(response);
        StringBuffer sb = new StringBuffer();
        try {
            LineNumberReader lineReader = new LineNumberReader(strReader);
            String line = lineReader.readLine();
            while (line != null) {
                if (line.trim().toLowerCase().startsWith("line vty")) {
                    sb.append(line).append("\n");
                    line = lineReader.readLine();
                    line = line.trim().toLowerCase();
                    while (line != null && !line.startsWith("line vty")) {
                        if (line.startsWith("exec-timeout")) {
                            sb.append(line).append("\n");
                        }
                        line = lineReader.readLine();
                    }
                    vlines.addElement(sb);
                    sb = new StringBuffer();
                    continue;
                }
                line = lineReader.readLine();
            }
        }
        catch (Exception e) {
            JLog.error(e);
            e.printStackTrace();
            JLog.printStackTrace(e);
        }
        return vlines;
    }

    public static void setLargeTimeout() {
        LineAdjustor.getTimeoutsFromRouter();
        Vector<String> vCLIs = new Vector<String>();
        int i = 0;
        while (i < _CLI.size()) {
            LineConfig cfg = (LineConfig)_CLI.elementAt(i);
            vCLIs.addElement(cfg._rangeCLI);
            vCLIs.addElement("exec-timeout 40 0");
            ++i;
        }
        String[] execCLI = LineAdjustor.VectortoArray(vCLIs);
        try {
            IOSCmdResponse[] replies = JMiscUtil.getUpdateEngine().getCmdsvc().config(execCLI);
        }
        catch (Exception e) {
            JLog.printStackTrace(e);
            JLog.error(e);
            e.printStackTrace();
        }
    }
}

