/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.updateengine;

import com.cisco.updateengine.JCmdCopyApplication;
import com.cisco.updateengine.JDiscoverFlash;
import com.cisco.updateengine.JMiscUtil;
import com.cisco.updateengine.JPackage;
import com.cisco.updateengine.JSDMUpdateAPIWrapper;
import com.cisco.updateengine.JUpdate;
import com.cisco.updateengine.JUpdateCommandBase;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class UnInstallCmd
extends JUpdateCommandBase {
    private Vector _apps = new Vector();
    private String _backupDir;
    private static String appLocation = "";

    public boolean deleteCSDSVCFilesFromFlash(String packageName) {
        boolean result = false;
        JSDMUpdateAPIWrapper api = JMiscUtil.getUpdateEngine().getAPIWrapper();
        JUpdate engine = JMiscUtil.getUpdateEngine();
        Hashtable CSDSVCTable = new Hashtable();
        boolean bStatus = false;
        if (packageName == "CSD") {
            CSDSVCTable = JDiscoverFlash.getFileNameSizeFromRouter("securedesktop");
        }
        if (packageName == "SVC") {
            CSDSVCTable = JDiscoverFlash.getFileNameSizeFromRouter("sslclient");
        }
        if (CSDSVCTable.size() > 0) {
            Enumeration keys = CSDSVCTable.keys();
            String fileName = null;
            while (keys.hasMoreElements()) {
                fileName = (String)keys.nextElement();
                result = bStatus = JSDMUpdateAPIWrapper.deleteFileFromRouter(engine.getCmdsvc(), appLocation, fileName);
            }
        }
        return result;
    }

    public boolean doBackup() {
        JCmdCopyApplication cmd = new JCmdCopyApplication();
        cmd.setBackupPath(this._backupDir);
        cmd.set_apps(this._apps);
        return cmd.doBackUp();
    }

    public boolean executeCommand() {
        if (!new JCmdCopyApplication().isRCPEnabled()) {
            this.writeStatus(JCmdCopyApplication.STAT_RCPBLOCKED);
            return false;
        }
        if (this._backupDir != null && this._backupDir.length() != 0 && !this.doBackup()) {
            this.writeStatus(1);
        }
        this.unInstallApps();
        this.writeStatus(0);
        return true;
    }

    public void populate(Vector param) {
        int i = 0;
        while (i < param.size()) {
            String item = ((String)param.elementAt(i)).trim();
            if (!item.startsWith("[") || !item.endsWith("]")) {
                String prefix = item.substring(0, item.indexOf("=")).trim();
                String suffix = item.substring(item.indexOf("=") + 1, item.length()).trim();
                if (prefix.equalsIgnoreCase("Applications")) {
                    StringTokenizer tk = new StringTokenizer(suffix, ":");
                    while (tk.hasMoreTokens()) {
                        this._apps.addElement(tk.nextToken());
                    }
                } else if (prefix.equalsIgnoreCase("BackupPath")) {
                    this._backupDir = suffix;
                }
            }
            ++i;
        }
    }

    public boolean removeApp(String app) {
        String location;
        Hashtable installedApps = JMiscUtil.getUpdateEngine().getAppsInstalledOnRouter();
        JPackage pkg = (JPackage)installedApps.get(app);
        JSDMUpdateAPIWrapper api = JMiscUtil.getUpdateEngine().getAPIWrapper();
        IOSCmdService comm = JMiscUtil.getUpdateEngine().getCmdsvc();
        appLocation = location = JSDMUpdateAPIWrapper.getAppLocationOnRouter(comm, pkg.get_masterFile());
        StringBuffer sb = new StringBuffer();
        if (pkg == null) {
            return false;
        }
        Vector files = pkg.getFiles();
        int j = 0;
        while (j < files.size()) {
            String file = (String)files.elementAt(j);
            boolean bStatus = JSDMUpdateAPIWrapper.deleteFileFromRouter(comm, location, file);
            if (!bStatus) {
                if (sb.toString().length() != 0) {
                    sb.append(",");
                }
                sb.append(file);
            }
            ++j;
        }
        return true;
    }

    public void unInstallApps() {
        int i = 0;
        while (i < this._apps.size()) {
            this.removeApp(((String)this._apps.elementAt(i)).trim());
            ++i;
        }
    }

    public void writeStatus(int code) {
        StringBuffer sb = new StringBuffer("[Command]\n");
        sb.append("Command=").append(this.getcommandID()).append("\n");
        sb.append("Status=").append(Integer.toString(code));
        JMiscUtil.printToFile(JMiscUtil.getUpdateEngine().get_resultFile(), sb.toString());
    }
}

