/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.updateengine;

import com.cisco.updateengine.JLog;
import com.cisco.updateengine.JPackage;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Locale;
import java.util.StringTokenizer;

public class VersionTextParser {
    String _text;
    private JPackage _package;

    public VersionTextParser(String text) {
        this._text = text;
        this._package = new JPackage();
        this.parse();
    }

    public void associate(String line) {
        if (line.indexOf("=") == -1) {
            return;
        }
        String prefix = line.substring(0, line.indexOf("=")).trim();
        String suffix = line.substring(line.indexOf("=") + 1, line.length()).trim();
        if (prefix.indexOf("MasterFile") != -1) {
            this._package.set_masterFile(suffix);
        } else if (prefix.indexOf("Version") != -1) {
            this._package.set_version(suffix);
        } else if (prefix.indexOf("Locale") != -1) {
            Locale local = new Locale(suffix, "US");
            this._package.set_language(local.getDisplayLanguage(Locale.ENGLISH));
        } else if (prefix.equals("Files")) {
            this.attachFileNames(suffix);
        } else if (prefix.equals("HomeFiles")) {
            this.attachAndAddHomeFileNames(suffix);
        } else if (prefix.equals("MappedFiles")) {
            this._package.addMappingFile(suffix);
        } else if (prefix.equals("SDF_MAPPING")) {
            this._package.addSDFFile(suffix);
        }
    }

    public void attachAndAddHomeFileNames(String text) {
        StringTokenizer tk = new StringTokenizer(text, ",");
        while (tk.hasMoreTokens()) {
            this._package.addHomeFile(tk.nextToken());
        }
    }

    public void attachFileNames(String text) {
        StringTokenizer tk = new StringTokenizer(text, ",");
        while (tk.hasMoreTokens()) {
            this._package.addFile(tk.nextToken());
        }
    }

    public JPackage get_package() {
        if (this._package.getFiles().size() != 0) {
            return this._package;
        }
        return null;
    }

    private void parse() {
        if (this._text == null || this._text.trim().length() == 0) {
            return;
        }
        StringReader strReader = new StringReader(this._text);
        try {
            LineNumberReader lineReader = new LineNumberReader(strReader);
            String line = lineReader.readLine();
            while (line != null) {
                if ((line = line.trim()).startsWith("<")) {
                    String beginTag = line.substring(line.indexOf("<") + 1, line.indexOf(">"));
                    String endTag = "</" + beginTag + ">";
                    StringBuffer taggedLine = new StringBuffer(line);
                    while (line != null && line.indexOf(endTag) == -1) {
                        line = lineReader.readLine();
                        taggedLine.append(line);
                    }
                    String strTaggedLine = taggedLine.toString().trim();
                    strTaggedLine = strTaggedLine.substring(beginTag.length() + 2);
                    strTaggedLine = strTaggedLine.substring(0, strTaggedLine.length() - endTag.length());
                    this.associate(String.valueOf(beginTag) + "=" + strTaggedLine);
                } else {
                    this.associate(line);
                }
                line = lineReader.readLine();
            }
            if (this._package.get_language() == null || this._package.get_language().trim().length() == 0) {
                Locale local = new Locale("en", "US");
                this._package.set_language(local.getDisplayLanguage(Locale.ENGLISH));
            }
        }
        catch (Exception e) {
            JLog.printStackTrace(e);
        }
    }
}

