/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.commonutils;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.FilterIf;

public class FilterFactory {
    public static FilterIf getCommandFilter(String cmdName) {
        return FilterFactory.getCommandFilterImpl(cmdName);
    }

    private static FilterIf getCommandFilterImpl(final String cmdName) {
        return new FilterIf(){

            public boolean accept(CmdValues cmdVals) {
                return cmdVals.getCmdName().equals(cmdName);
            }
        };
    }

    public static FilterIf getKeywordFilter(String cmdName, String[] keywordList) {
        return FilterFactory.getKeywordFilterImpl(cmdName, keywordList);
    }

    private static FilterIf getKeywordFilterImpl(final String cmdName, final String[] keywordList) {
        return new FilterIf(){

            public boolean accept(CmdValues cmdVals) {
                if (cmdVals.getCmdName().equals(cmdName)) {
                    if (keywordList == null) {
                        return true;
                    }
                    int count = 0;
                    while (count < keywordList.length) {
                        if (!cmdVals.containsKey(keywordList[count])) {
                            return false;
                        }
                        ++count;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public static FilterIf getKeywordValueFilter(String cmdName, String[] keywordList, String alias, String value) {
        return FilterFactory.getKeywordValueFilterImpl(cmdName, keywordList, alias, value);
    }

    private static FilterIf getKeywordValueFilterImpl(final String cmdName, final String[] keywordList, final String alias, final String value) {
        return new FilterIf(){

            public boolean accept(CmdValues cmdVals) {
                String mapName = null;
                if (cmdVals.getCmdName().equals(cmdName)) {
                    if (keywordList != null) {
                        int count = 0;
                        while (count < keywordList.length) {
                            if (!cmdVals.containsKey(keywordList[count])) {
                                return false;
                            }
                            ++count;
                        }
                    }
                    return (mapName = cmdVals.getValue(alias)).equals(value);
                }
                return false;
            }
        };
    }
}

