/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.acl;

import com.cisco.xdm.data.common.IPAddress;
import com.cisco.xdm.data.common.Netmask;

final class ACEIPAddress
implements Cloneable {
    private boolean _bAny;
    private boolean _bHost;
    private IPAddress _address = new IPAddress("0.0.0.0");
    private Netmask _wildcardMask = new Netmask("255.255.255.255");
    private String _host;

    ACEIPAddress() {
        this._bAny = true;
        this._bHost = false;
    }

    ACEIPAddress(String host) {
        this._bHost = true;
        this._bAny = false;
        if (IPAddress.isLegalIPAddress(host)) {
            this._address = new IPAddress(host);
        } else if (host.equals("any")) {
            this.setAny();
        } else {
            this._host = host;
        }
        this._wildcardMask = new Netmask("0.0.0.0");
    }

    ACEIPAddress(String source, String wildcardMask) {
        this._bHost = false;
        this._bAny = false;
        this._address = new IPAddress(source);
        this._wildcardMask = new Netmask(wildcardMask);
    }

    public Object clone() {
        try {
            ACEIPAddress newObj = (ACEIPAddress)super.clone();
            if (this._address != null) {
                newObj._address = (IPAddress)this._address.clone();
            }
            if (this._wildcardMask != null) {
                newObj._wildcardMask = (Netmask)this._wildcardMask.clone();
            }
            return newObj;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    int compare(ACEIPAddress ipAddress) {
        if (this._bAny && ipAddress._bAny) {
            return 5;
        }
        if (this._bAny) {
            return 4;
        }
        if (ipAddress._bAny) {
            return 3;
        }
        if (this._bHost && this._host != null) {
            if (ipAddress._bHost && ipAddress._host != null) {
                if (this._host.equals(ipAddress._host)) {
                    return 5;
                }
                return 2;
            }
            return 2;
        }
        if (ipAddress._host != null) {
            return 2;
        }
        IPAddress startAddress = this._address.getBeginningAddress(this.getInverseMask());
        IPAddress endAddress = this._address.getFinalAddress(this.getInverseMask());
        IPAddress startAddress1 = ipAddress._address.getBeginningAddress(ipAddress.getInverseMask());
        IPAddress endAddress1 = ipAddress._address.getFinalAddress(ipAddress.getInverseMask());
        if (startAddress.equals(startAddress1) && endAddress.equals(endAddress1)) {
            return 5;
        }
        if (startAddress.lessThanOrEqual(startAddress1) && endAddress.greaterThanOrEqual(endAddress1)) {
            return 4;
        }
        if (startAddress.greaterThanOrEqual(startAddress1) && endAddress.lessThanOrEqual(endAddress1)) {
            return 3;
        }
        return 2;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            ACEIPAddress address = (ACEIPAddress)obj;
            if (this._bAny) {
                return this._bAny == address._bAny;
            }
            if (this._bHost) {
                if (!address._bHost) {
                    return false;
                }
                if (this._host != null) {
                    return this._host.equals(address._host);
                }
                return this._address.equals(address._address);
            }
            return this._address.equals(address._address) && this._wildcardMask.equals(address._wildcardMask);
        }
        return false;
    }

    String getIPAddress() {
        if (this._bHost && this._host != null) {
            return this._host;
        }
        return this._address.toString();
    }

    private Netmask getInverseMask() {
        return new Netmask(~this._wildcardMask.getIntValue());
    }

    String getWildcardMask() {
        return this._wildcardMask.toString();
    }

    boolean isAny() {
        return this._bAny;
    }

    boolean isHost() {
        return this._bHost;
    }

    void setAny() {
        this._bAny = true;
        this._bHost = false;
        this._address = null;
        this._wildcardMask = null;
        this._address = new IPAddress("0.0.0.0");
        this._wildcardMask = new Netmask("255.255.255.255");
    }

    void setHost(String host) {
        this._bHost = true;
        this._bAny = false;
        this._address = null;
        this._wildcardMask = null;
        if (IPAddress.isLegalIPAddress(host)) {
            this._address = new IPAddress(host);
            this._host = null;
        } else if (host.equals("any")) {
            this.setAny();
        } else {
            this._host = host;
        }
        this._wildcardMask = new Netmask("0.0.0.0");
    }

    void setIPAddress(String ipAddress, String wildcardMask) {
        this._bHost = false;
        this._bAny = false;
        this._address = null;
        this._wildcardMask = null;
        this._address = new IPAddress(ipAddress);
        this._wildcardMask = new Netmask(wildcardMask);
    }

    String toCLI() {
        StringBuffer tempString = new StringBuffer();
        if (this._bAny) {
            tempString.append("any");
        } else if (this._bHost && this._host != null) {
            tempString.append("host ").append(this._host);
        } else if (this._bHost) {
            tempString.append("host ").append(this._address.toString());
        } else {
            tempString.append(this._address.toString()).append(" ").append(this._wildcardMask.toString());
        }
        return tempString.toString();
    }

    public String toFormatedString() {
        StringBuffer tempString = new StringBuffer();
        if (this._bAny) {
            tempString.append("any");
        } else if (this._bHost && this._host != null) {
            tempString.append(this._host);
        } else if (this._bHost) {
            tempString.append(this._address.toString());
        } else {
            tempString.append(this._address.toString()).append("/").append(this._wildcardMask.toString());
        }
        return tempString.toString();
    }
}

