/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.acl;

import com.cisco.xdm.data.common.PortMap;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import java.util.Enumeration;
import java.util.Vector;

public class ACEProtocols {
    private static final Vector _protocols = new Vector();
    public static final String IP = "ip";
    public static final String AHP = "ahp";
    public static final String ESP = "esp";
    public static final String EIGRP = "eigrp";
    public static final String GRE = "gre";
    public static final String IPINIP = "ipinip";
    public static final String NOS = "nos";
    public static final String OSPF = "ospf";
    public static final String PCP = "pcp";
    public static final String PIM = "pim";
    public static final String IGRP = "igrp";
    public static final String UDP = "udp";
    public static final String TCP = "tcp";
    public static final String ICMP = "icmp";
    public static final String IGMP = "igmp";

    private ACEProtocols() {
    }

    public static void discoverProtocolsSupported(IOSCmdResponse resp) {
        if (resp == null) {
            return;
        }
        String buf = resp.getOutput();
        if (resp.getStatus() != 2 && buf != null && buf.indexOf("% Unrecognized command") < 0) {
            if (buf.indexOf(IP) >= 0) {
                _protocols.addElement(IP);
            }
            if (buf.indexOf(AHP) >= 0) {
                _protocols.addElement(AHP);
            }
            if (buf.indexOf(ESP) >= 0) {
                _protocols.addElement(ESP);
            }
            if (buf.indexOf(EIGRP) >= 0) {
                _protocols.addElement(EIGRP);
            }
            if (buf.indexOf(GRE) >= 0) {
                _protocols.addElement(GRE);
            }
            if (buf.indexOf(IGRP, buf.indexOf(EIGRP) + 2) >= 0) {
                _protocols.addElement(IGRP);
            }
            if (buf.indexOf(IPINIP) >= 0) {
                _protocols.addElement(IPINIP);
            }
            if (buf.indexOf(NOS) >= 0) {
                _protocols.addElement(NOS);
            }
            if (buf.indexOf(OSPF) >= 0) {
                _protocols.addElement(OSPF);
            }
            if (buf.indexOf(PCP) >= 0) {
                _protocols.addElement(PCP);
            }
            if (buf.indexOf(PIM) >= 0) {
                _protocols.addElement(PIM);
            }
            if (buf.indexOf(UDP) >= 0) {
                _protocols.addElement(UDP);
            }
            if (buf.indexOf(TCP) >= 0) {
                _protocols.addElement(TCP);
            }
            if (buf.indexOf(ICMP) >= 0) {
                _protocols.addElement(ICMP);
            }
            if (buf.indexOf(IGMP) >= 0) {
                _protocols.addElement(IGMP);
            }
        }
    }

    public static Enumeration getProtocolSupported() {
        return _protocols.elements();
    }

    public static boolean isIpProtocolName(String protocol) {
        return protocol.equalsIgnoreCase(IP) || protocol.equalsIgnoreCase(AHP) || protocol.equalsIgnoreCase(ESP) || protocol.equalsIgnoreCase(EIGRP) || protocol.equalsIgnoreCase(GRE) || protocol.equalsIgnoreCase(IGRP) || protocol.equalsIgnoreCase(IPINIP) || protocol.equalsIgnoreCase(NOS) || protocol.equalsIgnoreCase(OSPF) || protocol.equalsIgnoreCase(PCP) || protocol.equalsIgnoreCase(PIM);
    }

    public static boolean isProtocolName(String protocol) {
        return protocol.equalsIgnoreCase(UDP) || protocol.equalsIgnoreCase(TCP) || protocol.equalsIgnoreCase(ICMP) || protocol.equalsIgnoreCase(IGMP) || ACEProtocols.isIpProtocolName(protocol);
    }

    public static boolean isProtocolSupported(int protocol) {
        if (protocol < 0 || protocol > 255) {
            return false;
        }
        String protocolName = PortMap.findKeyByValue(protocol, PortMap.ipProtTable);
        if (protocolName == null) {
            return true;
        }
        return _protocols.contains(protocolName);
    }

    public static boolean isProtocolSupported(String protocol) {
        return _protocols.contains(protocol);
    }
}

