/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.acl;

import java.util.Enumeration;
import java.util.Vector;

public class ACLCategories {
    public static final int ACCESS_RULES = 1;
    public static final int NAT_RULES = 2;
    public static final int IPSEC_RULES = 3;
    public static final int UNSUPPORTED_RULES = 4;
    public static final int EXTERNAL_RULES = 5;
    public static final int XDM_DEFAULTS_RULES = 6;
    public static final int NAC_RULES = 7;

    public static String convertToString(int categories) {
        String[] cats = new String[]{"Access Rules", "Nat Rules", "Ipsec Rules", "Unsuppored Rules", "External Rules", "Xdm Default Rules", "NAC Rules"};
        String tempString = "";
        int i = 0;
        while (i < 7) {
            if ((categories & 1) != 0) {
                tempString = String.valueOf(tempString) + "Category: " + cats[i] + "\n";
            }
            categories >>= 1;
            ++i;
        }
        return tempString;
    }

    static int getBinaryCategory(int category) {
        return 1 << category - 1;
    }

    public static Enumeration getCategories() {
        Vector<Integer> cat = new Vector<Integer>();
        cat.addElement(new Integer(1));
        cat.addElement(new Integer(2));
        cat.addElement(new Integer(3));
        cat.addElement(new Integer(7));
        cat.addElement(new Integer(4));
        cat.addElement(new Integer(5));
        cat.addElement(new Integer(6));
        return cat.elements();
    }

    public static int getCategoryIndex(int nUIIndex) {
        Enumeration e = ACLCategories.getCategories();
        int i = 0;
        while (e.hasMoreElements()) {
            Integer nItem = (Integer)e.nextElement();
            if (i == nUIIndex) {
                return nItem;
            }
            ++i;
        }
        return -1;
    }

    public static int getUIIndex(int nCatIndex) {
        Enumeration e = ACLCategories.getCategories();
        int i = 0;
        while (e.hasMoreElements()) {
            Integer nItem = (Integer)e.nextElement();
            if (nItem == nCatIndex) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

