/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.acl;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.acl.ACEInterface;
import com.cisco.xdm.data.acl.ACLBase;
import com.cisco.xdm.data.acl.ExtendedACE;
import com.cisco.xdm.data.acl.StandardACE;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.common.PortMap;

public class ExtIcmpACE
extends ExtendedACE
implements Cloneable {
    private String _icmpMessage = null;
    private int _icmpType = -1;
    private int _icmpCode = -1;
    private boolean _isMessage = false;

    public ExtIcmpACE() {
        this._aceType = 4;
        this._protocol = "icmp";
    }

    public Object clone() {
        ExtIcmpACE newObj = (ExtIcmpACE)super.clone();
        return newObj;
    }

    public int compare(ACEInterface aceRule) {
        if (((StandardACE)aceRule)._aceType == 0) {
            return 2;
        }
        if (aceRule instanceof ExtIcmpACE) {
            ExtIcmpACE ace = (ExtIcmpACE)aceRule;
            return this.compare(ace);
        }
        if (((ExtendedACE)aceRule).getProtocol().equals("ip")) {
            int superCompResult = super.compare(aceRule);
            if (superCompResult == 0) {
                return 3;
            }
            if (superCompResult == 1) {
                return 6;
            }
            return superCompResult;
        }
        return 2;
    }

    protected int compare(ExtIcmpACE aceRule) {
        if (!this.equals(aceRule)) {
            return 2;
        }
        return super.compare(aceRule);
    }

    public void copy(ACEInterface ace) {
        super.copy(ace);
        if (ace instanceof ExtIcmpACE) {
            ExtIcmpACE tempAce = (ExtIcmpACE)ace;
            this._icmpCode = tempAce._icmpCode;
            this._icmpType = tempAce._icmpType;
            this._icmpMessage = tempAce._icmpMessage;
        }
    }

    protected boolean equals(ExtIcmpACE ace) {
        boolean cmpVal;
        boolean bl = cmpVal = super.equals(ace) && this._icmpType == ace._icmpType && this._icmpCode == ace._icmpCode;
        if (this._icmpMessage != null && ace._icmpMessage != null) {
            return cmpVal && this._icmpMessage.equals(ace._icmpMessage);
        }
        if (this._icmpMessage == null && ace._icmpMessage == null) {
            return cmpVal;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            ExtIcmpACE ace = (ExtIcmpACE)obj;
            return this.equals(ace);
        }
        return false;
    }

    protected CmdValues generateAceCmd() {
        CmdValues cmdVal = super.generateAceCmd();
        if (this._icmpType != -1) {
            cmdVal.addValue("ICMP-TYPE", String.valueOf(this._icmpType));
            if (this._icmpCode != -1) {
                cmdVal.addValue("ICMP-CODE", String.valueOf(this._icmpCode));
            }
        } else if (this._icmpMessage != null && this._icmpMessage.length() != 0) {
            cmdVal.addValue("ICMP-MESSAGE", this._icmpMessage);
        }
        return cmdVal;
    }

    public int getIcmpCode() {
        return this._icmpCode;
    }

    public String getIcmpMessage() {
        return this._icmpMessage;
    }

    public int getIcmpType() {
        return this._icmpType;
    }

    public String getService() {
        StringBuffer tempString = new StringBuffer();
        if (this._icmpType != -1) {
            tempString.append(String.valueOf(this._icmpType)).append("/icmp");
            if (this._icmpCode != -1) {
                tempString.append(String.valueOf(this._icmpCode)).append("/icmp code");
            }
        } else if (this._icmpMessage != null && this._icmpMessage.length() != 0) {
            tempString.append(this._icmpMessage).append("/icmp");
        } else {
            tempString.append("icmp");
        }
        return tempString.toString();
    }

    public boolean isIcmpMessage() {
        return this._isMessage;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException {
        super.populate(config, cmdVal);
        String temp = cmdVal.getValue("ICMP-TYPE");
        if (temp != null) {
            this._icmpType = Integer.parseInt(temp);
            this._isMessage = false;
        }
        if ((temp = cmdVal.getValue("ICMP-CODE")) != null) {
            this._icmpCode = Integer.parseInt(temp);
        }
        this._icmpMessage = cmdVal.getValue("ICMP-MESSAGE");
        if (this._icmpMessage != null) {
            this._isMessage = true;
        }
        if (this._icmpCode != -1 || this._icmpMessage != null && PortMap.findValueByKey(this._icmpMessage, PortMap.icmpTypeTable) == -1) {
            ((ACLBase)this.getParent()).setUnSupported();
        }
    }

    public boolean setIcmpCode(int icmpCode) {
        return this.setIcmpType(this._icmpType, icmpCode);
    }

    public boolean setIcmpMessage(String icmpMessage) {
        if (PortMap.findValueByKey(icmpMessage, PortMap.icmpTypeTable) == -1) {
            return false;
        }
        this._icmpMessage = icmpMessage;
        this._icmpType = -1;
        this._icmpCode = -1;
        this._isMessage = true;
        this.setModified();
        return true;
    }

    public boolean setIcmpType(int icmpType) {
        return this.setIcmpType(icmpType, this._icmpCode);
    }

    public boolean setIcmpType(int icmpType, int icmpCode) {
        if (icmpType > 255) {
            return false;
        }
        if (icmpCode > 255) {
            return false;
        }
        this._icmpMessage = PortMap.getIcmpTypeName(icmpType, icmpCode);
        if (this._icmpMessage == null) {
            this._icmpType = icmpType;
            this._icmpCode = icmpCode;
            this._isMessage = false;
        } else {
            this._icmpType = -1;
            this._icmpCode = -1;
            this._isMessage = true;
        }
        this.setModified();
        return true;
    }

    public boolean setProtocol(String protocol) {
        return false;
    }

    public String toCLI() {
        StringBuffer tempString = new StringBuffer();
        if (!this._bGrant) {
            tempString.append("deny");
        } else {
            tempString.append("permit");
        }
        tempString.append(" ").append(this._protocol);
        tempString.append(" ").append(this._source.toCLI());
        tempString.append(" ").append(this._destAddress.toCLI());
        if (this._icmpType != -1) {
            tempString.append(" ").append(String.valueOf(this._icmpType));
            if (this._icmpCode != -1) {
                tempString.append(" ").append(String.valueOf(this._icmpCode));
            }
        } else if (this._icmpMessage != null && this._icmpMessage.length() != 0) {
            tempString.append(" ").append(this._icmpMessage);
        }
        if (this._dscp != null && this._dscp.length() != 0) {
            tempString.append(" ").append("dscp").append(" ").append(this._dscp);
        }
        if (this._precedence != null && this._precedence.length() != 0) {
            tempString.append(" ").append("precedence").append(" ").append(this._precedence);
        }
        if (this._tos != null && this._tos.length() != 0) {
            tempString.append(" ").append("tos").append(" ").append(this._tos);
        }
        if (this._bLog) {
            tempString.append(" ").append("log");
        }
        if (this._bLogInput) {
            tempString.append(" ").append("log-input");
        }
        if (this._timeRange != null && this._timeRange.length() != 0) {
            tempString.append(" ").append("time-range").append(" ").append(this._timeRange);
        }
        if (this._reflectACLName != null && this._reflectACLName.length() != 0) {
            tempString.append(" ").append("reflect").append(" ").append(this._reflectACLName);
        }
        return tempString.toString();
    }

    public String toCLI1() {
        StringBuffer tempString = new StringBuffer();
        boolean flag = false;
        if (!this._bGrant) {
            tempString.append("deny all ");
        } else {
            tempString.append("permit all ");
        }
        tempString.append(this._protocol).append(" traffic");
        tempString.append(" from ").append(this._source.toCLI());
        tempString.append(" to ").append(this._destAddress.toCLI()).append(" ");
        if (this._icmpType != -1) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("Icmp Type ").append(String.valueOf(this._icmpType));
            if (this._icmpCode != -1) {
                tempString.append(", Icmp Code ").append(String.valueOf(this._icmpCode));
            }
        } else if (this._icmpMessage != null && this._icmpMessage.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("Icmp Message ").append(this._icmpMessage);
        }
        if (this._dscp != null && this._dscp.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("dscp").append("=").append(this._dscp);
            flag = true;
        }
        if (this._precedence != null && this._precedence.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("precedence").append(" = ").append(this._precedence);
        }
        if (this._tos != null && this._tos.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("tos").append(" = ").append(this._tos);
        }
        if (this._bLog) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("log");
        }
        if (this._bLogInput) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("log-input");
        }
        if (this._bFragments) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("fragments");
        }
        if (this._timeRange != null && this._timeRange.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("time-range").append(" = ").append(this._timeRange);
        }
        if (this._reflectACLName != null && this._reflectACLName.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("reflect").append(" = ").append(this._reflectACLName);
        }
        return tempString.toString();
    }

    public String toFormatedString() {
        StringBuffer tempString = new StringBuffer();
        if (this._icmpType != -1) {
            tempString.append(String.valueOf(this._icmpType)).append("/icmp,");
            if (this._icmpCode != -1) {
                tempString.append(String.valueOf(this._icmpCode)).append("/icmp code,");
            }
        } else if (this._icmpMessage != null && this._icmpMessage.length() != 0) {
            tempString.append(this._icmpMessage).append("/icmp,");
        } else {
            tempString.append("icmp,");
        }
        if (this._dscp != null && this._dscp.length() != 0) {
            tempString.append(this._dscp).append("/").append("dscp").append(",");
        }
        if (this._precedence != null && this._precedence.length() != 0) {
            tempString.append(this._precedence).append("/").append("precedence").append(",");
        }
        if (this._tos != null && this._tos.length() != 0) {
            tempString.append(this._tos).append("/").append("tos").append(",");
        }
        if (this._bLog) {
            tempString.append("log").append(",");
        }
        if (this._bLogInput) {
            tempString.append("log-input").append(",");
        }
        if (this._bFragments) {
            tempString.append("fragments").append(",");
        }
        if (this._timeRange != null && this._timeRange.length() != 0) {
            tempString.append(this._timeRange).append("/").append("time-range").append(",");
        }
        if (this._reflectACLName != null && this._reflectACLName.length() != 0) {
            tempString.append(this._reflectACLName).append("/").append("reflect").append(",");
        }
        return tempString.toString();
    }
}

