/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.acl;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.acl.ACEInterface;
import com.cisco.xdm.data.acl.ACEPort;
import com.cisco.xdm.data.acl.ExtendedACE;
import com.cisco.xdm.data.acl.StandardACE;
import com.cisco.xdm.data.base.XDMException;

public class ExtUdpACE
extends ExtendedACE
implements Cloneable {
    protected ACEPort _sourcePort = new ACEPort();
    protected ACEPort _destPort = new ACEPort();

    public ExtUdpACE() {
        this._aceType = 2;
        this._protocol = "udp";
    }

    public void clearDestPort() {
        this._destPort.clear();
        this.setModified();
    }

    public void clearSourcePort() {
        this._sourcePort.clear();
        this.setModified();
    }

    public Object clone() {
        ExtUdpACE newObj = (ExtUdpACE)super.clone();
        newObj._sourcePort = (ACEPort)this._sourcePort.clone();
        newObj._destPort = (ACEPort)this._destPort.clone();
        return newObj;
    }

    public int compare(ACEInterface aceRule) {
        if (((StandardACE)aceRule)._aceType == 0) {
            return 2;
        }
        if (aceRule instanceof ExtUdpACE && ((ExtendedACE)aceRule).getProtocol().equals("udp")) {
            ExtUdpACE ace = (ExtUdpACE)aceRule;
            return this.compare(ace);
        }
        if (((ExtendedACE)aceRule).getProtocol().equals("ip")) {
            int superCompResult = super.compare(aceRule);
            if (superCompResult == 0) {
                return 3;
            }
            if (superCompResult == 1) {
                return 6;
            }
            return superCompResult;
        }
        return 2;
    }

    protected int compare(ExtUdpACE aceRule) {
        int sourcePortComp = this._sourcePort.compare(aceRule._sourcePort);
        if (sourcePortComp == 2) {
            return 2;
        }
        int destPortComp = this._destPort.compare(aceRule._destPort);
        if (destPortComp == 2) {
            return 2;
        }
        int superCompResult = super.compare(aceRule);
        if (superCompResult == 2) {
            return 2;
        }
        if (destPortComp == 3 || sourcePortComp == 3) {
            if (superCompResult == 0) {
                return 3;
            }
            if (superCompResult == 1) {
                return 6;
            }
        }
        return superCompResult;
    }

    public void copy(ACEInterface ace) {
        super.copy(ace);
        if (ace instanceof ExtUdpACE) {
            ExtUdpACE tempAce = (ExtUdpACE)ace;
            this._sourcePort = (ACEPort)tempAce._sourcePort.clone();
            this._destPort = (ACEPort)tempAce._destPort.clone();
        }
        this._sourcePort.setPortType(0);
        this._destPort.setPortType(0);
    }

    protected boolean equals(ExtUdpACE ace) {
        return super.equals(ace) && this._sourcePort.equals(ace._sourcePort) && this._destPort.equals(ace._destPort);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            ExtUdpACE ace = (ExtUdpACE)obj;
            return this.equals(ace);
        }
        return false;
    }

    protected CmdValues generateAceCmd() {
        CmdValues cmdVal = super.generateAceCmd();
        if (!this._sourcePort.isEmpty()) {
            cmdVal.addValue("SOURCE-OPERATOR", this._sourcePort.getPortOperator());
            cmdVal.addValue("SOURCE-PORT", String.valueOf(this._sourcePort.getPort()));
            if (this._sourcePort.isRange()) {
                cmdVal.addValue("SOURCE-PORT-HIGH", String.valueOf(this._sourcePort.getUpperPort()));
            }
        }
        if (!this._destPort.isEmpty()) {
            cmdVal.addValue("DEST-OPERATOR", this._destPort.getPortOperator());
            cmdVal.addValue("DEST-PORT", String.valueOf(this._destPort.getPort()));
            if (this._destPort.isRange()) {
                cmdVal.addValue("DEST-PORT-HIGH", String.valueOf(this._destPort.getUpperPort()));
            }
        }
        return cmdVal;
    }

    public String getDestPort() {
        return this._destPort.getPort();
    }

    public String getDestPortOperator() {
        return this._destPort.getPortOperator();
    }

    public String getDestPortUpp() {
        return this._destPort.getUpperPort();
    }

    public String getService() {
        StringBuffer tempString = new StringBuffer();
        if (!this._sourcePort.isEmpty()) {
            tempString.append(this._sourcePort.toFormatedString()).append("/").append(this._protocol);
        }
        if (!this._destPort.isEmpty()) {
            if (!this._sourcePort.isEmpty()) {
                tempString.append(", ");
            }
            tempString.append("dest: ").append(this._destPort.toFormatedString()).append("/").append(this._protocol);
        }
        if (this._sourcePort.isEmpty() && this._destPort.isEmpty()) {
            tempString.append(this._protocol);
        }
        return tempString.toString();
    }

    public String getSourcePort() {
        return this._sourcePort.getPort();
    }

    public String getSourcePortOperator() {
        return this._sourcePort.getPortOperator();
    }

    public String getSourcePortUpp() {
        return this._sourcePort.getUpperPort();
    }

    void mirrorACE() {
        super.mirrorACE();
        ACEPort tempSource = (ACEPort)this._sourcePort.clone();
        this._sourcePort = this._destPort;
        this._destPort = tempSource;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException {
        String tempUpperPort;
        String tempPort;
        super.populate(config, cmdVal);
        String operator = cmdVal.getValue("SOURCE-OPERATOR");
        if (operator != null) {
            tempPort = cmdVal.getValue("SOURCE-PORT");
            if (operator.equals("range")) {
                tempUpperPort = cmdVal.getValue("SOURCE-PORT-HIGH");
                this.setSourcePortRange(tempPort, tempUpperPort);
            } else {
                this.setSourcePort(tempPort, operator);
            }
        }
        if ((operator = cmdVal.getValue("DEST-OPERATOR")) != null) {
            tempPort = cmdVal.getValue("DEST-PORT");
            if (operator.equals("range")) {
                tempUpperPort = cmdVal.getValue("DEST-PORT-HIGH");
                this.setDestPortRange(tempPort, tempUpperPort);
            } else {
                this.setDestPort(tempPort, operator);
            }
        }
    }

    public boolean setDestPort(String port, String operator) {
        if (this._destPort.setPort(port, operator)) {
            this.setModified();
            return true;
        }
        return false;
    }

    public boolean setDestPortRange(String lower, String upper) {
        if (this._destPort.setRange(lower, upper)) {
            this.setModified();
            return true;
        }
        return false;
    }

    public boolean setDestPortUpp(String port) {
        if (this._destPort.setUpperPort(port)) {
            this.setModified();
            return true;
        }
        return false;
    }

    public boolean setProtocol(String protocol) {
        return false;
    }

    public boolean setSourcePort(String port, String operator) {
        if (this._sourcePort.setPort(port, operator)) {
            this.setModified();
            return true;
        }
        return false;
    }

    public boolean setSourcePortRange(String lower, String upper) {
        if (this._sourcePort.setRange(lower, upper)) {
            this.setModified();
            return true;
        }
        return false;
    }

    public boolean setSourcePortUpp(String port) {
        if (this._sourcePort.setUpperPort(port)) {
            this.setModified();
            return true;
        }
        return false;
    }

    public String toCLI() {
        StringBuffer tempString = new StringBuffer();
        if (!this._bGrant) {
            tempString.append("deny");
        } else {
            tempString.append("permit");
        }
        tempString.append(" ").append(this._protocol);
        tempString.append(" ").append(this._source.toCLI());
        tempString.append(" ").append(this._sourcePort.toCLI());
        tempString.append(" ").append(this._destAddress.toCLI());
        tempString.append(" ").append(this._destPort.toCLI());
        if (this._dscp != null && this._dscp.length() != 0) {
            tempString.append(" ").append("dscp").append(" ").append(this._dscp);
        }
        if (this._precedence != null && this._precedence.length() != 0) {
            tempString.append(" ").append("precedence").append(" ").append(this._precedence);
        }
        if (this._tos != null && this._tos.length() != 0) {
            tempString.append(" ").append("tos").append(" ").append(this._tos);
        }
        if (this._bLog) {
            tempString.append(" ").append("log");
        }
        if (this._bLogInput) {
            tempString.append(" ").append("log-input");
        }
        if (this._bFragments) {
            tempString.append(" ").append("fragments");
        }
        if (this._timeRange != null && this._timeRange.length() != 0) {
            tempString.append(" ").append("time-range").append(" ").append(this._timeRange);
        }
        if (this._reflectACLName != null && this._reflectACLName.length() != 0) {
            tempString.append(" ").append("reflect").append(" ").append(this._reflectACLName);
        }
        return tempString.toString();
    }

    public String toCLI1() {
        StringBuffer tempString = new StringBuffer();
        boolean flag = false;
        if (!this._bGrant) {
            tempString.append("deny all ");
        } else {
            tempString.append("permit all ");
        }
        tempString.append(this._protocol).append(" traffic");
        tempString.append(" from ").append(this._source.toCLI());
        if (!this._sourcePort.isEmpty()) {
            tempString.append(" port ").append(this._sourcePort.toCLI());
        }
        tempString.append(" to ").append(this._destAddress.toCLI()).append(" ");
        if (!this._destPort.isEmpty()) {
            tempString.append(" port ").append(this._destPort.toCLI()).append(" ");
        }
        if (this._dscp != null && this._dscp.length() != 0) {
            tempString.append("with ").append("dscp").append(" = ").append(this._dscp);
            flag = true;
        }
        if (this._precedence != null && this._precedence.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("precedence").append(" = ").append(this._precedence);
        }
        if (this._tos != null && this._tos.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("tos").append(" = ").append(this._tos);
        }
        if (this._bLog) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("log");
        }
        if (this._bLogInput) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("log-input");
        }
        if (this._bFragments) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("fragments");
        }
        if (this._timeRange != null && this._timeRange.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("time-range").append(" = ").append(this._timeRange);
        }
        if (this._reflectACLName != null && this._reflectACLName.length() != 0) {
            if (flag) {
                tempString.append(", ");
            } else {
                tempString.append("with ");
                flag = true;
            }
            tempString.append("reflect").append(" = ").append(this._reflectACLName);
        }
        return tempString.toString();
    }

    public String toFormatedString() {
        StringBuffer tempString = new StringBuffer();
        if (!this._sourcePort.isEmpty()) {
            tempString.append(this._sourcePort.toCLI()).append("/").append(this._protocol).append(",");
        }
        if (!this._destPort.isEmpty()) {
            tempString.append(this._destPort.toCLI()).append("/").append(this._protocol).append(",");
        }
        if (this._sourcePort.isEmpty() && this._destPort.isEmpty()) {
            tempString.append(this._protocol).append(",");
        }
        if (this._dscp != null && this._dscp.length() != 0) {
            tempString.append(this._dscp).append("/").append("dscp").append(",");
        }
        if (this._precedence != null && this._precedence.length() != 0) {
            tempString.append(this._precedence).append("/").append("precedence").append(",");
        }
        if (this._tos != null && this._tos.length() != 0) {
            tempString.append(this._tos).append("/").append("tos").append(",");
        }
        if (this._bLog) {
            tempString.append("log").append(",");
        }
        if (this._bLogInput) {
            tempString.append("log-input").append(",");
        }
        if (this._bFragments) {
            tempString.append("fragments").append(",");
        }
        if (this._timeRange != null && this._timeRange.length() != 0) {
            tempString.append(this._timeRange).append("/").append("time-range").append(",");
        }
        if (this._reflectACLName != null && this._reflectACLName.length() != 0) {
            tempString.append(this._reflectACLName).append("/").append("reflect").append(",");
        }
        return tempString.toString();
    }
}

