/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.acl;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.acl.ACEIPAddress;
import com.cisco.xdm.data.acl.ACEInterface;
import com.cisco.xdm.data.acl.ACL;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;

public class StandardACE
extends XDMObject
implements ACEInterface,
Cloneable {
    protected boolean _bGrant;
    protected boolean _bLog;
    protected String _strRemark = "";
    protected ACEIPAddress _source;
    protected int _aceType = 0;
    public static final int PASS = 0;
    public static final int BLOCK = 1;
    public static final int NOT_EQUAL = 2;
    public static final int SUBSET = 3;
    public static final int SUPERSET = 4;
    public static final int EQUAL = 5;
    public static final int SUB_BLOCK = 6;
    public static final boolean ACCESS_GRANT = true;
    public static final boolean ACCESS_DENY = false;

    public StandardACE() {
        this._source = new ACEIPAddress();
    }

    public StandardACE(boolean grant, String host) {
        this._bGrant = grant;
        this._source = new ACEIPAddress(host);
    }

    public StandardACE(boolean grant, String source, String wildcardMask) {
        this._bGrant = grant;
        this._source = new ACEIPAddress(source, wildcardMask);
    }

    public Object clone() {
        StandardACE newObj = (StandardACE)super.clone();
        newObj._source = (ACEIPAddress)this._source.clone();
        return newObj;
    }

    public int compare(ACEInterface rule) {
        StandardACE aceRule = (StandardACE)rule;
        if (this._aceType != aceRule._aceType) {
            return 2;
        }
        return this.compare(aceRule);
    }

    protected int compare(StandardACE aceRule) {
        if (this._bLog != aceRule._bLog) {
            return 2;
        }
        int compResult = this._source.compare(aceRule._source);
        if (compResult == 5 || compResult == 4) {
            if (this._bGrant == aceRule._bGrant) {
                return 0;
            }
            return 1;
        }
        if (compResult == 3) {
            if (this._bGrant == aceRule._bGrant) {
                return 3;
            }
            return 6;
        }
        return 2;
    }

    public void copy(ACEInterface ace) {
        if (ace instanceof StandardACE) {
            StandardACE tempAce = (StandardACE)ace;
            this._bGrant = tempAce._bGrant;
            this._bLog = tempAce._bLog;
            this._strRemark = tempAce._strRemark;
            this._source = (ACEIPAddress)tempAce._source.clone();
        }
    }

    protected boolean equals(StandardACE ace) {
        return this._aceType == ace._aceType && this._bLog == ace._bLog && this._bGrant == ace._bGrant && this._strRemark.equals(ace._strRemark) && this._source.equals(ace._source);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            StandardACE ace = (StandardACE)obj;
            return this.equals(ace);
        }
        return false;
    }

    protected CmdValues generateAceCmd() {
        ACL parent = (ACL)this.getParent();
        CmdValues cmdVal = null;
        if (parent.isNamedACL()) {
            cmdVal = !this._bGrant ? new CmdValues("deny") : new CmdValues("permit");
        } else {
            cmdVal = parent.getNewCmd();
            if (!this._bGrant) {
                cmdVal.addValue("ACLAction", "deny");
            } else {
                cmdVal.addValue("ACLAction", "permit");
            }
        }
        if (this.isSourceHost()) {
            cmdVal.addValue("SOURCE-HOST", "host");
            cmdVal.addValue("SOURCE-HOST-ADD", this.getSource());
        } else if (this.isSourceAny()) {
            cmdVal.addValue("SOURCE-ANY", "any");
        } else {
            cmdVal.addValue("SOURCE-ADDRESS", this.getSource());
            cmdVal.addValue("SOURCE-WILDCARD", this.getSourceWildcardMask());
        }
        if (this._bLog) {
            cmdVal.addValue("log", "log");
        }
        return cmdVal;
    }

    public void generateDelta(XDMObject backup, ConfigValues configValues) throws XDMException {
        ACL parent = (ACL)this.getParent();
        if (parent == null) {
            throw new XDMException(101);
        }
        CmdValues cmdVal = this.generateRemarkCmd();
        if (cmdVal != null) {
            configValues.addCmdValues(cmdVal);
        }
        cmdVal = this.generateAceCmd();
        configValues.addCmdValues(cmdVal);
    }

    protected CmdValues generateRemarkCmd() {
        ACL parent = (ACL)this.getParent();
        CmdValues cmdVal = null;
        if (this._strRemark != null && this._strRemark.length() != 0) {
            if (parent.isNamedACL()) {
                cmdVal = new CmdValues("remark");
            } else {
                cmdVal = parent.getNewCmd();
                cmdVal.addValue("remark", "remark");
            }
            cmdVal.addValue("Remark", this._strRemark);
        }
        return cmdVal;
    }

    public int getACEType() {
        return this._aceType;
    }

    public String getDestFormated() {
        return "";
    }

    public String getExtParameters() {
        return "";
    }

    public boolean getGrant() {
        return this._bGrant;
    }

    public boolean getLog() {
        return this._bLog;
    }

    public String getRemark() {
        return this._strRemark;
    }

    public String getService() {
        return "";
    }

    public String getSource() {
        return this._source.getIPAddress();
    }

    public String getSourceFormated() {
        if (this._source != null) {
            return this._source.toFormatedString();
        }
        return null;
    }

    public String getSourceWildcardMask() {
        return this._source.getWildcardMask();
    }

    public boolean isDeepEqual() {
        return true;
    }

    public boolean isDuplicateACE(ACEInterface ace) {
        String tempRemark = this._strRemark;
        this._strRemark = ace.getRemark();
        boolean compResult = this.equals(ace);
        this._strRemark = tempRemark;
        return compResult;
    }

    public boolean isSourceAny() {
        return this._source.isAny();
    }

    public boolean isSourceHost() {
        return this._source.isHost();
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException {
        String grant;
        String cmdName = cmdVal.getCmdName();
        this._bGrant = cmdName.equals("access-list") ? !(grant = cmdVal.getValue("ACLAction")).equals("deny") : !cmdName.equals("deny");
        if (cmdVal.getValue("SOURCE-ANY") != null) {
            this.setSourceAny();
        } else if (cmdVal.getValue("SOURCE-HOST") != null) {
            this.setSourceHost(cmdVal.getValue("SOURCE-HOST-ADD"));
        } else {
            String tempSource = cmdVal.getValue("SOURCE-ADDRESS");
            String tempWildCard = cmdVal.getValue("SOURCE-WILDCARD");
            if (tempWildCard != null) {
                this.setSource(tempSource, tempWildCard);
            } else {
                this.setSourceHost(tempSource);
            }
        }
        this._bLog = cmdVal.getValue("log") != null;
    }

    public void setGrant(boolean grant) {
        this._bGrant = grant;
        this.setModified();
    }

    public void setLog(boolean log) {
        this._bLog = log;
        this.setModified();
    }

    public void setRemark(String remark) {
        this._strRemark = remark;
        this.setModified();
    }

    public void setSource(String source, String wildcardMask) {
        if (source.equals("any")) {
            this.setSourceAny();
        } else if (wildcardMask == null || wildcardMask.length() == 0) {
            this.setSourceHost(source);
        } else {
            this._source.setIPAddress(source, wildcardMask);
        }
        this.setModified();
    }

    public void setSourceAny() {
        this._source.setAny();
        this.setModified();
    }

    public void setSourceHost(String source) {
        this._source.setHost(source);
        this.setModified();
    }

    public String toCLI() {
        StringBuffer tempString = new StringBuffer();
        if (!this._bGrant) {
            tempString.append("deny");
        } else {
            tempString.append("permit");
        }
        tempString.append(" ").append(this._source.toCLI());
        if (this._bLog) {
            tempString.append(" ").append("log");
        }
        return tempString.toString();
    }

    public String toCLI1() {
        StringBuffer tempString = new StringBuffer();
        if (this._bGrant) {
            tempString.append("permit all traffic ");
        } else {
            tempString.append("deny all traffic ");
        }
        tempString.append("from ").append(this._source.toCLI());
        if (this._bLog) {
            tempString.append(" with").append(" log");
        }
        return tempString.toString();
    }

    public String toFormatedString() {
        if (this._bLog) {
            return "log";
        }
        return "";
    }

    public String toString() {
        StringBuffer tempString = new StringBuffer();
        tempString.append(Types.getName(this._aceType)).append("\n");
        tempString.append("Remark: ").append(this._strRemark).append("\n");
        tempString.append(this.toCLI1()).append("\n");
        return tempString.toString();
    }

    public static class Types {
        public static final int STANDARD_ACE = 0;
        public static final int EXTENDED_ACE = 1;
        public static final int EXT_UDP_ACE = 2;
        public static final int EXT_TCP_ACE = 3;
        public static final int EXT_ICMP_ACE = 4;
        public static final int EXT_IGMP_ACE = 5;
        public static final int DYNAMIC_ACE = 6;
        public static final int REFLEX_EVALUATE_ACE = 7;
        static final String[] STRINGNAMES = new String[]{"Standard ACE", "Extended ACE", "Extended UDP ACE", "Extended TCP ACE", "Extended ICMP ACE", "Extended IGMP ACE", "Dynamic ACE", "Evaluate ACE"};

        public static String getName(int index) {
            try {
                return STRINGNAMES[index];
            }
            catch (Exception exception) {
                return "";
            }
        }
    }
}

