/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.atm;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.atm.DslInfo;
import com.cisco.xdm.data.base.DevInfoBase;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.discovery.XDMDiscovery;
import com.cisco.xdm.data.interfaces.Atm;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdServiceException;
import java.util.StringTokenizer;
import java.util.Vector;

public class AdslOverIsdnInfo
extends DslInfo {
    public static String[] OPERATING_MODE = null;
    private String _dslOperatingMode = "auto";
    private boolean _isToneLow = false;
    private static boolean _isToneLowSupported = false;

    public AdslOverIsdnInfo() {
        Log.getLog().debug("AdslOverIsdnInfo() " + this.getClass().getName());
    }

    public AdslOverIsdnInfo(XDMObject parent) {
        super(parent);
        Log.getLog().debug("AdslOverIsdnInfo() " + this.getClass().getName());
    }

    public AdslOverIsdnInfo(XDMObject parent, boolean isReadOnly) {
        super(parent, isReadOnly);
        Log.getLog().debug("AdslOverIsdnInfo() " + this.getClass().getName());
    }

    public Object clone() {
        AdslOverIsdnInfo adslOIsdn = (AdslOverIsdnInfo)super.clone();
        adslOIsdn.setDslOperatingMode(this._dslOperatingMode);
        adslOIsdn.setDslOperatingModeToneLow(this._isToneLow);
        return adslOIsdn;
    }

    private boolean compareStrings(String first, String second) {
        if (first == second && first == null) {
            return true;
        }
        if (first == null) {
            return false;
        }
        return first.equals(second);
    }

    public boolean equals(Object obj) {
        Log.getLog().debug("equals() " + this.getClass().getName());
        if (obj != null && obj.getClass().equals(this.getClass())) {
            AdslOverIsdnInfo dsl = (AdslOverIsdnInfo)obj;
            return this.compareStrings(this._dslOperatingMode, dsl._dslOperatingMode) && this._isToneLow == dsl._isToneLow && super.equals(obj);
        }
        return false;
    }

    private void generateAddCmd(XDMObject backup, ConfigValues cv) throws XDMException {
        Log.getLog().info("generateAddCmd() " + this.getClass().getName());
        CmdValues cmd = null;
        if (this._dslOperatingMode != null && !this.equals(backup)) {
            cmd = new CmdValues("dsl");
            cmd.addValue("operating-mode", "operating-mode");
            cmd.addValue("OMODE", this._dslOperatingMode);
            if (this._isToneLow) {
                cmd.addValue("tone", "tone");
                cmd.addValue("low", "low");
            }
            cmd.setAction(1);
            cv.addCmdValues(cmd);
        }
        Log.getLog().debug("Cmd Values " + this.getClass().getName());
        Log.getLog().debug(cv.toString());
    }

    private void generateChangeCmd(AdslOverIsdnInfo old, ConfigValues cv) throws XDMException {
        Log.getLog().info("generateChangeCmd() " + this.getClass().getName());
        CmdValues cmd = null;
        if (this._dslOperatingMode != null && !this.equals(old)) {
            cmd = new CmdValues("dsl");
            cmd.addOldValue("operating-mode", "operating-mode");
            cmd.addValue("operating-mode", "operating-mode");
            cmd.addValue("OMODE", this._dslOperatingMode);
            cmd.addOldValue("OMODE", old._dslOperatingMode);
            cmd.setAction(3);
            cv.addCmdValues(cmd);
        } else if (this._dslOperatingMode == null && this._dslOperatingMode != old._dslOperatingMode) {
            cmd = new CmdValues("dsl");
            cmd.addValue("operating-mode", "operating-mode");
            cmd.setAction(2);
            cv.addCmdValues(cmd);
        }
        Log.getLog().debug("Cmd Values " + this.getClass().getName());
        Log.getLog().debug(cv.toString());
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        Log.getLog().info("generateDelta() " + this.getClass().getName());
        if (!this.isReadOnly() && this.isModified() && !this.isBackup()) {
            this.generateAddCmd(backup, values);
        }
    }

    public String getDslOperatingMode() {
        return this._dslOperatingMode;
    }

    public boolean getDslOperatingModeToneLow() {
        return this._isToneLow;
    }

    public boolean isResetRequired() {
        AdslOverIsdnInfo obj = (AdslOverIsdnInfo)this.getBackup();
        Log.getLog().debug("OBJ is " + obj);
        if (!this.equals(obj)) {
            return true;
        }
        Log.getLog().debug("isResetRequired(): Returning false");
        return false;
    }

    public boolean isToneLowSupported() {
        return _isToneLowSupported;
    }

    private void parseResponse(String dsllinerate) {
        Log.getLog().debug("DSL Operating Mode Is " + dsllinerate);
        StringTokenizer st = new StringTokenizer(dsllinerate, "\r\n");
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            String nline = st.nextToken().trim();
            if (nline.indexOf("dsl operating-mode") > -1) break;
            int index = nline.indexOf(" ");
            if (index <= 0) continue;
            v.addElement(nline.substring(0, index));
        }
        if (v.size() == 0) {
            return;
        }
        OPERATING_MODE = new String[v.size()];
        v.copyInto(OPERATING_MODE);
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        Log.getLog().info("populate() " + this.getClass().getName());
        Log.getLog().debug("Cmd Values " + this.getClass().getName());
        Log.getLog().debug(config.toString());
        this.populateOperatingMode(((Atm)this.getParent()).getIfID());
        ConfigValues cv = config.getCmds("dsl", "operating-mode", ".*", false);
        if (cv != null) {
            CmdValues cmd = cv.getCmdValues(0);
            this._dslOperatingMode = cmd.getValue("OMODE");
            if (cmd.getValue("tone") != null && cmd.getValue("low") != null) {
                this._isToneLow = true;
            }
            if (this._dslOperatingMode == null) {
                this._dslOperatingMode = cmd.getValue("ADSLMODE");
            }
        }
    }

    private void populateOperatingMode(IfID ifId) {
        if (OPERATING_MODE != null) {
            return;
        }
        String[] cliCommands = new String[]{"interface " + ifId, "dsl operating-mode ?", "interface " + ifId, "dsl operating-mode auto tone low ?"};
        IOSCmdResponse[] response = this.sendConfigCommands(cliCommands);
        if (response == null || response.length < 4) {
            Log.getLog().error("Failed during DSL Operating Mode Discovery");
            return;
        }
        String dsllinerate = response[1].getOutput();
        if (XDMDiscovery.isOKResponse(response[3])) {
            _isToneLowSupported = true;
        }
        this.parseResponse(dsllinerate);
    }

    private IOSCmdResponse[] sendConfigCommands(String[] cliCommands) {
        IOSCmdResponse[] response;
        DevInfoBase deviceInfo = ((DeviceBase)this.getDevice()).getDevInfoBase();
        try {
            response = deviceInfo.getComm().config(cliCommands);
        }
        catch (IOSCmdServiceException ex) {
            Log.getLog().error("Failed during DSL Operating Mode Discovery");
            ex.printStackTrace();
            return null;
        }
        return response;
    }

    public void setDslOperatingMode(String dslOperatingMode) {
        this._dslOperatingMode = dslOperatingMode;
        this.setModified();
    }

    public void setDslOperatingModeToneLow(boolean isToneLow) {
        this._isToneLow = isToneLow;
        this.setModified();
    }

    public String toString() {
        if (!this.isToneLowSupported()) {
            return "\t_dslOperatingMode: " + this._dslOperatingMode;
        }
        return "\t_dslOperatingMode: " + this._dslOperatingMode + "\t_isToneLow: " + this._isToneLow;
    }
}

