/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.authentication;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.authentication.AuthenticationType;
import com.cisco.xdm.data.authentication.CHAPAuthentication;
import com.cisco.xdm.data.authentication.PAPAuthentication;
import com.cisco.xdm.data.authentication.UnsupportedAuthentication;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMHashCollection;
import com.cisco.xdm.data.base.XDMObject;
import java.util.StringTokenizer;

public class PPPAuthentication
extends XDMObject
implements Cloneable {
    private Log _theLog = null;
    private String _protocolNames = null;
    private XDMHashCollection _authentication = null;
    private int _options = 0;
    private String _strReason = null;
    public static int XDM_PPP_CALLIN_OPTION = 1;
    public static int XDM_PPP_CALLOUT_OPTION = 2;
    public static int XDM_PPP_CALLBACK_OPTION = 4;
    public static int XDM_PPP_OPTIONAL = 8;
    public static int XDM_PPP_ONE_TIME = 16;
    public static int XDM_PPP_AUTH_NONE = 0;
    public static int XDM_PPP_AUTH_ENCRYPT = 1;
    public static int XDM_PPP_AUTH_PASSWORD_INCONSISTENT = 2;
    public static int XDM_PPP_AUTH_PASSWORD_MATCH = 3;
    private String _listName = null;
    private String _authorListName = null;
    private int _authStatus = XDM_PPP_AUTH_NONE;

    public PPPAuthentication() {
        this(null);
    }

    public PPPAuthentication(XDMObject parent) {
        super(parent);
        this._theLog = Log.getLog();
        this._authentication = new XDMHashCollection(this);
    }

    public Object clone() {
        PPPAuthentication newObj = (PPPAuthentication)super.clone();
        newObj._authentication = (XDMHashCollection)this._authentication.clone();
        newObj._authentication.setParent(newObj);
        return newObj;
    }

    private String convertOptionsToString(int option) {
        if (option == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if ((option & XDM_PPP_CALLIN_OPTION) == 1) {
            sb.append("?callin?");
        }
        if ((option & XDM_PPP_CALLOUT_OPTION) == 1) {
            sb.append("?callout?");
        }
        if ((option & XDM_PPP_CALLOUT_OPTION) == 1) {
            sb.append("?optional?");
        }
        if ((option & XDM_PPP_ONE_TIME) == 1) {
            sb.append("?one-time?");
        }
        return sb.toString().substring(1, sb.length() - 1);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            PPPAuthentication auth = (PPPAuthentication)obj;
            boolean bAuthEquiv = this._authentication.equals(auth._authentication);
            return bAuthEquiv && this._protocolNames == auth._protocolNames && this._options == auth._options;
        }
        return false;
    }

    private void generateCHAPCmd(PPPAuthentication backupObj, ConfigValues cv) {
        int action;
        CHAPAuthentication oldchap;
        CmdValues subcmdval = null;
        CHAPAuthentication chap = (CHAPAuthentication)this.getProtocol("chap");
        CHAPAuthentication cHAPAuthentication = oldchap = backupObj == null ? null : (CHAPAuthentication)backupObj.getProtocol("chap");
        if (chap != null && oldchap == null) {
            action = 1;
        } else if (chap == null && oldchap != null) {
            action = 2;
        } else if (chap != null && !chap.equals(oldchap)) {
            action = 3;
        } else {
            return;
        }
        switch (action) {
            case 1: {
                if (chap.getHostname() != null) {
                    subcmdval = new CmdValues("ppp");
                    subcmdval.addValue("chap", "chap");
                    subcmdval.addValue("hostname", "hostname");
                    subcmdval.addValue("hostName", chap.getHostname());
                    subcmdval.setAction(action);
                    cv.addCmdValues(subcmdval);
                }
                if (chap.getPassword() == null) break;
                subcmdval = new CmdValues("ppp");
                subcmdval.addValue("chap", "chap");
                subcmdval.addValue("password", "password");
                subcmdval.addValue("chapEncryptionType", Integer.toString(chap.getEncryption()));
                subcmdval.addValue("chapPasswd", chap.getPassword());
                subcmdval.setAction(action);
                cv.addCmdValues(subcmdval);
                break;
            }
            case 2: {
                subcmdval = new CmdValues("ppp");
                subcmdval.addValue("chap", "chap");
                subcmdval.addValue("hostname", "hostname");
                subcmdval.setAction(action);
                cv.addCmdValues(subcmdval);
                subcmdval = new CmdValues("ppp");
                subcmdval.addValue("chap", "chap");
                subcmdval.addValue("password", "password");
                subcmdval.setAction(action);
                cv.addCmdValues(subcmdval);
                break;
            }
            case 3: {
                if (chap.getHostname() != null && !chap.getHostname().equals(oldchap.getHostname())) {
                    subcmdval = new CmdValues("ppp");
                    subcmdval.addValue("chap", "chap");
                    subcmdval.addValue("hostname", "hostname");
                    subcmdval.addOldValue("hostname", "hostname");
                    subcmdval.addValue("hostName", chap.getHostname());
                    subcmdval.addOldValue("hostName", oldchap.getHostname());
                    subcmdval.setAction(action);
                    cv.addCmdValues(subcmdval);
                }
                if (chap.getPassword() == null || chap.getPassword().equals(oldchap.getPassword())) break;
                subcmdval = new CmdValues("ppp");
                subcmdval.addValue("chap", "chap");
                subcmdval.addValue("password", "password");
                subcmdval.addOldValue("password", "password");
                subcmdval.addValue("chapEncryptionType", Integer.toString(chap.getEncryption()));
                subcmdval.addOldValue("chapEncryptionType", Integer.toString(oldchap.getEncryption()));
                subcmdval.addValue("chapPasswd", chap.getPassword());
                subcmdval.addOldValue("chapPasswd", oldchap.getPassword());
                subcmdval.setAction(action);
                cv.addCmdValues(subcmdval);
                break;
            }
        }
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        PPPAuthentication backupPPP = (PPPAuthentication)backup;
        if (!this.isReadOnly() && this.isModified()) {
            this.generatePPPCmd(backupPPP, values);
            this.generatePAPCmd(backupPPP, values);
            this.generateCHAPCmd(backupPPP, values);
            this.setAuthPasswordStatus();
        }
    }

    private void generatePAPCmd(PPPAuthentication backupObj, ConfigValues cv) {
        int action;
        PAPAuthentication oldpap;
        CmdValues subcmdval = new CmdValues("ppp");
        PAPAuthentication pap = (PAPAuthentication)this.getProtocol("pap");
        PAPAuthentication pAPAuthentication = oldpap = backupObj == null ? null : (PAPAuthentication)backupObj.getProtocol("pap");
        if (pap != null && oldpap == null) {
            action = 1;
        } else if (pap == null && oldpap != null) {
            action = 2;
        } else if (pap != null && !pap.equals(oldpap)) {
            action = 3;
        } else {
            return;
        }
        switch (action) {
            case 1: {
                subcmdval.addValue("pap", "pap");
                subcmdval.addValue("sentUserName", pap.getUsername());
                subcmdval.addValue("sent-username", "sent-username");
                subcmdval.addValue("papEncryptionType", Integer.toString(pap.getEncryption()));
                subcmdval.addValue("password", "password");
                subcmdval.addValue("papPasswd", pap.getPassword());
                subcmdval.setAction(action);
                break;
            }
            case 2: {
                subcmdval.addValue("pap", "pap");
                subcmdval.addValue("sent-username", "sent-username");
                subcmdval.setAction(action);
                break;
            }
            case 3: {
                subcmdval.addValue("pap", "pap");
                subcmdval.addOldValue("pap", "pap");
                subcmdval.addValue("sentUserName", pap.getUsername());
                subcmdval.addOldValue("sentUserName", oldpap.getUsername());
                subcmdval.addValue("sent-username", "sent-username");
                subcmdval.addOldValue("sent-username", "sent-username");
                subcmdval.addValue("papEncryptionType", Integer.toString(pap.getEncryption()));
                subcmdval.addOldValue("papEncryptionType", Integer.toString(oldpap.getEncryption()));
                subcmdval.addValue("password", "password");
                subcmdval.addOldValue("password", "password");
                subcmdval.addValue("papPasswd", pap.getPassword());
                subcmdval.addOldValue("papPasswd", oldpap.getPassword());
                subcmdval.setAction(action);
                break;
            }
        }
        if (subcmdval != null) {
            cv.addCmdValues(subcmdval);
        }
    }

    private void generatePPPCmd(PPPAuthentication backupObj, ConfigValues cv) {
        int action;
        if (this._protocolNames != null && backupObj == null) {
            action = 1;
        } else if (this._protocolNames != null && backupObj._protocolNames == null) {
            action = 1;
        } else {
            if (this._protocolNames == null && backupObj == null) {
                return;
            }
            if (this._protocolNames == null && backupObj._protocolNames != null) {
                action = 2;
            } else if (!(this._protocolNames == null || this._protocolNames.equals(backupObj._protocolNames) && this._options == backupObj._options)) {
                action = 3;
            } else {
                return;
            }
        }
        CmdValues cmdval = new CmdValues("ppp");
        switch (action) {
            case 1: {
                cmdval.addValue("authentication", "authentication");
                if (this._protocolNames != null) {
                    cmdval.addValue("protocolNames", this._protocolNames);
                }
                cmdval.addValue("options", this.convertOptionsToString(this._options));
                if (this._listName != null) {
                    cmdval.addValue("listName", this._listName);
                }
                cmdval.setAction(action);
                break;
            }
            case 2: {
                cmdval.addValue("authentication", "authentication");
                cmdval.setAction(action);
                break;
            }
            case 3: {
                cmdval.addValue("authentication", "authentication");
                cmdval.addOldValue("authentication", "authentication");
                cmdval.setAction(action);
                if (this._protocolNames != null) {
                    cmdval.addValue("protocolNames", this._protocolNames);
                }
                if (backupObj._protocolNames != null) {
                    cmdval.addOldValue("protocolNames", backupObj._protocolNames);
                }
                if (this._options != 0) {
                    cmdval.addValue("options", this.convertOptionsToString(this._options));
                }
                if (backupObj._options != 0) {
                    cmdval.addOldValue("options", this.convertOptionsToString(backupObj._options));
                }
                if (this._listName != null) {
                    cmdval.addValue("listName", this._listName);
                }
                if (backupObj._listName == null) break;
                cmdval.addOldValue("listName", backupObj._listName);
                break;
            }
        }
        if (cmdval != null) {
            cv.addCmdValues(cmdval);
        }
    }

    public String getAuthorListName() {
        return this._authorListName;
    }

    public String getListName() {
        return this._listName;
    }

    public int getOptions() {
        return this._options;
    }

    public AuthenticationType getProtocol(String protocolName) {
        AuthenticationType protocol = null;
        if (this._authentication != null) {
            protocol = (AuthenticationType)this._authentication.get(protocolName);
        }
        return protocol;
    }

    public String getProtocolNames() {
        return this._protocolNames;
    }

    public String getUnsupportedReason() {
        return this._strReason;
    }

    public int isAuthPasswordsEqual() {
        return this._authStatus;
    }

    public boolean isDeepEqual() {
        return true;
    }

    public boolean isProtocolSet(String protocol) {
        if (this._protocolNames == null || protocol == null) {
            return false;
        }
        return this._protocolNames.indexOf(protocol) != -1;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        this.populateAuthType(config);
        this.populatePAP(config);
        this.populateCHAP(config);
        this.setAuthPasswordStatus();
    }

    private void populateAuthType(ConfigValues subcmds) throws CliGPBException {
        ConfigValues cv = subcmds.getCmds("ppp", "authentication", ".*", false);
        if (cv == null) {
            return;
        }
        CmdValues cmd = cv.getCmdValues(0);
        this._protocolNames = cmd.getValue("protocolNames");
        this._theLog.debug("ProtocolName = " + this._protocolNames);
        StringTokenizer st = new StringTokenizer(this._protocolNames, "?");
        this._theLog.debug("Tokens = " + st.countTokens());
        int pos = 0;
        while (st.hasMoreTokens()) {
            String protocol = st.nextToken();
            if (protocol.equals("pap")) {
                PAPAuthentication pap = new PAPAuthentication(pos);
                pap.setParent(this._authentication);
                this._authentication.put(protocol, pap);
            } else if (protocol.equals("chap")) {
                CHAPAuthentication chap = new CHAPAuthentication(pos);
                chap.setParent(this._authentication);
                this._authentication.put(protocol, chap);
            } else {
                UnsupportedAuthentication invalidauth = new UnsupportedAuthentication(protocol, pos);
                invalidauth.setParent(this._authentication);
                this._authentication.put(protocol, invalidauth);
                this.setReadOnly(true);
            }
            ++pos;
        }
        this.populateOptions(subcmds);
        String listName = cmd.getValue("listName");
        if (listName != null) {
            this._listName = listName;
            this.setReadOnly(true);
        }
        if ((cv = subcmds.getCmds("ppp", "authorization", ".*", false)) == null) {
            return;
        }
        cmd = cv.getCmdValues(0);
        this._authorListName = cmd.getValue("authorlist");
        this.setReadOnly(true);
    }

    private void populateCHAP(ConfigValues subcmds) throws CliGPBException {
        ConfigValues cv = subcmds.getCmds("ppp", "chap", ".*", false);
        if (cv == null) {
            CHAPAuthentication chap = (CHAPAuthentication)this._authentication.get("chap");
            if (chap != null) {
                this.setReadOnly(true);
            }
            return;
        }
        CmdValues cmd = null;
        CHAPAuthentication chap = (CHAPAuthentication)this.getProtocol("chap");
        if (chap == null) {
            chap = new CHAPAuthentication();
        }
        int i = 0;
        while (i < cv.numCmds()) {
            cmd = cv.getCmdValues(i);
            String hostName = cmd.getValue("hostName");
            String passWord = cmd.getValue("chapPasswd");
            String encryption = cmd.getValue("chapEncryptionType");
            if (hostName != null) {
                chap.setHostname(hostName);
            }
            if (passWord != null) {
                chap.setPassword(passWord);
            }
            if (encryption != null) {
                chap.setEncryption(Integer.parseInt(encryption));
            }
            ++i;
        }
        chap.setParent(this._authentication);
        this._authentication.put("chap", chap);
        PAPAuthentication pap = (PAPAuthentication)this._authentication.get("pap");
        if (pap != null) {
            if (pap.getRelativePos() != 1) {
                this.setReadOnly(true);
            }
            if (pap.getUsername() != null && chap.getHostname() != null && !pap.getUsername().equals(chap.getHostname())) {
                this.setReadOnly(true);
            }
        }
    }

    private void populateOptions(ConfigValues subcmds) throws CliGPBException {
        String oneTime;
        ConfigValues cv = subcmds.getCmds("ppp", "authentication", ".*", false);
        if (cv == null) {
            return;
        }
        CmdValues cmd = cv.getCmdValues(0);
        String options = cmd.getValue("options");
        if (options != null) {
            StringTokenizer st = new StringTokenizer(options, "?");
            this._theLog.debug("Options Tokens = " + st.countTokens());
            while (st.hasMoreTokens()) {
                String option = st.nextToken();
                if (option.equals("callin")) {
                    this._options |= XDM_PPP_CALLIN_OPTION;
                    continue;
                }
                if (option.equals("callback")) {
                    this._options |= XDM_PPP_CALLBACK_OPTION;
                    this.setReadOnly(true);
                    continue;
                }
                if (option.equals("callout")) {
                    this._options |= XDM_PPP_CALLOUT_OPTION;
                    this.setReadOnly(true);
                    continue;
                }
                if (!option.equals("optional")) continue;
                this._options |= XDM_PPP_OPTIONAL;
                this.setReadOnly(true);
            }
        }
        if ((oneTime = cmd.getValue("oneTime")) != null) {
            this._options |= XDM_PPP_ONE_TIME;
            this.setReadOnly(true);
        }
    }

    private void populatePAP(ConfigValues subcmds) throws CliGPBException {
        ConfigValues cv = subcmds.getCmds("ppp", "pap", ".*", false);
        if (cv == null) {
            PAPAuthentication pap = (PAPAuthentication)this._authentication.get("pap");
            if (pap != null) {
                this.setReadOnly(true);
            }
            return;
        }
        CmdValues cmd = cv.getCmdValues(0);
        String userName = cmd.getValue("sentUserName");
        String passWord = cmd.getValue("papPasswd");
        String encryption = cmd.getValue("papEncryptionType");
        PAPAuthentication pap = (PAPAuthentication)this.getProtocol("pap");
        if (pap == null) {
            pap = new PAPAuthentication();
        }
        if (userName != null) {
            pap.setUsername(userName);
        }
        if (passWord != null) {
            pap.setPassword(passWord);
        }
        if (encryption != null) {
            pap.setEncryption(Integer.parseInt(encryption));
        }
        pap.setParent(this._authentication);
        this._authentication.put("pap", pap);
    }

    public AuthenticationType removeProtocol(String protocol) {
        if (protocol == null) {
            return null;
        }
        return (AuthenticationType)this._authentication.remove(protocol);
    }

    public void resetModifiedFlag() {
        super.resetModifiedFlag();
        if (this._authentication != null) {
            this._authentication.resetModifiedFlag();
        }
    }

    private void setAuthPasswordStatus() {
        PAPAuthentication pap = (PAPAuthentication)this.getProtocol("pap");
        CHAPAuthentication chap = (CHAPAuthentication)this.getProtocol("chap");
        this._authStatus = pap == null || chap == null ? XDM_PPP_AUTH_NONE : (pap.getEncryption() > 0 || chap.getEncryption() > 0 ? XDM_PPP_AUTH_ENCRYPT : (pap.getPassword() == null || chap.getPassword() == null ? XDM_PPP_AUTH_PASSWORD_MATCH : (!pap.getPassword().equals(chap.getPassword()) ? XDM_PPP_AUTH_PASSWORD_INCONSISTENT : XDM_PPP_AUTH_PASSWORD_MATCH)));
    }

    public void setCHAP(CHAPAuthentication chap) {
        if (chap != null) {
            this._authentication.put("chap", chap);
            this.setModified();
        } else {
            this.removeProtocol("chap");
            this.setModified();
        }
    }

    public void setListName(String listName) {
        this._listName = listName;
        this.setModified();
    }

    public void setOption(int option) {
        this._options |= option;
    }

    public void setPAP(PAPAuthentication pap) {
        if (pap != null) {
            this._authentication.put("pap", pap);
            this.setModified();
        } else {
            this.removeProtocol("pap");
            this.setModified();
        }
    }

    public void setProtocolNames(String names) {
        this._protocolNames = names == null ? null : names.replace(';', '?');
        this.setModified();
    }

    public void setUnsupportedReason(String reason) {
        this._strReason = reason;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("  protocol NAmes = " + this._protocolNames + "\n");
        sb.append("  ReadOnly = " + this.isReadOnly() + "\n");
        sb.append("  IsModified = " + this.isModified() + "\n");
        sb.append("  Unsupported Reason= " + this._strReason + "\n");
        sb.append("  Option = " + this._options + "\n");
        sb.append("  AuthenticationTypes = " + this._authentication + "\n");
        return sb.toString();
    }
}

