/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.base;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.acl.ACLBase;
import com.cisco.xdm.data.acl.ACLCollection;
import com.cisco.xdm.data.base.CmdPositionHandler;
import com.cisco.xdm.data.base.DevInfoBase;
import com.cisco.xdm.data.base.HWConfig;
import com.cisco.xdm.data.base.ProcessListener;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.bridging.Bridging;
import com.cisco.xdm.data.cbac.CBAC;
import com.cisco.xdm.data.cbac.CBACRule;
import com.cisco.xdm.data.cbac.CBACRuleEntry;
import com.cisco.xdm.data.cbac.appfw.AppFw;
import com.cisco.xdm.data.controllers.Controllers;
import com.cisco.xdm.data.dhcp.DHCPPoolCollection;
import com.cisco.xdm.data.dialer.DialerList;
import com.cisco.xdm.data.dialer.DialerListCollection;
import com.cisco.xdm.data.discovery.XDMDiscovery;
import com.cisco.xdm.data.interfaces.XDMInterface;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.interfaces.XDMInterfaces;
import com.cisco.xdm.data.nat.Nat;
import com.cisco.xdm.data.nat.NatDynamicRule;
import com.cisco.xdm.data.nat.NatRule;
import com.cisco.xdm.data.nat.RouteMap;
import com.cisco.xdm.data.nat.RouteMapCollection;
import com.cisco.xdm.data.nat.RouteMapEntry;
import com.cisco.xdm.data.routing.DynamicRouteColl;
import com.cisco.xdm.data.routing.StaticRouteVector;
import com.cisco.xdm.data.routing.VRFInstanceCollection;
import com.cisco.xdm.data.systemproperties.Line;
import com.cisco.xdm.data.systemproperties.SystemProp;
import com.cisco.xdm.data.vpdn.VPDN;
import com.cisco.xdm.net.cmdsvc.IOSCmdResponse;
import com.cisco.xdm.net.cmdsvc.IOSCmdService;
import com.cisco.xdm.net.cmdsvc.PromptHandlerIf;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringBufferInputStream;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class DeviceBase
extends XDMObject {
    private DeviceBase _backup = null;
    private boolean _isBackup = false;
    private DeviceBase _currentDevice = null;
    private DevInfoBase _devInfo;
    private static final String[] _months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private final String[] strHardWareClockcmd = new String[]{"clock update-calendar "};
    private ConfigValues[] _lastCmds = null;
    public static final int LC_USER_ACCOUNT = 0;
    public static final int LC_NEGATE_IP_ADDR = 1;
    public static final int LC_POINTED_IF = 2;
    private static final int LC_MAX = 2;
    private Hashtable _switchModules = null;
    public static final String OBJ_IFS = "ifs";
    public static final String OBJ_CNTRS = "cntrs";
    public static final String OBJ_NAT = "nat";
    public static final String OBJ_RMAPS = "rmaps";
    public static final String OBJ_ACLS = "acls";
    public static final String OBJ_DHCP = "dhcp";
    public static final String OBJ_SROUTE = "sroute";
    public static final String OBJ_DROUTE = "droute";
    public static final String OBJ_DIALLIST = "dialerlist";
    public static final String OBJ_VPDN = "vpdn";
    public static final String OBJ_CBAC = "cbac";
    public static final String OBJ_APPFW = "appfw";
    public static final String OBJ_SP = "sp";
    public static final String OBJ_BRIDGING = "bridging";
    public static final String OBJ_VRF = "vrf";
    public static final String ACL_USAGE_INBOUND = "<INBOUND>";
    public static final String ACL_USAGE_OUTBOUND = "<OUTBOUND>";
    public static final String ACL_USAGE_ROUTEMAP = "<ROUTEMAP>";
    public static final String ACL_USAGE_CBAC_RULE = "<CBAC>";
    public static final String ACL_USAGE_DIALERLIST = "<DIALERLIST>";
    public static final int FS_NO = 0;
    public static final int FS_OK = 1;
    public static final int FS_OK_SQUEEZE = 2;
    public static final int FS_OK_DEL = 3;
    public static final int FS_OK_SQUEEZE_DEL = 4;
    public static final int FS_ERROR_IOS_RESPONSE = 5;

    public DeviceBase(DevInfoBase info) throws XDMException {
        super(null);
        if (info == null) {
            throw new XDMException(4);
        }
        this._devInfo = info;
        this._isBackup = false;
    }

    protected void addAclUsage(Hashtable usages, String acl, String usage) {
        StringBuffer item = (StringBuffer)usages.get(acl);
        if (item == null) {
            item = new StringBuffer();
            usages.put(acl, item);
        }
        if (item.length() > 0) {
            item.append(", ");
        }
        item.append(usage);
    }

    public void addSwitchModule(int packedValue) {
        Integer v;
        if (this._switchModules == null) {
            this._switchModules = new Hashtable();
        }
        if (this._switchModules.get(v = new Integer(packedValue)) == null) {
            this._switchModules.put(v, v);
        }
    }

    public boolean anyDelta() {
        try {
            ConfigValues config = this.getDeltaConfigValues();
            return config != null && config.numCmds() > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int checkFreeSpace(String loc, String filename, int size) {
        int ret = 0;
        int total = 0;
        int sqTotal = 0;
        int oldFileSize = 0;
        int numFiles = -1;
        String model = this.getDevInfoBase().getModel();
        int MAX_FILE = model.toLowerCase().indexOf("c8") == 0 || model.indexOf("17") == 0 && this.getDevInfoBase().getIOSVersion().indexOf("12.2(13)T") == 0 ? 32 : (this.getDevInfoBase().getIOSVersion().indexOf("12.2") == 0 ? 64 : 256);
        Log log = Log.getLog();
        try {
            StringTokenizer st;
            String cmdVal = "show ";
            if (model.startsWith("72")) {
                cmdVal = "dir ";
            }
            String[] cmd = new String[]{String.valueOf(cmdVal) + loc + ":"};
            IOSCmdService comm = this.getDevInfoBase().getComm();
            IOSCmdResponse[] reply = comm.exec(cmd);
            if (reply == null || reply.length == 0) {
                return 5;
            }
            if (reply[0].getOutput().startsWith("\r\nNo files on device")) {
                return 1;
            }
            log.debug("show flash -- " + reply[reply.length - 1].getOutput());
            BufferedReader bfr = new BufferedReader(new InputStreamReader(new StringBufferInputStream(reply[reply.length - 1].getOutput())));
            String line = null;
            String preLine = null;
            while ((line = bfr.readLine()) != null) {
                if (line.length() > 0 && line.charAt(0) == '[' && preLine != null && preLine.length() > 0) {
                    st = new StringTokenizer(preLine);
                    String token = st.nextToken();
                    numFiles = Integer.valueOf(token);
                    break;
                }
                preLine = line;
            }
            bfr = new BufferedReader(new InputStreamReader(new StringBufferInputStream(reply[0].getOutput())));
            line = bfr.readLine();
            while ((line = bfr.readLine()) != null) {
                String freeSpace;
                if (line.indexOf("bytes available") > 0) {
                    int end = line.indexOf("bytes available");
                    try {
                        total += Integer.valueOf(line.substring(0, end).trim()).intValue();
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                }
                if (line.indexOf("available,") > 0) {
                    int begin = line.indexOf(",");
                    int end = line.indexOf("available,");
                    if (begin >= 0 && end > begin) {
                        freeSpace = line.substring(begin + 1, end).trim();
                        total += Integer.valueOf(freeSpace).intValue();
                    }
                    break;
                }
                if (line.indexOf(" bytes free") > 0) {
                    int begin = line.indexOf("(");
                    if (begin > 0) {
                        int end = line.indexOf(" bytes free");
                        freeSpace = line.substring(begin + 1, end).trim();
                        total += Integer.valueOf(freeSpace).intValue();
                    }
                    break;
                }
                st = new StringTokenizer(line);
                int num = st.countTokens();
                if (num < 3) continue;
                String token = st.nextToken();
                int fsize = 0;
                try {
                    fsize = Integer.valueOf(st.nextToken().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                int i = 0;
                while (i < num - 2) {
                    token = st.nextToken();
                    ++i;
                }
                if (token.equals("[deleted]") && num < 5) {
                    sqTotal += fsize;
                    continue;
                }
                if (!token.equals(filename)) continue;
                oldFileSize = fsize;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 5;
        }
        if (total + sqTotal + oldFileSize > size && numFiles < MAX_FILE) {
            boolean fileExist = oldFileSize > 0;
            boolean squeeze = false;
            if (total < size) {
                String sysType = this.getFileSystemType(loc);
                squeeze = sysType.equals("LEFS");
            }
            ret = fileExist && squeeze ? 4 : (fileExist ? 3 : (squeeze ? 2 : 1));
        } else if (total + sqTotal + oldFileSize > size && numFiles == MAX_FILE && sqTotal > 0) {
            ret = 2;
        }
        return ret;
    }

    private void clearReferences(DeviceBase prevDevice) {
        DeviceBase backup;
        if (prevDevice == null) {
            return;
        }
        if (!prevDevice.isBackup() && (backup = prevDevice.getBackup()) != null) {
            backup.resetClonedObjects();
            Object var2_2 = null;
        }
        prevDevice.resetClonedObjects();
    }

    public Object clone() {
        DeviceBase newObj = (DeviceBase)super.clone();
        if (this._switchModules != null) {
            newObj._switchModules = (Hashtable)this._switchModules.clone();
        }
        return newObj;
    }

    public void commit() {
        if (this.isBackup()) {
            return;
        }
        this._backup = (DeviceBase)this.clone();
        this._backup._isBackup = true;
        this._backup._currentDevice = this;
        this.resetModifiedFlag();
    }

    protected DeviceBase createInstance(DevInfoBase devInfo) {
        DeviceBase newDev = null;
        try {
            newDev = new DeviceBase(devInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newDev;
    }

    public CmdValues createTagCmdValues(String tag) {
        CmdValues cmd = new CmdValues("!");
        cmd.addValue("comment", tag);
        return cmd;
    }

    public DeviceBase discardChanges() {
        DeviceBase prevDevice = this;
        DeviceBase newDev = null;
        if (!this.isBackup()) {
            if (!this.isModified()) {
                newDev = this;
            } else {
                newDev = this._backup;
                newDev._isBackup = false;
                newDev.commit();
                if (prevDevice != newDev && prevDevice != null) {
                    prevDevice.resetClonedObjects();
                    prevDevice = null;
                }
            }
        }
        return newDev;
    }

    public String findLoc4File(String filename, int size, Stack option) {
        if (filename == null || filename.length() == 0 || size <= 0 || option == null) {
            return null;
        }
        String ret = null;
        while (!option.empty()) {
            option.pop();
        }
        try {
            String[] cmd = new String[]{"show file systems | include :"};
            IOSCmdService comm = this.getDevInfoBase().getComm();
            IOSCmdResponse[] resp = comm.exec(cmd);
            Log.getLog().debug("Output of show file system " + resp[0].getOutput());
            BufferedReader bfr = new BufferedReader(new InputStreamReader(new StringBufferInputStream(resp[0].getOutput())));
            String line = bfr.readLine();
            while ((line = bfr.readLine()) != null) {
                int val;
                int s;
                StringTokenizer st;
                if (line.indexOf("-") >= 0 || (st = new StringTokenizer(line)).countTokens() < 5) continue;
                String token = st.nextToken();
                if (token.indexOf("*") == 0) {
                    token = st.nextToken();
                }
                token = st.nextToken();
                token = st.nextToken();
                token = st.nextToken();
                token = st.nextToken();
                if (token.indexOf("nvram:") >= 0 || token.indexOf("bootflash:") >= 0 || (s = token.indexOf(":")) < 0 || (val = this.checkFreeSpace(token = token.substring(0, s), filename, size)) == 0) continue;
                ret = token;
                option.push(new Integer(val));
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public Hashtable getAclUsage() {
        Enumeration en;
        Hashtable usages = new Hashtable();
        String httpAcl = this.getSystemProp().getHttpServerACL();
        if (httpAcl != null && httpAcl.length() > 0) {
            this.addAclUsage(usages, httpAcl, "HTTP");
        }
        Enumeration ev = this.getSystemProp().getVtyLines().elements();
        while (ev.hasMoreElements()) {
            Line line = (Line)ev.nextElement();
            if (line.getAccessClassIn().length() > 0) {
                this.addAclUsage(usages, line.getAccessClassIn(), "line vty " + line.getStart() + " " + line.getEnd() + " " + ACL_USAGE_INBOUND);
            }
            if (line.getAccessClassOut().length() <= 0) continue;
            this.addAclUsage(usages, line.getAccessClassOut(), "line vty " + line.getStart() + " " + line.getEnd() + " " + ACL_USAGE_OUTBOUND);
        }
        Hashtable associations = this.getIfs().getLogicalPhysicalAssociations();
        Enumeration e = this.getIfs().elements();
        while (e.hasMoreElements()) {
            XDMInterface mainIf;
            XDMInterfaceBase item = (XDMInterfaceBase)e.nextElement();
            if (item.getIpAccessGroupIn().length() > 0) {
                this.addAclUsage(usages, item.getIpAccessGroupIn(), String.valueOf(item.getLabel((Vector)associations.get(item.getIfID()))) + " " + ACL_USAGE_INBOUND);
            }
            if (item.getIpAccessGroupOut().length() > 0) {
                this.addAclUsage(usages, item.getIpAccessGroupOut(), String.valueOf(item.getLabel((Vector)associations.get(item.getIfID()))) + " " + ACL_USAGE_OUTBOUND);
            }
            if (!(item instanceof XDMInterface) || !(mainIf = (XDMInterface)item).isSubInterfaceExist()) continue;
            Enumeration es = mainIf.getSubInterfaces().elements();
            while (es.hasMoreElements()) {
                XDMInterfaceBase sitem = (XDMInterfaceBase)es.nextElement();
                if (sitem.getIpAccessGroupIn().length() > 0) {
                    this.addAclUsage(usages, sitem.getIpAccessGroupIn(), String.valueOf(sitem.getIfID().toString()) + " " + ACL_USAGE_INBOUND);
                }
                if (sitem.getIpAccessGroupOut().length() <= 0) continue;
                this.addAclUsage(usages, sitem.getIpAccessGroupOut(), String.valueOf(sitem.getIfID().toString()) + " " + ACL_USAGE_OUTBOUND);
            }
        }
        NatRule[] nats = this.getNAT().getRules();
        int i = 0;
        while (i < nats.length) {
            NatDynamicRule dnat;
            String acl;
            if (nats[i] instanceof NatDynamicRule && (acl = (dnat = (NatDynamicRule)nats[i]).getACL()) != null && acl.length() > 0) {
                this.addAclUsage(usages, acl, "NAT");
            }
            ++i;
        }
        Enumeration rms = this.getRouteMaps().elements();
        while (rms.hasMoreElements()) {
            RouteMap rm = (RouteMap)rms.nextElement();
            Enumeration rmes = rm.elements();
            while (rmes.hasMoreElements()) {
                RouteMapEntry rme = (RouteMapEntry)rmes.nextElement();
                Vector acls = rme.getACLs();
                if (acls == null) continue;
                int i2 = 0;
                while (i2 < acls.size()) {
                    String acl = (String)acls.elementAt(i2);
                    this.addAclUsage(usages, acl, "<ROUTEMAP> " + rme.getName() + " " + rme.getSequenceNumber());
                    ++i2;
                }
            }
        }
        Enumeration enumeration = this.getIfs().elements();
        while (enumeration.hasMoreElements()) {
            XDMInterface mainIf;
            XDMInterfaceBase baseIf = (XDMInterfaceBase)enumeration.nextElement();
            if (baseIf == null) continue;
            String acl = baseIf.getIpUnicastRPFAcl();
            if (acl != null && acl.length() > 0) {
                this.addAclUsage(usages, acl, String.valueOf(baseIf.getIfID().toString()) + " uRPF");
            }
            if (!(baseIf instanceof XDMInterface) || !(mainIf = (XDMInterface)baseIf).isSubInterfaceExist()) continue;
            Enumeration es = mainIf.getSubInterfaces().elements();
            while (es.hasMoreElements()) {
                String acl1;
                XDMInterfaceBase sitem = (XDMInterfaceBase)es.nextElement();
                if (sitem == null || (acl1 = sitem.getIpUnicastRPFAcl()) == null || acl1.length() <= 0) continue;
                this.addAclUsage(usages, acl1, String.valueOf(sitem.getIfID().toString()) + " uRPF");
            }
        }
        if (this._devInfo.isCBAC()) {
            en = this.getCBAC().getCBACRules().elements();
            while (en.hasMoreElements()) {
                String javaList;
                CBACRule cbacRule = (CBACRule)en.nextElement();
                CBACRuleEntry entry = cbacRule.getRuleEntry("http");
                if (entry == null || (javaList = entry.getOption("javalist")) == null) continue;
                this.addAclUsage(usages, javaList, ACL_USAGE_CBAC_RULE + cbacRule.getName());
            }
        }
        en = this.getDialerListCollection().elements();
        while (en.hasMoreElements()) {
            DialerList dl = (DialerList)en.nextElement();
            String acl = dl.getList();
            if (acl == null || acl.trim().length() < 1) continue;
            this.addAclUsage(usages, acl, "<DIALERLIST> " + dl.getGroup());
        }
        return usages;
    }

    public ACLCollection getAcls() {
        return (ACLCollection)this.getObject(OBJ_ACLS);
    }

    public ConfigValues getAllNTPCommands(ConfigValues config) {
        int ret = -1;
        ConfigValues ntpConfigValues = new ConfigValues();
        if (config == null) {
            return ntpConfigValues;
        }
        int size = config.numCmds();
        int i = 0;
        while (i < size) {
            CmdValues cmd = config.getCmdValues(i);
            String name = cmd.getCmdName();
            if (name.equalsIgnoreCase("ntp")) {
                ntpConfigValues.addCmdValues(cmd);
            }
            ++i;
        }
        return ntpConfigValues;
    }

    public ConfigValues getAllnonNTPCommands(ConfigValues config) {
        int ret = -1;
        ConfigValues noNTPConfigValues = new ConfigValues();
        if (config == null) {
            return noNTPConfigValues;
        }
        int size = config.numCmds();
        int i = 0;
        while (i < size) {
            CmdValues cmd = config.getCmdValues(i);
            String name = cmd.getCmdName();
            if (!name.equalsIgnoreCase("ntp")) {
                noNTPConfigValues.addCmdValues(cmd);
            }
            ++i;
        }
        return noNTPConfigValues;
    }

    public AppFw getAppFw() {
        return (AppFw)this.getObject(OBJ_APPFW);
    }

    public DeviceBase getBackup() {
        return this._backup;
    }

    public Bridging getBridging() {
        return (Bridging)this.getObject(OBJ_BRIDGING);
    }

    public CBAC getCBAC() {
        if (this._devInfo.isCBAC()) {
            return (CBAC)this.getObject(OBJ_CBAC);
        }
        return null;
    }

    public Vector getCLIs(ConfigValues cv) throws CliGPBException, XDMException {
        if (cv == null) {
            return null;
        }
        Log log = Log.getLog();
        Vector ret = this._devInfo.getCliBuilder().getClis(cv, false, false);
        if (ret != null) {
            log.debug("Delta CLIs:");
            Enumeration e = ret.elements();
            while (e.hasMoreElements()) {
                log.debug((String)e.nextElement());
            }
        }
        return ret;
    }

    public Vector getCLIs4Preview(ConfigValues cv) throws CliGPBException, XDMException {
        if (cv == null) {
            return null;
        }
        return this._devInfo.getCliBuilder().getClis(cv, false, true);
    }

    private int getCmdCount(CmdValues cmd) {
        int count = 0;
        if (cmd != null) {
            ++count;
            ConfigValues subs = cmd.getModeCmdsValues();
            if (subs != null && subs.numCmds() > 0) {
                int i = 0;
                while (i < subs.numCmds()) {
                    count += this.getCmdCount(subs.getCmdValues(i));
                    ++i;
                }
                ++count;
            }
        }
        return count;
    }

    public Controllers getControllers() {
        return (Controllers)this.getObject(OBJ_CNTRS);
    }

    public DeviceBase getCurrentDevice() {
        if (this.isBackup()) {
            return this._currentDevice;
        }
        return this;
    }

    public GregorianCalendar getDateTime() throws IOException {
        String buf;
        StringTokenizer st;
        GregorianCalendar cal = null;
        String[] timecmd = new String[]{"show clock detail"};
        IOSCmdResponse[] reply = this.getDevInfoBase().getComm().exec(timecmd);
        if (reply != null && reply.length > 0 && (st = new StringTokenizer(buf = reply[0].getOutput())).countTokens() >= 6) {
            int index;
            cal = new GregorianCalendar();
            int month = 0;
            String token = st.nextToken();
            if (token.charAt(index = 0) == '*' || token.charAt(index) == '.') {
                ++index;
            }
            int hour = Integer.valueOf(token.substring(index, index + 2));
            int min = Integer.valueOf(token.substring(index += 3, index + 2));
            int sec = Integer.valueOf(token.substring(index += 3, index + 2));
            token = st.nextToken();
            token = st.nextToken();
            token = st.nextToken();
            int i = 0;
            while (i < 12) {
                if (token.equalsIgnoreCase(_months[i])) {
                    month = i;
                    break;
                }
                ++i;
            }
            token = st.nextToken();
            int day = Integer.valueOf(token);
            token = st.nextToken();
            int year = Integer.valueOf(token);
            cal.set(year, month, day, hour, min, sec);
            buf = buf.trim();
            int firstindex = buf.indexOf("\n");
            int secondindex = buf.indexOf("\n", firstindex + 1);
            if (secondindex < 0) {
                secondindex = buf.length();
            }
            String sClockSource = buf.substring(firstindex + 1, secondindex);
            this.getSystemProp().setTimeSource(sClockSource);
        }
        return cal;
    }

    public Vector getDeltaCLIs() throws CliGPBException, XDMException {
        ConfigValues cv = this.getDeltaConfigValues();
        return this._devInfo.getCliBuilder().getClis(cv, false);
    }

    public ConfigValues getDeltaConfigValues() throws XDMException {
        if (this.isBackup() || this._backup == null) {
            return null;
        }
        ConfigValues cv = new ConfigValues();
        this._lastCmds = null;
        this.preGetDeltaConfigValues(cv);
        if (this.getAcls().isModified()) {
            this.getAcls().generateDelta(this._backup.getAcls(), cv);
        }
        if (this.getSystemProp().isModified()) {
            this.getSystemProp().generateDelta(this._backup.getSystemProp(), cv);
        }
        if (this.getControllers().isModified()) {
            this.getControllers().generateDelta(this._backup.getControllers(), cv);
        }
        if (this.getIfs().isModified()) {
            this.getIfs().generateDelta(this._backup.getIfs(), cv);
        }
        if (this.getRouteMaps().isModified()) {
            this.getRouteMaps().generateDelta(this._backup.getRouteMaps(), cv);
        }
        ConfigValues NTPConfigValues = this.getAllNTPCommands(cv);
        ConfigValues noNTPConfigValues = this.getAllnonNTPCommands(cv);
        if (NTPConfigValues != null && NTPConfigValues.numCmds() > 0 && noNTPConfigValues != null) {
            Log.getLog().debug("NTP Commands present.. So placing the NTP commands in end");
            cv.clearCmdValues();
            int count = 0;
            while (count < noNTPConfigValues.numCmds()) {
                cv.addCmdValues(noNTPConfigValues.getCmdValues(count));
                ++count;
            }
            int count2 = 0;
            while (count2 < NTPConfigValues.numCmds()) {
                cv.addCmdValues(NTPConfigValues.getCmdValues(count2));
                ++count2;
            }
        }
        if (this.getNAT().isModified()) {
            this.getNAT().generateDelta(this._backup.getNAT(), cv);
        }
        if (this.getDhcp().isModified()) {
            this.getDhcp().generateDelta(this._backup.getDhcp(), cv);
        }
        if (this.getStaticRoutes().isModified()) {
            this.getStaticRoutes().generateDelta(this._backup.getStaticRoutes(), cv);
        }
        if (this.getSystemProp().isIpRouting() && this.getDynamicRoutes().isModified()) {
            this.getDynamicRoutes().generateDelta(this._backup.getDynamicRoutes(), cv);
        }
        if (this.getDialerListCollection().isModified()) {
            this.getDialerListCollection().generateDelta(this._backup.getDialerListCollection(), cv);
        }
        if (this.getVPDN().isModified()) {
            this.getVPDN().generateDelta(this._backup.getVPDN(), cv);
        }
        if (this.isCBACExist()) {
            if (this.getCBAC().isModified()) {
                this.getCBAC().generateDelta(this._backup.getCBAC(), cv);
            }
            if (this.getAppFw().isModified()) {
                this.getAppFw().generateDelta(this._backup.getAppFw(), cv);
            }
        }
        if (this.getBridging().isModified()) {
            this.getBridging().generateDelta(this._backup.getBridging(), cv);
        }
        this.postGetDeltaConfigValues(cv);
        if (this._lastCmds != null) {
            boolean tagCreated = false;
            int i = 0;
            while (i <= 2) {
                ConfigValues item = this._lastCmds[i];
                int j = 0;
                while (j < item.numCmds()) {
                    if (!tagCreated) {
                        cv.addCmdValues(this.createTagCmdValues("IP address / user account command"));
                        tagCreated = true;
                    }
                    CmdValues cmd = item.getCmdValues(j);
                    cv.addCmdValues(cmd);
                    ++j;
                }
                ++i;
            }
        }
        return cv;
    }

    public DevInfoBase getDevInfoBase() {
        return this._devInfo;
    }

    public XDMObject getDevice() {
        return this;
    }

    public DHCPPoolCollection getDhcp() {
        return (DHCPPoolCollection)this.getObject(OBJ_DHCP);
    }

    public DialerListCollection getDialerListCollection() {
        return (DialerListCollection)this.getObject(OBJ_DIALLIST);
    }

    public DynamicRouteColl getDynamicRoutes() {
        return (DynamicRouteColl)this.getObject(OBJ_DROUTE);
    }

    public String getFileSystemType(String fileSystem) {
        String ret = null;
        try {
            String[] cmd = new String[]{"show " + fileSystem + ": all"};
            IOSCmdService comm = this.getDevInfoBase().getComm();
            IOSCmdResponse[] resp = comm.exec(cmd);
            Log.getLog().debug("Output of show " + fileSystem + ": all = " + resp[0].getOutput());
            ret = resp[0].getOutput().toLowerCase().indexOf("geometry") != -1 && resp[0].getOutput().toLowerCase().indexOf("format") != -1 ? "DOS" : "LEFS";
            return ret;
        }
        catch (Exception icse) {
            Log.getLog().debug("Exception occcured while determining type of file system" + icse);
            return null;
        }
    }

    public ConfigValues getFilteredConfig(String filter) throws IOException, CliGPBException {
        InputStream in = XDMDiscovery.getFilteredRunningConfig(this._devInfo.getComm(), filter);
        return this._devInfo.getParser().getConfigValues(in);
    }

    public int getFirstCmdPosition(String module, ConfigValues config, boolean noCmd) {
        int ret = -1;
        StringTokenizer st = new StringTokenizer(module);
        int count = st.countTokens();
        if (count <= 0) {
            return ret;
        }
        String key = st.nextToken();
        XDMObject obj = this.getObject(key);
        if (obj != null && obj instanceof CmdPositionHandler) {
            CmdPositionHandler p = (CmdPositionHandler)((Object)obj);
            String subModule = "";
            if (count > 1) {
                subModule = module.substring(key.length() + 1);
            }
            ret = p.getFirstCmdPosition(subModule, config, noCmd);
        }
        return ret;
    }

    public XDMInterfaces getIfs() {
        return (XDMInterfaces)this.getObject(OBJ_IFS);
    }

    public Nat getNAT() {
        return (Nat)this.getObject(OBJ_NAT);
    }

    public XDMObject getObject(String key) {
        XDMObject ret = super.getObject(key);
        if (ret == null) {
            this.initialize(key);
            ret = super.getObject(key);
        }
        return ret;
    }

    public RouteMapCollection getRouteMaps() {
        return (RouteMapCollection)this.getObject(OBJ_RMAPS);
    }

    public StaticRouteVector getStaticRoutes() {
        return (StaticRouteVector)this.getObject(OBJ_SROUTE);
    }

    public int[] getSwitchModules() {
        int[] swmods = null;
        if (this._switchModules == null) {
            swmods = new int[]{};
        } else {
            swmods = new int[this._switchModules.size()];
            int index = 0;
            Enumeration e = this._switchModules.keys();
            while (e.hasMoreElements()) {
                swmods[index++] = (Integer)e.nextElement();
            }
        }
        return swmods;
    }

    public Boolean getSwitchPort(int packedValue) {
        Object obj;
        if (this._switchModules != null && (obj = this._switchModules.get(new Integer(packedValue))) instanceof Boolean) {
            return (Boolean)obj;
        }
        return null;
    }

    public SystemProp getSystemProp() {
        return (SystemProp)this.getObject(OBJ_SP);
    }

    public VPDN getVPDN() {
        return (VPDN)this.getObject(OBJ_VPDN);
    }

    public VRFInstanceCollection getVRFInstances() {
        return (VRFInstanceCollection)this.getObject(OBJ_VRF);
    }

    public boolean initGetConfig(ProcessListener listener) throws IOException, XDMException, CliGPBException {
        if (this._backup != null || this._isBackup) {
            return false;
        }
        ConfigValues config = this.retrieveConfig(listener, true);
        if (config == null) {
            throw new XDMException(22);
        }
        this.populate(config, listener);
        return true;
    }

    protected void initialize(String key) {
        if (key.equals(OBJ_SP)) {
            this.addObject(OBJ_SP, new SystemProp(this));
        } else if (key.equals(OBJ_IFS)) {
            this.addObject(OBJ_IFS, new XDMInterfaces(this));
        } else if (key.equals(OBJ_CNTRS)) {
            this.addObject(OBJ_CNTRS, new Controllers(this));
        } else if (key.equals(OBJ_NAT)) {
            this.addObject(OBJ_NAT, new Nat(this));
        } else if (key.equals(OBJ_RMAPS)) {
            this.addObject(OBJ_RMAPS, new RouteMapCollection(this));
        } else if (key.equals(OBJ_ACLS)) {
            this.addObject(OBJ_ACLS, new ACLCollection(this));
        } else if (key.equals(OBJ_DHCP)) {
            this.addObject(OBJ_DHCP, new DHCPPoolCollection(this));
        } else if (key.equals(OBJ_SROUTE)) {
            this.addObject(OBJ_SROUTE, new StaticRouteVector(this));
        } else if (key.equals(OBJ_DROUTE)) {
            this.addObject(OBJ_DROUTE, new DynamicRouteColl(this));
        } else if (key.equals(OBJ_DIALLIST)) {
            this.addObject(OBJ_DIALLIST, new DialerListCollection(this));
        } else if (key.equals(OBJ_VPDN)) {
            this.addObject(OBJ_VPDN, new VPDN(this));
        } else if (key.equals(OBJ_BRIDGING)) {
            this.addObject(OBJ_BRIDGING, new Bridging(this));
        } else if (key.equals(OBJ_CBAC)) {
            if (this._devInfo.isCBAC()) {
                this.addObject(OBJ_CBAC, new CBAC(this));
            }
        } else if (key.equals(OBJ_APPFW)) {
            if (this._devInfo.isCBAC()) {
                this.addObject(OBJ_APPFW, new AppFw(this));
            }
        } else if (key.equals(OBJ_VRF)) {
            this.addObject(OBJ_VRF, new VRFInstanceCollection(this));
        }
    }

    public boolean isBackup() {
        return this._isBackup;
    }

    public boolean isCBACExist() {
        return this._devInfo.isCBAC();
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        this.populate(config, (ProcessListener)null);
    }

    public void populate(ConfigValues config, ProcessListener listener) throws XDMException, CliGPBException {
        if (this.isBackup()) {
            return;
        }
        ConfigValues ifCVs = config.getCmds("interface", "ifname", ".*", false);
        Vector<String> ifNames = new Vector<String>();
        if (ifCVs != null) {
            int i = 0;
            while (i < ifCVs.numCmds()) {
                CmdValues cmd = ifCVs.getCmdValues(i);
                String str = cmd.getValue("ifname");
                if (str != null && str.length() > 0) {
                    ifNames.addElement(str);
                }
                ++i;
            }
        }
        HWConfig hw = this.getDevInfoBase().getHWConfig();
        hw.setIfNames(ifNames);
        ConfigValues cCVs = config.getCmds("controller", "type", ".*", false);
        Vector<String> cNames = new Vector<String>();
        if (cCVs != null) {
            int i = 0;
            while (i < cCVs.numCmds()) {
                CmdValues cmd = cCVs.getCmdValues(i);
                String str = cmd.getValue("type");
                String loc = cmd.getValue("location");
                if (str != null && str.length() > 0 && loc != null && loc.length() > 0) {
                    cNames.addElement(String.valueOf(str) + " " + loc);
                }
                ++i;
            }
        }
        hw.setCNames(cNames);
        Log log = Log.getLog();
        if (listener != null) {
            listener.notify(5, 3);
        } else {
            log.debug("Device: populate ACL");
        }
        try {
            this.getAcls().populate(config, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (listener != null) {
            listener.notify(5, 9);
        } else {
            log.debug("Device: populate Route Map");
        }
        try {
            this.getRouteMaps().populate(config, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (listener != null) {
            listener.notify(5, 1);
        } else {
            log.debug("Device: populate systemProp");
        }
        try {
            this.getSystemProp().populate(config, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (listener != null) {
            listener.notify(5, 2);
        } else {
            log.debug("Device: populate interfaces");
        }
        try {
            this.getControllers().populate(config, null);
            this.getIfs().populate(config, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (listener != null) {
            listener.notify(5, 5);
        } else {
            log.debug("Device: populate DHCP");
        }
        try {
            this.getDhcp().populate(config, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (listener != null) {
            listener.notify(5, 4);
        } else {
            log.debug("Device: populate nat");
        }
        try {
            this.getNAT().populate(config, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (listener != null) {
            listener.notify(5, 6);
        } else {
            log.debug("Device: populate Static Routing");
        }
        try {
            this.getStaticRoutes().populate(config, null);
            this.getVRFInstances().populate(config, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.getSystemProp().isIpRouting()) {
            try {
                this.getDynamicRoutes().populate(config, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this.getDialerListCollection().populate(config, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.getVPDN().populate(config, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.isCBACExist()) {
            if (listener != null) {
                listener.notify(5, 8);
            } else {
                log.debug("Device: populate CBAC");
            }
            try {
                this.getCBAC().populate(config, null);
                this.getAppFw().populate(config, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (listener != null) {
            listener.notify(5, 12);
        } else {
            log.debug("Device: populate bridging");
        }
        try {
            this.getBridging().populate(config, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.populateEx(config, listener);
        this.commit();
    }

    protected void populateEx(ConfigValues config, ProcessListener listener) throws XDMException, CliGPBException {
    }

    protected void postGetDeltaConfigValues(ConfigValues cv) throws XDMException {
    }

    protected void preGetDeltaConfigValues(ConfigValues cv) throws XDMException {
    }

    public DeviceBase refresh(ProcessListener listener) throws IOException, XDMException, CliGPBException {
        DeviceBase prevDevice = this;
        HWConfig newHW = XDMDiscovery.getHWConfig(this._devInfo.getComm(), this._devInfo.getModel());
        if (newHW == null) {
            throw new XDMException(6);
        }
        if (this._devInfo.getProcessor().equalsIgnoreCase("NPE-G1") || this._devInfo.getProcessor().equalsIgnoreCase("NPE-G2")) {
            int i = 0;
            while (i < 3) {
                newHW._ifs.addElement(new Integer(4));
                ++i;
            }
        }
        this._devInfo.setHWConfig(newHW);
        DeviceBase newDev = this.createInstance(this._devInfo);
        ConfigValues config = newDev.retrieveConfig(listener, false);
        newDev.populate(config, listener);
        this.clearReferences(prevDevice);
        return newDev;
    }

    private ConfigValues retrieveConfig(ProcessListener listener, boolean initial) throws IOException, CliGPBException {
        Log log = Log.getLog();
        if (listener != null) {
            listener.notify(4, 0);
        } else {
            log.debug("Device: get running config");
        }
        int oldTimeout = this._devInfo.getComm().getTimeout();
        this._devInfo.getComm().setTimeout(120000);
        InputStream in = XDMDiscovery.getRunningConfig(this._devInfo.getComm());
        this._devInfo.getComm().setTimeout(oldTimeout);
        if (in.available() > 256000 && initial) {
            return null;
        }
        ConfigValues cv = this._devInfo.getParser().getConfigValues(in);
        return cv;
    }

    public void setACLAccessCategory(String aclNew, String aclOld) {
        ACLBase acl;
        if (aclOld != null && aclOld.length() > 0 && (acl = this.getAcls().getACL(aclOld)) != null) {
            XDMInterfaces ifs = this.getIfs();
            Vector users = ifs.getIfs(0, aclOld);
            boolean found = this.getSystemProp().isUsingACL(aclOld);
            if (users.size() == 0 && !found && (acl.isBelongTo(5) || acl.isBelongTo(4))) {
                acl.deleteFromCategory(1);
            }
        }
        if (aclNew != null && aclNew.length() > 0 && (acl = this.getAcls().getACL(aclNew)) != null) {
            acl.addToCategory(1);
        }
    }

    public void setDateTime(int hour, int min, int sec, int month, int day, int year, String timezone, int offsetHour, int offsetMin) throws IOException {
        StringBuffer sb = new StringBuffer();
        if (timezone != null && timezone.length() > 0) {
            sb.append("clock timezone ");
            sb.append(timezone);
            sb.append(" ");
            sb.append(offsetHour);
            sb.append(" ");
            sb.append(offsetMin);
            String[] zonecmd = new String[]{sb.toString()};
            this.getDevInfoBase().getComm().config(zonecmd);
            this.getSystemProp().setTimezone(timezone, offsetHour, offsetMin);
        }
        StringBuffer time = new StringBuffer();
        time.append("clock set " + hour + ":" + min + ":" + sec + " ");
        time.append(String.valueOf(day) + " " + _months[month] + " " + year);
        String[] timecmd = new String[]{time.toString()};
        this.getDevInfoBase().getComm().exec(timecmd);
        if (this.getSystemProp().isHardwareClockSupported()) {
            try {
                this.getDevInfoBase().getComm().exec(this.strHardWareClockcmd);
            }
            catch (Exception exception) {}
        }
        this.getSystemProp().setTimezone(timezone, offsetHour, offsetMin);
    }

    public void setLastCmd(int type, CmdValues cmd) {
        if (type < 0 || type > 2) {
            return;
        }
        DeviceBase dev = null;
        dev = this.isBackup() ? this._currentDevice : this;
        if (cmd != null) {
            if (dev._lastCmds == null) {
                dev._lastCmds = new ConfigValues[3];
                int i = 0;
                while (i <= 2) {
                    dev._lastCmds[i] = new ConfigValues();
                    ++i;
                }
            }
            dev._lastCmds[type].addCmdValues(cmd);
        }
    }

    public void setSwitchPort(int packedValue, boolean b) {
        if (this._switchModules != null) {
            this._switchModules.put(new Integer(packedValue), new Boolean(b));
        }
    }

    public void squeezeFlash() throws Exception {
        IOSCmdService comm = this.getDevInfoBase().getComm();
        int curTimeout = comm.getTimeout();
        comm.setTimeout(1200000);
        IOSCmdResponse[] reply = this.getDevInfoBase().getComm().exec(new String[]{"squeeze flash:"}, new PromptHandlerIf(){

            public String handle(String[] devOutput) {
                if (devOutput[devOutput.length - 1].toLowerCase().indexOf("[confirm]") > -1) {
                    return "\r\n";
                }
                return null;
            }
        });
        comm.setTimeout(curTimeout);
        if (reply == null || reply.length == 0) {
            throw new XDMException(18);
        }
        String output = reply[reply.length - 1].getOutput();
        if (output.indexOf("%Error squeez") >= 0) {
            throw new XDMException(19);
        }
    }
}

