/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.base;

import com.cisco.xdm.data.discovery.ControllerType;
import com.cisco.xdm.data.discovery.HWDictionary;
import com.cisco.xdm.data.discovery.HWEntity;
import com.cisco.xdm.data.discovery.IfType;
import java.util.Stack;
import java.util.Vector;

public class HWCompConfig {
    private int _type;
    private String _key;
    private int _pos;
    public Vector _components = new Vector();
    public Vector _ifs = new Vector();
    public Vector _controllers = new Vector();

    public HWCompConfig() {
        this._key = null;
        this._pos = 0;
        this._type = 0;
    }

    public HWCompConfig(int type, String key, int pos) {
        this._key = key;
        this._pos = pos;
        this._type = type;
    }

    protected boolean findHW(String word, int port, Stack start, Vector hw) {
        if (start == null || start.empty() || hw == null) {
            return false;
        }
        HWDictionary dict = HWDictionary.GetInstance();
        int pos = (Integer)start.pop();
        int i = 0;
        while (i < this._ifs.size()) {
            String phrase = dict.getif((Integer)this._ifs.elementAt(i)).getPhrase();
            if (word.equalsIgnoreCase(phrase) && ++pos == port) {
                hw.addElement(this);
                return true;
            }
            ++i;
        }
        boolean ret = false;
        start.push(new Integer(pos));
        int i2 = 0;
        while (i2 < this._components.size()) {
            HWCompConfig comp = (HWCompConfig)this._components.elementAt(i2);
            if (comp.findHW(word, port, start, hw)) {
                hw.addElement(this);
                ret = true;
                break;
            }
            ++i2;
        }
        return ret;
    }

    protected int findHWControllerTypeFromDict(String phrase, int port, Stack start, boolean recursive) {
        int ret = 2000;
        if (start == null || start.empty()) {
            return ret;
        }
        HWDictionary dict = HWDictionary.GetInstance();
        int pos = (Integer)start.pop();
        int i = 0;
        while (i < this._controllers.size()) {
            int type = (Integer)this._controllers.elementAt(i);
            ControllerType cType = dict.getController(type);
            if (cType != null && cType.getPhrase().equalsIgnoreCase(phrase) && ++pos == port) {
                return type;
            }
            ++i;
        }
        if (recursive) {
            start.push(new Integer(pos));
            int i2 = 0;
            while (i2 < this._components.size()) {
                HWCompConfig comp = (HWCompConfig)this._components.elementAt(i2);
                ret = comp.findHWControllerTypeFromDict(phrase, port, start, recursive);
                if (ret != 2000) break;
                ++i2;
            }
        }
        return ret;
    }

    protected int findHWIfTypeFromDict(String phrase, int port, Stack start, boolean recursive) {
        int ret = 0;
        if (start == null || start.empty()) {
            return ret;
        }
        HWDictionary dict = HWDictionary.GetInstance();
        int pos = (Integer)start.pop();
        int i = 0;
        while (i < this._ifs.size()) {
            int type = (Integer)this._ifs.elementAt(i);
            IfType ifType = dict.getif(type);
            if (ifType != null && ifType.getPhrase().equalsIgnoreCase(phrase) && ++pos == port) {
                return type;
            }
            ++i;
        }
        if (recursive) {
            start.push(new Integer(pos));
            int i2 = 0;
            while (i2 < this._components.size()) {
                HWCompConfig comp = (HWCompConfig)this._components.elementAt(i2);
                ret = comp.findHWIfTypeFromDict(phrase, port, start, recursive);
                if (ret != 0) break;
                ++i2;
            }
        }
        return ret;
    }

    public String getKey() {
        return this._key;
    }

    public String getLabel() {
        HWDictionary dict = HWDictionary.GetInstance();
        String label = null;
        HWEntity entity = null;
        switch (this._type) {
            case 0: {
                entity = dict.getDevice(this._key);
                break;
            }
            case 1: {
                entity = dict.getNM(this._key);
                break;
            }
            case 2: {
                entity = dict.getWIC(this._key);
                break;
            }
        }
        if (entity != null) {
            label = entity.getLabel();
        }
        return label;
    }

    public String getName() {
        HWDictionary dict = HWDictionary.GetInstance();
        String name = null;
        HWEntity entity = null;
        switch (this._type) {
            case 0: {
                entity = dict.getDevice(this._key);
                break;
            }
            case 1: {
                entity = dict.getNM(this._key);
                break;
            }
            case 2: {
                entity = dict.getWIC(this._key);
                break;
            }
        }
        if (entity != null) {
            name = entity.getName();
        }
        return name;
    }

    public int getPos() {
        return this._pos;
    }

    public int getType() {
        return this._type;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("HWConfig=> type: " + this._type);
        sb.append("\tkey: " + this._key);
        sb.append("\tname: " + this.getName());
        sb.append("\tpos: " + this._pos);
        sb.append("\tlabel: " + this.getLabel());
        if (this._ifs.size() > 0) {
            sb.append("\tinterfaces: " + this._ifs.toString());
        }
        if (this._components.size() > 0) {
            sb.append("\t {component: " + this._components.toString() + "}");
        }
        return sb.toString();
    }
}

