/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.base;

import com.cisco.xdm.data.base.HWCompConfig;
import com.cisco.xdm.data.discovery.HWDevice;
import com.cisco.xdm.data.discovery.HWDictionary;
import com.cisco.xdm.data.discovery.IfType;
import com.cisco.xdm.parser.InterfaceParser;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class HWConfig
extends HWCompConfig {
    private Vector _ifNames = null;
    private Vector _cNames = null;
    public Vector _AIMs = new Vector();
    private int _mainboardSlot = -1;

    public HWConfig(String model) {
        super(0, model, 0);
    }

    public boolean findController(String type, int slot, int mslot, int port) {
        StringBuffer sb = new StringBuffer(type);
        sb.append(" ");
        if (slot >= 0) {
            sb.append(String.valueOf(slot) + "/");
            if (mslot >= 0) {
                sb.append(String.valueOf(mslot) + "/");
            }
        }
        sb.append(port);
        String word = sb.toString();
        Enumeration e = this.getCNames();
        while (e.hasMoreElements()) {
            String ifName = (String)e.nextElement();
            if (ifName.compareTo(word) != 0) continue;
            return true;
        }
        return false;
    }

    public int findHWControllerType(String phrase, int port) {
        int index = this.getControllerIndexInSlot(phrase, -1, port);
        Stack<Integer> start = new Stack<Integer>();
        start.push(new Integer(-1));
        return this.findHWControllerTypeFromDict(phrase, index, start, true);
    }

    public int findHWControllerType(String phrase, int component, int sub_component, int port) {
        int ret = 2000;
        boolean withSubModule = this.getFlag("ifNumbering3");
        Stack<Integer> start = new Stack<Integer>();
        start.push(new Integer(-1));
        if (withSubModule) {
            int i = 0;
            while (i < this._components.size()) {
                HWCompConfig comp = (HWCompConfig)this._components.elementAt(i);
                if (comp.getPos() == component) {
                    if (sub_component < 0) {
                        return comp.findHWControllerTypeFromDict(phrase, port, start, false);
                    }
                    Vector sub_comps = comp._components;
                    int j = 0;
                    while (j < sub_comps.size()) {
                        HWCompConfig subComp = (HWCompConfig)sub_comps.elementAt(j);
                        if (subComp.getPos() == sub_component) {
                            return subComp.findHWControllerTypeFromDict(phrase, port, start, false);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } else {
            Vector comps;
            int index = this.getControllerIndexInSlot(phrase, component, port);
            HWDictionary dict = HWDictionary.GetInstance();
            HWDevice hwDev = (HWDevice)dict.getDevice(this.getKey());
            if (hwDev.isMainboardOnlyDevice()) {
                if (component == -1) {
                    return this.findHWControllerTypeFromDict(phrase, index, start, true);
                }
                HWCompConfig mb = (HWCompConfig)this._components.elementAt(0);
                comps = mb._components;
            } else {
                comps = this._components;
            }
            int i = 0;
            while (i < comps.size()) {
                HWCompConfig comp = (HWCompConfig)comps.elementAt(i);
                if (comp.getPos() == component) {
                    ret = comp.findHWControllerTypeFromDict(phrase, index, start, true);
                }
                ++i;
            }
        }
        return ret;
    }

    public int findHWIfType(String phrase, int port) {
        int index = this.getIndexInSlot(phrase, -1, port);
        Stack<Integer> start = new Stack<Integer>();
        start.push(new Integer(-1));
        return this.findHWIfTypeFromDict(phrase, index, start, true);
    }

    public int findHWIfType(String phrase, int component, int sub_component, int port) {
        if (component < 0) {
            return 0;
        }
        int ret = 0;
        boolean withSubModule = this.getFlag("ifNumbering3");
        if (withSubModule) {
            Stack<Integer> start = new Stack<Integer>();
            start.push(new Integer(-1));
            int i = 0;
            while (i < this._components.size()) {
                HWCompConfig comp = (HWCompConfig)this._components.elementAt(i);
                if (comp.getPos() == component) {
                    if (sub_component < 0) {
                        return comp.findHWIfTypeFromDict(phrase, port, start, false);
                    }
                    Vector sub_comps = comp._components;
                    int j = 0;
                    while (j < sub_comps.size()) {
                        HWCompConfig subComp = (HWCompConfig)sub_comps.elementAt(j);
                        if (subComp.getPos() == sub_component) {
                            return subComp.findHWIfTypeFromDict(phrase, port, start, false);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } else {
            Vector comps;
            int pos = -1;
            int index = this.getIndexInSlot(phrase, component, port);
            HWDictionary dict = HWDictionary.GetInstance();
            HWDevice hwDev = (HWDevice)dict.getDevice(this.getKey());
            if (component == 0) {
                int i = 0;
                while (i < this._ifs.size()) {
                    int type = (Integer)this._ifs.elementAt(i);
                    IfType ifType = dict.getif(type);
                    if (ifType != null && ifType.getPhrase().equalsIgnoreCase(phrase) && ++pos == index) {
                        return type;
                    }
                    ++i;
                }
            }
            if (hwDev.isMainboardOnlyDevice()) {
                HWCompConfig mb = (HWCompConfig)this._components.elementAt(0);
                if (component == 0) {
                    int i = 0;
                    while (i < mb._ifs.size()) {
                        int type = (Integer)mb._ifs.elementAt(i);
                        IfType ifType = dict.getif(type);
                        if (ifType != null && ifType.getPhrase().equalsIgnoreCase(phrase) && ++pos == index) {
                            return type;
                        }
                        ++i;
                    }
                }
                comps = mb._components;
            } else {
                comps = this._components;
            }
            Stack<Integer> start = new Stack<Integer>();
            start.push(new Integer(pos));
            int i = 0;
            while (i < comps.size()) {
                HWCompConfig comp = (HWCompConfig)comps.elementAt(i);
                if (comp.getPos() == component) {
                    ret = comp.findHWIfTypeFromDict(phrase, index, start, true);
                }
                ++i;
            }
        }
        return ret;
    }

    public Enumeration getCNames() {
        return this._cNames.elements();
    }

    public int getControllerIndexInSlot(String word, int component, int port) {
        int ret = 0;
        Enumeration e = this.getCNames();
        while (e.hasMoreElements()) {
            int loc;
            String cName = (String)e.nextElement();
            StringTokenizer st = new StringTokenizer(cName, " /");
            String type = st.nextToken();
            int slot = -1;
            if (st.countTokens() == 3) {
                slot = Integer.valueOf(st.nextToken());
                loc = Integer.valueOf(st.nextToken());
            } else {
                if (st.countTokens() != 2) continue;
                loc = Integer.valueOf(st.nextToken());
            }
            if (word.compareTo(type) != 0 || slot != component) continue;
            if (port == loc) {
                return ret;
            }
            ++ret;
        }
        return ret;
    }

    public boolean getFlag(String flag) {
        HWDictionary dict = HWDictionary.GetInstance();
        HWDevice hwDev = (HWDevice)dict.getDevice(this.getKey());
        String val = hwDev.getAttr(flag);
        return val != null && val.length() != 0 && val.equalsIgnoreCase("yes");
    }

    public Vector getHardwares(int type, int component, int port) {
        Vector comps;
        Vector<HWCompConfig> hw = new Vector<HWCompConfig>();
        int pos = -1;
        HWDictionary dict = HWDictionary.GetInstance();
        HWDevice hwDev = (HWDevice)dict.getDevice(this.getKey());
        IfType iftype = dict.getif(type);
        if (iftype == null) {
            return hw;
        }
        String word = iftype.getPhrase();
        if (hwDev.isMainboardOnlyDevice()) {
            HWCompConfig mb = (HWCompConfig)this._components.elementAt(0);
            int i = 0;
            while (i < mb._ifs.size()) {
                String phrase = dict.getif((Integer)mb._ifs.elementAt(i)).getPhrase();
                if (word.equalsIgnoreCase(phrase) && ++pos == port) {
                    hw.addElement(mb);
                    return hw;
                }
                ++i;
            }
            comps = mb._components;
        } else {
            comps = this._components;
        }
        Stack<Integer> start = new Stack<Integer>();
        int index = this.getIndexInSlot(word, component, port);
        start.push(new Integer(pos));
        int i = 0;
        while (i < comps.size()) {
            HWCompConfig comp = (HWCompConfig)comps.elementAt(i);
            if ((comp.getPos() == component || component == 0) && comp.findHW(word, index, start, hw)) break;
            ++i;
        }
        return hw;
    }

    public Enumeration getIfNames() {
        return this._ifNames.elements();
    }

    public int getIndexInSlot(String word, int component, int port) {
        int ret = 0;
        Enumeration e = this.getIfNames();
        while (e.hasMoreElements()) {
            String ifName = (String)e.nextElement();
            Hashtable ifRes = InterfaceParser.parseInterface(ifName);
            int slot = -1;
            if (component != -1 && ifRes.containsKey("part1")) {
                slot = Integer.valueOf((String)ifRes.get("part0"));
            }
            int port_num = ifRes.containsKey("part1") ? Integer.valueOf((String)ifRes.get("part1")).intValue() : Integer.valueOf((String)ifRes.get("part0")).intValue();
            if (slot != component || word.compareTo((String)ifRes.get("type")) != 0 || ifRes.containsKey("timeslot") || ifRes.containsKey("subinterface") || word.equalsIgnoreCase("atm") && this.findController("DSL", component, -1, port_num)) continue;
            if (port == port_num) {
                return ret;
            }
            ++ret;
        }
        return ret;
    }

    public int getMainboarSlot() {
        return this._mainboardSlot;
    }

    void setCNames(Vector cNames) {
        this._cNames = cNames;
    }

    void setIfNames(Vector ifNames) {
        this._ifNames = ifNames;
    }

    public void setMainboardSlot(int slot) {
        this._mainboardSlot = slot;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append("mainboard=> " + this._mainboardSlot);
        sb.append("AIM=> " + this._AIMs.toString());
        return sb.toString();
    }
}

