/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.base;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.commonutils.MiscUtils;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import java.util.Enumeration;
import java.util.Hashtable;

public class XDMHashCollection
extends XDMObject {
    protected Hashtable _hashTable = new Hashtable();

    public XDMHashCollection() {
    }

    public XDMHashCollection(XDMObject parent) {
        super(parent);
    }

    public XDMHashCollection(XDMObject parent, boolean isReadOnly) {
        super(parent, isReadOnly);
    }

    public synchronized void clear() {
        if (this._hashTable.size() > 0) {
            Enumeration e = this._hashTable.elements();
            while (e.hasMoreElements()) {
                XDMObject obj = (XDMObject)e.nextElement();
                if (!obj.isReadOnly()) continue;
                return;
            }
            this.setModified();
            this._hashTable.clear();
        }
    }

    public Object clone() {
        XDMHashCollection newColl = (XDMHashCollection)super.clone();
        newColl._hashTable = new Hashtable();
        Enumeration e = this._hashTable.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            XDMObject obj = this.get(key);
            XDMObject newElem = (XDMObject)obj.clone();
            newElem.setParent(newColl);
            newColl.put(key, newElem);
        }
        return newColl;
    }

    public synchronized boolean contains(XDMObject value) {
        return this._hashTable.contains(value);
    }

    public synchronized boolean containsKey(Object key) {
        return this._hashTable.containsKey(key);
    }

    public synchronized Enumeration elements() {
        return this._hashTable.elements();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof XDMHashCollection)) {
            return false;
        }
        XDMHashCollection coll = (XDMHashCollection)obj;
        return MiscUtils.hashtableEquals(this._hashTable, coll._hashTable);
    }

    public void generateAddModifyDelta(XDMObject backup, ConfigValues values) throws XDMException {
        if (backup != null && !(backup instanceof XDMHashCollection)) {
            throw new XDMException(3, this);
        }
        XDMHashCollection backupColl = null;
        if (backup != null) {
            backupColl = (XDMHashCollection)backup;
        }
        Enumeration e = this._hashTable.keys();
        while (e.hasMoreElements()) {
            XDMObject curObj;
            Object key = e.nextElement();
            XDMObject backupObj = null;
            if (backupColl != null) {
                backupObj = backupColl.get(key);
            }
            if ((curObj = this.get(key)).isReadOnly() || backupObj != null && (backupObj == null || !curObj.isModified())) continue;
            curObj.generateDelta(backupObj, values);
        }
    }

    public void generateDeleteDelta(XDMObject backup, ConfigValues values) throws XDMException {
        if (backup != null && !(backup instanceof XDMHashCollection)) {
            throw new XDMException(3, this);
        }
        if (backup != null) {
            XDMHashCollection backupColl = (XDMHashCollection)backup;
            Enumeration e = backupColl.keys();
            while (e.hasMoreElements()) {
                Object backupKey = e.nextElement();
                if (this.containsKey(backupKey)) continue;
                backupColl.get(backupKey).generateDelta(null, values);
            }
        }
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        if (this.isBackup()) {
            Enumeration e = this.elements();
            while (e.hasMoreElements()) {
                XDMObject obj = (XDMObject)e.nextElement();
                obj.generateDelta(backup, values);
            }
            return;
        }
        this.generateDeleteDelta(backup, values);
        this.generateAddModifyDelta(backup, values);
    }

    public synchronized XDMObject get(Object key) {
        return (XDMObject)this._hashTable.get(key);
    }

    public boolean isDeepEqual() {
        return true;
    }

    public boolean isEmpty() {
        return this._hashTable.isEmpty();
    }

    public synchronized Enumeration keys() {
        return this._hashTable.keys();
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
    }

    public synchronized XDMObject put(Object key, XDMObject value) {
        if (key == null || value == null) {
            return null;
        }
        XDMObject obj = this._hashTable.put(key, value);
        value.setParent(this);
        value.setModified();
        if (obj != null) {
            return obj;
        }
        return null;
    }

    public synchronized Object remove(Object key) {
        XDMObject obj;
        if (key == null) {
            return null;
        }
        if (this._hashTable.containsKey(key) && (obj = this.get(key)) != null && !obj.isReadOnly()) {
            this.setModified();
            return this._hashTable.remove(key);
        }
        return null;
    }

    public void resetModifiedFlag() {
        super.resetModifiedFlag();
        Enumeration e = this._hashTable.elements();
        while (e.hasMoreElements()) {
            XDMObject element = (XDMObject)e.nextElement();
            element.resetModifiedFlag();
        }
    }

    public int size() {
        return this._hashTable.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\t");
        sb.append(super.toString());
        sb.append("\t{ ");
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            XDMObject obj = this.get(key);
            sb.append("\tkey: " + key.toString());
            sb.append("\tvalue: " + obj.toString());
            sb.append(",");
        }
        sb.append("\t }");
        return sb.toString();
    }
}

