/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.bridging;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;

public class BridgeGroup
extends XDMObject {
    public static final int BRIDGE_SPIN_TREE_PROTOCOL_NONE = 0;
    public static final int BRIDGE_SPIN_TREE_PROTOCOL_IEEE = 1;
    public static final int BRIDGE_SPIN_TREE_PROTOCOL_DEC = 2;
    public static final int BRIDGE_SPIN_TREE_PROTOCOL_IBM = 3;
    public static final int BRIDGE_SPIN_TREE_PROTOCOL_VLAN = 4;
    public static final int BRIDGE_ROUTE_IP = 0;
    public static final int BRIDGE_ROUTE_CLNS = 1;
    private int _id;
    private int _protocol = 0;
    private boolean _ipRoute = false;
    private boolean _clnsRoute = false;
    private static final String KEY_NUMBER = "NUMBER";
    private static final String KEY_PROT = "PROT";
    private static final String KEY_ROUT = "ROUT";
    private static final String KEY_IEEE = "ieee";
    private static final String KEY_DEC = "dec";
    private static final String KEY_IBM = "ibm";
    private static final String KEY_VLAN = "vlan-bridge";
    private static final String KEY_IP = "ip";
    private static final String KEY_CLNS = "clns";
    private static final String KEY_BRIDGE = "bridge";
    private static final String KEY_PROTOCOL = "protocol";
    private static final String KEY_ROUTE = "route";

    public BridgeGroup(int id) {
        this._id = id;
    }

    public void disableRouting() {
        this._ipRoute = false;
        this._clnsRoute = false;
        this.setModified();
    }

    public void enableIPRouting(boolean enable) {
        if (enable == this._ipRoute) {
            return;
        }
        this._ipRoute = enable;
        this.setModified();
    }

    private void generateDelete(ConfigValues values) {
        this.generateSTProtocol(false, values);
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        if (this.isBackup()) {
            this.generateDelete(values);
        } else if (backup == null) {
            this.generateNew(values);
        } else {
            this.generateModify((BridgeGroup)backup, values);
        }
    }

    private void generateModify(BridgeGroup backup, ConfigValues values) {
        if (this._protocol != backup._protocol) {
            this.generateSTProtocol(true, values);
        }
        if (this._ipRoute != backup._ipRoute) {
            this.generateRoute(this._ipRoute, KEY_IP, values);
        }
        if (this._clnsRoute != backup._clnsRoute) {
            this.generateRoute(this._ipRoute, KEY_CLNS, values);
        }
    }

    private void generateNew(ConfigValues values) {
        this.generateSTProtocol(true, values);
        if (this._ipRoute) {
            this.generateRoute(true, KEY_IP, values);
        }
        if (this._clnsRoute) {
            this.generateRoute(true, KEY_CLNS, values);
        }
    }

    private void generateRoute(boolean enable, String route, ConfigValues values) {
        CmdValues cmd = new CmdValues(KEY_BRIDGE);
        cmd.addValue(KEY_NUMBER, String.valueOf(this._id));
        cmd.addValue(KEY_ROUTE, KEY_ROUTE);
        cmd.addValue(KEY_ROUT, route);
        if (!enable) {
            cmd.setAction(2);
        }
        values.addCmdValues(cmd);
    }

    private void generateSTProtocol(boolean enable, ConfigValues values) {
        if (this._protocol != 1 && this._protocol != 0) {
            return;
        }
        CmdValues cmd = new CmdValues(KEY_BRIDGE);
        cmd.addValue(KEY_NUMBER, String.valueOf(this._id));
        cmd.addValue(KEY_PROTOCOL, KEY_PROTOCOL);
        if (enable && this._protocol == 1) {
            cmd.addValue(KEY_PROT, KEY_IEEE);
            values.insertCmdValues(cmd, 0);
        } else {
            cmd.setAction(2);
            values.addCmdValues(cmd);
        }
    }

    public int getID() {
        return this._id;
    }

    public int getProtocol() {
        return this._protocol;
    }

    public void populate(ConfigValues config, CmdValues cmdval) throws XDMException, CliGPBException {
        if (cmdval == null) {
            return;
        }
        if (cmdval.containsKey(KEY_PROT)) {
            String prot = cmdval.getValue(KEY_PROT);
            if (prot.equals(KEY_IEEE)) {
                this._protocol = 1;
            } else if (prot.equals(KEY_IBM)) {
                this._protocol = 3;
            } else if (prot.equals(KEY_DEC)) {
                this._protocol = 2;
            } else if (prot.equals(KEY_VLAN)) {
                this._protocol = 4;
            }
        } else if (cmdval.containsKey(KEY_ROUT)) {
            String route = cmdval.getValue(KEY_ROUT);
            if (route.equals(KEY_IP)) {
                this._ipRoute = true;
            } else if (route.equals(KEY_CLNS)) {
                this._clnsRoute = true;
            }
        }
    }

    public void setProtocol(int prot) {
        this._protocol = prot;
        this.setModified();
    }
}

