/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.bridging;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMHashCollection;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.bridging.BridgeGroup;
import com.cisco.xdm.data.interfaces.IfID;
import com.cisco.xdm.data.interfaces.XDMInterface;
import com.cisco.xdm.data.interfaces.XDMInterfaceBase;
import com.cisco.xdm.data.interfaces.XDMInterfaces;
import com.cisco.xdm.data.interfaces.XDMSubInterfaces;
import java.util.Enumeration;
import java.util.Vector;

public class Bridging
extends XDMHashCollection {
    public static final int BRIDGING_NONE = 0;
    public static final int BRIDGING_CRB = 1;
    public static final int BRIDGING_IRB = 2;
    private int _type = 0;
    private static final String KEY_BRIDGING = "BRIDGING";
    private static final String KEY_NUMBER = "NUMBER";
    private static final String KEY_PROTOCOL = "PROT";
    private static final String KEY_ROUTE = "ROUT";
    private static final String KEY_BRIDGE = "bridge";
    private static final String KEY_IRB = "irb";
    private static final String KEY_CRB = "crb";

    public Bridging(XDMObject parent) {
        super(parent);
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        Bridging bObj = (Bridging)backup;
        super.generateDelta(backup, values);
        this.generateType(bObj, values);
    }

    private void generateType(Bridging bObj, ConfigValues values) {
        if (bObj._type == this._type) {
            return;
        }
        if (this._type == 1) {
            return;
        }
        if (this._type == 2) {
            CmdValues cmd = new CmdValues(KEY_BRIDGE);
            cmd.addValue(KEY_BRIDGING, KEY_IRB);
            values.insertCmdValues(cmd, 0);
            if (bObj._type == 1) {
                cmd = new CmdValues(KEY_BRIDGE);
                cmd.addValue(KEY_BRIDGING, KEY_CRB);
                cmd.setAction(2);
                values.insertCmdValues(cmd, 0);
            }
        } else if (this._type == 0 && bObj._type == 2) {
            CmdValues cmd = new CmdValues(KEY_BRIDGE);
            cmd.addValue(KEY_BRIDGING, KEY_IRB);
            cmd.setAction(2);
            values.addCmdValues(cmd);
        }
    }

    public BridgeGroup get(int num) {
        return (BridgeGroup)this.get(new Integer(num));
    }

    public int getBridgingType() {
        return this._type;
    }

    public Vector getIfsInBridgeGroup(int bridgeGroup) {
        Vector<XDMInterfaceBase> ret = new Vector<XDMInterfaceBase>();
        if (bridgeGroup <= 0) {
            return ret;
        }
        DeviceBase dev = (DeviceBase)this.getDevice();
        XDMInterfaces ifs = dev.getIfs();
        Enumeration e = ifs.elements();
        while (e.hasMoreElements()) {
            XDMInterface mainIf;
            XDMInterfaceBase item = (XDMInterfaceBase)e.nextElement();
            if (item.getBridgeGroup() == bridgeGroup) {
                ret.addElement(item);
            }
            if (!(mainIf = (XDMInterface)item).isSubInterfaceExist()) continue;
            XDMSubInterfaces subIfs = mainIf.getSubInterfaces();
            Enumeration se = subIfs.elements();
            while (se.hasMoreElements()) {
                XDMInterfaceBase sif = (XDMInterfaceBase)se.nextElement();
                if (sif.getBridgeGroup() != bridgeGroup) continue;
                ret.addElement(sif);
            }
        }
        return ret;
    }

    public boolean isBGExistInInterfaces() {
        DeviceBase dev = (DeviceBase)this.getDevice();
        XDMInterfaces ifs = dev.getIfs();
        Enumeration e = ifs.elements();
        while (e.hasMoreElements()) {
            XDMInterfaceBase item = (XDMInterfaceBase)e.nextElement();
            if (item.getBridgeGroup() > 0) {
                return true;
            }
            XDMInterface mainIf = (XDMInterface)item;
            if (!mainIf.isSubInterfaceExist()) continue;
            XDMSubInterfaces subIfs = mainIf.getSubInterfaces();
            Enumeration se = subIfs.elements();
            while (se.hasMoreElements()) {
                XDMInterfaceBase sif = (XDMInterfaceBase)se.nextElement();
                if (sif.getBridgeGroup() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSubinterfaceInBridgeGroup(int bridgeGroup) {
        Vector<XDMInterfaceBase> ret = new Vector<XDMInterfaceBase>();
        if (bridgeGroup <= 0) {
            return false;
        }
        DeviceBase dev = (DeviceBase)this.getDevice();
        XDMInterfaces ifs = dev.getIfs();
        Enumeration e = ifs.elements();
        while (e.hasMoreElements()) {
            XDMInterface mainIf;
            XDMInterfaceBase item = (XDMInterfaceBase)e.nextElement();
            if (item.getBridgeGroup() == bridgeGroup) {
                ret.addElement(item);
            }
            if (!(mainIf = (XDMInterface)item).isSubInterfaceExist()) continue;
            XDMSubInterfaces subIfs = mainIf.getSubInterfaces();
            Enumeration se = subIfs.elements();
            while (se.hasMoreElements()) {
                XDMInterfaceBase sif = (XDMInterfaceBase)se.nextElement();
                if (sif.getBridgeGroup() != bridgeGroup) continue;
                return true;
            }
        }
        return false;
    }

    public void populate(ConfigValues config, CmdValues cmdval) throws XDMException, CliGPBException {
        this._type = 0;
        ConfigValues ifCVs = config.getCmds(KEY_BRIDGE, ".*", ".*", false);
        if (ifCVs != null) {
            int i = 0;
            while (i < ifCVs.numCmds()) {
                CmdValues cmd = ifCVs.getCmdValues(i);
                if (cmd.containsKey(KEY_BRIDGING)) {
                    String type = cmd.getValue(KEY_BRIDGING);
                    if (type.equals(KEY_IRB)) {
                        this._type = 2;
                    } else if (type.equals(KEY_CRB)) {
                        this._type = 1;
                    }
                } else if (cmd.containsKey(KEY_NUMBER)) {
                    int num = Integer.valueOf(cmd.getValue(KEY_NUMBER));
                    this.populateBG(num, config, cmd);
                }
                ++i;
            }
        }
    }

    private void populateBG(int num, ConfigValues config, CmdValues cmd) throws XDMException, CliGPBException {
        BridgeGroup bg = this.get(num);
        if (bg == null) {
            bg = new BridgeGroup(num);
            this.put(bg);
        }
        bg.populate(config, cmd);
    }

    public XDMObject put(BridgeGroup val) {
        if (val == null) {
            return null;
        }
        return this.put(new Integer(val.getID()), val);
    }

    public Object removeBridgeGroup(int num) {
        return this.remove(new Integer(num));
    }

    public void setBridgingType(int type) {
        if (type == this._type) {
            return;
        }
        if (type == 0) {
            DeviceBase dev = (DeviceBase)this.getDevice();
            XDMInterfaces ifs = dev.getIfs();
            Vector bvis = ifs.getIfsByType(1010);
            Enumeration e = bvis.elements();
            while (e.hasMoreElements()) {
                IfID id = ((XDMInterfaceBase)e.nextElement()).getIfID();
                ifs.remove(id);
            }
            Enumeration e2 = this.elements();
            while (e2.hasMoreElements()) {
                BridgeGroup bg = (BridgeGroup)e2.nextElement();
                bg.disableRouting();
            }
            this._type = 0;
        } else if (type == 2) {
            this._type = 2;
        }
        this.setModified();
    }
}

