/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.cbac;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdSet;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.nm.xms.cliparser.KeywordParamNode;
import com.cisco.xdm.commonutils.Log;
import com.cisco.xdm.data.base.CmdPositionHandler;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.cbac.CBACDiscover;
import com.cisco.xdm.data.cbac.CBACProtocols;
import com.cisco.xdm.data.cbac.CBACRule;
import com.cisco.xdm.data.cbac.CBACRuleEntry;
import com.cisco.xdm.data.cbac.feed.FwData;
import com.cisco.xdm.data.cbac.feed.FwFeed;
import com.cisco.xdm.data.cbac.feed.FwGroup;
import com.cisco.xdm.data.systemproperties.PAM;
import com.cisco.xdm.data.systemproperties.PAMBaseEntry;
import com.cisco.xdm.data.systemproperties.SystemProp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;

public class CBAC
extends XDMObject
implements CBACProtocols,
CmdPositionHandler {
    public static final String KEY_IP = "ip";
    public static final String KEY_INSPECT = "inspect";
    public static final String KEY_INSPECT_NAME = "inspectname";
    public static final String KEY_APPFW = "appfw";
    public static final String KEY_ESMTP = "esmtp";
    public static final String KEY_FRAGMENT = "fragment";
    public static final String KEY_H323 = "h323";
    public static final String KEY_HTTP = "http";
    public static final String KEY_ICMP = "icmp";
    public static final String KEY_IMAP = "imap";
    public static final String KEY_PARAM = "parameter";
    public static final String KEY_POP3 = "pop3";
    public static final String KEY_POP = "pop";
    public static final String KEY_RPC = "rpc";
    public static final String KEY_SMTP = "smtp";
    public static final String KEY_TCP = "tcp";
    public static final String KEY_UDP = "udp";
    public static final String KEY_INSPECT_PROTOCOL = "inspectprotocol";
    public static final String KEY_ALERT = "alert";
    public static final String KEY_AUDIT = "audit";
    public static final String KEY_TCP_FINWAIT_TIME = "tcpfinwaittime";
    public static final String KEY_TCP_IDLE_TIME = "tcpidletime";
    public static final String KEY_TCP_SYNWAIT_TIME = "tcpsynwaittime";
    public static final String KEY_DNS_TIMEOUT = "dnstimeout";
    public static final String KEY_UDP_IDLE_TIME = "udpidletime";
    public static final String KEY_TCP_MAX_INCOMPLETE = "max-incomplete";
    public static final String KEY_MAX_INCOMPLETE = "max-incomplete";
    public static final String KEY_ONE_MINUTE = "one-minute";
    public static final String KEY_MAX_INCOMPLETE_LOW = "max-incomplete-low";
    public static final String KEY_MAX_INCOMPLETE_HIGH = "max-incomplete-high";
    public static final String KEY_ONE_MINUTE_LOW = "one-minute-low";
    public static final String KEY_ONE_MINUTE_HIGH = "one-minute-high";
    public static final String KEY_TCP_MAX_INCOMPLETE_HOST = "tcpmaxincompletehost";
    public static final String KEY_TCP_BLOCK_TIME = "tcpblocktime";
    public static final String KEY_RPC_WAIT_TIME = "waittime";
    public static final String KEY_RPC_PROGRAM_NUMBER_PARAM = "programnumber";
    public static final String KEY_RPC_PROGRAM_NUMBER = "program-number";
    public static final String KEY_HTTP_JAVALIST = "javalist";
    public static final String KEY_HTTP_URLFILTER = "urlfilter";
    public static final String KEY_MAXIMUM = "maximum";
    public static final String KEY_MAXIMUM_FRAGMENT = "maximumfrag";
    public static final String KEY_FRAGMENT_TIMEOUT = "fragtimeout";
    public static final String KEY_ALERT_OFF = "alert-off";
    public static final String KEY_AUDIT_TRAIL = "audit-trail";
    public static final String KEY_TIMEOUT = "timeout";
    public static final String KEY_ICMP_TIMEOUT = "icmp-timeout";
    public static final String KEY_OFF = "off";
    public static final String KEY_ON = "on";
    public static final String KEY_DEFAULT = "default";
    public static final String KEY_MAXDATA = "maxdata";
    public static final String KEY_POLICYNAME = "policyname";
    public static final String KEY_ROUTERTRAFFIC = "router-traffic";
    public static final String KEY_RESET = "reset";
    public static final String KEY_SECURELOGIN = "secure-login";
    public static final String KEY_MAX_SESSIONS = "maxsessions";
    public static final String KEY_LOG = "log";
    public static final String KEY_DROP_PKT = "drop-pkt";
    public static final String KEY_BLOCK_NON_SESSION = "block-non-session";
    public static final int tcp_synwait_time = 0;
    public static final int tcp_finwait_time = 1;
    public static final int tcp_idle_time = 2;
    public static final int tcp_max_incomplete_host = 3;
    public static final int tcp_max_incomplete_host_block_time = 4;
    public static final int udp_idle_time = 5;
    public static final int dns_timeout = 6;
    public static final int max_incomplete_high = 7;
    public static final int max_incomplete_low = 8;
    public static final int one_minute_high = 9;
    public static final int one_minute_low = 10;
    public static final int fragment_maximum = 11;
    public static final int fragment_timeout = 12;
    public static final int http_javalist = 13;
    public static final int rpc_program_number = 14;
    public static final int rpc_wait_time = 15;
    public static final int icmp_timeout = 16;
    public static final int timeout = 17;
    public static final int current_value = 0;
    public static final int min_threshold = 1;
    public static final int max_threshold = 2;
    public static final int default_value = 3;
    private static final String[] _keys_string = new String[]{"tcpsynwaittime", "tcpfinwaittime", "tcpidletime", "tcpmaxincompletehost", "tcpblocktime", "udpidletime", "dnstimeout", "max-incomplete-high", "max-incomplete-low", "one-minute-high", "one-minute-low", "maximumfrag", "fragtimeout", "javalist", "programnumber", "waittime", "icmp-timeout", "timeout"};
    public long[][] _keys;
    public boolean bAlert;
    public boolean bAuditTrial;
    public boolean bDropPkt;
    public boolean bDropNonSession;
    protected Vector CBACRules;
    protected CBACDiscover cbacDiscover;
    private FwFeed feed;

    public CBAC() {
        long[][] lArrayArray = new long[18][];
        lArrayArray[0] = new long[]{30L, 1L, 2147483L, 30L};
        lArrayArray[1] = new long[]{30L, 1L, 2147483L, 5L};
        lArrayArray[2] = new long[]{3600L, 1L, 2147483L, 3600L};
        lArrayArray[3] = new long[]{50L, 1L, 0xFFFFFFFFL, 50L};
        long[] lArray = new long[4];
        lArray[2] = 35791L;
        lArrayArray[4] = lArray;
        lArrayArray[5] = new long[]{30L, 1L, 2147483L, 30L};
        lArrayArray[6] = new long[]{5L, 1L, 2147483L, 5L};
        lArrayArray[7] = new long[]{500L, 1L, Integer.MAX_VALUE, 500L};
        lArrayArray[8] = new long[]{400L, 1L, Integer.MAX_VALUE, 400L};
        lArrayArray[9] = new long[]{500L, 1L, Integer.MAX_VALUE, 500L};
        lArrayArray[10] = new long[]{400L, 1L, Integer.MAX_VALUE, 400L};
        lArrayArray[11] = new long[]{256L, 50L, 10000L, 256L};
        lArrayArray[12] = new long[]{1L, 1L, 1000L, 1L};
        lArrayArray[13] = new long[]{-1L, 1L, 99L, -1L};
        lArrayArray[14] = new long[]{-1L, 1L, 0xFFFFFFFFL, -1L};
        long[] lArray2 = new long[4];
        lArray2[2] = 35791L;
        lArrayArray[15] = lArray2;
        lArrayArray[16] = new long[]{10L, 5L, 43200L, 10L};
        lArrayArray[17] = new long[]{-1L, 5L, 43200L, -1L};
        this._keys = lArrayArray;
        this.CBACRules = new Vector();
        this.initCBAC();
    }

    public CBAC(XDMObject parent) {
        super(parent);
        long[][] lArrayArray = new long[18][];
        lArrayArray[0] = new long[]{30L, 1L, 2147483L, 30L};
        lArrayArray[1] = new long[]{30L, 1L, 2147483L, 5L};
        lArrayArray[2] = new long[]{3600L, 1L, 2147483L, 3600L};
        lArrayArray[3] = new long[]{50L, 1L, 0xFFFFFFFFL, 50L};
        long[] lArray = new long[4];
        lArray[2] = 35791L;
        lArrayArray[4] = lArray;
        lArrayArray[5] = new long[]{30L, 1L, 2147483L, 30L};
        lArrayArray[6] = new long[]{5L, 1L, 2147483L, 5L};
        lArrayArray[7] = new long[]{500L, 1L, Integer.MAX_VALUE, 500L};
        lArrayArray[8] = new long[]{400L, 1L, Integer.MAX_VALUE, 400L};
        lArrayArray[9] = new long[]{500L, 1L, Integer.MAX_VALUE, 500L};
        lArrayArray[10] = new long[]{400L, 1L, Integer.MAX_VALUE, 400L};
        lArrayArray[11] = new long[]{256L, 50L, 10000L, 256L};
        lArrayArray[12] = new long[]{1L, 1L, 1000L, 1L};
        lArrayArray[13] = new long[]{-1L, 1L, 99L, -1L};
        lArrayArray[14] = new long[]{-1L, 1L, 0xFFFFFFFFL, -1L};
        long[] lArray2 = new long[4];
        lArray2[2] = 35791L;
        lArrayArray[15] = lArray2;
        lArrayArray[16] = new long[]{10L, 5L, 43200L, 10L};
        lArrayArray[17] = new long[]{-1L, 5L, 43200L, -1L};
        this._keys = lArrayArray;
        this.CBACRules = new Vector();
        this.initCBAC();
    }

    public CBAC(XDMObject parent, boolean isReadOnly) {
        super(parent, isReadOnly);
        long[][] lArrayArray = new long[18][];
        lArrayArray[0] = new long[]{30L, 1L, 2147483L, 30L};
        lArrayArray[1] = new long[]{30L, 1L, 2147483L, 5L};
        lArrayArray[2] = new long[]{3600L, 1L, 2147483L, 3600L};
        lArrayArray[3] = new long[]{50L, 1L, 0xFFFFFFFFL, 50L};
        long[] lArray = new long[4];
        lArray[2] = 35791L;
        lArrayArray[4] = lArray;
        lArrayArray[5] = new long[]{30L, 1L, 2147483L, 30L};
        lArrayArray[6] = new long[]{5L, 1L, 2147483L, 5L};
        lArrayArray[7] = new long[]{500L, 1L, Integer.MAX_VALUE, 500L};
        lArrayArray[8] = new long[]{400L, 1L, Integer.MAX_VALUE, 400L};
        lArrayArray[9] = new long[]{500L, 1L, Integer.MAX_VALUE, 500L};
        lArrayArray[10] = new long[]{400L, 1L, Integer.MAX_VALUE, 400L};
        lArrayArray[11] = new long[]{256L, 50L, 10000L, 256L};
        lArrayArray[12] = new long[]{1L, 1L, 1000L, 1L};
        lArrayArray[13] = new long[]{-1L, 1L, 99L, -1L};
        lArrayArray[14] = new long[]{-1L, 1L, 0xFFFFFFFFL, -1L};
        long[] lArray2 = new long[4];
        lArray2[2] = 35791L;
        lArrayArray[15] = lArray2;
        lArrayArray[16] = new long[]{10L, 5L, 43200L, 10L};
        lArrayArray[17] = new long[]{-1L, 5L, 43200L, -1L};
        this._keys = lArrayArray;
        this.CBACRules = new Vector();
        this.initCBAC();
    }

    public CBACRule addRule(CBACRule rule) {
        rule.setParent(this);
        try {
            int i = 0;
            while (i < this.CBACRules.size()) {
                CBACRule cbacRule = (CBACRule)this.CBACRules.elementAt(i);
                if (cbacRule.getName().equals(rule.getName())) {
                    this.CBACRules.setElementAt(rule, i);
                    this.setModified();
                    return rule;
                }
                ++i;
            }
            this.CBACRules.addElement(rule);
            this.setModified();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return rule;
    }

    public CBACRule addRuleAt(CBACRule rule, int pos) {
        try {
            rule.setParent(this);
            this.CBACRules.setElementAt(rule, pos);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        this.setModified();
        return rule;
    }

    public Object clone() {
        CBAC cloneEntry = (CBAC)super.clone();
        cloneEntry.bAlert = this.bAlert;
        cloneEntry.bAuditTrial = this.bAuditTrial;
        cloneEntry.bDropPkt = this.bDropPkt;
        cloneEntry.bDropNonSession = this.bDropNonSession;
        if (this.feed != null) {
            cloneEntry.feed = (FwFeed)this.feed.clone();
        }
        cloneEntry.CBACRules = new Vector();
        Enumeration en = this.CBACRules.elements();
        while (en.hasMoreElements()) {
            CBACRule newRule = (CBACRule)((CBACRule)en.nextElement()).clone();
            cloneEntry.addRule(newRule);
            newRule.setParent(cloneEntry);
        }
        if (this.cbacDiscover != null) {
            cloneEntry.cbacDiscover = (CBACDiscover)this.cbacDiscover.clone();
        }
        cloneEntry._keys = new long[18][4];
        int i = 0;
        while (i <= 17) {
            cloneEntry._keys[i][0] = this._keys[i][0];
            cloneEntry._keys[i][1] = this._keys[i][1];
            cloneEntry._keys[i][2] = this._keys[i][2];
            cloneEntry._keys[i][3] = this._keys[i][3];
            ++i;
        }
        Log.getInstance().debug("CBAC Cloned.");
        return cloneEntry;
    }

    private String convert(int num, int len) {
        StringBuffer tmp = new StringBuffer();
        tmp.append("");
        int i = Integer.toString(num).length();
        while (i < len) {
            tmp.append("0");
            ++i;
        }
        tmp.append(Integer.toString(num));
        return tmp.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CBAC)) {
            return false;
        }
        return !this.isModified();
    }

    public CBACRule findRuleByName(String name) {
        if (this.CBACRules.isEmpty()) {
            return null;
        }
        Enumeration en = this.CBACRules.elements();
        while (en.hasMoreElements()) {
            CBACRule cbacRule = (CBACRule)en.nextElement();
            if (!cbacRule.getName().equals(name)) continue;
            return cbacRule;
        }
        return null;
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        CmdValues cmd;
        CBAC old = (CBAC)backup;
        Log.getInstance().debug("CBAC generateDelta started.");
        int index = -1;
        DeviceBase dev = (DeviceBase)this.getDevice();
        if (dev != null) {
            index = dev.getFirstCmdPosition("ifs", values, false);
        }
        if (old == null || this._keys[0][0] != old._keys[0][0]) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_INSPECT, KEY_INSPECT);
            cmd.addValue(KEY_TCP, KEY_TCP);
            cmd.addValue(KEY_TCP_SYNWAIT_TIME, Long.toString(this._keys[0][0]));
            cmd.setAction(1);
            index = this.updateConfigValues(values, cmd, index);
        }
        if (old == null || this._keys[1][0] != old._keys[1][0]) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_INSPECT, KEY_INSPECT);
            cmd.addValue(KEY_TCP, KEY_TCP);
            cmd.addValue(KEY_TCP_FINWAIT_TIME, Long.toString(this._keys[1][0]));
            cmd.setAction(1);
            index = this.updateConfigValues(values, cmd, index);
        }
        if (old == null || this._keys[2][0] != old._keys[2][0]) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_INSPECT, KEY_INSPECT);
            cmd.addValue(KEY_TCP, KEY_TCP);
            cmd.addValue(KEY_TCP_IDLE_TIME, Long.toString(this._keys[2][0]));
            cmd.setAction(1);
            index = this.updateConfigValues(values, cmd, index);
        }
        if (old == null || this._keys[5][0] != old._keys[5][0]) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_INSPECT, KEY_INSPECT);
            cmd.addValue(KEY_UDP, KEY_UDP);
            cmd.addValue(KEY_UDP_IDLE_TIME, Long.toString(this._keys[5][0]));
            cmd.setAction(1);
            index = this.updateConfigValues(values, cmd, index);
        }
        if (old == null || this._keys[6][0] != old._keys[6][0]) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_INSPECT, KEY_INSPECT);
            cmd.addValue(KEY_DNS_TIMEOUT, Long.toString(this._keys[6][0]));
            cmd.setAction(1);
            index = this.updateConfigValues(values, cmd, index);
        }
        if (old == null || this._keys[7][0] != old._keys[7][0]) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_INSPECT, KEY_INSPECT);
            cmd.addValue("max-incomplete", "max-incomplete");
            cmd.addValue(KEY_MAX_INCOMPLETE_HIGH, Long.toString(this._keys[7][0]));
            cmd.setAction(1);
            index = this.updateConfigValues(values, cmd, index);
        }
        if (old == null || this._keys[8][0] != old._keys[8][0]) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_INSPECT, KEY_INSPECT);
            cmd.addValue("max-incomplete", "max-incomplete");
            cmd.addValue(KEY_MAX_INCOMPLETE_LOW, Long.toString(this._keys[8][0]));
            cmd.setAction(1);
            index = this.updateConfigValues(values, cmd, index);
        }
        if (old == null || this._keys[9][0] != old._keys[9][0]) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_INSPECT, KEY_INSPECT);
            cmd.addValue(KEY_ONE_MINUTE, KEY_ONE_MINUTE);
            cmd.addValue(KEY_ONE_MINUTE_HIGH, Long.toString(this._keys[9][0]));
            cmd.setAction(1);
            index = this.updateConfigValues(values, cmd, index);
        }
        if (old == null || this._keys[10][0] != old._keys[10][0]) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_INSPECT, KEY_INSPECT);
            cmd.addValue(KEY_ONE_MINUTE, KEY_ONE_MINUTE);
            cmd.addValue(KEY_ONE_MINUTE_LOW, Long.toString(this._keys[10][0]));
            cmd.setAction(1);
            index = this.updateConfigValues(values, cmd, index);
        }
        if (old == null || this._keys[3][0] != old._keys[3][0] || this._keys[4][0] != old._keys[4][0]) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_INSPECT, KEY_INSPECT);
            cmd.addValue(KEY_TCP, KEY_TCP);
            cmd.addValue("max-incomplete", "max-incomplete");
            cmd.addValue(KEY_TCP_MAX_INCOMPLETE_HOST, Long.toString(this._keys[3][0]));
            cmd.addValue(KEY_TCP_BLOCK_TIME, Long.toString(this._keys[4][0]));
            cmd.setAction(1);
            index = this.updateConfigValues(values, cmd, index);
        }
        if (old == null || this.bAlert != old.bAlert) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_INSPECT, KEY_INSPECT);
            cmd.addValue(KEY_ALERT_OFF, KEY_ALERT_OFF);
            if (this.bAlert) {
                cmd.setAction(2);
            } else {
                cmd.setAction(1);
            }
            index = this.updateConfigValues(values, cmd, index);
        }
        if (old == null || this.bAuditTrial != old.bAuditTrial) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_INSPECT, KEY_INSPECT);
            cmd.addValue(KEY_AUDIT_TRAIL, KEY_AUDIT_TRAIL);
            if (this.bAuditTrial) {
                cmd.setAction(1);
            } else {
                cmd.setAction(2);
            }
            index = this.updateConfigValues(values, cmd, index);
        }
        if (old == null || this.bDropPkt != old.bDropPkt) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_INSPECT, KEY_INSPECT);
            cmd.addValue(KEY_LOG, KEY_LOG);
            cmd.addValue(KEY_DROP_PKT, KEY_DROP_PKT);
            if (this.bDropPkt) {
                cmd.setAction(1);
            } else {
                cmd.setAction(2);
            }
            index = this.updateConfigValues(values, cmd, index);
        }
        if (old == null || this.bDropNonSession != old.bDropNonSession) {
            cmd = new CmdValues(KEY_IP);
            cmd.addValue(KEY_INSPECT, KEY_INSPECT);
            cmd.addValue(KEY_TCP, KEY_TCP);
            cmd.addValue(KEY_BLOCK_NON_SESSION, KEY_BLOCK_NON_SESSION);
            if (this.bDropNonSession) {
                cmd.setAction(1);
            } else {
                cmd.setAction(2);
            }
            index = this.updateConfigValues(values, cmd, index);
        }
        if (old != null) {
            Enumeration oldRules = old.getCBACRules().elements();
            while (oldRules.hasMoreElements()) {
                CBACRule oldRule = (CBACRule)oldRules.nextElement();
                CBACRule rule = this.findRuleByName(oldRule.getName());
                if (rule != null) continue;
                Log.getInstance().debug("CBAC generateDelta - Delete rule: " + oldRule.getName());
                CmdValues cmd2 = new CmdValues(KEY_IP);
                cmd2.addValue(KEY_INSPECT, KEY_INSPECT);
                cmd2.addValue(KEY_INSPECT_NAME, oldRule.getName());
                cmd2.setAction(2);
                values.addCmdValues(cmd2);
            }
        }
        Enumeration curRules = this.CBACRules.elements();
        while (curRules.hasMoreElements()) {
            CBACRule rule = (CBACRule)curRules.nextElement();
            CBACRule oldRule = null;
            if (old != null) {
                oldRule = old.findRuleByName(rule.getName());
            }
            boolean bGenerate = false;
            if (oldRule == null) {
                Log.getInstance().debug("CBAC generateDelta - New rule: " + rule.getName());
                bGenerate = true;
            } else if (rule.equals(oldRule)) {
                Log.getInstance().debug("CBAC generateDelta - Equal rule: " + rule.getName());
            } else {
                bGenerate = true;
            }
            if (!bGenerate) continue;
            Log.getInstance().debug("CBAC generateDelta - generateDelta for rule: " + rule.getName());
            index = rule.generateDelta(oldRule, values, index);
        }
        Log.getInstance().debug("CBAC generateDelta Finished.");
    }

    public CBACRule getAssociatedAppFwRule(String policyName) {
        Enumeration en = this.CBACRules.elements();
        while (en.hasMoreElements()) {
            CBACRule rule = (CBACRule)en.nextElement();
            if (!rule.getAppfwPolicyName().equals(policyName)) continue;
            return rule;
        }
        return null;
    }

    public CBACDiscover getCBACDiscover() {
        if (this.feed == null) {
            this.feed = new FwFeed();
        }
        if (this.cbacDiscover == null) {
            this.cbacDiscover = new CBACDiscover(this.feed);
        }
        return this.cbacDiscover;
    }

    public Vector getCBACRules() {
        return this.CBACRules;
    }

    public FwFeed getFeed() {
        if (this.feed == null) {
            this.feed = new FwFeed();
            this.cbacDiscover = new CBACDiscover(this.feed);
        }
        return this.feed;
    }

    public int getFirstCmdPosition(String module, ConfigValues config, boolean noCmd) {
        int ret = -1;
        int size = config.numCmds();
        CmdValues cmd = null;
        String name = null;
        int i = 0;
        while (i < size) {
            cmd = config.getCmdValues(i);
            name = cmd.getCmdName();
            if (name.equalsIgnoreCase(KEY_IP) && cmd.containsKey(KEY_INSPECT) && (cmd.getAction() == 2 && noCmd || cmd.getAction() != 2 && !noCmd)) {
                ret = i;
                break;
            }
            ++i;
        }
        return ret;
    }

    public long getKeyValue(int keyname, int type) {
        if (keyname < 0 || keyname > 17) {
            return -1L;
        }
        if (type < 0 || type > 3) {
            return -1L;
        }
        return this._keys[keyname][type];
    }

    public String getNextName(String name) {
        int i = 100;
        while (i < 999) {
            if (this.findRuleByName(String.valueOf(name) + Integer.toString(i)) == null) {
                return String.valueOf(name) + Integer.toString(i);
            }
            ++i;
        }
        Calendar today = Calendar.getInstance();
        StringBuffer tmp = new StringBuffer();
        tmp.append(String.valueOf(name) + today.get(1));
        tmp.append(this.convert(today.get(2) + 1, 2));
        tmp.append(this.convert(today.get(5), 2));
        tmp.append(this.convert(today.get(11), 2));
        tmp.append(this.convert(today.get(12), 2));
        tmp.append(this.convert(today.get(13), 2));
        tmp.append(this.convert(today.get(14), 3));
        return tmp.toString();
    }

    public String getProtocolDesc(String prot) {
        if (!this.isSupported(prot)) {
            return "";
        }
        return this.getFeed().getResource().getResDesc(prot);
    }

    public int getProtocolSize() {
        return this.getCBACDiscover().getProtocols().size();
    }

    public Enumeration getProtocols() {
        return this.getCBACDiscover().getProtocols().keys();
    }

    public CBACRule getRuleAt(int pos) {
        try {
            CBACRule r = (CBACRule)this.CBACRules.elementAt(pos);
            return r;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getTimeout(String protocol) {
        return -1L;
    }

    public Vector getUsedACLs() {
        Vector<String> v = new Vector<String>();
        Enumeration en = this.CBACRules.elements();
        while (en.hasMoreElements()) {
            String javalist;
            CBACRule cbacRule = (CBACRule)en.nextElement();
            CBACRuleEntry entry = cbacRule.getRuleEntry(KEY_HTTP);
            if (entry == null || (javalist = entry.getOption(KEY_HTTP_JAVALIST)) == null) continue;
            try {
                int nList = Integer.parseInt(javalist);
                if (nList == -1) continue;
                v.addElement(Integer.toString(nList));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return v;
    }

    public String getUsedby(String acl) {
        StringBuffer str;
        block3: {
            str = new StringBuffer();
            Enumeration en = this.CBACRules.elements();
            while (en.hasMoreElements()) {
                String javalist;
                CBACRule cbacRule = (CBACRule)en.nextElement();
                CBACRuleEntry entry = cbacRule.getRuleEntry(KEY_HTTP);
                if (entry == null || (javalist = entry.getOption(KEY_HTTP_JAVALIST)) == null || !javalist.equals(acl)) continue;
                str.append(cbacRule.getName()).append(",");
            }
            if (str.length() <= 0) break block3;
            try {
                str.setCharAt(str.length() - 1, ' ');
            }
            catch (StringIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
        return str.toString();
    }

    private void initCBAC() {
        this.bAlert = true;
        this.bAuditTrial = false;
        this.bDropPkt = false;
        this.bDropNonSession = false;
    }

    public boolean isKeyValueInRange(int keyname, long keyvalue) {
        if (keyname < 0 || keyname > 17) {
            return false;
        }
        return this._keys[keyname][1] <= keyvalue && keyvalue <= this._keys[keyname][2];
    }

    public boolean isSupported(String prot) {
        if (prot == null || prot.equals("")) {
            return false;
        }
        return this.getCBACDiscover().getProtocols().containsKey(prot);
    }

    public boolean isTCPInterceptConfigured() {
        DeviceBase dev = (DeviceBase)this.getDevice();
        SystemProp sysProp = dev.getSystemProp();
        return !sysProp.getInterceptListName().equals("");
    }

    private void parseDefaults() {
        if ((DeviceBase)this.getDevice() == null) {
            return;
        }
        CmdSet cmdset = ((DeviceBase)this.getDevice()).getDevInfoBase().getCmdSet();
        if (cmdset == null) {
            return;
        }
        int i = 0;
        while (i < 16) {
            KeywordParamNode node = cmdset.getParamNode(KEY_IP, _keys_string[i], true);
            if (node != null) {
                String defaultstr = node.getDefaultValue();
                long low = node.getMinRange();
                long high = node.getMaxRange();
                if (defaultstr != null) {
                    try {
                        long d;
                        Log.getInstance().debug("ip inspect defaults for " + _keys_string[i] + " [" + low + ", " + high + ", " + defaultstr + "]");
                        this._keys[i][0] = d = Long.parseLong(defaultstr);
                        this._keys[i][3] = d;
                    }
                    catch (NumberFormatException e) {
                        Log.getInstance().debug(e.toString());
                        e.printStackTrace();
                    }
                } else {
                    Log.getInstance().debug("ip inspect defaults for " + _keys_string[i] + " [" + low + ", " + high + ", null ]");
                }
                if (low != -1L) {
                    this._keys[i][1] = low;
                }
                if (high != -1L && high > low) {
                    this._keys[i][2] = high;
                }
            }
            ++i;
        }
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        block92: {
            Log.getInstance().debug("CBAC populate started...");
            this.parseDefaults();
            try {
                ConfigValues cv1;
                if (config == null || (cv1 = config.getCmds(KEY_IP, KEY_INSPECT, ".*", false)) == null || cv1.isEmpty()) break block92;
                int i = 0;
                while (i < cv1.numCmds()) {
                    CmdValues inspectCmds = cv1.getCmdValues(i);
                    if (inspectCmds.containsKey(KEY_ALERT_OFF)) {
                        this.bAlert = inspectCmds.isNoCmd();
                    } else if (inspectCmds.containsKey(KEY_AUDIT_TRAIL)) {
                        this.bAuditTrial = !inspectCmds.isNoCmd();
                    } else if (inspectCmds.containsKey(KEY_DROP_PKT)) {
                        this.bDropPkt = !inspectCmds.isNoCmd();
                    } else if (inspectCmds.containsKey(KEY_DNS_TIMEOUT)) {
                        try {
                            this._keys[6][0] = Long.parseLong(inspectCmds.getValue(KEY_DNS_TIMEOUT));
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    } else if (inspectCmds.containsKey(KEY_TCP) && !inspectCmds.containsKey(KEY_INSPECT_NAME)) {
                        if (inspectCmds.containsKey("max-incomplete")) {
                            try {
                                this._keys[3][0] = Long.parseLong(inspectCmds.getValue(KEY_TCP_MAX_INCOMPLETE_HOST));
                                if (inspectCmds.containsKey(KEY_TCP_BLOCK_TIME)) {
                                    this._keys[4][0] = Long.parseLong(inspectCmds.getValue(KEY_TCP_BLOCK_TIME));
                                }
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                        if (inspectCmds.containsKey(KEY_TCP_FINWAIT_TIME)) {
                            try {
                                this._keys[1][0] = Long.parseLong(inspectCmds.getValue(KEY_TCP_FINWAIT_TIME));
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                        if (inspectCmds.containsKey(KEY_TCP_IDLE_TIME)) {
                            try {
                                this._keys[2][0] = Long.parseLong(inspectCmds.getValue(KEY_TCP_IDLE_TIME));
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                        if (inspectCmds.containsKey(KEY_TCP_SYNWAIT_TIME)) {
                            try {
                                this._keys[0][0] = Long.parseLong(inspectCmds.getValue(KEY_TCP_SYNWAIT_TIME));
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                        if (inspectCmds.containsKey(KEY_BLOCK_NON_SESSION)) {
                            this.bDropNonSession = !inspectCmds.isNoCmd();
                        }
                    } else if (inspectCmds.containsKey("max-incomplete")) {
                        if (inspectCmds.containsKey(KEY_MAX_INCOMPLETE_HIGH)) {
                            try {
                                this._keys[7][0] = Long.parseLong(inspectCmds.getValue(KEY_MAX_INCOMPLETE_HIGH));
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                        if (inspectCmds.containsKey(KEY_MAX_INCOMPLETE_LOW)) {
                            try {
                                this._keys[8][0] = Long.parseLong(inspectCmds.getValue(KEY_MAX_INCOMPLETE_LOW));
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                    } else if (inspectCmds.containsKey(KEY_ONE_MINUTE)) {
                        if (inspectCmds.containsKey(KEY_ONE_MINUTE_HIGH)) {
                            try {
                                this._keys[9][0] = Long.parseLong(inspectCmds.getValue(KEY_ONE_MINUTE_HIGH));
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                        if (inspectCmds.containsKey(KEY_ONE_MINUTE_LOW)) {
                            try {
                                this._keys[10][0] = Long.parseLong(inspectCmds.getValue(KEY_ONE_MINUTE_LOW));
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                    } else if (inspectCmds.containsKey(KEY_UDP) && !inspectCmds.containsKey(KEY_INSPECT_NAME)) {
                        if (inspectCmds.containsKey(KEY_UDP_IDLE_TIME)) {
                            try {
                                this._keys[5][0] = Long.parseLong(inspectCmds.getValue(KEY_UDP_IDLE_TIME));
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                    } else if (inspectCmds.containsKey(KEY_INSPECT_NAME)) {
                        CBACRule aCBACRule;
                        String ruleName = inspectCmds.getValue(KEY_INSPECT_NAME);
                        if (inspectCmds.containsKey(KEY_PARAM)) {
                            long maxSessions = -1L;
                            try {
                                Long.parseLong(inspectCmds.getValue(KEY_MAX_SESSIONS));
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                            aCBACRule = this.findRuleByName(ruleName);
                            if (aCBACRule == null) {
                                aCBACRule = new CBACRule((XDMObject)this, ruleName);
                                aCBACRule.setMaxSessions(maxSessions);
                                this.CBACRules.addElement(aCBACRule);
                            } else {
                                aCBACRule.setMaxSessions(maxSessions);
                            }
                        } else if (inspectCmds.containsKey(KEY_POLICYNAME)) {
                            String appfwPName = inspectCmds.getValue(KEY_POLICYNAME);
                            CBACRule aCBACRule2 = this.findRuleByName(ruleName);
                            if (aCBACRule2 == null) {
                                aCBACRule2 = new CBACRule((XDMObject)this, ruleName);
                                aCBACRule2.setAppfwPolicyName(appfwPName);
                                this.CBACRules.addElement(aCBACRule2);
                            } else {
                                aCBACRule2.setAppfwPolicyName(appfwPName);
                            }
                        } else {
                            String protName = "";
                            if (inspectCmds.containsKey(KEY_INSPECT_PROTOCOL)) {
                                protName = inspectCmds.getValue(KEY_INSPECT_PROTOCOL);
                            } else if (inspectCmds.containsKey(KEY_ESMTP)) {
                                protName = KEY_ESMTP;
                            } else if (inspectCmds.containsKey(KEY_FRAGMENT)) {
                                protName = KEY_FRAGMENT;
                            } else if (inspectCmds.containsKey(KEY_H323)) {
                                protName = KEY_H323;
                            } else if (inspectCmds.containsKey(KEY_HTTP)) {
                                protName = KEY_HTTP;
                            } else if (inspectCmds.containsKey(KEY_ICMP)) {
                                protName = KEY_ICMP;
                            } else if (inspectCmds.containsKey(KEY_IMAP)) {
                                protName = KEY_IMAP;
                            } else if (inspectCmds.containsKey(KEY_POP3)) {
                                protName = KEY_POP3;
                            } else if (inspectCmds.containsKey(KEY_POP)) {
                                protName = KEY_POP;
                            } else if (inspectCmds.containsKey(KEY_RPC)) {
                                protName = KEY_RPC;
                            } else if (inspectCmds.containsKey(KEY_SMTP)) {
                                protName = KEY_SMTP;
                            } else if (inspectCmds.containsKey(KEY_TCP)) {
                                protName = KEY_TCP;
                            } else if (inspectCmds.containsKey(KEY_UDP)) {
                                protName = KEY_UDP;
                            }
                            CBACRuleEntry aRuleEntry = null;
                            if (!protName.equals("")) {
                                aRuleEntry = new CBACRuleEntry((XDMObject)this, protName);
                                aRuleEntry.setSelected(true);
                                aRuleEntry.populate(null, inspectCmds);
                            } else {
                                Log.getInstance().debug("CBAC populate: unexpected protocol.");
                            }
                            if (protName.indexOf("user-") != -1) {
                                this.getFeed().addUserDefinedProtocol(protName);
                            }
                            if ((aCBACRule = this.findRuleByName(ruleName)) == null) {
                                aCBACRule = new CBACRule((XDMObject)this, ruleName);
                                aCBACRule.addRuleEntry(aRuleEntry);
                                this.CBACRules.addElement(aCBACRule);
                            } else {
                                aCBACRule.addRuleEntry(aRuleEntry);
                            }
                            aRuleEntry.setParent(aCBACRule);
                        }
                    } else {
                        Log.getInstance().debug("CBAC populate: unknown CLI command.");
                    }
                    ++i;
                }
            }
            catch (CliGPBException e) {
                e.printStackTrace();
            }
        }
        this.trimProtocols();
        Log.getInstance().debug("CBAC populate finished.");
        Log.getInstance().debug("CBAC update pam....");
        this.updatePAM();
        Log.getInstance().debug("CBAC update pam finished.");
    }

    public void printElements() {
        FwData fwData = this.getFeed().getData();
        Vector groups = fwData.getGroups();
        Enumeration e = groups.elements();
        while (e.hasMoreElements()) {
            FwGroup grp = (FwGroup)e.nextElement();
            System.out.println("Group " + grp.getName());
            System.out.println(grp.getItems());
        }
    }

    public void removeRule(CBACRule rule) {
        try {
            int i = 0;
            while (i < this.CBACRules.size()) {
                CBACRule cbacRule = (CBACRule)this.CBACRules.elementAt(i);
                if (cbacRule.getName().equalsIgnoreCase(rule.getName())) {
                    this.CBACRules.removeElementAt(i);
                    this.setModified();
                    break;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    public void removeRuleAt(int pos) {
        try {
            this.CBACRules.removeElementAt(pos);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        this.setModified();
    }

    public void setModified() {
        super.setModified();
    }

    public void showALL() {
        String s = "";
        Log.getInstance().debug("");
        s = this.bAuditTrial ? "enabled" : "disabled";
        Log.getInstance().debug("Session audit trail is " + s);
        s = this.bAlert ? "enabled" : "disabled";
        Log.getInstance().debug("Session alert is " + s);
        Log.getInstance().debug("one-minute (sampling period) thresholds are [" + this._keys[10][0] + ":" + this._keys[9][0] + "] connections");
        Log.getInstance().debug("max-incomplete sessions thresholds are [" + this._keys[8][0] + ":" + this._keys[7][0] + "]");
        Log.getInstance().debug("max-incomplete tcp connections per host is " + this._keys[3][0] + ". Block-time " + this._keys[4][0] + " minutes.");
        Log.getInstance().debug("tcp synwait-time is " + this._keys[0][0] + " sec -- tcp finwait-time is " + this._keys[1][0] + " sec");
        Log.getInstance().debug("tcp idle-time is " + this._keys[2][0] + " sec -- udp idle-time is " + this._keys[5][0] + " sec");
        Log.getInstance().debug("dns-timeout is " + this._keys[6][0] + " sec");
        Log.getInstance().debug("Inspection Rule Configuration");
        Enumeration en = this.CBACRules.elements();
        while (en.hasMoreElements()) {
            CBACRule aRule = (CBACRule)en.nextElement();
            Log.getInstance().debug("");
            Log.getInstance().debug("  Inspection name " + aRule.getName());
            Enumeration clis = aRule.getCLIs().elements();
            while (clis.hasMoreElements()) {
                Log.getInstance().debug("    " + clis.nextElement());
            }
        }
    }

    private void trimProtocols() {
        this.getCBACDiscover().attach((DeviceBase)this.getDevice());
        FwData fwData = this.getFeed().getData();
        Enumeration e = fwData.getGroups().elements();
        while (e.hasMoreElements()) {
            FwGroup grp = (FwGroup)e.nextElement();
            grp.trimProtocols(this.getCBACDiscover().getProtocols());
        }
    }

    private int updateConfigValues(ConfigValues values, CmdValues cmd, int index) {
        if (index >= 0) {
            values.insertCmdValues(cmd, index++);
        } else {
            values.addCmdValues(cmd);
        }
        return index;
    }

    private void updatePAM() {
        if (this.getDevice() == null) {
            return;
        }
        PAM pam = ((DeviceBase)this.getDevice()).getSystemProp().getPAM();
        if (pam == null) {
            return;
        }
        FwGroup group = this.getFeed().getData().getGroup("User Defined");
        if (group == null) {
            return;
        }
        Vector userDefinedProtocol = pam.getUserDefinedEntries();
        String protocolName = "";
        int i = 0;
        while (i < userDefinedProtocol.size()) {
            protocolName = ((PAMBaseEntry)userDefinedProtocol.elementAt(i)).getProtocol();
            if (group.getProtocol(protocolName) == null) {
                this.getFeed().addUserDefinedProtocol(protocolName);
            }
            ++i;
        }
    }
}

