/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.cbac.appfw;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.MergeCallback;
import com.cisco.xdm.data.base.MergeInterface;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.cbac.appfw.AppFwPolicy;

public class AppFwAction
extends XDMObject
implements MergeInterface {
    private boolean _alarm = false;
    private int _action = -1;
    public static final int ACTION_NONE = -1;
    public static final int ACTION_RESET = 1;
    public static final int ACTION_ALLOW = 2;
    private static final String KEY_ACTION = "action";
    private static final String KEY_ACTION1 = "action1";
    private static final String KEY_ALLOW = "allow";
    private static final String KEY_RESET = "reset";
    private static final String KEY_ALARM = "alarm";

    public AppFwAction(XDMObject parent) {
        super(parent);
    }

    protected boolean equals(AppFwAction object) {
        if (object == null) {
            return false;
        }
        return this._alarm == object._alarm && this._action == object._action;
    }

    protected void generateCmdValue(CmdValues cmd) {
        this.generateValue(cmd, false);
    }

    protected void generateFullCmdValue(CmdValues cmd) {
        this.generateValue(cmd, true);
    }

    private void generateValue(CmdValues cmd, boolean full) {
        if (cmd == null) {
            return;
        }
        if (this.isNoAct() || this.isBackup()) {
            cmd.setAction(2);
            if (!full) {
                return;
            }
        }
        cmd.addValue(KEY_ACTION, KEY_ACTION);
        if (this._action == 2) {
            cmd.addValue(KEY_ACTION1, KEY_ALLOW);
        } else if (this._action == 1) {
            cmd.addValue(KEY_ACTION1, KEY_RESET);
        }
        if (this._alarm) {
            cmd.addValue(KEY_ALARM, KEY_ALARM);
        }
    }

    public int getAction() {
        return this._action;
    }

    public boolean getAlarm() {
        return this._alarm;
    }

    public boolean isNoAct() {
        return !this._alarm && this._action == -1;
    }

    public boolean merge(XDMObject data, MergeCallback cb) {
        if (!(data != null && data instanceof AppFwAction || AppFwPolicy.notifyMergeCaller(1, cb, null))) {
            return false;
        }
        AppFwAction mData = (AppFwAction)data;
        if (mData._alarm) {
            this.setAlarm(mData._alarm);
        }
        if (mData._action != -1) {
            this.setAction(mData._action);
        }
        return true;
    }

    public void noAct() {
        if (!this.isNoAct()) {
            this._alarm = false;
            this._action = -1;
            this.setModified();
        }
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        if (cmdVal == null) {
            return;
        }
        if (cmdVal.containsKey(KEY_ACTION1)) {
            String action = cmdVal.getValue(KEY_ACTION1);
            this._action = action.equals(KEY_ALLOW) ? 2 : 1;
        }
        if (cmdVal.containsKey(KEY_ALARM)) {
            this._alarm = true;
        }
    }

    public void setAction(int val) {
        if (this._action != val) {
            this._action = val;
            this.setModified();
        }
    }

    public void setAlarm(boolean val) {
        if (val != this._alarm) {
            this._alarm = val;
            this.setModified();
        }
    }
}

