/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.cbac.appfw;

import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.common.IPAddress;

public class AppFwIMServer
extends XDMObject {
    public static final int SINGLE_ADDR = 0;
    public static final int ADDR_RANGE = 1;
    public static final int NAME = 2;
    private int _type;
    private boolean _permit;
    private String _name;
    private IPAddress _addr1;
    private IPAddress _addr2;

    public AppFwIMServer(IPAddress start, IPAddress end, boolean permit) {
        this._type = 1;
        this._addr1 = start;
        this._addr2 = end;
        this._permit = permit;
    }

    public AppFwIMServer(IPAddress addr, boolean permit) {
        this._type = 0;
        this._addr1 = addr;
        this._permit = permit;
    }

    public AppFwIMServer(String name, boolean permit) {
        this._type = 2;
        this._name = name;
        this._permit = permit;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AppFwIMServer)) {
            return false;
        }
        AppFwIMServer aObj = (AppFwIMServer)obj;
        if (this._type != aObj._type || this._permit != aObj._permit) {
            return false;
        }
        if (this._type == 0) {
            return this._addr1.equals(aObj._addr1);
        }
        if (this._type == 1) {
            return this._addr1.equals(aObj._addr1) && this._addr2.equals(aObj._addr2);
        }
        if (this._type == 2) {
            return this._name.equals(aObj._name);
        }
        return false;
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        CmdValues cmd = new CmdValues("server");
        if (this._permit) {
            cmd.addValue("access", "permit");
        } else {
            cmd.addValue("access", "deny");
        }
        if (this._type == 2) {
            cmd.addValue("name", "name");
            cmd.addValue("servername", this._name);
        } else {
            cmd.addValue("ip", "ip");
            if (this._type == 0) {
                cmd.addValue("serverip", this._addr1.toString());
            } else {
                cmd.addValue("range", "range");
                cmd.addValue("startip", this._addr1.toString());
                cmd.addValue("endip", this._addr2.toString());
            }
        }
        if (this.isBackup()) {
            cmd.setAction(2);
        }
        values.addCmdValues(cmd);
    }

    public IPAddress getAddr1() {
        return this._addr1;
    }

    public IPAddress getAddr2() {
        return this._addr2;
    }

    public String getName() {
        return this._name;
    }

    public int getType() {
        return this._type;
    }

    public boolean isPermit() {
        return this._permit;
    }
}

