/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.cbac.appfw;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.DeviceBase;
import com.cisco.xdm.data.base.MergeCallback;
import com.cisco.xdm.data.base.MergeInterface;
import com.cisco.xdm.data.base.XDMEditableVector;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMHashCollection;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.cbac.appfw.AppFwHTTP;
import com.cisco.xdm.data.cbac.appfw.AppFwIM;
import com.cisco.xdm.data.cbac.appfw.AppFwIMAol;
import com.cisco.xdm.data.cbac.appfw.AppFwIMMsn;
import com.cisco.xdm.data.cbac.appfw.AppFwIMServer;
import com.cisco.xdm.data.cbac.appfw.AppFwIMYahoo;
import com.cisco.xdm.data.common.IPAddress;
import java.util.Enumeration;
import java.util.Vector;

public class AppFwPolicy
extends XDMHashCollection
implements MergeInterface {
    private String _name = null;
    public static final String APP_HTTP = "http";
    public static final String APP_IM_YAHOO = "yahoo";
    public static final String APP_IM_MSN = "msn";
    public static final String APP_IM_AOL = "aol";
    public static final int APP_P2P_EDONKEY = 0;
    public static final int APP_P2P_BITTORRENT = 1;
    public static final int APP_P2P_KAZAA = 2;
    public static final int APP_P2P_GNUTELLA = 3;
    public static final int APP_P2P_NOT_CONFIG = 0;
    public static final int APP_P2P_DROP = 1;
    public static final int APP_P2P_PERMIT = 2;
    private int[] _otherApps = new int[4];
    public static final int MERGE_WRONG_PARAM = 1;
    public static final int MERGE_WRONG_MEMBER_VARIABLE_IMPL = 2;

    public AppFwPolicy(String name, XDMObject parent) {
        super(parent);
        this._name = name;
    }

    private boolean addrExistIn(IPAddress addr1, IPAddress addr2, AppFwIM im) {
        long start;
        if (im == null || addr1 == null) {
            return false;
        }
        long end = start = addr1.getUnsignedIntValue();
        if (addr2 != null) {
            end = addr2.getUnsignedIntValue();
        }
        XDMEditableVector servers = im.getServers();
        Enumeration e = im.getServers().elements();
        while (e.hasMoreElements()) {
            AppFwIMServer server = (AppFwIMServer)e.nextElement();
            if (server.getType() == 0) {
                long val = server.getAddr1().getUnsignedIntValue();
                if (val < start || val > end) continue;
                return true;
            }
            if (server.getType() != 1) continue;
            long first = server.getAddr1().getUnsignedIntValue();
            long last = server.getAddr2().getUnsignedIntValue();
            if ((first < start || first > end) && (start < first || start > last)) continue;
            return true;
        }
        return false;
    }

    public boolean anyAttrChanged() {
        ConfigValues values = new ConfigValues();
        try {
            this.generateDelta(null, values);
            if (values.numCmds() == 0) {
                return false;
            }
            CmdValues gcmd = values.getCmdValues(0);
            ConfigValues config = gcmd.getModeCmdsValues();
            if (config == null || config.numCmds() == 0) {
                return false;
            }
            ConfigValues ifCVs = config.getCmds("application", ".*", ".*", false);
            if (ifCVs != null) {
                int i = 0;
                while (i < ifCVs.numCmds()) {
                    CmdValues subcmd = ifCVs.getCmdValues(i);
                    ConfigValues subconfig = subcmd.getModeCmdsValues();
                    if (subconfig != null && subconfig.numCmds() > 0) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        return false;
    }

    public void clearAppState() {
        this._otherApps[0] = 0;
        this._otherApps[1] = 0;
        this._otherApps[2] = 0;
        this._otherApps[3] = 0;
    }

    public AppFwPolicy createFrom(String name, AppFwPolicy policy) {
        AppFwPolicy appfwPolicy = null;
        appfwPolicy = policy == null ? (AppFwPolicy)this.clone() : (AppFwPolicy)policy.clone();
        appfwPolicy._name = name;
        return appfwPolicy;
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        DeviceBase dev;
        CmdValues cmd = new CmdValues("appfw");
        cmd.addValue("policy-name", "policy-name");
        cmd.addValue("fwpolicyname", this._name);
        if (this.isBackup()) {
            cmd.setAction(2);
            values.addCmdValues(cmd);
            return;
        }
        ConfigValues cv = new ConfigValues();
        super.generateDelta(backup, cv);
        if (cv.numCmds() == 0 && backup != null) {
            return;
        }
        if (cv.numCmds() > 0) {
            cmd.setModeCmdsValues(cv);
        }
        int position = -1;
        if (backup == null && (dev = (DeviceBase)this.getDevice()) != null) {
            position = dev.getFirstCmdPosition("cbac", values, false);
        }
        if (position == -1) {
            values.addCmdValues(cmd);
        } else {
            values.insertCmdValues(cmd, position);
        }
    }

    public int getAppState(int app) {
        return this._otherApps[app];
    }

    public AppFwHTTP getHttp() {
        return (AppFwHTTP)this.get(APP_HTTP);
    }

    public AppFwIM getIM(String type) {
        return (AppFwIM)this.get(type);
    }

    public String getName() {
        return this._name;
    }

    public boolean isIpAddrExistingInIMServers(IPAddress addr) {
        if (addr == null) {
            return false;
        }
        return this.isIpAddrRangeExistingInIMServers(addr, null);
    }

    public boolean isIpAddrRangeExistingInIMServers(IPAddress addr1, IPAddress addr2) {
        if (addr1 == null) {
            return false;
        }
        if (addr2 != null && addr1.getUnsignedIntValue() > addr2.getUnsignedIntValue()) {
            return false;
        }
        if (this.addrExistIn(addr1, addr2, this.getIM(APP_IM_YAHOO))) {
            return true;
        }
        if (this.addrExistIn(addr1, addr2, this.getIM(APP_IM_MSN))) {
            return true;
        }
        return this.addrExistIn(addr1, addr2, this.getIM(APP_IM_AOL));
    }

    public boolean merge(XDMObject data, MergeCallback cb) {
        if (!(data != null && data instanceof AppFwPolicy || AppFwPolicy.notifyMergeCaller(1, cb, null))) {
            return false;
        }
        AppFwPolicy mData = (AppFwPolicy)data;
        return AppFwPolicy.mergeHashtable(this, mData, cb);
    }

    protected static boolean mergeHashtable(XDMHashCollection target, XDMHashCollection src, MergeCallback cb) {
        Enumeration e = src.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            XDMObject s = src.get(key);
            if (target.containsKey(key)) {
                XDMObject t = target.get(key);
                if (!(t instanceof MergeInterface) && !AppFwPolicy.notifyMergeCaller(2, cb, null)) {
                    return false;
                }
                MergeInterface memMerge = (MergeInterface)((Object)t);
                if (memMerge.merge(s, cb)) continue;
                return false;
            }
            target.put(key, (XDMObject)s.clone());
        }
        return true;
    }

    protected static boolean notifyMergeCaller(int event, MergeCallback cb, Object eventData) {
        if (cb == null) {
            return false;
        }
        return cb.notify(event, eventData);
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        if (cmdVal == null) {
            return;
        }
        ConfigValues subConfig = cmdVal.getModeCmdsValues();
        if (subConfig == null) {
            return;
        }
        int i = 0;
        while (i < subConfig.numCmds()) {
            CmdValues cmd = subConfig.getCmdValues(i);
            if (cmd.getCmdName().equals("application")) {
                if (cmd.containsKey(APP_HTTP)) {
                    AppFwHTTP http = new AppFwHTTP(this);
                    this.setHttp(http);
                    http.populate(config, cmd);
                } else if (cmd.containsKey("im")) {
                    AppFwIM im = null;
                    if (cmd.containsKey(APP_IM_YAHOO)) {
                        im = new AppFwIMYahoo(this);
                    } else if (cmd.containsKey(APP_IM_MSN)) {
                        im = new AppFwIMMsn(this);
                    } else if (cmd.containsKey(APP_IM_AOL)) {
                        im = new AppFwIMAol(this);
                    }
                    if (im != null) {
                        this.setIM(im);
                        im.populate(config, cmd);
                    }
                }
            }
            ++i;
        }
    }

    public void setAppState(int app, int state) {
        this._otherApps[app] = state;
    }

    public void setHttp(AppFwHTTP obj) {
        this.put(APP_HTTP, obj);
    }

    public void setIM(AppFwIM obj) {
        if (obj instanceof AppFwIMYahoo) {
            this.put(APP_IM_YAHOO, obj);
        } else if (obj instanceof AppFwIMMsn) {
            this.put(APP_IM_MSN, obj);
        }
        if (obj instanceof AppFwIMAol) {
            this.put(APP_IM_AOL, obj);
        }
    }

    protected void trimNewEmptyApp(AppFwPolicy orig) {
        Vector<String> removes = new Vector<String>();
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            XDMObject app = this.get(name);
            Object origApp = null;
            if (orig != null && orig.containsKey(name)) continue;
            try {
                ConfigValues values = new ConfigValues();
                app.generateDelta(null, values);
                if (values.numCmds() == 0) {
                    removes.addElement(name);
                    continue;
                }
                CmdValues cmd = values.getCmdValues(0);
                ConfigValues config = cmd.getModeCmdsValues();
                if (config != null && config.numCmds() != 0) continue;
                removes.addElement(name);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        int i = 0;
        while (i < removes.size()) {
            this.remove(removes.elementAt(i));
            ++i;
        }
    }
}

