/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.cbac.appfw;

import com.cisco.nm.xms.cliparser.CliGPBException;
import com.cisco.nm.xms.cliparser.CmdValues;
import com.cisco.nm.xms.cliparser.ConfigValues;
import com.cisco.xdm.data.base.XDMException;
import com.cisco.xdm.data.base.XDMObject;
import com.cisco.xdm.data.cbac.appfw.AppFwAction;

public class HTTPMaxHeaderLength
extends AppFwAction {
    private int _request = -1;
    private int _response = -1;
    private static final String KEY_MAX_HEADER_LEN = "max-header-length";
    private static final String KEY_REQ = "req";
    private static final String KEY_RES = "res";

    public HTTPMaxHeaderLength(XDMObject parent) {
        super(parent);
    }

    protected boolean equals(HTTPMaxHeaderLength object) {
        if (object == null) {
            return false;
        }
        return this._request == object._request && this._response == object._response && super.equals(object);
    }

    public void generateDelta(XDMObject backup, ConfigValues values) throws XDMException {
        HTTPMaxHeaderLength bObj = null;
        if (backup != null) {
            bObj = (HTTPMaxHeaderLength)backup;
        }
        if (this.equals(bObj)) {
            return;
        }
        if (backup == null && this.isNoAct()) {
            return;
        }
        CmdValues cmd = new CmdValues(KEY_MAX_HEADER_LEN);
        if (this._request != -1) {
            cmd.addValue(KEY_REQ, String.valueOf(this._request));
        }
        if (this._response != -1) {
            cmd.addValue(KEY_RES, String.valueOf(this._response));
        }
        this.generateCmdValue(cmd);
        values.addCmdValues(cmd);
    }

    public int getRequest() {
        return this._request;
    }

    public int getResponse() {
        return this._response;
    }

    public void populate(ConfigValues config, CmdValues cmdVal) throws XDMException, CliGPBException {
        if (cmdVal == null) {
            return;
        }
        if (cmdVal.containsKey(KEY_REQ)) {
            this._request = Integer.parseInt(cmdVal.getValue(KEY_REQ));
        }
        if (cmdVal.containsKey(KEY_RES)) {
            this._response = Integer.parseInt(cmdVal.getValue(KEY_RES));
        }
        super.populate(config, cmdVal);
    }

    public void setRequest(int val) {
        if (val != this._request) {
            this._request = val;
            this.setModified();
        }
    }

    public void setResponse(int val) {
        if (val != this._response) {
            this._response = val;
            this.setModified();
        }
    }
}

