/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.cbac.feed;

import com.cisco.xdm.data.cbac.feed.FwBase;
import com.cisco.xdm.data.cbac.feed.FwProtocol;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;

public class FwGroup
extends FwBase {
    private Vector items = new Vector();

    public void addGroup(FwGroup grp) {
        this.items.addElement(grp);
    }

    public void addProtocol(FwProtocol prot) {
        this.items.addElement(prot);
    }

    public void addProtocols(Vector v) {
        Enumeration e = this.items.elements();
        while (e.hasMoreElements()) {
            FwBase base = (FwBase)e.nextElement();
            if (base instanceof FwGroup) {
                FwGroup grp = (FwGroup)base;
                grp.addProtocols(v);
                continue;
            }
            v.addElement(base.getName());
        }
    }

    public Object clone() {
        FwGroup cloneEntry = (FwGroup)super.clone();
        cloneEntry.items = new Vector();
        Enumeration en = this.items.elements();
        while (en.hasMoreElements()) {
            FwBase fwbase = (FwBase)((FwBase)en.nextElement()).clone();
            cloneEntry.items.addElement(fwbase);
        }
        return cloneEntry;
    }

    public boolean containsGroup() {
        Enumeration e = this.items.elements();
        while (e.hasMoreElements()) {
            FwBase base = (FwBase)e.nextElement();
            if (!(base instanceof FwGroup)) continue;
            return true;
        }
        return false;
    }

    public Vector getItems() {
        return this.items;
    }

    public FwProtocol getProtocol(String prot) {
        Enumeration e = this.items.elements();
        while (e.hasMoreElements()) {
            FwBase base = (FwBase)e.nextElement();
            if (base instanceof FwGroup) {
                FwProtocol p = ((FwGroup)base).getProtocol(prot);
                if (p == null) continue;
                return p;
            }
            if (!base.getName().equals(prot)) continue;
            return (FwProtocol)base;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.items.size() == 0;
    }

    public void parse(Element grp) {
        this.name = grp.getAttributeValue("name");
        this.resid = grp.getAttributeValue("resid");
        List l = grp.getChildren();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            Element item = (Element)it.next();
            String itemname = item.getName();
            if (itemname.equals("group")) {
                FwGroup subgrp = new FwGroup();
                subgrp.parse(item);
                this.addGroup(subgrp);
                continue;
            }
            FwProtocol prot = new FwProtocol();
            prot.parse(item);
            this.addProtocol(prot);
        }
    }

    public void removeProtocol(FwProtocol fwProtocol) {
        this.items.removeElement(fwProtocol);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("Group: " + this.name);
        str.append(System.getProperty("line.separator"));
        Enumeration e = this.items.elements();
        while (e.hasMoreElements()) {
            FwBase base = (FwBase)e.nextElement();
            if (base instanceof FwGroup) {
                str.append(((FwGroup)base).toString());
                continue;
            }
            str.append(((FwProtocol)base).toString());
        }
        return str.toString();
    }

    public void trimProtocols(Hashtable protocols) {
        if (this.isEmpty()) {
            return;
        }
        int itemCount = this.items.size();
        int idx = 0;
        while (itemCount > 0) {
            try {
                FwBase fwBase = (FwBase)this.items.elementAt(idx);
                if (fwBase instanceof FwProtocol) {
                    FwProtocol fwProtocol = (FwProtocol)fwBase;
                    if (!protocols.containsKey(fwProtocol.getName()) || !fwProtocol.getAltCmd().equals("")) {
                        this.items.removeElementAt(idx);
                        --itemCount;
                    } else {
                        ++idx;
                    }
                } else if (fwBase instanceof FwGroup) {
                    FwGroup grp = (FwGroup)fwBase;
                    grp.trimProtocols(protocols);
                    if (grp.isEmpty()) {
                        this.items.removeElement(grp);
                        --itemCount;
                    } else {
                        ++idx;
                    }
                }
                if (idx < itemCount) continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            break;
        }
    }
}

