/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.xdm.data.cbac.feed;

import com.cisco.xdm.data.cbac.feed.type.tBase;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class FwType
implements Cloneable {
    private static String[][] typemaps = new String[][]{{"tBool", "tBool"}, {"tEnum", "tEnum"}, {"tInteger", "tInteger"}, {"tLong", "tLong"}, {"tStruct", "tStruct"}};
    private Hashtable types = new Hashtable();

    public Object clone() {
        FwType cloneEntry = null;
        try {
            cloneEntry = (FwType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return cloneEntry;
    }

    private String getTypeforName(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        int i = 0;
        while (i < typemaps.length) {
            if (typemaps[i][0].equals(name)) {
                return typemaps[i][1];
            }
            ++i;
        }
        return null;
    }

    public Hashtable getTypes() {
        return this.types;
    }

    public void parse(Element res) {
        List l = res.getChildren();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            Element item = (Element)it.next();
            String ename = item.getName();
            String type = this.getTypeforName(ename);
            if (type == null) {
                System.out.println("FwType: Invalid type definition - " + ename);
                continue;
            }
            String typename = item.getAttributeValue("typename");
            tBase typeClass = this.produce(ename, item);
            if (typeClass == null) {
                System.out.println("FwType: Cannot instantiate class - " + ename + "-" + typename);
                continue;
            }
            this.types.put(typename, typeClass);
        }
    }

    private tBase produce(String typeName, Element e) {
        tBase ret = null;
        String className = "com.cisco.xdm.data.cbac.feed.type." + typeName;
        try {
            Class<?> elemClass = Class.forName("org.jdom.Element");
            Class<?> typeClass = Class.forName(className);
            Object[] argList = null;
            Constructor<?> ct = null;
            try {
                Class[] params = new Class[]{elemClass};
                ct = typeClass.getConstructor(params);
                argList = new Object[]{e};
            }
            catch (NoSuchMethodException nsme) {
                nsme.printStackTrace();
            }
            ret = (tBase)ct.newInstance(argList);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return ret;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        Enumeration e = this.types.keys();
        while (e.hasMoreElements()) {
            String typeName = (String)e.nextElement();
            str.append("<").append(typeName).append(">=");
            str.append(((tBase)this.types.get(typeName)).toString());
        }
        return str.toString();
    }
}

